/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.common;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class AttributeMap<T>
implements Serializable,
Cloneable {
    private static final String[] EMPTY_NAMESPACES = new String[0];
    private static final long serialVersionUID = -7442871030874215436L;
    private LinkedHashMap<String, LinkedHashMap<String, T>> namespaces;
    private String singletonNamespace;
    private LinkedHashMap<String, T> singletonContent;

    public AttributeMap() {
    }

    public AttributeMap(AttributeMap copy) {
        if (copy == null) {
            return;
        }
        if (copy.singletonNamespace != null) {
            this.singletonNamespace = copy.singletonNamespace;
            this.singletonContent = (LinkedHashMap)copy.singletonContent.clone();
        }
        if (copy.namespaces == null) {
            return;
        }
        this.namespaces = (LinkedHashMap)copy.namespaces.clone();
        for (Map.Entry<String, LinkedHashMap<String, T>> entry : this.namespaces.entrySet()) {
            LinkedHashMap<String, T> value = entry.getValue();
            entry.setValue((LinkedHashMap)value.clone());
        }
    }

    public AttributeMap<T> clone() {
        try {
            AttributeMap map = (AttributeMap)super.clone();
            if (this.singletonNamespace != null) {
                map.singletonContent = (LinkedHashMap)this.singletonContent.clone();
            }
            if (this.namespaces != null) {
                map.namespaces = (LinkedHashMap)this.namespaces.clone();
                for (Map.Entry<String, LinkedHashMap<String, T>> entry : map.namespaces.entrySet()) {
                    LinkedHashMap<String, T> value = entry.getValue();
                    entry.setValue((LinkedHashMap)value.clone());
                }
            }
            return map;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException("Cannot happen: Clone not supported exception");
        }
    }

    public T setAttribute(String namespace, String attribute, T value) {
        LinkedHashMap<String, T> attrs;
        if (namespace == null) {
            throw new NullPointerException("Attribute namespace must not be null");
        }
        if (attribute == null) {
            throw new NullPointerException("Attribute name must not be null");
        }
        if (this.singletonNamespace == null) {
            if (value != null) {
                this.singletonNamespace = namespace;
                this.singletonContent = new LinkedHashMap();
                this.singletonContent.put(attribute, value);
            }
            return null;
        }
        if (namespace.equals(this.singletonNamespace)) {
            if (value == null) {
                return (T)this.singletonContent.remove(attribute);
            }
            return this.singletonContent.put(attribute, value);
        }
        if (this.namespaces == null) {
            if (value == null) {
                return null;
            }
            this.namespaces = new LinkedHashMap();
        }
        if ((attrs = this.namespaces.get(namespace)) == null) {
            if (value == null) {
                return null;
            }
            LinkedHashMap<String, T> newAtts = new LinkedHashMap<String, T>();
            newAtts.put(attribute, value);
            this.namespaces.put(namespace, newAtts);
            return null;
        }
        if (value == null) {
            Object retval = attrs.remove(attribute);
            if (attrs.isEmpty()) {
                this.namespaces.remove(namespace);
            }
            return (T)retval;
        }
        return attrs.put(attribute, value);
    }

    public T getAttribute(String namespace, String attribute) {
        if (namespace == null) {
            throw new NullPointerException("Attribute namespace must not be null");
        }
        if (attribute == null) {
            throw new NullPointerException("Attribute name must not be null");
        }
        if (this.singletonNamespace == null) {
            return null;
        }
        if (namespace.equals(this.singletonNamespace)) {
            return this.singletonContent.get(attribute);
        }
        if (this.namespaces == null) {
            return null;
        }
        LinkedHashMap<String, T> attrs = this.namespaces.get(namespace);
        if (attrs == null) {
            return null;
        }
        return attrs.get(attribute);
    }

    public T getFirstAttribute(String attribute) {
        T val;
        if (attribute == null) {
            throw new NullPointerException("Attribute name must not be null");
        }
        if (this.singletonContent != null && (val = this.singletonContent.get(attribute)) != null) {
            return val;
        }
        if (this.namespaces == null) {
            return null;
        }
        for (Map.Entry<String, LinkedHashMap<String, T>> entry : this.namespaces.entrySet()) {
            LinkedHashMap<String, T> value = entry.getValue();
            T val2 = value.get(attribute);
            if (val2 == null) continue;
            return val2;
        }
        return null;
    }

    public Map<String, T> getAttributes(String namespace) {
        if (namespace == null) {
            throw new NullPointerException("Attribute namespace must not be null");
        }
        if (namespace.equals(this.singletonNamespace)) {
            return Collections.unmodifiableMap(this.singletonContent);
        }
        if (this.namespaces == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, T> attrs = this.namespaces.get(namespace);
        if (attrs == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(attrs);
    }

    public String[] getNames(String namespace) {
        if (namespace == null) {
            throw new NullPointerException("Attribute namespace must not be null");
        }
        if (namespace.equals(this.singletonNamespace)) {
            return this.singletonContent.keySet().toArray(new String[this.singletonContent.size()]);
        }
        if (this.namespaces == null) {
            return EMPTY_NAMESPACES;
        }
        LinkedHashMap<String, T> attrs = this.namespaces.get(namespace);
        if (attrs == null) {
            return EMPTY_NAMESPACES;
        }
        return attrs.keySet().toArray(new String[attrs.size()]);
    }

    public String[] getNameSpaces() {
        if (this.namespaces == null) {
            if (this.singletonContent != null) {
                return new String[]{this.singletonNamespace};
            }
            return EMPTY_NAMESPACES;
        }
        String[] strings = this.namespaces.keySet().toArray(new String[this.namespaces.size() + 1]);
        System.arraycopy(strings, 0, strings, 1, this.namespaces.size());
        strings[0] = this.singletonNamespace;
        return strings;
    }

    public void putAll(AttributeMap<T> attributeMap) {
        boolean dontCopySingleton;
        String[] namespaces = attributeMap.getNameSpaces();
        if (namespaces.length == 0) {
            return;
        }
        if (this.singletonNamespace == null) {
            dontCopySingleton = true;
            this.singletonNamespace = attributeMap.singletonNamespace;
            this.singletonContent = (LinkedHashMap)attributeMap.singletonContent.clone();
        } else if (this.singletonNamespace.equals(attributeMap.singletonNamespace)) {
            dontCopySingleton = true;
            this.singletonContent.putAll(attributeMap.singletonContent);
        } else {
            dontCopySingleton = false;
        }
        for (int i = 0; i < namespaces.length; ++i) {
            LinkedHashMap<String, T> targetMap;
            String namespace = namespaces[i];
            Map<String, T> sourceMap = attributeMap.getAttributes(namespace);
            if (dontCopySingleton && this.singletonNamespace.equals(namespace)) continue;
            if (this.namespaces == null) {
                this.namespaces = new LinkedHashMap();
            }
            if ((targetMap = this.namespaces.get(namespace)) == null) {
                this.namespaces.put(namespace, new LinkedHashMap<String, T>(sourceMap));
                continue;
            }
            targetMap.putAll(sourceMap);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeMap that = (AttributeMap)o;
        if (this.singletonNamespace != null ? !this.singletonNamespace.equals(that.singletonNamespace) : that.singletonNamespace != null) {
            return false;
        }
        if (this.singletonContent != null ? !this.singletonContent.equals(that.singletonContent) : that.singletonContent != null) {
            return false;
        }
        return !(this.namespaces != null ? !this.namespaces.equals(that.namespaces) : that.namespaces != null);
    }

    public int hashCode() {
        int result = this.namespaces != null ? this.namespaces.hashCode() : 0;
        result = 31 * result + (this.singletonNamespace != null ? this.singletonNamespace.hashCode() : 0);
        result = 31 * result + (this.singletonContent != null ? this.singletonContent.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AttributeMap");
        sb.append("{namespaces=").append(this.namespaces);
        sb.append(", singletonNamespace='").append(this.singletonNamespace).append('\'');
        sb.append(", singletonContent=").append(this.singletonContent);
        sb.append('}');
        return sb.toString();
    }
}

