/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.parser;

import java.util.HashMap;
import org.pentaho.reporting.libraries.base.config.DefaultConfiguration;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.resourceloader.DependencyCollector;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.CommentHandler;
import org.pentaho.reporting.libraries.xmlns.parser.FixNamespaceUriAttributes;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RootXmlReadHandler
extends DefaultHandler {
    private DefaultConfiguration parserConfiguration;
    private Locator documentLocator;
    private FastStack currentHandlers;
    private FastStack outerScopes;
    private XmlReadHandler rootHandler;
    private HashMap<String, Object> objectRegistry;
    private boolean rootHandlerInitialized;
    private CommentHandler commentHandler;
    private DependencyCollector dependencyCollector;
    private ResourceKey source;
    private ResourceKey context;
    private ResourceManager manager;
    private FastStack namespaces;
    private boolean firstCall;
    private boolean xmlnsUrisNotAvailable;

    public RootXmlReadHandler(ResourceManager manager, ResourceKey source, long version) {
        this(manager, source, source, version);
    }

    public RootXmlReadHandler(ResourceManager manager, ResourceKey source, ResourceKey context, long version) {
        if (manager == null) {
            throw new NullPointerException();
        }
        if (source == null) {
            throw new NullPointerException();
        }
        this.firstCall = true;
        this.manager = manager;
        this.source = source;
        this.context = context;
        this.dependencyCollector = new DependencyCollector(source, version);
        this.objectRegistry = new HashMap();
        this.parserConfiguration = new DefaultConfiguration();
        this.commentHandler = new CommentHandler();
        this.namespaces = new FastStack();
    }

    public ResourceKey getContext() {
        return this.context;
    }

    public ResourceManager getResourceManager() {
        return this.manager;
    }

    public boolean isFirstCall() {
        return this.firstCall;
    }

    public ResourceKey getSource() {
        return this.source;
    }

    public DependencyCollector getDependencyCollector() {
        return this.dependencyCollector;
    }

    public CommentHandler getCommentHandler() {
        return this.commentHandler;
    }

    public DefaultConfiguration getParserConfiguration() {
        return this.parserConfiguration;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.documentLocator = locator;
    }

    public Locator getDocumentLocator() {
        return this.documentLocator;
    }

    public void setHelperObject(String key, Object value) {
        if (value == null) {
            this.objectRegistry.remove(key);
        } else {
            this.objectRegistry.put(key, value);
        }
    }

    public Object getHelperObject(String key) {
        return this.objectRegistry.get(key);
    }

    public String[] getHelperObjectNames() {
        return this.objectRegistry.keySet().toArray(new String[this.objectRegistry.size()]);
    }

    protected void setRootHandler(XmlReadHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.rootHandler = handler;
        this.rootHandlerInitialized = false;
    }

    protected XmlReadHandler getRootHandler() {
        return this.rootHandler;
    }

    public void recurse(XmlReadHandler handler, String uri, String tagName, Attributes attrs) throws SAXException {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.outerScopes.push((Object)this.currentHandlers);
        this.currentHandlers = new FastStack();
        this.currentHandlers.push((Object)handler);
        handler.startElement(uri, tagName, attrs);
    }

    public void delegate(XmlReadHandler handler, String uri, String tagName, Attributes attrs) throws SAXException {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.currentHandlers.push((Object)handler);
        handler.init(this, uri, tagName);
        handler.startElement(uri, tagName, attrs);
    }

    public void unwind(String uri, String tagName) throws SAXException {
        this.currentHandlers.pop();
        if (this.currentHandlers.isEmpty() && !this.outerScopes.isEmpty()) {
            this.currentHandlers = (FastStack)this.outerScopes.pop();
        } else if (!this.currentHandlers.isEmpty()) {
            this.getCurrentHandler().endElement(uri, tagName);
        }
    }

    protected XmlReadHandler getCurrentHandler() {
        return (XmlReadHandler)this.currentHandlers.peek();
    }

    @Override
    public void startDocument() throws SAXException {
        this.outerScopes = new FastStack();
        this.currentHandlers = new FastStack();
        if (this.rootHandler != null) {
            this.currentHandlers.push((Object)this.rootHandler);
        }
    }

    @Override
    public final void startElement(String originalUri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.firstCall) {
            this.firstCall = false;
            this.interceptFirstStartElement(originalUri, localName, qName, attributes);
            return;
        }
        String nsuri = attributes.getValue("xmlns");
        String defaultNamespace = nsuri != null ? nsuri : (this.namespaces.isEmpty() ? "" : (String)this.namespaces.peek());
        this.pushDefaultNamespace(defaultNamespace);
        String uri = (originalUri == null || "".equals(originalUri)) && defaultNamespace != null ? defaultNamespace : originalUri;
        if (!this.rootHandlerInitialized) {
            this.rootHandler.init(this, uri, localName);
            this.rootHandlerInitialized = true;
        }
        XmlReadHandler currentHandler = this.getCurrentHandler();
        currentHandler.startElement(uri, localName, this.wrapAttributes(new FixNamespaceUriAttributes(uri, attributes)));
    }

    protected Attributes wrapAttributes(Attributes attributes) {
        return attributes;
    }

    protected void interceptFirstStartElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.startElement(uri, localName, qName, attributes);
    }

    protected final void pushDefaultNamespace(String nsuri) {
        this.namespaces.push((Object)nsuri);
    }

    protected void installRootHandler(XmlReadHandler handler, String uri, String localName, Attributes attributes) throws SAXException {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.rootHandler = handler;
        this.rootHandler.init(this, uri, localName);
        this.currentHandlers.push((Object)handler);
        this.rootHandlerInitialized = true;
        this.rootHandler.startElement(uri, localName, attributes);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.getCurrentHandler().characters(ch, start, length);
        }
        catch (SAXException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ParseException("Failed at handling character data", e, this.getDocumentLocator());
        }
    }

    @Override
    public final void endElement(String originalUri, String localName, String qName) throws SAXException {
        String defaultNamespace = (String)this.namespaces.pop();
        String uri = (originalUri == null || "".equals(originalUri)) && defaultNamespace != null ? defaultNamespace : originalUri;
        XmlReadHandler currentHandler = this.getCurrentHandler();
        currentHandler.endElement(uri, localName);
    }

    public Object getResult() throws SAXException {
        if (this.rootHandler != null) {
            return this.rootHandler.getObject();
        }
        return null;
    }

    public EntityResolver getEntityResolver() {
        return this;
    }

    public boolean isXmlnsUrisNotAvailable() {
        return this.xmlnsUrisNotAvailable;
    }

    public void setXmlnsUrisNotAvailable(boolean xmlnsUrisNotAvailable) {
        this.xmlnsUrisNotAvailable = xmlnsUrisNotAvailable;
    }
}

