/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.palo.core;

import java.util.ArrayList;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsolidationElement {
    private final String name;
    private boolean isChild = false;
    private final ArrayList<Consolidation> children;
    private final Hashtable<String, Consolidation> childrenFast;

    public ConsolidationElement(String name) {
        this.name = name;
        this.children = new ArrayList();
        this.childrenFast = new Hashtable();
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<Consolidation> getChildren() {
        return this.children;
    }

    public void setIsChild() {
        this.isChild = true;
    }

    public boolean getIsChild() {
        return this.isChild;
    }

    public void addChild(ConsolidationElement element, double consolidationFactor) {
        Consolidation child;
        if (!this.childrenFast.containsKey(element.getName())) {
            child = new Consolidation(element, consolidationFactor);
            this.children.add(child);
            this.childrenFast.put(element.getName(), child);
            element.setIsChild();
        } else {
            child = this.childrenFast.get(element.getName());
        }
        child.setConsolidationFactor(consolidationFactor);
    }

    public class Consolidation {
        private final ConsolidationElement element;
        private double consolidationFactor;

        public Consolidation(ConsolidationElement element, double consolidationFactor) {
            this.element = element;
            this.consolidationFactor = consolidationFactor;
        }

        public ConsolidationElement getElement() {
            return this.element;
        }

        public double getConsolidationFactor() {
            return this.consolidationFactor;
        }

        public void setConsolidationFactor(double consolidationFactor) {
            this.consolidationFactor = consolidationFactor;
        }
    }
}

