/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.palo.core;

import com.jedox.palojlib.interfaces.IDatabase;
import com.jedox.palojlib.interfaces.IDimension;
import com.jedox.palojlib.interfaces.IElement;
import java.util.ArrayList;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaloDimensionCache {
    private Hashtable<String, IElement> elementCache = new Hashtable();
    private String dimensionName = "";
    private IDimension dimension;
    private boolean enableCache = false;
    private boolean allLoaded = false;
    private ArrayList<String> elementsAdded = new ArrayList();

    public PaloDimensionCache(IDatabase paloDatabase, IDimension dimension, boolean enableCache) {
        this.dimension = dimension;
        this.dimensionName = this.dimension.getName();
        this.enableCache = enableCache;
    }

    public PaloDimensionCache(IDatabase paloDatabase, String dimensionName, boolean enableCache) throws Exception {
        this.dimensionName = dimensionName;
        this.enableCache = enableCache;
        this.dimension = paloDatabase.getDimensionByName(dimensionName);
        if (this.dimension == null) {
            throw new Exception("The dimension " + dimensionName + " does not exist.");
        }
    }

    public void loadDimensionCache() throws Exception {
        IElement[] elements;
        if (!this.enableCache) {
            throw new Exception("Cache is not enabled for dimension " + this.dimensionName);
        }
        for (IElement elem : elements = this.dimension.getElements(false)) {
            this.elementCache.put(elem.getName(), elem);
        }
        this.allLoaded = true;
        this.elementsAdded.clear();
    }

    public IElement getElement(String elementName) {
        IElement element = null;
        if (this.enableCache) {
            element = this.elementCache.get(elementName);
        }
        if (element == null && !this.allLoaded) {
            element = this.dimension.getElementByName(elementName, false);
            if (this.enableCache && element != null) {
                this.elementCache.put(elementName, element);
            }
        }
        return element;
    }

    public IElement createElement(String elementName, IElement.ElementType elementType, boolean errorIfExists) throws Exception {
        IElement elem = this.getElement(elementName);
        if (errorIfExists && elem != null) {
            throw new Exception("Element with name " + elementName + " already exists");
        }
        if (elem == null) {
            elem = this.dimension.addBaseElement(elementName, elementType);
            if (this.enableCache) {
                this.elementCache.put(elementName, elem);
            }
        }
        return elem;
    }

    public void createElements(ArrayList<String> elementNames, IElement.ElementType elementType, boolean errorIfExists) throws Exception {
        ArrayList<String> uniqueElementNames = new ArrayList<String>();
        ArrayList<String> toAddElementNames = new ArrayList<String>();
        for (String elementName : elementNames) {
            if (uniqueElementNames.contains(elementName)) continue;
            uniqueElementNames.add(elementName);
        }
        for (String elementName : uniqueElementNames) {
            if (this.elementsAdded.contains(elementName) || this.getElement(elementName) != null) {
                if (!errorIfExists) continue;
                throw new Exception("Element with name " + elementName + " already exists");
            }
            toAddElementNames.add(elementName);
        }
        IElement.ElementType[] elementTypes = new IElement.ElementType[toAddElementNames.size()];
        for (int i = 0; i < toAddElementNames.size(); ++i) {
            elementTypes[i] = elementType;
        }
        this.dimension.addElements(toAddElementNames.toArray(new String[0]), elementTypes);
        for (String elementName : toAddElementNames) {
            this.elementsAdded.add(elementName);
        }
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public IDimension getDimension() {
        return this.dimension;
    }
}

