/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3.vfs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.pentaho.s3.vfs.S3FileSystem;

public class S3FileObject
extends AbstractFileObject
implements FileObject {
    private S3Bucket bucket = null;
    private S3FileSystem fileSystem = null;
    protected Set<String> folders = new HashSet<String>();
    protected static Map<String, S3Object[]> s3ChildrenMap = new HashMap<String, S3Object[]>();

    protected S3FileObject(FileName name, S3FileSystem fileSystem) throws FileSystemException {
        super(name, (AbstractFileSystem)fileSystem);
        this.fileSystem = fileSystem;
    }

    protected String getS3BucketName() throws Exception {
        String bucketName = this.getName().getPath();
        bucketName = bucketName.indexOf("/", 1) > 1 ? bucketName.substring(1, bucketName.indexOf("/", 1)) : bucketName.replaceAll("/", "");
        return bucketName;
    }

    protected S3Bucket getS3Bucket() throws Exception {
        if (this.bucket == null) {
            String bucketName = this.getS3BucketName();
            this.bucket = this.fileSystem.getS3Service().getBucket(bucketName);
        }
        return this.bucket;
    }

    protected S3Object getS3Object(boolean deleteIfAlreadyExists) throws Exception {
        try {
            if (this.getName().getPath().indexOf("/", 1) == -1) {
                return null;
            }
            String name = this.getName().getPath().substring(this.getName().getPath().indexOf("/", 1) + 1);
            if (!name.equals("")) {
                try {
                    S3Object object = this.fileSystem.getS3Service().getObject(this.getS3Bucket(), name);
                    if (deleteIfAlreadyExists) {
                        this.bucket = this.getS3Bucket();
                        this.bucket = this.fileSystem.getS3Service().createBucket(this.getS3BucketName());
                        this.fileSystem.getS3Service().deleteObject(this.getS3Bucket(), name);
                        object = new S3Object(name);
                    }
                    return object;
                }
                catch (Exception e) {
                    S3Object object = new S3Object(name);
                    if (deleteIfAlreadyExists) {
                        this.bucket = this.getS3Bucket();
                        this.bucket = this.fileSystem.getS3Service().createBucket(this.getS3BucketName());
                        this.fileSystem.getS3Service().deleteObject(this.getS3Bucket(), name);
                    }
                    return object;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    protected long doGetContentSize() throws Exception {
        return this.getS3Object(false).getContentLength();
    }

    protected OutputStream doGetOutputStream(boolean append) throws Exception {
        final ByteArrayOutputStream output = new ByteArrayOutputStream();
        final PipedInputStream pis = new PipedInputStream();
        final Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IOUtils.copy((InputStream)pis, (OutputStream)output);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        t.start();
        PipedOutputStream pos = new PipedOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                try {
                    t.join();
                    S3Object s3Object = S3FileObject.this.getS3Object(true);
                    byte[] bytes = output.toByteArray();
                    s3Object.setContentLength((long)bytes.length);
                    s3Object.setDataInputStream((InputStream)new ByteArrayInputStream(bytes));
                    S3FileObject.this.fileSystem.getS3Service().putObject(S3FileObject.this.getS3Bucket(), s3Object);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        pis.connect(pos);
        return pos;
    }

    public void close() throws FileSystemException {
        try {
            this.getS3Object(false).closeDataInputStream();
            super.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected InputStream doGetInputStream() throws Exception {
        return this.getS3Object(false).getDataInputStream();
    }

    protected FileType doGetType() throws Exception {
        if (this.getName().getPath().equals("") || this.getName().getPath().equals("/")) {
            return FileType.FOLDER;
        }
        S3FileObject parent = (S3FileObject)this.getParent();
        if (parent.folders == null || parent.folders.isEmpty()) {
            parent.doListChildren();
        }
        if (((S3FileObject)this.getParent()).folders.contains(this.getName().getBaseName())) {
            return FileType.FOLDER;
        }
        S3Bucket bucket = null;
        S3Object object = null;
        try {
            bucket = this.getS3Bucket();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            object = this.getS3Object(false);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (bucket == null && object == null) {
            return FileType.IMAGINARY;
        }
        if (bucket != null && object == null) {
            return FileType.FOLDER;
        }
        if (object.getBucketName() != null && object.getLastModifiedDate() != null) {
            return FileType.FILE;
        }
        return FileType.IMAGINARY;
    }

    public void doCreateFolder() throws Exception {
        if (this.getS3Object(false) == null) {
            this.bucket = this.fileSystem.getS3Service().createBucket(this.getS3BucketName());
        } else {
            this.bucket = this.fileSystem.getS3Service().createBucket(this.getS3BucketName());
            String name = this.getName().getPath().substring(this.getName().getPath().indexOf("/", 1) + 1) + "/";
            S3Object obj = new S3Object(this.bucket, name);
            this.fileSystem.getS3Service().putObject(this.bucket, obj);
            ((S3FileObject)this.getParent()).folders.add(this.getName().getBaseName());
            s3ChildrenMap.remove(this.getS3BucketName());
        }
    }

    public boolean canRenameTo(FileObject newfile) {
        try {
            if (this.getType().equals(FileType.FOLDER)) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.canRenameTo(newfile);
    }

    public void doDelete() throws Exception {
        S3Object s3obj = this.getS3Object(false);
        this.bucket = this.getS3Bucket();
        if (s3obj == null) {
            if (this.bucket != null) {
                this.fileSystem.getS3Service().deleteBucket(this.bucket);
            }
            return;
        }
        if (this.getName().getPath().equals("") || this.getName().getPath().equals("/")) {
            return;
        }
        String key = s3obj.getKey();
        FileType filetype = this.getName().getType();
        if (filetype.equals(FileType.FILE)) {
            this.fileSystem.getS3Service().deleteObject(this.bucket, key);
        } else if (filetype.equals(FileType.FOLDER)) {
            key = key + "/";
            this.fileSystem.getS3Service().deleteObject(this.bucket, key);
        } else {
            return;
        }
        ((S3FileObject)this.getParent()).folders.remove(this.getName().getBaseName());
        s3ChildrenMap.remove(this.getS3BucketName());
    }

    protected void doRename(FileObject newfile) throws Exception {
        if (this.getType().equals(FileType.FOLDER)) {
            throw new FileSystemException("vfs.provider/rename-not-supported.error");
        }
        S3Object s3Object = this.getS3Object(false);
        s3Object.setKey(newfile.getName().getBaseName());
        this.fileSystem.getS3Service().renameObject(this.getS3BucketName(), this.getName().getBaseName(), s3Object);
    }

    protected long doGetLastModifiedTime() throws Exception {
        if (this.getType() == FileType.FOLDER) {
            return -1L;
        }
        return this.getS3Object(false).getLastModifiedDate().getTime();
    }

    protected void doSetLastModifiedTime(long modtime) throws Exception {
    }

    protected String[] doListChildren() throws Exception {
        S3Bucket bucket = this.getS3Bucket();
        if (bucket == null && (this.getName().getPath().equals("") || this.getName().getPath().equals("/"))) {
            S3Bucket[] buckets = this.fileSystem.getS3Service().listAllBuckets();
            String[] children = new String[buckets.length];
            for (int i = 0; i < buckets.length; ++i) {
                children[i] = buckets[i].getName();
            }
            return children;
        }
        if (s3ChildrenMap.get(this.getS3BucketName()) == null) {
            s3ChildrenMap.put(this.getS3BucketName(), this.fileSystem.getS3Service().listObjects(this.getS3Bucket()));
        }
        S3Object[] s3Children = s3ChildrenMap.get(this.getS3BucketName());
        HashSet<String> vfsChildren = new HashSet<String>();
        if (s3Children != null && this.getName().getPath().indexOf("/", 1) >= 0) {
            String s3Path = this.getName().getPath().substring(this.getName().getPath().indexOf("/", 1) + 1);
            for (S3Object obj : s3Children) {
                String key = obj.getKey();
                if (!key.startsWith(s3Path)) continue;
                String pathSegment = key.substring(s3Path.length() + 1);
                int slashIndex = pathSegment.indexOf("/");
                if (slashIndex > 0) {
                    String child = pathSegment.substring(0, slashIndex);
                    vfsChildren.add(child);
                    this.folders.add(child);
                    continue;
                }
                if ("".equalsIgnoreCase(pathSegment) || pathSegment == null) continue;
                vfsChildren.add(pathSegment);
            }
        } else {
            for (int i = 0; i < s3Children.length; ++i) {
                String key = s3Children[i].getKey();
                int slashIndex = key.indexOf("/");
                if (slashIndex > 0) {
                    String child = key.substring(0, slashIndex);
                    vfsChildren.add(child);
                    this.folders.add(child);
                    continue;
                }
                vfsChildren.add(key);
            }
        }
        return vfsChildren.toArray(new String[0]);
    }
}

