/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.rcfile.merge;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileBlockMergeOutputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileKeyBufferWrapper;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileValueBufferWrapper;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.CombineHiveKey;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public class RCFileMergeMapper
extends MapReduceBase
implements Mapper<Object, RCFileValueBufferWrapper, Object, Object> {
    private JobConf jc;
    Class<? extends Writable> outputClass;
    RCFile.Writer outWriter;
    Path finalPath;
    FileSystem fs;
    boolean exception = false;
    boolean autoDelete = false;
    Path outPath;
    CompressionCodec codec = null;
    int columnNumber = 0;
    boolean hasDynamicPartitions = false;
    boolean tmpPathFixed = false;
    Path tmpPath;
    Path taskTmpPath;
    Path dpPath;
    public static final Log LOG = LogFactory.getLog((String)"RCFileMergeMapper");
    public static String BACKUP_PREFIX = "_backup.";

    public void configure(JobConf job) {
        this.jc = job;
        this.hasDynamicPartitions = HiveConf.getBoolVar((Configuration)job, HiveConf.ConfVars.HIVEMERGECURRENTJOBHASDYNAMICPARTITIONS);
        String specPath = RCFileBlockMergeOutputFormat.getMergeOutputPath(job).toString();
        Path tmpPath = Utilities.toTempPath(specPath);
        Path taskTmpPath = Utilities.toTaskTempPath(specPath);
        this.updatePaths(tmpPath, taskTmpPath);
        try {
            this.fs = new Path(specPath).getFileSystem((Configuration)job);
            this.autoDelete = ShimLoader.getHadoopShims().fileSystemDeleteOnExit(this.fs, this.outPath);
        }
        catch (IOException e) {
            this.exception = true;
            throw new RuntimeException(e);
        }
    }

    private void updatePaths(Path tmpPath, Path taskTmpPath) {
        String taskId = Utilities.getTaskId((Configuration)this.jc);
        this.tmpPath = tmpPath;
        this.taskTmpPath = taskTmpPath;
        this.finalPath = new Path(tmpPath, taskId);
        this.outPath = new Path(taskTmpPath, Utilities.toTempPath(taskId));
    }

    public void map(Object k, RCFileValueBufferWrapper value, OutputCollector<Object, Object> output, Reporter reporter) throws IOException {
        try {
            boolean sameCodec;
            RCFileKeyBufferWrapper key = null;
            key = k instanceof CombineHiveKey ? (RCFileKeyBufferWrapper)((CombineHiveKey)k).getKey() : (RCFileKeyBufferWrapper)k;
            if (this.hasDynamicPartitions) {
                if (this.tmpPathFixed) {
                    this.checkPartitionsMatch(key.inputPath.getParent());
                } else {
                    this.fixTmpPath(key.inputPath.getParent());
                    this.tmpPathFixed = true;
                }
            }
            if (this.outWriter == null) {
                this.codec = key.codec;
                this.columnNumber = key.keyBuffer.getColumnNumber();
                this.jc.setInt("hive.io.rcfile.column.number.conf", this.columnNumber);
                this.outWriter = new RCFile.Writer(this.fs, (Configuration)this.jc, this.outPath, null, this.codec);
            }
            boolean bl = sameCodec = this.codec == key.codec || this.codec.getClass().equals(key.codec.getClass());
            if (key.keyBuffer.getColumnNumber() != this.columnNumber || !sameCodec) {
                throw new IOException("RCFileMerge failed because the input files use different CompressionCodec or have different column number setting.");
            }
            this.outWriter.flushBlock(key.keyBuffer, value.valueBuffer, key.recordLength, key.keyLength, key.compressedKeyLength);
        }
        catch (Throwable e) {
            this.exception = true;
            this.close();
            throw new IOException(e);
        }
    }

    private void checkPartitionsMatch(Path inputPath) throws HiveException {
        if (!this.dpPath.equals((Object)inputPath)) {
            String msg = "Multiple partitions for one block merge mapper: " + this.dpPath + " NOT EQUAL TO " + inputPath;
            LOG.error((Object)msg);
            throw new HiveException(msg);
        }
    }

    private void fixTmpPath(Path inputPath) throws HiveException, IOException {
        this.dpPath = inputPath;
        Path newPath = new Path(".");
        int inputDepth = inputPath.depth();
        int tmpDepth = this.tmpPath.depth();
        while (inputPath != null && inputPath.depth() > tmpDepth) {
            newPath = new Path(inputPath.getName(), newPath);
            --inputDepth;
            inputPath = inputPath.getParent();
        }
        Path newTmpPath = new Path(this.tmpPath, newPath);
        Path newTaskTmpPath = new Path(this.taskTmpPath, newPath);
        if (!this.fs.exists(newTmpPath)) {
            this.fs.mkdirs(newTmpPath);
        }
        this.updatePaths(newTmpPath, newTaskTmpPath);
    }

    public void close() throws IOException {
        if (this.outWriter == null) {
            return;
        }
        this.outWriter.close();
        this.outWriter = null;
        if (!this.exception) {
            FileStatus fss = this.fs.getFileStatus(this.outPath);
            LOG.info((Object)("renamed path " + this.outPath + " to " + this.finalPath + " . File size is " + fss.getLen()));
            if (!this.fs.rename(this.outPath, this.finalPath)) {
                throw new IOException("Unable to rename output to " + this.finalPath);
            }
        } else if (!this.autoDelete) {
            this.fs.delete(this.outPath, true);
        }
    }

    public static Path backupOutputPath(FileSystem fs, Path outpath, JobConf job) throws IOException, HiveException {
        if (fs.exists(outpath)) {
            Path backupPath = new Path(outpath.getParent(), BACKUP_PREFIX + outpath.getName());
            Utilities.rename(fs, outpath, backupPath);
            return backupPath;
        }
        return null;
    }

    public static void jobClose(String outputPath, boolean success, JobConf job, SessionState.LogHelper console, DynamicPartitionCtx dynPartCtx, Reporter reporter) throws HiveException, IOException {
        Path outpath = new Path(outputPath);
        FileSystem fs = outpath.getFileSystem((Configuration)job);
        Path backupPath = RCFileMergeMapper.backupOutputPath(fs, outpath, job);
        Utilities.mvFileToFinalPath(outputPath, (Configuration)job, success, LOG, dynPartCtx, null, reporter);
        fs.delete(backupPath, true);
    }
}

