/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class DriverProxyInvocationChain {
    protected static boolean initialized = false;
    protected static Class<? extends DatabaseMetaData> hive1DbMetaDataClass = null;
    protected static Class<? extends DatabaseMetaData> hive2DbMetaDataClass = null;
    protected static Class<? extends ResultSet> hive1ResultSetClass = null;
    protected static Class<? extends ResultSet> hive2ResultSetClass = null;
    protected static Class<?> hive1ClientClass = null;
    protected static Class<?> hive2ClientClass = null;
    protected static Class<? extends Statement> hive1StatementClass = null;
    protected static Class<? extends Statement> hive2StatementClass = null;

    public static Driver getProxy(Class<? extends Driver> intf, Driver obj) {
        if (!initialized) {
            DriverProxyInvocationChain.init();
        }
        return (Driver)Proxy.newProxyInstance(obj.getClass().getClassLoader(), new Class[]{intf}, (InvocationHandler)new DriverInvocationHandler(obj));
    }

    protected static void init() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            hive1DbMetaDataClass = Class.forName("org.apache.hadoop.hive.jdbc.HiveDatabaseMetaData", false, cl);
            hive1ResultSetClass = Class.forName("org.apache.hadoop.hive.jdbc.HiveQueryResultSet", false, cl);
            hive1ClientClass = Class.forName("org.apache.hadoop.hive.service.HiveInterface", false, cl);
            hive1StatementClass = Class.forName("org.apache.hadoop.hive.jdbc.HiveStatement", false, cl);
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        try {
            hive2DbMetaDataClass = Class.forName("org.apache.hive.jdbc.HiveDatabaseMetaData", false, cl);
            hive2ResultSetClass = Class.forName("org.apache.hive.jdbc.HiveQueryResultSet", false, cl);
            hive2ClientClass = Class.forName("org.apache.hive.service.cli.thrift.TCLIService.Iface", false, cl);
            hive2StatementClass = Class.forName("org.apache.hive.jdbc.HiveStatement", false, cl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        initialized = true;
    }

    private static class ResultSetMetaDataInvocationHandler
    implements InvocationHandler {
        ResultSetMetaData rsmd;

        public ResultSetMetaDataInvocationHandler(ResultSetMetaData r) {
            this.rsmd = r;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke((Object)this.rsmd, args);
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    Throwable cause = t.getCause();
                    if (cause instanceof SQLException) {
                        if (cause.getMessage().equals("Method not supported")) {
                            String methodName = method.getName();
                            if ("isSigned".equals(methodName)) {
                                return this.isSigned((Integer)args[0]);
                            }
                            throw cause;
                        }
                        throw cause;
                    }
                    throw cause;
                }
                throw t;
            }
        }

        public boolean isSigned(int column) throws SQLException {
            int numCols = this.rsmd.getColumnCount();
            if (column < 1 || column > numCols) {
                throw new SQLException("Invalid column value: " + column);
            }
            int type = this.rsmd.getColumnType(column);
            switch (type) {
                case -6: 
                case -5: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return true;
                }
            }
            return false;
        }
    }

    private static class ResultSetInvocationHandler
    implements InvocationHandler {
        ResultSet rs;

        public ResultSetInvocationHandler(ResultSet r) {
            this.rs = r;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if ("getString".equals(method.getName()) && args != null && args.length == 1 && args[0] instanceof String) {
                    return this.getString((String)args[0]);
                }
                Object o = method.invoke((Object)this.rs, args);
                if (o instanceof ResultSetMetaData) {
                    return (ResultSetMetaData)Proxy.newProxyInstance(o.getClass().getClassLoader(), new Class[]{ResultSetMetaData.class}, (InvocationHandler)new ResultSetMetaDataInvocationHandler((ResultSetMetaData)o));
                }
                return o;
            }
            catch (Throwable t) {
                throw t instanceof InvocationTargetException ? t.getCause() : t;
            }
        }

        public String getString(String columnName) throws SQLException {
            String columnVal = null;
            SQLException exception = null;
            try {
                columnVal = this.rs.getString(columnName);
            }
            catch (SQLException se) {
                exception = se;
            }
            if (columnVal != null) {
                return columnVal;
            }
            if (columnName != null && "TABLE_NAME".equals(columnName) && columnName != null && "TABLE_NAME".equals(columnName)) {
                try {
                    columnVal = this.rs.getString(1);
                }
                catch (SQLException se) {
                    throw exception == null ? se : exception;
                }
            }
            return columnVal;
        }
    }

    private static class CaptureResultSetInvocationHandler<T>
    implements InvocationHandler {
        T t;

        public CaptureResultSetInvocationHandler(T t) {
            this.t = t;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.getProxiedObject(method.invoke(this.t, args));
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof SQLException) {
                    if (cause.getMessage().equals("Method not supported")) {
                        String methodName = method.getName();
                        if ("getMetaData".equals(method.getName()) && (args == null || args.length == 0)) {
                            return this.getProxiedObject(this.getMetaData());
                        }
                        throw cause;
                    }
                    throw cause;
                }
                throw cause;
            }
        }

        public ResultSetMetaData getMetaData() {
            ResultSetMetaData rsmd = null;
            if (this.t instanceof Statement) {
                try {
                    ResultSet resultSet = ((Statement)this.t).getResultSet();
                    rsmd = resultSet == null ? null : resultSet.getMetaData();
                }
                catch (SQLException se) {
                    rsmd = null;
                }
            }
            return rsmd;
        }

        private Object getProxiedObject(Object o) {
            if (o == null) {
                return null;
            }
            if (o instanceof ResultSet) {
                ResultSet r = (ResultSet)o;
                return (ResultSet)Proxy.newProxyInstance(r.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new ResultSetInvocationHandler(r));
            }
            if (o instanceof ResultSetMetaData) {
                ResultSetMetaData r = (ResultSetMetaData)o;
                return (ResultSetMetaData)Proxy.newProxyInstance(r.getClass().getClassLoader(), new Class[]{ResultSetMetaData.class}, (InvocationHandler)new ResultSetMetaDataInvocationHandler(r));
            }
            return o;
        }
    }

    private static class DatabaseMetaDataInvocationHandler
    implements InvocationHandler {
        DatabaseMetaData t;

        public DatabaseMetaDataInvocationHandler(DatabaseMetaData t) {
            this.t = t;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (hive1DbMetaDataClass != null && hive1DbMetaDataClass.isAssignableFrom(this.t.getClass())) {
                    return this.getTables(this.t, hive1DbMetaDataClass, hive1StatementClass, hive1ClientClass, (String)args[0], (String)args[1], (String)args[2], (String[])args[3]);
                }
                if (hive2DbMetaDataClass != null && hive2DbMetaDataClass.isAssignableFrom(this.t.getClass())) {
                    return this.getTables(this.t, hive2DbMetaDataClass, hive2StatementClass, hive2ClientClass, (String)args[0], (String)args[1], (String)args[2], (String[])args[3]);
                }
                Object o = method.invoke((Object)this.t, args);
                if (o instanceof ResultSet) {
                    ResultSet r = (ResultSet)o;
                    return (ResultSet)Proxy.newProxyInstance(r.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new ResultSetInvocationHandler(r));
                }
                return o;
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    Throwable cause = t.getCause();
                    if (cause instanceof SQLException) {
                        if (cause.getMessage().equals("Method not supported")) {
                            String methodName = method.getName();
                            if ("getIdentifierQuoteString".equals(methodName)) {
                                return this.getIdentifierQuoteString();
                            }
                            throw cause;
                        }
                        throw cause;
                    }
                    throw cause;
                }
                throw t;
            }
        }

        public String getIdentifierQuoteString() throws SQLException {
            return "'";
        }

        public ResultSet getTables(Object originalObject, Class<? extends DatabaseMetaData> dbMetadataClass, Class<? extends Statement> statementClass, Class<?> clientClass, String catalog, String schemaPattern, String tableNamePattern, String[] types) throws Exception {
            boolean tables = false;
            if (types == null) {
                tables = true;
            } else {
                for (String type : types) {
                    if (!"TABLE".equals(type)) continue;
                    tables = true;
                }
            }
            if (tables) {
                Method getClient = dbMetadataClass.getDeclaredMethod("getClient", new Class[0]);
                Constructor<? extends Statement> hiveStatementCtor = statementClass.getDeclaredConstructor(clientClass);
                Statement showTables = hiveStatementCtor.newInstance(clientClass.cast(getClient.invoke(originalObject, new Object[0])));
                showTables.executeQuery("show tables");
                ResultSet rs = showTables.getResultSet();
                return rs;
            }
            Method getTables = dbMetadataClass.getDeclaredMethod("getTables", new Class[0]);
            ResultSet rs = (ResultSet)getTables.invoke(originalObject, catalog, schemaPattern, tableNamePattern, types);
            return rs;
        }
    }

    private static class ConnectionInvocationHandler
    implements InvocationHandler {
        Connection connection;

        public ConnectionInvocationHandler(Connection obj) {
            this.connection = obj;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object o = null;
            try {
                o = method.invoke((Object)this.connection, args);
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    Throwable cause = t.getCause();
                    if (cause instanceof SQLException) {
                        if (cause.getMessage().equals("Method not supported")) {
                            String methodName = method.getName();
                            if ("createStatement".equals(methodName)) {
                                o = this.createStatement(this.connection, args);
                            }
                            if ("setReadOnly".equals(methodName)) {
                                o = null;
                            }
                            throw cause;
                        }
                        throw cause;
                    }
                    throw cause;
                }
                throw t;
            }
            if (o instanceof DatabaseMetaData) {
                DatabaseMetaData dbmd = (DatabaseMetaData)o;
                return (DatabaseMetaData)Proxy.newProxyInstance(dbmd.getClass().getClassLoader(), new Class[]{DatabaseMetaData.class}, (InvocationHandler)new DatabaseMetaDataInvocationHandler(dbmd));
            }
            if (o instanceof PreparedStatement) {
                PreparedStatement st = (PreparedStatement)o;
                return (PreparedStatement)Proxy.newProxyInstance(st.getClass().getClassLoader(), new Class[]{PreparedStatement.class}, new CaptureResultSetInvocationHandler<PreparedStatement>(st));
            }
            if (o instanceof Statement) {
                Statement st = (Statement)o;
                return (Statement)Proxy.newProxyInstance(st.getClass().getClassLoader(), new Class[]{Statement.class}, new CaptureResultSetInvocationHandler<Statement>(st));
            }
            return o;
        }

        public Statement createStatement(Connection c, Object[] args) throws SQLException {
            if (c.isClosed()) {
                throw new SQLException("Can't create Statement, connection is closed ");
            }
            return c.createStatement();
        }
    }

    private static class DriverInvocationHandler
    implements InvocationHandler {
        Driver driver;

        public DriverInvocationHandler(Driver obj) {
            this.driver = obj;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Object o = method.invoke((Object)this.driver, args);
                if (o instanceof Connection) {
                    return (Connection)Proxy.newProxyInstance(o.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionInvocationHandler((Connection)o));
                }
                return o;
            }
            catch (Throwable t) {
                throw t instanceof InvocationTargetException ? t.getCause() : t;
            }
        }
    }
}

