/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.toc;

import java.util.ArrayList;
import java.util.Arrays;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.function.Function;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.function.PageFunction;
import org.pentaho.reporting.engine.classic.core.function.WrapperExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class TocDataGeneratorFunction
extends AbstractFunction
implements PageEventListener {
    private PageFunction pageFunction;
    private TypedTableModel model;
    private ArrayList<String> groups = new ArrayList();
    private ArrayList<Integer> groupCount;
    private ArrayList<Object> groupValues;
    private String titleField;
    private FormulaExpression titleFormula;
    private String indexSeparator = ".";
    private boolean collectDetails;
    private transient int groupIndex;
    private transient boolean rowAdded;
    private transient int rowCounter;
    private transient boolean initialized;
    private int dependencyLevel = -1;

    public TocDataGeneratorFunction() {
        this.pageFunction = new PageFunction();
        this.model = new TypedTableModel();
        this.titleFormula = new FormulaExpression();
    }

    public void setDependencyLevel(int dependencyLevel) {
        this.dependencyLevel = dependencyLevel;
    }

    public int getDependencyLevel() {
        return this.dependencyLevel;
    }

    public String getIndexSeparator() {
        return this.indexSeparator;
    }

    public void setIndexSeparator(String indexSeparator) {
        this.indexSeparator = indexSeparator;
    }

    public String getTitleFormula() {
        return this.titleFormula.getFormula();
    }

    public void setTitleFormula(String titleFormula) {
        this.titleFormula.setFormula(titleFormula);
    }

    public String getTitleField() {
        return this.titleField;
    }

    public void setTitleField(String titleField) {
        this.titleField = titleField;
    }

    public boolean isCollectDetails() {
        return this.collectDetails;
    }

    public void setCollectDetails(boolean collectDetails) {
        this.collectDetails = collectDetails;
    }

    public void setGroup(int index, String field) {
        if (this.groups.size() == index) {
            this.groups.add(field);
        } else {
            this.groups.set(index, field);
        }
        this.groupCount = null;
    }

    public String getGroup(int index) {
        return this.groups.get(index);
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public String[] getGroup() {
        return this.groups.toArray(new String[this.groups.size()]);
    }

    public void setGroup(String[] fields) {
        this.groups.clear();
        this.groups.addAll(Arrays.asList(fields));
        this.groupCount = null;
    }

    public void reportInitialized(ReportEvent event) {
        if (event.isDeepTraversing()) {
            return;
        }
        if (!this.initialized) {
            this.initialized = true;
            this.model.addColumn("item-title", Object.class);
            this.model.addColumn("item-page", Number.class);
            this.model.addColumn("item-index", String.class);
            this.model.addColumn("item-index-array", Integer[].class);
            if (this.groups.size() == 0) {
                for (int i = 0; i < 40; ++i) {
                    this.model.addColumn("group-value-" + i, Object.class);
                }
            } else {
                for (int i = 0; i < this.groups.size(); ++i) {
                    this.model.addColumn("group-value-" + i, Object.class);
                }
            }
            this.groupCount = new ArrayList(this.groups.size());
            this.groupValues = new ArrayList(this.groups.size());
        }
        this.pageFunction.reportInitialized(event);
    }

    public void reportStarted(ReportEvent event) {
        if (event.isDeepTraversing()) {
            return;
        }
        this.pageFunction.reportStarted(event);
        this.rowAdded = false;
        this.groupIndex = -1;
        this.rowCounter = 0;
    }

    public void groupStarted(ReportEvent event) {
        if (event.isDeepTraversing() && "toc".equals(event.getOriginatingState().getReport().getMetaData().getName())) {
            return;
        }
        Group group = FunctionUtilities.getCurrentDeepTraverseGroup((ReportEvent)event);
        if (!(group instanceof RelationalGroup)) {
            return;
        }
        RelationalGroup relationalGroup = (RelationalGroup)group;
        ++this.groupIndex;
        if (this.groupIndex < this.getGroupCount() || this.getGroupCount() == 0) {
            String fieldName;
            this.rowAdded = false;
            DataRow dataRow = this.extractDataRow(event);
            Object groupValue = this.groupIndex < this.getGroupCount() ? ((fieldName = this.getGroup(this.groupIndex)) != null ? dataRow.get(fieldName) : this.extractFieldFromGroup(relationalGroup, dataRow)) : this.extractFieldFromGroup(relationalGroup, dataRow);
            this.addOrUpdateValue(groupValue);
        }
    }

    private DataRow extractDataRow(ReportEvent event) {
        if (!event.isDeepTraversing()) {
            return this.getDataRow();
        }
        return event.getOriginatingState().getDataRow();
    }

    private Object extractFieldFromGroup(RelationalGroup relationalGroup, DataRow dataRow) {
        Object[] groupValue;
        String[] fields = relationalGroup.getFieldsArray();
        if (fields.length == 0) {
            groupValue = null;
        } else if (fields.length == 1) {
            groupValue = dataRow.get(fields[0]);
        } else {
            Object[] localGroupValues = new Object[fields.length];
            for (int i = 0; i < localGroupValues.length; ++i) {
                localGroupValues[i] = dataRow.get(fields[i]);
            }
            groupValue = localGroupValues;
        }
        return groupValue;
    }

    public void itemsStarted(ReportEvent event) {
        if (event.isDeepTraversing() && "toc".equals(event.getOriginatingState().getReport().getMetaData().getName())) {
            return;
        }
        if (this.collectDetails) {
            ++this.groupIndex;
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        if (event.isDeepTraversing() && "toc".equals(event.getOriginatingState().getReport().getMetaData().getName())) {
            return;
        }
        if (this.collectDetails && (this.groupIndex < this.getGroupCount() || this.getGroupCount() == 0)) {
            Object groupValue;
            this.rowAdded = false;
            if (this.groupIndex < this.getGroupCount()) {
                String fieldName = this.getGroup(this.groupIndex);
                if (fieldName != null) {
                    DataRow dataRow = this.extractDataRow(event);
                    groupValue = dataRow.get(fieldName);
                } else {
                    groupValue = null;
                }
            } else {
                groupValue = null;
            }
            this.addOrUpdateValue(groupValue);
        }
        this.collectOrUpdate(event);
    }

    private void collectOrUpdate(ReportEvent event) {
        if (FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)event)) {
            if (!this.rowAdded) {
                int i;
                if (!this.isValidGroupValues()) {
                    return;
                }
                DataRow dataRow = this.extractDataRow(event);
                Object titleValue = this.computeTitleValue(dataRow);
                StringBuilder indexText = new StringBuilder();
                Integer[] indexValues = new Integer[this.groupCount.size()];
                for (i = 0; i < this.groupCount.size(); ++i) {
                    Integer o;
                    if (i != 0) {
                        indexText.append(this.indexSeparator);
                    }
                    indexValues[i] = o = this.groupCount.get(i);
                    indexText.append(o);
                }
                this.model.setValueAt(titleValue, this.rowCounter, 0);
                this.model.setValueAt((Object)new Integer(9999), this.rowCounter, 1);
                this.model.setValueAt((Object)indexText.toString(), this.rowCounter, 2);
                this.model.setValueAt((Object)indexValues, this.rowCounter, 3);
                for (i = 0; i < this.groupValues.size(); ++i) {
                    Object groupValue = this.groupValues.get(i);
                    this.model.setValueAt(groupValue, this.rowCounter, 4 + i);
                }
                ++this.rowCounter;
                this.rowAdded = true;
            }
        } else if (FunctionUtilities.isLayoutLevel((ReportEvent)event) && !this.rowAdded) {
            if (!this.isValidGroupValues()) {
                return;
            }
            this.model.setValueAt(this.pageFunction.getValue(), this.rowCounter, 1);
            this.rowAdded = true;
            ++this.rowCounter;
        }
    }

    private boolean isValidGroupValues() {
        for (int i = 0; i < this.groupValues.size(); ++i) {
            String s = (String)this.groupValues.get(i);
            if (StringUtils.isEmpty((String)s)) continue;
            return true;
        }
        return false;
    }

    private void addOrUpdateValue(Object groupValue) {
        if (this.groupCount.size() == this.groupIndex) {
            this.groupCount.add(IntegerCache.getInteger((int)1));
            this.groupValues.add(groupValue);
        } else {
            int lastIndex = this.groupCount.size() - 1;
            if (lastIndex == this.groupIndex) {
                Integer o = this.groupCount.get(lastIndex);
                if (o == null) {
                    throw new IllegalStateException();
                }
                this.groupCount.set(lastIndex, IntegerCache.getInteger((int)(o + 1)));
                this.groupValues.set(lastIndex, groupValue);
            } else {
                throw new IllegalStateException("Out of index error: " + this.groupIndex + " " + this.groupCount.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object computeTitleValue(DataRow dataRow) {
        if (!StringUtils.isEmpty((String)this.titleField)) {
            return dataRow.get(this.titleField);
        }
        try {
            this.titleFormula.setRuntime((ExpressionRuntime)new WrapperExpressionRuntime(dataRow, this.getRuntime()));
            Object object = this.titleFormula.getValue();
            return object;
        }
        finally {
            this.titleFormula.setRuntime(null);
        }
    }

    public void itemsFinished(ReportEvent event) {
        if (event.isDeepTraversing() && "toc".equals(event.getOriginatingState().getReport().getMetaData().getName())) {
            return;
        }
        this.collectOrUpdate(event);
        if (this.collectDetails) {
            if (this.groupIndex + 2 == this.groupCount.size()) {
                this.groupCount.remove(this.groupCount.size() - 1);
                this.groupValues.remove(this.groupValues.size() - 1);
            }
            --this.groupIndex;
        }
    }

    public void groupFinished(ReportEvent event) {
        if (event.isDeepTraversing() && "toc".equals(event.getOriginatingState().getReport().getMetaData().getName())) {
            return;
        }
        Group group = FunctionUtilities.getCurrentDeepTraverseGroup((ReportEvent)event);
        if (!(group instanceof RelationalGroup)) {
            return;
        }
        if (this.groupIndex + 2 == this.groupCount.size()) {
            this.groupCount.remove(this.groupCount.size() - 1);
            this.groupValues.remove(this.groupValues.size() - 1);
        }
        --this.groupIndex;
    }

    public void pageStarted(ReportEvent event) {
        this.pageFunction.pageStarted(event);
    }

    public void pageFinished(ReportEvent event) {
        this.pageFunction.pageFinished(event);
    }

    public Object getValue() {
        return this.model;
    }

    public TypedTableModel getModel() {
        return this.model;
    }

    public boolean isDeepTraversing() {
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        TocDataGeneratorFunction o = (TocDataGeneratorFunction)((Object)super.clone());
        o.titleFormula = (FormulaExpression)this.titleFormula.clone();
        o.pageFunction = (PageFunction)this.pageFunction.clone();
        if (this.groupCount != null) {
            o.groupCount = (ArrayList)this.groupCount.clone();
            o.groupValues = (ArrayList)this.groupValues.clone();
        }
        return o;
    }

    public Expression getInstance() {
        TocDataGeneratorFunction instance = (TocDataGeneratorFunction)super.getInstance();
        instance.model = new TypedTableModel();
        instance.titleFormula = (FormulaExpression)this.titleFormula.getInstance();
        instance.pageFunction = (PageFunction)this.pageFunction.getInstance();
        instance.groups = (ArrayList)this.groups.clone();
        instance.groupCount = null;
        instance.groupValues = null;
        return instance;
    }
}

