/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.hadoop.hive.jdbc.HiveQueryResultSet;
import org.apache.hadoop.hive.service.HiveInterface;
import org.apache.hadoop.hive.service.HiveServerException;

public class HivePreparedStatement
implements PreparedStatement {
    private final String sql;
    private HiveInterface client;
    private final HashMap<Integer, String> parameters = new HashMap();
    private ResultSet resultSet = null;
    private int maxRows = 0;
    private SQLWarning warningChain = null;
    private boolean isClosed = false;
    private final int updateCount = 0;

    public HivePreparedStatement(HiveInterface client, String sql) {
        this.client = client;
        this.sql = sql;
    }

    @Override
    public void addBatch() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.parameters.clear();
    }

    @Override
    public boolean execute() throws SQLException {
        ResultSet rs = this.executeImmediate(this.sql);
        return rs != null;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.executeImmediate(this.sql);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.executeImmediate(this.sql);
        return 0;
    }

    protected ResultSet executeImmediate(String sql) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Can't execute after statement has been closed");
        }
        try {
            this.clearWarnings();
            this.resultSet = null;
            if (sql.contains("?")) {
                sql = this.updateSql(sql, this.parameters);
            }
            this.client.execute(sql);
        }
        catch (HiveServerException e) {
            throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode(), e);
        }
        catch (Exception ex) {
            throw new SQLException(ex.toString(), "08S01", ex);
        }
        this.resultSet = new HiveQueryResultSet(this.client, this.maxRows);
        return this.resultSet;
    }

    private String updateSql(String sql, HashMap<Integer, String> parameters) {
        StringBuffer newSql = new StringBuffer(sql);
        int paramLoc = 1;
        while (this.getCharIndexFromSqlByParamLocation(sql, '?', paramLoc) > 0) {
            if (parameters.containsKey(paramLoc)) {
                int tt = this.getCharIndexFromSqlByParamLocation(newSql.toString(), '?', 1);
                newSql.deleteCharAt(tt);
                newSql.insert(tt, parameters.get(paramLoc));
            }
            ++paramLoc;
        }
        return newSql.toString();
    }

    private int getCharIndexFromSqlByParamLocation(String sql, char cchar, int paramLoc) {
        int signalCount = 0;
        int charIndex = -1;
        int num = 0;
        for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (c == '\'' || c == '\\') {
                ++signalCount;
                continue;
            }
            if (c != cchar || signalCount % 2 != 0 || ++num != paramLoc) continue;
            charIndex = i;
            break;
        }
        return charIndex;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.parameters.put(parameterIndex, "" + x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.parameters.put(parameterIndex, "" + x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.parameters.put(parameterIndex, "" + x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.parameters.put(parameterIndex, "" + x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.parameters.put(parameterIndex, "" + x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.parameters.put(parameterIndex, "" + x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.parameters.put(parameterIndex, "" + x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        x = x.replace("'", "\\'");
        this.parameters.put(parameterIndex, "'" + x + "'");
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.parameters.put(parameterIndex, x.toString());
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public void close() throws SQLException {
        this.client = null;
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.isClosed = true;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("max must be >= 0");
        }
        this.maxRows = max;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }
}

