/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hive.jdbc.JdbcColumn;
import org.apache.hadoop.hive.jdbc.Utils;

public class HiveResultSetMetaData
implements ResultSetMetaData {
    private final List<String> columnNames;
    private final List<String> columnTypes;

    public HiveResultSetMetaData(List<String> columnNames, List<String> columnTypes) {
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnNames.size();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        int columnType = this.getColumnType(column);
        return JdbcColumn.columnDisplaySize(columnType);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.columnNames.get(column - 1);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.columnNames.get(column - 1);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        if (this.columnTypes == null) {
            throw new SQLException("Could not determine column type name for ResultSet");
        }
        if (column < 1 || column > this.columnTypes.size()) {
            throw new SQLException("Invalid column value: " + column);
        }
        String type = this.columnTypes.get(column - 1);
        return Utils.hiveTypeToSqlType(type);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        if (this.columnTypes == null) {
            throw new SQLException("Could not determine column type name for ResultSet");
        }
        if (column < 1 || column > this.columnTypes.size()) {
            throw new SQLException("Invalid column value: " + column);
        }
        String type = this.columnTypes.get(column - 1);
        if ("string".equalsIgnoreCase(type)) {
            return "string";
        }
        if ("float".equalsIgnoreCase(type)) {
            return "float";
        }
        if ("double".equalsIgnoreCase(type)) {
            return "double";
        }
        if ("boolean".equalsIgnoreCase(type)) {
            return "boolean";
        }
        if ("tinyint".equalsIgnoreCase(type)) {
            return "tinyint";
        }
        if ("smallint".equalsIgnoreCase(type)) {
            return "smallint";
        }
        if ("int".equalsIgnoreCase(type)) {
            return "int";
        }
        if ("bigint".equalsIgnoreCase(type)) {
            return "bigint";
        }
        if ("timestamp".equalsIgnoreCase(type)) {
            return "timestamp";
        }
        if (type.startsWith("map<")) {
            return "string";
        }
        if (type.startsWith("array<")) {
            return "string";
        }
        if (type.startsWith("struct<")) {
            return "string";
        }
        throw new SQLException("Unrecognized column type: " + type);
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        int columnType = this.getColumnType(column);
        return JdbcColumn.columnPrecision(columnType);
    }

    @Override
    public int getScale(int column) throws SQLException {
        int columnType = this.getColumnType(column);
        return JdbcColumn.columnScale(columnType);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getTableName(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 1;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }
}

