/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.s3csvinput;

import java.io.IOException;
import java.util.ArrayList;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.s3csvinput.Messages;
import org.pentaho.di.trans.steps.s3csvinput.S3CsvInputData;
import org.pentaho.di.trans.steps.s3csvinput.S3CsvInputMeta;

public class S3CsvInput
extends BaseStep
implements StepInterface {
    private S3CsvInputMeta meta;
    private S3CsvInputData data;

    public S3CsvInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (S3CsvInputMeta)smi;
        this.data = (S3CsvInputData)sdi;
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this);
            if (this.data.filenames == null) {
                this.getFilenamesFromPreviousSteps();
            }
            this.data.parallel = this.meta.isRunningInParallel() && this.data.totalNumberOfSteps > 1;
            this.data.convertRowMeta = this.data.outputRowMeta.clone();
            for (ValueMetaInterface valueMeta : this.data.convertRowMeta.getValueMetaList()) {
                valueMeta.setStorageType(1);
            }
            if (this.data.parallel) {
                this.prepareToRunInParallel();
            }
            if (!this.openNextFile()) {
                this.setOutputDone();
                return false;
            }
        }
        if (this.data.parallel && this.data.totalBytesRead > this.data.blockToRead) {
            this.setOutputDone();
            return false;
        }
        Object[] outputRowData = this.readOneRow(true);
        if (outputRowData == null) {
            if (this.openNextFile()) {
                return true;
            }
            this.setOutputDone();
            return false;
        }
        this.putRow(this.data.outputRowMeta, outputRowData);
        if (this.checkFeedback(this.getLinesInput()) && this.log.isBasic()) {
            this.logBasic(Messages.getString("S3CsvInput.Log.LineNumber", Long.toString(this.getLinesInput())));
        }
        return true;
    }

    private void prepareToRunInParallel() throws KettleException {
        try {
            for (String filename : this.data.filenames) {
                S3Object objectDetails = this.data.s3Service.getObjectDetails(this.data.s3bucket, filename);
                long size = objectDetails.getContentLength();
                this.data.fileSizes.add(size);
                this.data.totalFileSize += size;
            }
            this.data.blockToRead = Math.round((double)this.data.totalFileSize / (double)this.data.totalNumberOfSteps);
            this.data.startPosition = this.data.blockToRead * (long)this.data.stepNumber;
            this.data.endPosition = this.data.startPosition + this.data.blockToRead;
            long totalFileSize = 0L;
            for (int i = 0; i < this.data.fileSizes.size(); ++i) {
                long size = this.data.fileSizes.get(i);
                if (this.data.startPosition >= totalFileSize && this.data.startPosition < totalFileSize + size) {
                    this.data.filenr = i;
                    this.data.startFilenr = i;
                    if (this.data.startPosition == 0L) {
                        this.data.bytesToSkipInFirstFile = 0L;
                        break;
                    }
                    this.data.bytesToSkipInFirstFile = this.data.startPosition - totalFileSize;
                    break;
                }
                totalFileSize += size;
            }
            this.logBasic(Messages.getString("S3CsvInput.Log.ParallelFileNrAndPositionFeedback", this.data.filenames[this.data.filenr], Long.toString(this.data.fileSizes.get(this.data.filenr)), Long.toString(this.data.bytesToSkipInFirstFile), Long.toString(this.data.blockToRead)));
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("S3CsvInput.Exception.ErrorPreparingParallelRun"), (Throwable)e);
        }
    }

    private void getFilenamesFromPreviousSteps() throws KettleException {
        ArrayList<String> filenames = new ArrayList<String>();
        boolean firstRow = true;
        int index = -1;
        Object[] row = this.getRow();
        while (row != null) {
            if (firstRow) {
                firstRow = false;
                String filenameField = this.environmentSubstitute(this.meta.getFilenameField());
                index = this.getInputRowMeta().indexOfValue(filenameField);
                if (index < 0) {
                    throw new KettleException(Messages.getString("S3CsvInput.Exception.FilenameFieldNotFound", filenameField));
                }
            }
            String filename = this.getInputRowMeta().getString(row, index);
            filenames.add(filename);
            row = this.getRow();
        }
        this.data.filenames = filenames.toArray(new String[filenames.size()]);
        this.logBasic(Messages.getString("S3CsvInput.Log.ReadingFromNrFiles", Integer.toString(this.data.filenames.length)));
    }

    private boolean openNextFile() throws KettleException {
        try {
            if (this.data.fis != null) {
                this.data.fis.close();
            }
            if (this.data.filenr >= this.data.filenames.length) {
                return false;
            }
            this.data.s3Object = null;
            this.data.s3Object = this.data.parallel ? this.data.s3Service.getObject(this.data.s3bucket, this.data.filenames[this.data.filenr], null, null, null, null, Long.valueOf(this.data.bytesToSkipInFirstFile), Long.valueOf(this.data.bytesToSkipInFirstFile + this.data.blockToRead + (long)(this.data.maxLineSize * 2))) : this.data.s3Service.getObject(this.data.s3bucket, this.data.filenames[this.data.filenr]);
            if (this.meta.isLazyConversionActive()) {
                this.data.binaryFilename = this.data.filenames[this.data.filenr].getBytes();
            }
            this.data.fis = this.data.s3Object.getDataInputStream();
            if (this.data.parallel && this.data.bytesToSkipInFirstFile > 0L) {
                this.readOneRow(false);
            }
            if (this.meta.isHeaderPresent() && !this.data.parallel || this.data.parallel && this.data.filenr == this.data.startFilenr && this.data.bytesToSkipInFirstFile <= 0L || this.data.parallel && this.data.filenr > this.data.startFilenr && this.data.bytesToSkipInFirstFile <= 0L) {
                this.readOneRow(false);
                this.logBasic(Messages.getString("S3CsvInput.Log.HeaderRowSkipped", this.data.filenames[this.data.filenr]));
            }
            ++this.data.filenr;
            this.data.rowNumber = 1L;
            this.data.bytesToSkipInFirstFile = -1L;
            return true;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    private Object[] readOneRow(boolean doConversions) throws KettleException {
        try {
            Object[] outputRowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            int outputIndex = 0;
            boolean newLineFound = false;
            int newLines = 0;
            while (!newLineFound && outputIndex < this.data.convertRowMeta.size()) {
                if (this.data.endBuffer >= this.data.bufferSize) {
                    this.data.resizeByteBuffer();
                    if (!this.data.readBufferFromFile()) {
                        return null;
                    }
                }
                boolean delimiterFound = false;
                boolean enclosureFound = false;
                int escapedEnclosureFound = 0;
                while (!delimiterFound) {
                    if (this.data.byteBuffer[this.data.endBuffer] == this.data.delimiter[0]) {
                        delimiterFound = true;
                        continue;
                    }
                    if (this.data.byteBuffer[this.data.endBuffer] == 10 || this.data.byteBuffer[this.data.endBuffer] == 13) {
                        ++this.data.endBuffer;
                        ++this.data.totalBytesRead;
                        newLines = 1;
                        if (this.data.endBuffer >= this.data.bufferSize) {
                            this.data.resizeByteBuffer();
                            this.data.readBufferFromFile();
                        }
                        if (this.data.byteBuffer[this.data.endBuffer] == 10 || this.data.byteBuffer[this.data.endBuffer] == 13) {
                            ++this.data.endBuffer;
                            ++this.data.totalBytesRead;
                            newLines = 2;
                            if (this.data.endBuffer >= this.data.bufferSize) {
                                this.data.resizeByteBuffer();
                                this.data.readBufferFromFile();
                            }
                        }
                        newLineFound = true;
                        delimiterFound = true;
                        continue;
                    }
                    if (this.data.enclosure != null && this.data.byteBuffer[this.data.endBuffer] == this.data.enclosure[0]) {
                        boolean keepGoing;
                        enclosureFound = true;
                        do {
                            if (this.data.increaseEndBuffer()) {
                                enclosureFound = false;
                                break;
                            }
                            boolean bl = keepGoing = this.data.byteBuffer[this.data.endBuffer] != this.data.enclosure[0];
                            if (keepGoing) continue;
                            if (this.data.increaseEndBuffer()) {
                                enclosureFound = false;
                                break;
                            }
                            boolean bl2 = keepGoing = this.data.byteBuffer[this.data.endBuffer] == this.data.enclosure[0];
                            if (!keepGoing) continue;
                            ++escapedEnclosureFound;
                        } while (keepGoing);
                        if (this.data.endBuffer < this.data.bufferSize) continue;
                        newLineFound = true;
                        newLines += 2;
                        break;
                    }
                    ++this.data.endBuffer;
                    ++this.data.totalBytesRead;
                    if (this.data.endBuffer < this.data.bufferSize) continue;
                    this.data.resizeByteBuffer();
                    if (this.data.readBufferFromFile() || this.data.endBuffer < this.data.bufferSize) continue;
                    newLineFound = true;
                    break;
                }
                int length = this.data.endBuffer - this.data.startBuffer;
                if (newLineFound && (length -= newLines) <= 0) {
                    length = 0;
                }
                if (enclosureFound) {
                    ++this.data.startBuffer;
                    if ((length -= 2) <= 0) {
                        length = 0;
                    }
                }
                if (length <= 0) {
                    length = 0;
                }
                byte[] field = new byte[length];
                System.arraycopy(this.data.byteBuffer, this.data.startBuffer, field, 0, length);
                if (escapedEnclosureFound > 0) {
                    if (this.log.isRowLevel()) {
                        this.logRowlevel("Escaped enclosures found in " + new String(field));
                    }
                    field = this.data.removeEscapedEnclosures(field, escapedEnclosureFound);
                }
                if (doConversions) {
                    if (this.meta.isLazyConversionActive()) {
                        outputRowData[outputIndex++] = field;
                    } else {
                        ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(outputIndex);
                        outputRowData[outputIndex++] = sourceValueMeta.convertBinaryStringToNativeType(field);
                    }
                } else {
                    outputRowData[outputIndex++] = null;
                }
                if (!newLineFound) {
                    ++this.data.totalBytesRead;
                }
                this.data.startBuffer = ++this.data.endBuffer;
            }
            if (this.meta.isIncludingFilename() && !Const.isEmpty((String)this.meta.getFilenameField())) {
                outputRowData[outputIndex++] = this.meta.isLazyConversionActive() ? (Object)this.data.binaryFilename : this.data.filenames[this.data.filenr - 1];
            }
            if (this.data.isAddingRowNumber) {
                outputRowData[outputIndex++] = new Long(this.data.rowNumber++);
            }
            this.incrementLinesInput();
            return outputRowData;
        }
        catch (Exception e) {
            throw new KettleFileException("Exception reading line using NIO", (Throwable)e);
        }
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (S3CsvInputMeta)smi;
        this.data = (S3CsvInputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.preferredBufferSize = 500000;
            try {
                this.data.s3Service = this.meta.getS3Service((VariableSpace)this);
                String bucketname = this.environmentSubstitute(this.meta.getBucket());
                S3Bucket[] buckets = this.data.s3Service.listAllBuckets();
                this.data.s3bucket = null;
                for (S3Bucket bucket : buckets) {
                    if (!bucket.getName().equals(bucketname)) continue;
                    this.data.s3bucket = bucket;
                }
                if (this.data.s3bucket == null) {
                    this.logError("Unable to find specified bucket : [" + bucketname + "]");
                    return false;
                }
                this.data.maxLineSize = Integer.parseInt(this.environmentSubstitute(this.meta.getMaxLineSize()));
                if (this.getTransMeta().findNrPrevSteps(this.getStepMeta()) == 0) {
                    String filename = this.environmentSubstitute(this.meta.getFilename());
                    if (Const.isEmpty((String)filename)) {
                        this.logError(Messages.getString("S3CsvInput.MissingFilename.Message"));
                        return false;
                    }
                    this.data.filenames = new String[]{filename};
                } else {
                    this.data.filenames = null;
                    this.data.filenr = 0;
                }
                this.data.totalBytesRead = 0L;
                this.data.delimiter = this.environmentSubstitute(this.meta.getDelimiter()).getBytes();
                this.data.enclosure = (byte[])(Const.isEmpty((String)this.meta.getEnclosure()) ? null : this.environmentSubstitute(this.meta.getEnclosure()).getBytes());
                this.data.isAddingRowNumber = !Const.isEmpty((String)this.meta.getRowNumField());
                this.data.stopReading = false;
                if (this.meta.isRunningInParallel()) {
                    this.data.stepNumber = this.getUniqueStepNrAcrossSlaves();
                    this.data.totalNumberOfSteps = this.getUniqueStepCountAcrossSlaves();
                    this.data.fileSizes = new ArrayList<Long>();
                    this.data.totalFileSize = 0L;
                }
                return true;
            }
            catch (Exception e) {
                this.logError("Unexpected error trying to verify S3 settings : ", e);
            }
        }
        return false;
    }

    public void closeFile() throws KettleException {
        try {
            if (this.data.fis != null) {
                this.data.fis.close();
            }
        }
        catch (IOException e) {
            throw new KettleException("Unable to close file channel for file '" + this.data.filenames[this.data.filenr - 1], (Throwable)e);
        }
    }
}

