/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFunc;
import org.apache.pig.StoreMetadata;
import org.apache.pig.builtin.JsonMetadata;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;

public class JsonStorage
extends StoreFunc
implements StoreMetadata {
    protected RecordWriter writer = null;
    protected ResourceSchema schema = null;
    private String udfcSignature = null;
    private JsonFactory jsonFactory = null;
    private static final int BUF_SIZE = 4096;
    private static final String SCHEMA_SIGNATURE = "pig.jsonstorage.schema";

    @Override
    public OutputFormat getOutputFormat() throws IOException {
        return new TextOutputFormat();
    }

    @Override
    public void setStoreLocation(String location, Job job) throws IOException {
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(location));
    }

    @Override
    public void setStoreFuncUDFContextSignature(String signature) {
        this.udfcSignature = signature;
    }

    @Override
    public void checkSchema(ResourceSchema s) throws IOException {
        UDFContext udfc = UDFContext.getUDFContext();
        Properties p = udfc.getUDFProperties(this.getClass(), new String[]{this.udfcSignature});
        p.setProperty(SCHEMA_SIGNATURE, s.toString());
    }

    @Override
    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.writer = writer;
        UDFContext udfc = UDFContext.getUDFContext();
        Properties p = udfc.getUDFProperties(this.getClass(), new String[]{this.udfcSignature});
        String strSchema = p.getProperty(SCHEMA_SIGNATURE);
        if (strSchema == null) {
            throw new IOException("Could not find schema in UDF context");
        }
        this.schema = new ResourceSchema(Utils.getSchemaFromString(strSchema));
        this.jsonFactory = new JsonFactory();
    }

    @Override
    public void putNext(Tuple t) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        JsonGenerator json = this.jsonFactory.createJsonGenerator(baos, JsonEncoding.UTF8);
        json.writeStartObject();
        ResourceSchema.ResourceFieldSchema[] fields = this.schema.getFields();
        for (int i = 0; i < fields.length; ++i) {
            this.writeField(json, fields[i], t.get(i));
        }
        json.writeEndObject();
        json.close();
        try {
            this.writer.write(null, (Object)new Text(baos.toByteArray()));
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    private void writeField(JsonGenerator json, ResourceSchema.ResourceFieldSchema field, Object d) throws IOException {
        if (d == null) {
            json.writeNullField(field.getName());
            return;
        }
        switch (field.getType()) {
            case 10: {
                json.writeNumberField(field.getName(), (Integer)d);
                return;
            }
            case 15: {
                json.writeNumberField(field.getName(), (Long)d);
                return;
            }
            case 20: {
                json.writeNumberField(field.getName(), ((Float)d).floatValue());
                return;
            }
            case 25: {
                json.writeNumberField(field.getName(), (Double)d);
                return;
            }
            case 50: {
                json.writeStringField(field.getName(), d.toString());
                return;
            }
            case 55: {
                json.writeStringField(field.getName(), (String)d);
                return;
            }
            case 100: {
                json.writeFieldName(field.getName());
                json.writeStartObject();
                for (Map.Entry e : ((Map)d).entrySet()) {
                    json.writeStringField((String)e.getKey(), e.getValue().toString());
                }
                json.writeEndObject();
                return;
            }
            case 110: {
                json.writeFieldName(field.getName());
                json.writeStartObject();
                ResourceSchema s = field.getSchema();
                if (s == null) {
                    throw new IOException("Schemas must be fully specified to use this storage function.  No schema found for field " + field.getName());
                }
                ResourceSchema.ResourceFieldSchema[] fs = s.getFields();
                for (int j = 0; j < fs.length; ++j) {
                    this.writeField(json, fs[j], ((Tuple)d).get(j));
                }
                json.writeEndObject();
                return;
            }
            case 120: {
                json.writeFieldName(field.getName());
                json.writeStartArray();
                ResourceSchema s = field.getSchema();
                if (s == null) {
                    throw new IOException("Schemas must be fully specified to use this storage function.  No schema found for field " + field.getName());
                }
                ResourceSchema.ResourceFieldSchema[] fs = s.getFields();
                if (fs.length != 1 || fs[0].getType() != 110) {
                    throw new IOException("Found a bag without a tuple inside!");
                }
                s = fs[0].getSchema();
                if (s == null) {
                    throw new IOException("Schemas must be fully specified to use this storage function.  No schema found for field " + field.getName());
                }
                fs = s.getFields();
                for (Tuple t : (DataBag)d) {
                    json.writeStartObject();
                    for (int j = 0; j < fs.length; ++j) {
                        this.writeField(json, fs[j], t.get(j));
                    }
                    json.writeEndObject();
                }
                json.writeEndArray();
                return;
            }
        }
    }

    @Override
    public void storeStatistics(ResourceStatistics stats, String location, Job job) throws IOException {
    }

    @Override
    public void storeSchema(ResourceSchema schema, String location, Job job) throws IOException {
        JsonMetadata metadataWriter = new JsonMetadata();
        byte recordDel = 10;
        byte fieldDel = 9;
        metadataWriter.setFieldDel(fieldDel);
        metadataWriter.setRecordDel(recordDel);
        metadataWriter.storeSchema(schema, location, job);
    }
}

