/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.PigCounters;
import org.apache.pig.PigWarning;
import org.apache.pig.data.DefaultAbstractBag;
import org.apache.pig.data.InterSedes;
import org.apache.pig.data.InterSedesFactory;
import org.apache.pig.data.Tuple;

public class DefaultDataBag
extends DefaultAbstractBag {
    private static final long serialVersionUID = 2L;
    private static final Log log = LogFactory.getLog(DefaultDataBag.class);
    private static final InterSedes SEDES = InterSedesFactory.getInterSedesInstance();

    public DefaultDataBag() {
        this.mContents = new ArrayList();
    }

    public DefaultDataBag(List<Tuple> listOfTuples) {
        this.mContents = listOfTuples;
        this.mSize = listOfTuples.size();
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public boolean isDistinct() {
        return false;
    }

    @Override
    public Iterator<Tuple> iterator() {
        return new DefaultDataBagIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long spill() {
        if (this.mContents.size() == 0) {
            return 0L;
        }
        long spilled = 0L;
        Collection collection = this.mContents;
        synchronized (collection) {
            DataOutputStream out = null;
            try {
                out = this.getSpillFile();
            }
            catch (IOException ioe) {
                this.warn("Unable to create tmp file to spill to disk", PigWarning.UNABLE_TO_CREATE_FILE_TO_SPILL, ioe);
                return 0L;
            }
            try {
                Iterator i = this.mContents.iterator();
                while (i.hasNext()) {
                    SEDES.writeDatum(out, i.next(), (byte)110);
                    if ((++spilled & 0x3FFFL) != 0L) continue;
                    this.reportProgress();
                }
                out.flush();
            }
            catch (IOException ioe) {
                this.mSpillFiles.remove(this.mSpillFiles.size() - 1);
                this.warn("Unable to spill contents to disk", PigWarning.UNABLE_TO_SPILL, ioe);
                long l = 0L;
                return l;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        this.warn("Error closing spill", PigWarning.UNABLE_TO_CLOSE_SPILL_FILE, e);
                    }
                }
            }
            this.mContents.clear();
        }
        this.incSpillCount(PigCounters.SPILLABLE_MEMORY_MANAGER_SPILL_COUNT);
        return spilled;
    }

    private class DefaultDataBagIterator
    implements Iterator<Tuple> {
        private Tuple mBuf = null;
        private int mMemoryPtr = 0;
        private int mFilePtr = 0;
        private DataInputStream mIn = null;
        private int mCntr = 0;
        private boolean hasCachedTuple = false;

        DefaultDataBagIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.hasCachedTuple) {
                return this.mBuf != null;
            }
            this.mBuf = this.next();
            this.hasCachedTuple = true;
            return this.mBuf != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Tuple next() {
            if ((this.mCntr++ & 0x3FF) == 0) {
                DefaultDataBag.this.reportProgress();
            }
            if (this.hasCachedTuple) {
                Tuple t = this.mBuf;
                this.hasCachedTuple = false;
                return t;
            }
            if (this.mMemoryPtr > 0) {
                Collection t = DefaultDataBag.this.mContents;
                synchronized (t) {
                    if (DefaultDataBag.this.mContents.size() > 0) {
                        return this.readFromMemory();
                    }
                }
                try {
                    this.mIn = new DataInputStream(new BufferedInputStream(new FileInputStream((File)DefaultDataBag.this.mSpillFiles.get(this.mFilePtr++))));
                }
                catch (FileNotFoundException fnfe) {
                    String msg = "Unable to find our spill file.";
                    log.fatal((Object)msg, (Throwable)fnfe);
                    throw new RuntimeException(msg, fnfe);
                }
                for (int i = 0; i < this.mMemoryPtr; ++i) {
                    try {
                        SEDES.readDatum(this.mIn);
                        continue;
                    }
                    catch (EOFException eof) {
                        String msg = "Ran out of tuples to read prematurely.";
                        log.fatal((Object)msg, (Throwable)eof);
                        throw new RuntimeException(msg, eof);
                    }
                    catch (IOException ioe) {
                        String msg = "Unable to read our spill file.";
                        log.fatal((Object)msg, (Throwable)ioe);
                        throw new RuntimeException(msg, ioe);
                    }
                }
                this.mMemoryPtr = 0;
                return this.readFromFile();
            }
            return this.readFromFile();
        }

        @Override
        public void remove() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Tuple readFromFile() {
            if (this.mIn != null) {
                try {
                    Tuple t = (Tuple)SEDES.readDatum(this.mIn);
                    return t;
                }
                catch (EOFException eof) {
                    try {
                        this.mIn.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)"Failed to close spill file.", (Throwable)e);
                    }
                }
                catch (IOException ioe) {
                    String msg = "Unable to read our spill file.";
                    log.fatal((Object)msg, (Throwable)ioe);
                    throw new RuntimeException(msg, ioe);
                }
            }
            Collection t = DefaultDataBag.this.mContents;
            synchronized (t) {
                if (DefaultDataBag.this.mSpillFiles == null || this.mFilePtr >= DefaultDataBag.this.mSpillFiles.size()) {
                    return this.readFromMemory();
                }
            }
            try {
                this.mIn = new DataInputStream(new BufferedInputStream(new FileInputStream((File)DefaultDataBag.this.mSpillFiles.get(this.mFilePtr++))));
            }
            catch (FileNotFoundException fnfe) {
                String msg = "Unable to find our spill file.";
                log.fatal((Object)msg, (Throwable)fnfe);
                throw new RuntimeException(msg, fnfe);
            }
            return this.readFromFile();
        }

        private Tuple readFromMemory() {
            if (DefaultDataBag.this.mContents.size() == 0) {
                return null;
            }
            if (this.mMemoryPtr < DefaultDataBag.this.mContents.size()) {
                return (Tuple)((List)DefaultDataBag.this.mContents).get(this.mMemoryPtr++);
            }
            return null;
        }
    }
}

