/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.JavaCompilerHelper;
import org.apache.pig.impl.util.ObjectSerializer;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SchemaTupleClassGenerator {
    private static final Log LOG = LogFactory.getLog(SchemaTupleClassGenerator.class);
    private static int nextGlobalClassIdentifier = 0;

    private SchemaTupleClassGenerator() {
    }

    protected static void resetGlobalClassIdentifier() {
        nextGlobalClassIdentifier = 0;
    }

    protected static void generateSchemaTuple(Schema s, boolean appendable, int id, File codeDir, GenContext ... contexts) {
        StringBuilder contextAnnotations = new StringBuilder();
        for (GenContext context : contexts) {
            LOG.info((Object)("Including context: " + (Object)((Object)context)));
            contextAnnotations.append("@").append(context.getAnnotationCanonicalName()).append("\n");
        }
        String codeString = SchemaTupleClassGenerator.produceCodeString(s, appendable, id, contextAnnotations.toString(), codeDir);
        String name = "SchemaTuple_" + id;
        LOG.info((Object)("Compiling class " + name + " for Schema: " + s + ", and appendability: " + appendable));
        SchemaTupleClassGenerator.compileCodeString(name, codeString, codeDir);
    }

    private static int generateSchemaTuple(Schema s, boolean appendable, File codeDir, GenContext ... contexts) {
        int id = SchemaTupleClassGenerator.getNextGlobalClassIdentifier();
        SchemaTupleClassGenerator.generateSchemaTuple(s, appendable, id, codeDir, contexts);
        return id;
    }

    private static String produceCodeString(Schema s, boolean appendable, int id, String contextAnnotations, File codeDir) {
        TypeInFunctionStringOutFactory f = new TypeInFunctionStringOutFactory(s, id, appendable, contextAnnotations, codeDir);
        for (Schema.FieldSchema fs : s.getFields()) {
            f.process(fs);
        }
        return f.end();
    }

    protected static int getNextGlobalClassIdentifier() {
        return nextGlobalClassIdentifier++;
    }

    private static void compileCodeString(String className, String generatedCodeString, File codeDir) {
        JavaCompilerHelper compiler = new JavaCompilerHelper();
        String tempDir = codeDir.getAbsolutePath();
        compiler.addToClassPath(tempDir);
        LOG.debug((Object)("Compiling SchemaTuple code with classpath: " + compiler.getClassPath()));
        compiler.compile(tempDir, new JavaCompilerHelper.JavaSourceFromString(className, generatedCodeString));
        LOG.info((Object)("Successfully compiled class: " + className));
    }

    static class TypeInFunctionStringOut {
        private int fieldPos = 0;
        private StringBuilder content = new StringBuilder();
        private byte type;
        public int appendable = -1;

        public void prepare() {
        }

        public void process(int fieldPos, Schema.FieldSchema fs) {
        }

        public void end() {
        }

        public StringBuilder getContent() {
            return this.content;
        }

        public TypeInFunctionStringOut() {
            this.add("// this code generated by " + this.getClass());
            this.addBreak();
        }

        public boolean isAppendable() {
            if (this.appendable == -1) {
                throw new RuntimeException("Need to be given appendable status in " + this.getClass());
            }
            return this.appendable == 1;
        }

        public TypeInFunctionStringOut(boolean appendable) {
            this();
            this.appendable = appendable ? 1 : 0;
        }

        public StringBuilder spaces(int indent) {
            StringBuilder out = new StringBuilder();
            String space = "    ";
            for (int i = 0; i < indent; ++i) {
                out.append(space);
            }
            return out;
        }

        public void add(String s) {
            for (String str : s.split("\\n")) {
                this.content.append((CharSequence)this.spaces(1).append(str).append("\n"));
            }
        }

        public void addBreak() {
            this.content.append("\n");
        }

        public void prepareProcess(Schema.FieldSchema fs) {
            this.type = fs.type;
            this.process(this.fieldPos, fs);
            ++this.fieldPos;
        }

        public boolean isInt() {
            return this.type == 10;
        }

        public boolean isLong() {
            return this.type == 15;
        }

        public boolean isFloat() {
            return this.type == 20;
        }

        public boolean isDouble() {
            return this.type == 25;
        }

        public boolean isDateTime() {
            return this.type == 30;
        }

        public boolean isPrimitive() {
            return this.isInt() || this.isLong() || this.isFloat() || this.isDouble() || this.isBoolean();
        }

        public boolean isBoolean() {
            return this.type == 5;
        }

        public boolean isString() {
            return this.type == 55;
        }

        public boolean isBytearray() {
            return this.type == 50;
        }

        public boolean isTuple() {
            return this.type == 110;
        }

        public boolean isBag() {
            return this.type == 120;
        }

        public boolean isMap() {
            return this.type == 100;
        }

        public boolean isObject() {
            return !this.isPrimitive();
        }

        public String typeName() {
            return this.typeName(this.type);
        }

        public String typeName(byte type) {
            switch (type) {
                case 10: {
                    return "int";
                }
                case 15: {
                    return "long";
                }
                case 20: {
                    return "float";
                }
                case 25: {
                    return "double";
                }
                case 50: {
                    return "byte[]";
                }
                case 55: {
                    return "String";
                }
                case 5: {
                    return "boolean";
                }
                case 30: {
                    return "DateTime";
                }
                case 110: {
                    return "Tuple";
                }
                case 120: {
                    return "DataBag";
                }
                case 100: {
                    return "Map";
                }
            }
            throw new RuntimeException("Can't return String for given type " + DataType.findTypeName(type));
        }

        public String proper(byte type) {
            String s = this.typeName(type);
            switch (type) {
                case 50: {
                    return "Bytes";
                }
            }
            return s.substring(0, 1).toUpperCase() + s.substring(1);
        }
    }

    static class TypeInFunctionStringOutFactory {
        private List<TypeInFunctionStringOut> listOfFutureMethods = Lists.newArrayList();
        private int id;
        private boolean appendable;
        private String contextAnnotations;

        public TypeInFunctionStringOutFactory(Schema s, int id, boolean appendable, String contextAnnotations, File codeDir) {
            this.id = id;
            this.appendable = appendable;
            this.contextAnnotations = contextAnnotations;
            LinkedList<Integer> nextNestedSchemaIdForSetPos = Lists.newLinkedList();
            LinkedList<Integer> nextNestedSchemaIdForGetPos = Lists.newLinkedList();
            LinkedList<Integer> nextNestedSchemaIdForReadField = Lists.newLinkedList();
            ArrayList<Queue<Integer>> listOfQueuesForIds = Lists.newArrayList(nextNestedSchemaIdForSetPos, nextNestedSchemaIdForGetPos, nextNestedSchemaIdForReadField);
            this.listOfFutureMethods.add(new FieldString(codeDir, listOfQueuesForIds, s, appendable));
            this.listOfFutureMethods.add(new SetPosString(nextNestedSchemaIdForSetPos));
            this.listOfFutureMethods.add(new GetPosString(nextNestedSchemaIdForGetPos));
            this.listOfFutureMethods.add(new GetDummyString());
            this.listOfFutureMethods.add(new GenericSetString());
            this.listOfFutureMethods.add(new GenericGetString());
            this.listOfFutureMethods.add(new GeneralIsNullString());
            this.listOfFutureMethods.add(new CheckIfNullString());
            this.listOfFutureMethods.add(new SetNullString());
            this.listOfFutureMethods.add(new SetEqualToSchemaTupleSpecificString(id));
            this.listOfFutureMethods.add(new WriteNullsString(appendable));
            this.listOfFutureMethods.add(new ReadString(nextNestedSchemaIdForReadField, appendable));
            this.listOfFutureMethods.add(new WriteString());
            this.listOfFutureMethods.add(new SizeString(appendable));
            this.listOfFutureMethods.add(new MemorySizeString());
            this.listOfFutureMethods.add(new GetSchemaTupleIdentifierString(id));
            this.listOfFutureMethods.add(new HashCode());
            this.listOfFutureMethods.add(new SchemaSizeString());
            this.listOfFutureMethods.add(new GetTypeString());
            this.listOfFutureMethods.add(new CompareToString(id));
            this.listOfFutureMethods.add(new CompareToSpecificString(id, appendable));
            this.listOfFutureMethods.add(new SetEqualToSchemaTupleString(id));
            this.listOfFutureMethods.add(new IsSpecificSchemaTuple(id));
            this.listOfFutureMethods.add(new TypeAwareSetString(10));
            this.listOfFutureMethods.add(new TypeAwareSetString(15));
            this.listOfFutureMethods.add(new TypeAwareSetString(20));
            this.listOfFutureMethods.add(new TypeAwareSetString(25));
            this.listOfFutureMethods.add(new TypeAwareSetString(50));
            this.listOfFutureMethods.add(new TypeAwareSetString(55));
            this.listOfFutureMethods.add(new TypeAwareSetString(5));
            this.listOfFutureMethods.add(new TypeAwareSetString(30));
            this.listOfFutureMethods.add(new TypeAwareSetString(110));
            this.listOfFutureMethods.add(new TypeAwareSetString(120));
            this.listOfFutureMethods.add(new TypeAwareSetString(100));
            this.listOfFutureMethods.add(new TypeAwareGetString(10));
            this.listOfFutureMethods.add(new TypeAwareGetString(15));
            this.listOfFutureMethods.add(new TypeAwareGetString(20));
            this.listOfFutureMethods.add(new TypeAwareGetString(25));
            this.listOfFutureMethods.add(new TypeAwareGetString(50));
            this.listOfFutureMethods.add(new TypeAwareGetString(55));
            this.listOfFutureMethods.add(new TypeAwareGetString(5));
            this.listOfFutureMethods.add(new TypeAwareGetString(30));
            this.listOfFutureMethods.add(new TypeAwareGetString(110));
            this.listOfFutureMethods.add(new TypeAwareGetString(120));
            this.listOfFutureMethods.add(new TypeAwareGetString(100));
            this.listOfFutureMethods.add(new ListSetString());
            for (TypeInFunctionStringOut t : this.listOfFutureMethods) {
                t.prepare();
            }
        }

        public void process(Schema.FieldSchema fs) {
            for (TypeInFunctionStringOut t : this.listOfFutureMethods) {
                t.prepareProcess(fs);
            }
        }

        public String end() {
            StringBuilder head = new StringBuilder().append("import java.util.List;\n").append("import java.util.Map;\n").append("import java.util.Iterator;\n").append("import java.io.DataOutput;\n").append("import java.io.DataInput;\n").append("import java.io.IOException;\n").append("\n").append("import com.google.common.collect.Lists;\n").append("\n").append("import org.joda.time.DateTime;").append("\n").append("import org.apache.pig.data.DataType;\n").append("import org.apache.pig.data.DataBag;\n").append("import org.apache.pig.data.Tuple;\n").append("import org.apache.pig.data.SchemaTuple;\n").append("import org.apache.pig.data.AppendableSchemaTuple;\n").append("import org.apache.pig.data.utils.SedesHelper;\n").append("import org.apache.pig.data.utils.BytesHelper;\n").append("import org.apache.pig.data.DataByteArray;\n").append("import org.apache.pig.data.BinInterSedes;\n").append("import org.apache.pig.impl.util.Utils;\n").append("import org.apache.pig.impl.logicalLayer.schema.Schema;\n").append("import org.apache.pig.impl.logicalLayer.FrontendException;\n").append("import org.apache.pig.backend.executionengine.ExecException;\n").append("import org.apache.pig.data.SizeUtil;\n").append("import org.apache.pig.data.SchemaTuple.SchemaTupleQuickGenerator;\n").append("\n").append(this.contextAnnotations);
            if (this.appendable) {
                head.append("public class SchemaTuple_" + this.id + " extends AppendableSchemaTuple<SchemaTuple_" + this.id + "> {\n");
            } else {
                head.append("public class SchemaTuple_" + this.id + " extends SchemaTuple<SchemaTuple_" + this.id + "> {\n");
            }
            for (TypeInFunctionStringOut t : this.listOfFutureMethods) {
                t.end();
                head.append((CharSequence)t.getContent());
            }
            head.append("\n").append("    @Override\n").append("    public SchemaTupleQuickGenerator<SchemaTuple_" + this.id + "> getQuickGenerator() {\n").append("        return new SchemaTupleQuickGenerator<SchemaTuple_" + this.id + ">() {\n").append("            @Override\n").append("            public SchemaTuple_" + this.id + " make() {\n").append("                return new SchemaTuple_" + this.id + "();\n").append("            }\n").append("        };\n").append("    }\n");
            return head.append("}").toString();
        }
    }

    static class TypeAwareSetString
    extends TypeInFunctionStringOut {
        private byte type;

        public TypeAwareSetString(byte type) {
            this.type = type;
        }

        public byte thisType() {
            return this.type;
        }

        public String name() {
            return this.typeName(this.type);
        }

        public String properName() {
            return this.proper(this.thisType());
        }

        @Override
        public void prepare() {
            this.add("@Override");
            this.add("protected void generatedCodeSet" + this.properName() + "(int fieldNum, " + this.name() + " val) throws ExecException {");
            this.add("    switch(fieldNum) {");
        }

        @Override
        public void process(int fieldNum, Schema.FieldSchema fs) {
            if (fs.type == this.thisType()) {
                this.add("    case (" + fieldNum + "): setPos_" + fieldNum + "(val); break;");
            }
        }

        @Override
        public void end() {
            this.add("    default: setTypeAwareBase(fieldNum, val, \"" + this.name() + "\");");
            this.add("    }");
            this.add("}");
        }
    }

    static class TypeAwareGetString
    extends TypeAwareSetString {
        public TypeAwareGetString(byte type) {
            super(type);
        }

        @Override
        public void prepare() {
            this.add("@Override");
            this.add("protected " + this.name() + " generatedCodeGet" + this.properName() + "(int fieldNum) throws ExecException {");
            this.add("    switch(fieldNum) {");
        }

        @Override
        public void process(int fieldNum, Schema.FieldSchema fs) {
            if (fs.type == this.thisType()) {
                this.add("    case (" + fieldNum + "): return returnUnlessNull(checkIfNull_" + fieldNum + "(), getPos_" + fieldNum + "());");
            }
        }

        @Override
        public void end() {
            this.add("    default:");
            this.add("        return unbox" + this.properName() + "(getTypeAwareBase(fieldNum, \"" + this.name() + "\"));");
            this.add("    }");
            this.add("}");
        }
    }

    static class SetEqualToSchemaTupleString
    extends TypeInFunctionStringOut {
        int id;

        public SetEqualToSchemaTupleString(int id) {
            this.id = id;
        }

        @Override
        public void prepare() {
            this.add("@Override");
            this.add("protected SchemaTuple generatedCodeSet(SchemaTuple t, boolean checkClass) throws ExecException {");
            this.add("    if (checkClass && t instanceof SchemaTuple_" + this.id + ") {");
            this.add("        return setSpecific((SchemaTuple_" + this.id + ")t);");
            this.add("    }");
            this.addBreak();
            this.add("    if (t.size() < schemaSize()) {");
            this.add("        throw new ExecException(\"Given SchemaTuple does not have as many fields as \"+getClass()+\" (\"+t.size()+\" vs \"+schemaSize()+\")\");");
            this.add("    }");
            this.addBreak();
            this.add("    List<Schema.FieldSchema> theirFS = t.getSchema().getFields();");
            this.addBreak();
        }

        @Override
        public void process(int fieldNum, Schema.FieldSchema fs) {
            this.add("    if (" + fs.type + " != theirFS.get(" + fieldNum + ").type) {");
            this.add("        throw new ExecException(\"Given SchemaTuple does not match current in field " + fieldNum + ". Expected type: " + fs.type + ", found: \" + theirFS.get(" + fieldNum + ").type);");
            this.add("    }");
            this.add("    if (t.isNull(" + fieldNum + ")) {");
            this.add("        setNull_" + fieldNum + "(true);");
            this.add("    } else {");
            if (!this.isTuple()) {
                this.add("        setPos_" + fieldNum + "(t.get" + this.proper(fs.type) + "(" + fieldNum + "));");
            } else {
                this.add("        setPos_" + fieldNum + "((Tuple)t.get(" + fieldNum + "));");
            }
            this.add("    }");
            this.addBreak();
        }

        @Override
        public void end() {
            this.add("    return this;");
            this.add("}");
        }
    }

    static class GetTypeString
    extends TypeInFunctionStringOut {
        GetTypeString() {
        }

        @Override
        public void prepare() {
            this.add("@Override");
            this.add("public byte getGeneratedCodeFieldType(int fieldNum) throws ExecException {");
            this.add("    switch (fieldNum) {");
        }

        @Override
        public void process(int fieldNum, Schema.FieldSchema fs) {
            this.add("    case (" + fieldNum + "): return " + fs.type + ";");
        }

        @Override
        public void end() {
            this.add("    default: throw new ExecException(\"Invalid index given: \" + fieldNum);");
            this.add("    }");
            this.add("}");
            this.addBreak();
        }
    }

    static class SizeString
    extends TypeInFunctionStringOut {
        int i = 0;

        @Override
        public void process(int fieldNum, Schema.FieldSchema fS) {
            ++this.i;
        }

        @Override
        public void end() {
            this.add("@Override");
            this.add("protected int generatedCodeSize() {");
            this.add("    return " + this.i + ";");
            this.add("}");
            this.addBreak();
        }

        public SizeString(boolean appendable) {
            super(appendable);
        }
    }

    static class SchemaSizeString
    extends TypeInFunctionStringOut {
        int i = 0;

        SchemaSizeString() {
        }

        @Override
        public void process(int fieldNum, Schema.FieldSchema fS) {
            ++this.i;
        }

        @Override
        public void end() {
            this.add("@Override");
            this.add("protected int schemaSize() {");
            this.add("    return " + this.i + ";");
            this.add("}");
            this.addBreak();
        }
    }

    static class GetSchemaTupleIdentifierString
    extends TypeInFunctionStringOut {
        private int id;

        @Override
        public void end() {
            this.add("@Override");
            this.add("public int getSchemaTupleIdentifier() {");
            this.add("    return " + this.id + ";");
            this.add("}");
            this.addBreak();
        }

        public GetSchemaTupleIdentifierString(int id) {
            this.id = id;
        }
    }

    static class GetPosString
    extends TypeInFunctionStringOut {
        private Queue<Integer> idQueue;
        private int booleanByte = 0;
        private int booleans;

        @Override
        public void process(int fieldPos, Schema.FieldSchema fs) {
            if (!this.isTuple()) {
                this.add("public " + this.typeName() + " getPos_" + fieldPos + "() {");
            } else {
                int nestedSchemaTupleId = this.idQueue.remove();
                this.add("public SchemaTuple_" + nestedSchemaTupleId + " getPos_" + fieldPos + "() {");
            }
            if (this.isBoolean()) {
                this.add("    return BytesHelper.getBitByPos(booleanByte_" + this.booleanByte + ", " + this.booleans++ + ");");
                if (this.booleans % 8 == 0) {
                    ++this.booleanByte;
                    this.booleans = 0;
                }
            } else {
                this.add("    return pos_" + fieldPos + ";");
            }
            this.add("}");
            this.addBreak();
        }

        public GetPosString(Queue<Integer> idQueue) {
            this.idQueue = idQueue;
        }
    }

    static class GetDummyString
    extends TypeInFunctionStringOut {
        GetDummyString() {
        }

        @Override
        public void process(int fieldPos, Schema.FieldSchema fs) {
            this.add("public " + this.typeName() + " getDummy_" + fieldPos + "() {");
            switch (fs.type) {
                case 10: {
                    this.add("    return 0;");
                    break;
                }
                case 15: {
                    this.add("    return 0L;");
                    break;
                }
                case 20: {
                    this.add("    return 0.0f;");
                    break;
                }
                case 25: {
                    this.add("    return 0.0;");
                    break;
                }
                case 5: {
                    this.add("    return true;");
                    break;
                }
                case 30: {
                    this.add("    return new DateTime();");
                    break;
                }
                case 50: {
                    this.add("    return (byte[])null;");
                    break;
                }
                case 55: {
                    this.add("    return (String)null;");
                    break;
                }
                case 110: {
                    this.add("    return (Tuple)null;");
                    break;
                }
                case 120: {
                    this.add("    return (DataBag)null;");
                    break;
                }
                case 100: {
                    this.add("    return (Map<String,Object>)null;");
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported type");
                }
            }
            this.add("}");
            this.addBreak();
        }
    }

    static class MemorySizeString
    extends TypeInFunctionStringOut {
        private int size = 0;
        String s = "    return SizeUtil.roundToEight(";
        private int booleans = 0;
        private int primitives = 0;

        MemorySizeString() {
        }

        @Override
        public void prepare() {
            this.add("@Override");
            this.add("public long getGeneratedCodeMemorySize() {");
        }

        @Override
        public void process(int fieldPos, Schema.FieldSchema fs) {
            if (this.isInt() || this.isFloat()) {
                this.size += 4;
            } else if (this.isLong() || this.isDouble()) {
                this.size += 8;
            } else if (this.isBytearray()) {
                this.size += 8;
                this.s = this.s + "(pos_" + fieldPos + " == null ? 0 : SizeUtil.roundToEight(12 + pos_" + fieldPos + ".length) * 8) + ";
            } else if (this.isBoolean()) {
                if (this.booleans++ % 8 == 0) {
                    ++this.size;
                }
            } else if (this.isDateTime()) {
                this.size += 10;
            } else if (this.isBag()) {
                this.size += 8;
                this.s = this.s + "(pos_" + fieldPos + " == null ? 0 : pos_" + fieldPos + ".getMemorySize()) + ";
            } else if (this.isMap() || this.isString()) {
                this.size += 8;
                this.s = this.s + "(pos_" + fieldPos + " == null ? 0 : SizeUtil.getPigObjMemSize(pos_" + fieldPos + ")) + ";
            } else if (this.isTuple()) {
                this.size += 8;
                this.s = this.s + "(pos_" + fieldPos + " == null ? 8 : pos_" + fieldPos + ".getMemorySize()) + ";
            } else {
                throw new RuntimeException("Unsupported type found: " + fs);
            }
            if (this.isPrimitive() && this.primitives++ % 8 == 0) {
                ++this.size;
            }
        }

        @Override
        public void end() {
            this.s = this.s + this.size + ");";
            this.add(this.s);
            this.add("}");
            this.addBreak();
        }
    }

    static class WriteString
    extends TypeInFunctionStringOut {
        private int booleans = 0;

        WriteString() {
        }

        @Override
        public void prepare() {
            this.add("@Override");
            this.add("protected void generatedCodeWriteElements(DataOutput out) throws IOException {");
        }

        @Override
        public void process(int fieldPos, Schema.FieldSchema fs) {
            if (this.isBoolean()) {
                ++this.booleans;
            } else {
                this.add("    if (!checkIfNull_" + fieldPos + "()) {");
                this.add("        write(out, pos_" + fieldPos + ");");
                this.add("    }");
                this.addBreak();
            }
        }

        @Override
        public void end() {
            if (this.booleans > 0) {
                int i = 0;
                while (this.booleans > 0) {
                    this.add("    out.writeByte(booleanByte_" + i++ + ");");
                    this.booleans -= 8;
                }
            }
            this.add("}");
            this.addBreak();
        }
    }

    static class ReadString
    extends TypeInFunctionStringOut {
        private Queue<Integer> idQueue;
        private int booleans = 0;

        @Override
        public void prepare() {
            this.add("@Override");
            this.add("protected void generatedCodeReadFields(DataInput in, boolean[] b) throws IOException {");
        }

        @Override
        public void process(int fieldPos, Schema.FieldSchema fs) {
            if (this.isBoolean()) {
                ++this.booleans;
                this.add("    if (b[" + fieldPos + "]) {");
                this.add("        setNull_" + fieldPos + "(true);");
                this.add("    } else {");
                this.add("        setNull_" + fieldPos + "(false);");
                this.add("    }");
            } else if (!this.isTuple()) {
                this.add("    if (b[" + fieldPos + "]) {");
                this.add("        setNull_" + fieldPos + "(true);");
                this.add("    } else {");
                this.add("        setPos_" + fieldPos + "(read(in, pos_" + fieldPos + "));");
                this.add("    }");
                this.addBreak();
            } else {
                int nestedSchemaTupleId = this.idQueue.remove();
                this.add("    if (b[" + fieldPos + "]) {");
                this.add("        setNull_" + fieldPos + "(true);");
                this.add("    } else {");
                this.add("        SchemaTuple_" + nestedSchemaTupleId + " st = new SchemaTuple_" + nestedSchemaTupleId + "();");
                this.add("        st.readFields(in);");
                this.add("        setPos_" + fieldPos + "(st);");
                this.add("    }");
                this.addBreak();
            }
        }

        @Override
        public void end() {
            if (this.booleans > 0) {
                int i = 0;
                while (this.booleans > 0) {
                    this.add("    booleanByte_" + i++ + " = in.readByte();");
                    this.booleans -= 8;
                }
            }
            this.add("}");
            this.addBreak();
        }

        public ReadString(Queue<Integer> idQueue, boolean appendable) {
            super(appendable);
            this.idQueue = idQueue;
        }
    }

    static class WriteNullsString
    extends TypeInFunctionStringOut {
        String s = "    boolean[] b = {\n";

        @Override
        public void prepare() {
            this.add("@Override");
            this.add("protected boolean[] generatedCodeNullsArray() throws IOException {");
        }

        @Override
        public void process(int fieldPos, Schema.FieldSchema fs) {
            this.s = this.s + "        checkIfNull_" + fieldPos + "(),\n";
        }

        @Override
        public void end() {
            this.s = this.s.substring(0, this.s.length() - 2) + "\n    };";
            this.add(this.s);
            this.add("    return b;");
            this.add("}");
            this.addBreak();
        }

        public WriteNullsString(boolean appendable) {
            super(appendable);
        }
    }

    static class IsSpecificSchemaTuple
    extends TypeInFunctionStringOut {
        private int id;

        public IsSpecificSchemaTuple(int id) {
            this.id = id;
        }

        @Override
        public void prepare() {
            this.add("@Override");
            this.add("public boolean isSpecificSchemaTuple(Object o) {");
            this.add("    return o instanceof SchemaTuple_" + this.id + ";");
            this.add("}");
        }
    }

    static class SetEqualToSchemaTupleSpecificString
    extends TypeInFunctionStringOut {
        private int id;

        @Override
        public void prepare() {
            this.add("@Override");
            this.add("protected SchemaTuple generatedCodeSetSpecific(SchemaTuple_" + this.id + " t) {");
        }

        @Override
        public void process(int fieldPos, Schema.FieldSchema fs) {
            this.add("    if (t.checkIfNull_" + fieldPos + "()) {");
            this.add("        setNull_" + fieldPos + "(true);");
            this.add("    } else {");
            this.add("        setPos_" + fieldPos + "(t.getPos_" + fieldPos + "());");
            this.add("    }");
            this.addBreak();
        }

        @Override
        public void end() {
            this.add("    return this;");
            this.add("}");
            this.addBreak();
        }

        public SetEqualToSchemaTupleSpecificString(int id) {
            this.id = id;
        }
    }

    static class SetNullString
    extends TypeInFunctionStringOut {
        private int nullByte = 0;
        private int byteIncr = 0;

        SetNullString() {
        }

        @Override
        public void process(int fieldPos, Schema.FieldSchema fs) {
            this.add("public void setNull_" + fieldPos + "(boolean b) {");
            if (this.isPrimitive()) {
                this.add("    isNull_" + this.nullByte + " = BytesHelper.setBitByPos(isNull_" + this.nullByte + ", b, " + this.byteIncr++ + ");");
                if (this.byteIncr % 8 == 0) {
                    this.byteIncr = 0;
                    ++this.nullByte;
                }
            } else {
                this.add("    if (b) {");
                this.add("        pos_" + fieldPos + " = null;");
                this.add("    }");
            }
            this.add("}");
            this.addBreak();
        }
    }

    static class CheckIfNullString
    extends TypeInFunctionStringOut {
        private int nullByte = 0;
        private int byteIncr = 0;

        CheckIfNullString() {
        }

        @Override
        public void process(int fieldPos, Schema.FieldSchema fs) {
            this.add("public boolean checkIfNull_" + fieldPos + "() {");
            if (this.isPrimitive()) {
                this.add("    return BytesHelper.getBitByPos(isNull_" + this.nullByte + ", " + this.byteIncr++ + ");");
                if (this.byteIncr % 8 == 0) {
                    this.byteIncr = 0;
                    ++this.nullByte;
                }
            } else {
                this.add("    return pos_" + fieldPos + " == null;");
            }
            this.add("}");
            this.addBreak();
        }
    }

    static class GeneralIsNullString
    extends TypeInFunctionStringOut {
        GeneralIsNullString() {
        }

        @Override
        public void prepare() {
            this.add("@Override");
            this.add("public boolean isGeneratedCodeFieldNull(int fieldNum) throws ExecException {");
            this.add("    switch (fieldNum) {");
        }

        @Override
        public void process(int fieldPos, Schema.FieldSchema fs) {
            this.add("    case (" + fieldPos + "): return checkIfNull_" + fieldPos + "();");
        }

        @Override
        public void end() {
            this.add("    default: throw new ExecException(\"Invalid index given: \" + fieldNum);");
            this.add("    }");
            this.add("}");
        }
    }

    static class GenericGetString
    extends TypeInFunctionStringOut {
        GenericGetString() {
        }

        @Override
        public void prepare() {
            this.add("@Override");
            this.add("public Object generatedCodeGetField(int fieldNum) throws ExecException {");
            this.add("    switch (fieldNum) {");
        }

        @Override
        public void process(int fieldPos, Schema.FieldSchema fs) {
            this.add("    case (" + fieldPos + "): return checkIfNull_" + fieldPos + "() ? null : box(getPos_" + fieldPos + "());");
        }

        @Override
        public void end() {
            this.add("    default: throw new ExecException(\"Invalid index given to get: \" + fieldNum);");
            this.add("    }");
            this.add("}");
        }
    }

    static class GenericSetString
    extends TypeInFunctionStringOut {
        GenericSetString() {
        }

        @Override
        public void prepare() {
            this.add("@Override");
            this.add("public void generatedCodeSetField(int fieldNum, Object val) throws ExecException {");
            this.add("    switch (fieldNum) {");
        }

        @Override
        public void process(int fieldPos, Schema.FieldSchema fs) {
            this.add("    case (" + fieldPos + "):");
            this.add("        if (val == null) {");
            this.add("            setNull_" + fieldPos + "(true);");
            this.add("            return;");
            this.add("        }");
            this.add("        setPos_" + fieldPos + "(unbox(val, getDummy_" + fieldPos + "()));");
            this.add("        break;");
        }

        @Override
        public void end() {
            this.add("    default:");
            this.add("        throw new ExecException(\"Invalid index given to set: \" + fieldNum);");
            this.add("    }");
            this.add("}");
        }
    }

    static class ListSetString
    extends TypeInFunctionStringOut {
        ListSetString() {
        }

        @Override
        public void prepare() {
            this.add("@Override");
            this.add("public void generatedCodeSetIterator(Iterator<Object> it) throws ExecException {");
        }

        @Override
        public void process(int fieldPos, Schema.FieldSchema fs) {
            this.add("    setPos_" + fieldPos + "(unbox(it.next(), getDummy_" + fieldPos + "()));");
        }

        @Override
        public void end() {
            this.add("}");
        }
    }

    static class SetPosString
    extends TypeInFunctionStringOut {
        private Queue<Integer> idQueue;
        private int byteField = 0;
        private int byteIncr = 0;

        @Override
        public void process(int fieldPos, Schema.FieldSchema fs) {
            if (!this.isTuple()) {
                this.add("public void setPos_" + fieldPos + "(" + this.typeName() + " v) {");
                if (this.isPrimitive()) {
                    this.add("    setNull_" + fieldPos + "(false);");
                }
                if (!this.isBoolean()) {
                    this.add("    pos_" + fieldPos + " = v;");
                } else {
                    this.add("    booleanByte_" + this.byteField + " = BytesHelper.setBitByPos(booleanByte_" + this.byteField + ", v, " + this.byteIncr++ + ");");
                    if (this.byteIncr % 8 == 0) {
                        this.byteIncr = 0;
                        ++this.byteField;
                    }
                }
                this.add("}");
            } else {
                int nestedSchemaTupleId = this.idQueue.remove();
                this.add("public void setPos_" + fieldPos + "(SchemaTuple_" + nestedSchemaTupleId + " t) {");
                this.add("    pos_" + fieldPos + " = t;");
                this.add("}");
                this.addBreak();
                this.add("public void setPos_" + fieldPos + "(SchemaTuple t) {");
                this.add("    if (pos_" + fieldPos + " == null) {");
                this.add("        pos_" + fieldPos + " = new SchemaTuple_" + nestedSchemaTupleId + "();");
                this.add("    }");
                this.add("    pos_" + fieldPos + ".setAndCatch(t);");
                this.add("}");
                this.addBreak();
                this.add("public void setPos_" + fieldPos + "(Tuple t) {");
                this.add("    if (pos_" + fieldPos + " == null) {");
                this.add("        pos_" + fieldPos + " = new SchemaTuple_" + nestedSchemaTupleId + "();");
                this.add("    }");
                this.add("    pos_" + fieldPos + ".setAndCatch(t);");
                this.add("}");
            }
            this.addBreak();
        }

        public SetPosString(Queue<Integer> idQueue) {
            this.idQueue = idQueue;
        }
    }

    static class FieldString
    extends TypeInFunctionStringOut {
        private List<Queue<Integer>> listOfQueuesForIds;
        private Schema schema;
        private int primitives = 0;
        private int isNulls = 0;
        private int booleanBytes = 0;
        private int booleans = 0;
        private File codeDir;

        @Override
        public void prepare() {
            String s;
            try {
                s = ObjectSerializer.serialize(this.schema);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to serialize schema: " + this.schema, e);
            }
            this.add("private static Schema schema = staticSchemaGen(\"" + s + "\");");
        }

        @Override
        public void process(int fieldPos, Schema.FieldSchema fs) {
            if (!this.isTuple()) {
                if (this.isPrimitive() && this.primitives++ % 8 == 0) {
                    this.add("private byte isNull_" + this.isNulls++ + " = (byte)0xFF;");
                }
                if (this.isBoolean()) {
                    if (this.booleans++ % 8 == 0) {
                        this.add("private byte booleanByte_" + this.booleanBytes++ + ";");
                    }
                } else {
                    this.add("private " + this.typeName() + " pos_" + fieldPos + ";");
                }
            } else {
                int id = SchemaTupleClassGenerator.generateSchemaTuple(fs.schema, this.isAppendable(), this.codeDir(), new GenContext[0]);
                for (Queue<Integer> q : this.listOfQueuesForIds) {
                    q.add(id);
                }
                this.add("private SchemaTuple_" + id + " pos_" + fieldPos + ";");
            }
        }

        @Override
        public void end() {
            this.addBreak();
            this.add("@Override");
            this.add("public Schema getSchema() {");
            this.add("    return schema;");
            this.add("}");
            this.addBreak();
        }

        public FieldString(File codeDir, List<Queue<Integer>> listOfQueuesForIds, Schema schema, boolean appendable) {
            super(appendable);
            this.codeDir = codeDir;
            this.listOfQueuesForIds = listOfQueuesForIds;
            this.schema = schema;
        }

        public File codeDir() {
            return this.codeDir;
        }
    }

    static class HashCode
    extends TypeInFunctionStringOut {
        HashCode() {
        }

        @Override
        public void prepare() {
            this.add("@Override");
            this.add("public int generatedCodeHashCode() {");
            this.add("    int h = 17;");
        }

        @Override
        public void process(int fieldPos, Schema.FieldSchema fs) {
            this.add("    h = hashCodePiece(h, getPos_" + fieldPos + "(), checkIfNull_" + fieldPos + "());");
        }

        @Override
        public void end() {
            this.add("    return h;");
            this.add("}");
        }
    }

    static class CompareToString
    extends TypeInFunctionStringOut {
        private int id;
        boolean compTup = false;
        boolean compStr = false;
        boolean compIsNull = false;
        boolean compByte = false;

        public CompareToString(int id) {
            this.id = id;
        }

        @Override
        public void prepare() {
            this.add("@Override");
            this.add("protected int generatedCodeCompareTo(SchemaTuple t, boolean checkType) {");
            this.add("    int i;");
        }

        @Override
        public void process(int fieldNum, Schema.FieldSchema fs) {
            this.add("        i = compareWithElementAtPos(checkIfNull_" + fieldNum + "(), getPos_" + fieldNum + "(), t, " + fieldNum + ");");
            this.add("        if (i != 0) {");
            this.add("            return i;");
            this.add("        }");
        }

        @Override
        public void end() {
            this.add("    return 0;");
            this.add("}");
        }
    }

    static class CompareToSpecificString
    extends TypeInFunctionStringOut {
        private int id;

        public CompareToSpecificString(int id, boolean appendable) {
            super(appendable);
            this.id = id;
        }

        @Override
        public void prepare() {
            this.add("@Override");
            this.add("protected int generatedCodeCompareToSpecific(SchemaTuple_" + this.id + " t) {");
            this.add("    int i = 0;");
        }

        @Override
        public void process(int fieldNum, Schema.FieldSchema fs) {
            this.add("    i = compare(checkIfNull_" + fieldNum + "(), getPos_" + fieldNum + "(), t.checkIfNull_" + fieldNum + "(), t.getPos_" + fieldNum + "());");
            this.add("    if (i != 0) {");
            this.add("        return i;");
            this.add("    }");
        }

        @Override
        public void end() {
            this.add("    return i;");
            this.add("}");
        }
    }

    public static enum GenContext {
        UDF("pig.schematuple.udf", true, GenerateUdf.class),
        FOREACH("pig.schematuple.foreach", true, GenerateForeach.class),
        FR_JOIN("pig.schematuple.fr_join", true, GenerateFrJoin.class),
        MERGE_JOIN("pig.schematuple.merge_join", true, GenerateMergeJoin.class),
        FORCE_LOAD("pig.schematuple.force", true, GenerateForceLoad.class);

        private String key;
        private boolean defaultValue;
        private Class<?> annotation;

        private GenContext(String key, boolean defaultValue, Class<?> annotation) {
            this.key = key;
            this.defaultValue = defaultValue;
            this.annotation = annotation;
        }

        public String key() {
            return this.key;
        }

        public String getAnnotationCanonicalName() {
            return this.annotation.getCanonicalName();
        }

        public boolean shouldGenerate(Class clazz) {
            return clazz.getAnnotation(this.annotation) != null;
        }

        public boolean shouldGenerate(Configuration conf) {
            String shouldString = conf.get(this.key);
            if (shouldString == null) {
                return this.defaultValue;
            }
            return Boolean.parseBoolean(shouldString);
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.TYPE})
        public static @interface GenerateForceLoad {
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.TYPE})
        public static @interface GenerateMergeJoin {
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.TYPE})
        public static @interface GenerateFrJoin {
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.TYPE})
        public static @interface GenerateForeach {
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.TYPE})
        public static @interface GenerateUdf {
        }
    }
}

