/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.expression;

import java.util.List;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.PlanValidationException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.ColumnExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.parser.SourceLocation;

public class ProjectExpression
extends ColumnExpression {
    private int input;
    private int col;
    private String alias;
    private LogicalRelationalOperator attachedRelationalOp;
    private boolean isRangeProject = false;
    private int startCol = -1;
    private int endCol = -2;
    private String startAlias;
    private String endAlias;

    public ProjectExpression(OperatorPlan plan, int inputNum, int colNum, LogicalRelationalOperator attachedRelationalOp) {
        super("Project", plan);
        this.input = inputNum;
        this.col = colNum;
        plan.add(this);
        this.attachedRelationalOp = attachedRelationalOp;
    }

    public ProjectExpression(OperatorPlan plan, int inputNum, String alias, LogicalRelationalOperator attachedRelationalOp) {
        super("Project", plan);
        this.input = inputNum;
        this.alias = alias;
        plan.add(this);
        this.attachedRelationalOp = attachedRelationalOp;
    }

    public ProjectExpression(OperatorPlan plan, int inputNum, LogicalRelationalOperator attachedRelationalOp) {
        super("Project", plan);
        this.input = inputNum;
        this.isRangeProject = true;
        plan.add(this);
        this.attachedRelationalOp = attachedRelationalOp;
    }

    public ProjectExpression(ProjectExpression projExpr, OperatorPlan plan) {
        super("Project", plan);
        this.input = projExpr.input;
        this.col = projExpr.col;
        this.alias = projExpr.alias;
        this.attachedRelationalOp = projExpr.attachedRelationalOp;
        this.isRangeProject = projExpr.isRangeProject;
        this.startCol = projExpr.startCol;
        this.endCol = projExpr.endCol;
        this.startAlias = projExpr.startAlias;
        this.endAlias = projExpr.endAlias;
        plan.add(this);
    }

    public void setColumnNumberFromAlias() throws FrontendException {
        if (this.isRangeProject) {
            if (this.startAlias != null) {
                this.startCol = this.findColNum(this.startAlias);
                this.startAlias = null;
            }
            if (this.endAlias != null) {
                this.endCol = this.findColNum(this.endAlias);
                this.endAlias = null;
            }
            if (this.startCol < 0) {
                String msg = "Invalid start column position in range projection (..) " + this.startCol;
                throw new PlanValidationException((Operator)this, msg, 2270, 4);
            }
            if (this.endCol > 0 && this.startCol > this.endCol) {
                String msg = "start column appears after end column in range projection (..) . Start column position " + this.startCol + " End column position " + this.endCol;
                throw new PlanValidationException((Operator)this, msg, 1127, 2);
            }
        } else {
            this.setColNum(this.findColNum(this.alias));
        }
    }

    private int findColNum(String alias) throws FrontendException {
        LogicalPlan lp = (LogicalPlan)this.attachedRelationalOp.getPlan();
        List<Operator> inputs = lp.getPredecessors(this.attachedRelationalOp);
        LogicalRelationalOperator input = (LogicalRelationalOperator)inputs.get(this.getInputNum());
        LogicalSchema inputSchema = input.getSchema();
        if (alias != null) {
            int colNum;
            int n = colNum = inputSchema == null ? -1 : inputSchema.getFieldPosition(alias);
            if (colNum == -1) {
                String msg = "Invalid field projection. Projected field [" + alias + "] does not exist";
                if (inputSchema != null) {
                    msg = msg + " in schema: " + inputSchema.toString(false);
                }
                msg = msg + ".";
                throw new PlanValidationException(this, msg, 1025);
            }
            return colNum;
        }
        int col = this.getColNum();
        if (inputSchema != null && col >= inputSchema.size()) {
            throw new PlanValidationException(this, "Out of bound access. Trying to access non-existent column: " + col + ". Schema " + inputSchema.toString(false) + " has " + inputSchema.size() + " column(s).", 1000);
        }
        return col;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalExpressionVisitor)) {
            throw new FrontendException("Expected LogicalExpressionVisitor", 2222);
        }
        ((LogicalExpressionVisitor)v).visit(this);
    }

    public int getInputNum() {
        return this.input;
    }

    public void setInputNum(int inputNum) {
        this.input = inputNum;
    }

    public int getColNum() {
        if (this.isRangeProject) {
            throw new AssertionError((Object)"getColNum should not be called on range project");
        }
        return this.col;
    }

    public String getColAlias() {
        return this.alias;
    }

    public void setColNum(int colNum) {
        this.col = colNum;
        this.alias = null;
    }

    public boolean isProjectStar() {
        return this.col < 0;
    }

    public boolean isRangeProject() {
        return this.isRangeProject;
    }

    public boolean isRangeOrStarProject() {
        return this.isProjectStar() || this.isRangeProject();
    }

    @Override
    public LogicalSchema.LogicalFieldSchema getFieldSchema() throws FrontendException {
        if (this.fieldSchema != null) {
            return this.fieldSchema;
        }
        LogicalRelationalOperator referent = this.findReferent();
        LogicalSchema schema = referent.getSchema();
        if (this.attachedRelationalOp instanceof LOGenerate && this.plan.getSuccessors(this) == null) {
            if (!(this.findReferent() instanceof LOInnerLoad) || ((LOInnerLoad)this.findReferent()).sourceIsBag()) {
                String alias = this.findReferent().getAlias();
                Pair<List<LOInnerLoad>, Boolean> innerLoadsPair = LOForEach.findReacheableInnerLoadFromBoundaryProject(this);
                List innerLoads = (List)innerLoadsPair.first;
                boolean needNewUid = (Boolean)innerLoadsPair.second;
                if (((LOInnerLoad)innerLoads.get((int)0)).getProjection().getFieldSchema().schema != null && ((LOInnerLoad)innerLoads.get((int)0)).getProjection().getFieldSchema().type == 120) {
                    LogicalSchema.LogicalFieldSchema originalTupleFieldSchema = ((LOInnerLoad)innerLoads.get((int)0)).getProjection().getFieldSchema().schema.getField(0);
                    LogicalSchema.LogicalFieldSchema newTupleFieldSchema = new LogicalSchema.LogicalFieldSchema(originalTupleFieldSchema.alias, schema, 110);
                    newTupleFieldSchema.uid = needNewUid ? LogicalExpression.getNextUid() : originalTupleFieldSchema.uid;
                    LogicalSchema newTupleSchema = new LogicalSchema();
                    newTupleSchema.addField(newTupleFieldSchema);
                    this.fieldSchema = new LogicalSchema.LogicalFieldSchema(alias, newTupleSchema, 120);
                } else {
                    this.fieldSchema = new LogicalSchema.LogicalFieldSchema(alias, schema, 120);
                }
                this.fieldSchema.uid = needNewUid ? LogicalExpression.getNextUid() : ((LOInnerLoad)innerLoads.get((int)0)).getProjection().getFieldSchema().uid;
            } else if (schema == null) {
                if (this.isRangeProject && this.endCol != -1) {
                    LogicalSchema innerSchema = new LogicalSchema();
                    for (int i = this.startCol; i <= this.endCol; ++i) {
                        innerSchema.addField(new LogicalSchema.LogicalFieldSchema(null, null, 50));
                    }
                    this.fieldSchema = new LogicalSchema.LogicalFieldSchema(null, innerSchema, 110);
                } else {
                    this.fieldSchema = null;
                }
            } else {
                this.fieldSchema = schema.getField(0);
            }
            if (this.fieldSchema != null) {
                this.uidOnlyFieldSchema = this.fieldSchema.mergeUid(this.uidOnlyFieldSchema);
            }
        } else if (schema == null) {
            if (this.isRangeOrStarProject()) {
                if (this.isRangeProject && this.endCol != -1) {
                    LogicalSchema innerSchema = new LogicalSchema();
                    for (int i = this.startCol; i <= this.endCol; ++i) {
                        innerSchema.addField(new LogicalSchema.LogicalFieldSchema(null, null, 50));
                    }
                    this.fieldSchema = new LogicalSchema.LogicalFieldSchema(null, innerSchema, 110);
                } else {
                    this.fieldSchema = null;
                }
            } else {
                this.fieldSchema = new LogicalSchema.LogicalFieldSchema(null, null, 50);
            }
            if (this.fieldSchema != null) {
                this.uidOnlyFieldSchema = this.fieldSchema.mergeUid(this.uidOnlyFieldSchema);
            }
        } else {
            int index = -1;
            if (!this.isRangeOrStarProject() && this.uidOnlyFieldSchema != null) {
                long uid = this.uidOnlyFieldSchema.uid;
                for (int i = 0; i < schema.size(); ++i) {
                    LogicalSchema.LogicalFieldSchema fs = schema.getField(i);
                    if (fs.uid != uid) continue;
                    index = i;
                }
            }
            if (index == -1 && this.alias != null) {
                index = schema.getFieldPosition(this.alias);
            }
            if (index == -1) {
                index = this.col;
            }
            if (!this.isRangeOrStarProject()) {
                this.fieldSchema = schema != null && schema.size() > index ? schema.getField(index) : new LogicalSchema.LogicalFieldSchema(null, null, 50);
                this.uidOnlyFieldSchema = this.fieldSchema.cloneUid();
            } else {
                LogicalSchema newTupleSchema = null;
                if (this.isProjectStar()) {
                    newTupleSchema = schema.deepCopy();
                } else {
                    newTupleSchema = new LogicalSchema();
                    for (int i = this.startCol; i <= this.endCol; ++i) {
                        newTupleSchema.addField(schema.getField(i).deepCopy());
                    }
                }
                this.fieldSchema = new LogicalSchema.LogicalFieldSchema(null, newTupleSchema, 110);
                this.uidOnlyFieldSchema = this.fieldSchema.mergeUid(this.uidOnlyFieldSchema);
            }
        }
        return this.fieldSchema;
    }

    public LogicalRelationalOperator findReferent() throws FrontendException {
        List<Operator> preds = this.attachedRelationalOp.getPlan().getPredecessors(this.attachedRelationalOp);
        if (preds == null || this.input >= preds.size()) {
            throw new FrontendException("Projection with nothing to reference!", 2225);
        }
        LogicalRelationalOperator pred = (LogicalRelationalOperator)preds.get(this.input);
        if (pred == null) {
            throw new FrontendException("Cannot find reference for " + this, 2226);
        }
        return pred;
    }

    @Override
    public boolean isEqual(Operator other) throws FrontendException {
        if (other != null && other instanceof ProjectExpression) {
            Operator theirSucc;
            ProjectExpression po = (ProjectExpression)other;
            if (po.input != this.input || po.col != this.col) {
                return false;
            }
            Operator mySucc = this.getPlan().getSuccessors(this) != null ? this.getPlan().getSuccessors(this).get(0) : null;
            Operator operator = theirSucc = other.getPlan().getSuccessors(other) != null ? other.getPlan().getSuccessors(other).get(0) : null;
            if (mySucc != null && theirSucc != null) {
                return mySucc.isEqual(theirSucc);
            }
            return mySucc == null && theirSucc == null;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder msg = new StringBuilder();
        if (this.fieldSchema != null && this.fieldSchema.alias != null) {
            msg.append(this.fieldSchema.alias + ":");
        }
        msg.append("(Name: " + this.name + " Type: ");
        if (this.fieldSchema != null) {
            msg.append(DataType.findTypeName(this.fieldSchema.type));
        } else {
            msg.append("null");
        }
        msg.append(" Uid: ");
        if (this.fieldSchema != null) {
            msg.append(this.fieldSchema.uid);
        } else {
            msg.append("null");
        }
        msg.append(" Input: " + this.input + " Column: ");
        if (this.alias != null) {
            msg.append(this.alias);
        } else if (this.isProjectStar()) {
            msg.append("(*)");
        } else if (this.isRangeProject) {
            msg.append("[").append(this.startCol).append(" .. ").append(this.endCol).append("]");
        } else {
            msg.append(this.col);
        }
        msg.append(")");
        return msg.toString();
    }

    public LogicalRelationalOperator getAttachedRelationalOp() {
        return this.attachedRelationalOp;
    }

    public void setAttachedRelationalOp(LogicalRelationalOperator attachedRelationalOp) {
        this.attachedRelationalOp = attachedRelationalOp;
    }

    @Override
    public byte getType() throws FrontendException {
        if (this.getFieldSchema() == null) {
            if (this.attachedRelationalOp instanceof LOGenerate && this.findReferent() instanceof LOInnerLoad && ((LOInnerLoad)this.findReferent()).getProjection().isRangeOrStarProject()) {
                return 110;
            }
            return 50;
        }
        return super.getType();
    }

    public int getStartCol() {
        return this.startCol;
    }

    public void setStartCol(int startCol) {
        this.startCol = startCol;
    }

    public int getEndCol() {
        return this.endCol;
    }

    public void setEndCol(int endCol) {
        this.endCol = endCol;
    }

    public void setStartAlias(String startAlias) throws FrontendException {
        this.startAlias = startAlias;
    }

    public void setEndAlias(String endAlias) throws FrontendException {
        this.endAlias = endAlias;
    }

    @Override
    public LogicalExpression deepCopy(LogicalExpressionPlan lgExpPlan) throws FrontendException {
        ProjectExpression copy = new ProjectExpression((OperatorPlan)lgExpPlan, this.getInputNum(), this.getColNum(), this.getAttachedRelationalOp());
        copy.setLocation(new SourceLocation(this.location));
        copy.alias = this.alias;
        copy.isRangeProject = this.isRangeProject;
        copy.startCol = this.startCol;
        copy.endCol = this.endCol;
        copy.startAlias = this.startAlias;
        copy.endAlias = this.endAlias;
        return copy;
    }
}

