/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.pig.PigCounters;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.tools.pigstats.InputStats;
import org.apache.pig.tools.pigstats.OutputStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.PigStatsUtil;
import org.apache.pig.tools.pigstats.ScriptState;
import org.apache.pig.tools.pigstats.SimplePigStats;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class JobStats
extends Operator {
    public static final String ALIAS = "JobStatistics:alias";
    public static final String ALIAS_LOCATION = "JobStatistics:alias_location";
    public static final String FEATURE = "JobStatistics:feature";
    public static final String SUCCESS_HEADER = "JobId\tMaps\tReduces\tMaxMapTime\tMinMapTIme\tAvgMapTime\tMedianMapTime\tMaxReduceTime\tMinReduceTime\tAvgReduceTime\tMedianReducetime\tAlias\tFeature\tOutputs";
    public static final String FAILURE_HEADER = "JobId\tAlias\tFeature\tMessage\tOutputs";
    public static final String SUCCESS_HEADER_LOCAL = "JobId\tAlias\tFeature\tOutputs";
    private static final Log LOG = LogFactory.getLog(JobStats.class);
    private JobState state = JobState.UNKNOWN;
    private Configuration conf;
    private List<POStore> mapStores = null;
    private List<POStore> reduceStores = null;
    private List<FileSpec> loads = null;
    private ArrayList<OutputStats> outputs;
    private ArrayList<InputStats> inputs;
    private String errorMsg;
    private Exception exception = null;
    private Boolean disableCounter = false;
    private JobID jobId;
    private long maxMapTime = 0L;
    private long minMapTime = 0L;
    private long avgMapTime = 0L;
    private long medianMapTime = 0L;
    private long maxReduceTime = 0L;
    private long minReduceTime = 0L;
    private long avgReduceTime = 0L;
    private long medianReduceTime = 0L;
    private int numberMaps = 0;
    private int numberReduces = 0;
    private long mapInputRecords = 0L;
    private long mapOutputRecords = 0L;
    private long reduceInputRecords = 0L;
    private long reduceOutputRecords = 0L;
    private long hdfsBytesWritten = 0L;
    private long hdfsBytesRead = 0L;
    private long spillCount = 0L;
    private long activeSpillCountObj = 0L;
    private long activeSpillCountRecs = 0L;
    private HashMap<String, Long> multiStoreCounters = new HashMap();
    private HashMap<String, Long> multiInputCounters = new HashMap();
    private Counters counters = null;

    JobStats(String name, PigStats.JobGraph plan) {
        super(name, plan);
        this.outputs = new ArrayList();
        this.inputs = new ArrayList();
    }

    public String getJobId() {
        return this.jobId == null ? null : this.jobId.toString();
    }

    public JobState getState() {
        return this.state;
    }

    public boolean isSuccessful() {
        return this.state == JobState.SUCCESS;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public Exception getException() {
        return this.exception;
    }

    public int getNumberMaps() {
        return this.numberMaps;
    }

    public int getNumberReduces() {
        return this.numberReduces;
    }

    public long getMaxMapTime() {
        return this.maxMapTime;
    }

    public long getMinMapTime() {
        return this.minMapTime;
    }

    public long getAvgMapTime() {
        return this.avgMapTime;
    }

    public long getMaxReduceTime() {
        return this.maxReduceTime;
    }

    public long getMinReduceTime() {
        return this.minReduceTime;
    }

    public long getAvgREduceTime() {
        return this.avgReduceTime;
    }

    public long getMapInputRecords() {
        return this.mapInputRecords;
    }

    public long getMapOutputRecords() {
        return this.mapOutputRecords;
    }

    public long getReduceOutputRecords() {
        return this.reduceOutputRecords;
    }

    public long getReduceInputRecords() {
        return this.reduceInputRecords;
    }

    public long getSMMSpillCount() {
        return this.spillCount;
    }

    public long getProactiveSpillCountObjects() {
        return this.activeSpillCountObj;
    }

    public long getProactiveSpillCountRecs() {
        return this.activeSpillCountRecs;
    }

    public long getHdfsBytesWritten() {
        return this.hdfsBytesWritten;
    }

    public Counters getHadoopCounters() {
        return this.counters;
    }

    public List<OutputStats> getOutputs() {
        return Collections.unmodifiableList(this.outputs);
    }

    public List<InputStats> getInputs() {
        return Collections.unmodifiableList(this.inputs);
    }

    public Map<String, Long> getMultiStoreCounters() {
        return Collections.unmodifiableMap(this.multiStoreCounters);
    }

    public String getAlias() {
        return (String)this.getAnnotation(ALIAS);
    }

    public String getAliasLocation() {
        return (String)this.getAnnotation(ALIAS_LOCATION);
    }

    public String getFeature() {
        return (String)this.getAnnotation(FEATURE);
    }

    public long getBytesWritten() {
        long count = 0L;
        for (OutputStats out : this.outputs) {
            long n = out.getBytes();
            if (n <= 0L) continue;
            count += n;
        }
        return count;
    }

    public long getRecordWrittern() {
        long count = 0L;
        for (OutputStats out : this.outputs) {
            long rec = out.getNumberRecords();
            if (rec <= 0L) continue;
            count += rec;
        }
        return count;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (v instanceof SimplePigStats.JobGraphPrinter) {
            SimplePigStats.JobGraphPrinter jpp = (SimplePigStats.JobGraphPrinter)v;
            jpp.visit(this);
        }
    }

    @Override
    public boolean isEqual(Operator operator) {
        if (!(operator instanceof JobStats)) {
            return false;
        }
        return this.name.equalsIgnoreCase(operator.getName());
    }

    void setId(JobID jobId) {
        this.jobId = jobId;
    }

    void setSuccessful(boolean isSuccessful) {
        this.state = isSuccessful ? JobState.SUCCESS : JobState.FAILED;
    }

    void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    void setBackendException(Exception e) {
        this.exception = e;
    }

    void setConf(Configuration conf) {
        if (conf == null) {
            return;
        }
        this.conf = conf;
        try {
            this.mapStores = (List)ObjectSerializer.deserialize(conf.get("pig.map.stores"));
            this.reduceStores = (List)ObjectSerializer.deserialize(conf.get("pig.reduce.stores"));
            this.loads = (ArrayList)ObjectSerializer.deserialize(conf.get("pig.inputs"));
            this.disableCounter = conf.getBoolean("pig.disable.counter", false);
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to deserialize the store list", (Throwable)e);
        }
    }

    void setMapStat(int size, long max, long min, long avg, long median) {
        this.numberMaps = size;
        this.maxMapTime = max;
        this.minMapTime = min;
        this.avgMapTime = avg;
        this.medianMapTime = median;
    }

    void setReduceStat(int size, long max, long min, long avg, long median) {
        this.numberReduces = size;
        this.maxReduceTime = max;
        this.minReduceTime = min;
        this.avgReduceTime = avg;
        this.medianReduceTime = median;
    }

    String getDisplayString(boolean local) {
        String id;
        StringBuilder sb = new StringBuilder();
        String string = id = this.jobId == null ? "N/A" : this.jobId.toString();
        if (this.state == JobState.FAILED || local) {
            sb.append(id).append("\t").append(this.getAlias()).append("\t").append(this.getFeature()).append("\t");
            if (this.state == JobState.FAILED) {
                sb.append("Message: ").append(this.getErrorMessage()).append("\t");
            }
        } else if (this.state == JobState.SUCCESS) {
            sb.append(id).append("\t").append(this.numberMaps).append("\t").append(this.numberReduces).append("\t");
            if (this.maxMapTime < 0L) {
                sb.append("n/a\t").append("n/a\t").append("n/a\t");
            } else {
                sb.append(this.maxMapTime / 1000L).append("\t").append(this.minMapTime / 1000L).append("\t").append(this.avgMapTime / 1000L).append("\t").append(this.medianMapTime / 1000L).append("\t");
            }
            if (this.maxReduceTime < 0L) {
                sb.append("n/a\t").append("n/a\t").append("n/a\t");
            } else {
                sb.append(this.maxReduceTime / 1000L).append("\t").append(this.minReduceTime / 1000L).append("\t").append(this.avgReduceTime / 1000L).append("\t").append(this.medianReduceTime / 1000L).append("\t");
            }
            sb.append(this.getAlias()).append("\t").append(this.getFeature()).append("\t");
        }
        for (OutputStats os : this.outputs) {
            sb.append(os.getLocation()).append(",");
        }
        sb.append("\n");
        return sb.toString();
    }

    void addCounters(RunningJob rjob) {
        if (rjob != null) {
            try {
                this.counters = rjob.getCounters();
            }
            catch (IOException e) {
                LOG.warn((Object)"Unable to get job counters", (Throwable)e);
            }
        }
        if (this.counters != null) {
            Counters.Group taskgroup = this.counters.getGroup("org.apache.hadoop.mapred.Task$Counter");
            Counters.Group hdfsgroup = this.counters.getGroup(PigStatsUtil.FS_COUNTER_GROUP);
            Counters.Group multistoregroup = this.counters.getGroup("MultiStoreCounters");
            Counters.Group multiloadgroup = this.counters.getGroup("MultiInputCounters");
            this.mapInputRecords = taskgroup.getCounterForName("MAP_INPUT_RECORDS").getCounter();
            this.mapOutputRecords = taskgroup.getCounterForName("MAP_OUTPUT_RECORDS").getCounter();
            this.reduceInputRecords = taskgroup.getCounterForName("REDUCE_INPUT_RECORDS").getCounter();
            this.reduceOutputRecords = taskgroup.getCounterForName("REDUCE_OUTPUT_RECORDS").getCounter();
            this.hdfsBytesRead = hdfsgroup.getCounterForName("HDFS_BYTES_READ").getCounter();
            this.hdfsBytesWritten = hdfsgroup.getCounterForName("HDFS_BYTES_WRITTEN").getCounter();
            this.spillCount = this.counters.findCounter((Enum)PigCounters.SPILLABLE_MEMORY_MANAGER_SPILL_COUNT).getCounter();
            this.activeSpillCountObj = this.counters.findCounter((Enum)PigCounters.PROACTIVE_SPILL_COUNT_BAGS).getCounter();
            this.activeSpillCountRecs = this.counters.findCounter((Enum)PigCounters.PROACTIVE_SPILL_COUNT_RECS).getCounter();
            for (Counters.Counter cter : multistoregroup) {
                this.multiStoreCounters.put(cter.getName(), cter.getValue());
            }
            for (Counters.Counter cter : multiloadgroup) {
                this.multiInputCounters.put(cter.getName(), cter.getValue());
            }
        }
    }

    void addMapReduceStatistics(JobClient client, Configuration conf) {
        TaskReport[] maps = null;
        try {
            maps = client.getMapTaskReports(this.jobId);
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to get map task report", (Throwable)e);
        }
        if (maps != null && maps.length > 0) {
            int size = maps.length;
            long max = 0L;
            long min = Long.MAX_VALUE;
            long median = 0L;
            long total = 0L;
            long[] durations = new long[size];
            for (int i = 0; i < maps.length; ++i) {
                long duration;
                TaskReport rpt = maps[i];
                durations[i] = duration = rpt.getFinishTime() - rpt.getStartTime();
                max = duration > max ? duration : max;
                min = duration < min ? duration : min;
                total += duration;
            }
            long avg = total / (long)size;
            median = this.calculateMedianValue(durations);
            this.setMapStat(size, max, min, avg, median);
        } else {
            int m = conf.getInt("mapred.map.tasks", 1);
            if (m > 0) {
                this.setMapStat(m, -1L, -1L, -1L, -1L);
            }
        }
        TaskReport[] reduces = null;
        try {
            reduces = client.getReduceTaskReports(this.jobId);
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to get reduce task report", (Throwable)e);
        }
        if (reduces != null && reduces.length > 0) {
            int size = reduces.length;
            long max = 0L;
            long min = Long.MAX_VALUE;
            long median = 0L;
            long total = 0L;
            long[] durations = new long[size];
            for (int i = 0; i < reduces.length; ++i) {
                long duration;
                TaskReport rpt = reduces[i];
                durations[i] = duration = rpt.getFinishTime() - rpt.getStartTime();
                max = duration > max ? duration : max;
                min = duration < min ? duration : min;
                total += duration;
            }
            long avg = total / (long)size;
            median = this.calculateMedianValue(durations);
            this.setReduceStat(size, max, min, avg, median);
        } else {
            int m = conf.getInt("mapred.reduce.tasks", 1);
            if (m > 0) {
                this.setReduceStat(m, -1L, -1L, -1L, -1L);
            }
        }
    }

    private long calculateMedianValue(long[] durations) {
        Arrays.sort(durations);
        int midPoint = durations.length / 2;
        long median = (durations.length & 1) == 1 ? durations[midPoint] : (durations[midPoint - 1] + durations[midPoint]) / 2L;
        return median;
    }

    void setAlias(MapReduceOper mro) {
        this.annotate(ALIAS, ScriptState.get().getAlias(mro));
        this.annotate(ALIAS_LOCATION, ScriptState.get().getAliasLocation(mro));
        this.annotate(FEATURE, ScriptState.get().getPigFeature(mro));
    }

    void addOutputStatistics() {
        block4: {
            block3: {
                POStore sto;
                if (this.mapStores == null || this.reduceStores == null) {
                    LOG.warn((Object)"unable to get stores of the job");
                    return;
                }
                if (this.mapStores.size() + this.reduceStores.size() != 1) break block3;
                POStore pOStore = sto = this.mapStores.size() > 0 ? this.mapStores.get(0) : this.reduceStores.get(0);
                if (sto.isTmpStore()) break block4;
                long records = this.mapStores.size() > 0 ? this.mapOutputRecords : this.reduceOutputRecords;
                OutputStats ds = new OutputStats(sto.getSFile().getFileName(), this.hdfsBytesWritten, records, this.state == JobState.SUCCESS);
                ds.setPOStore(sto);
                ds.setConf(this.conf);
                this.outputs.add(ds);
                if (this.state != JobState.SUCCESS) break block4;
                ScriptState.get().emitOutputCompletedNotification(ds);
                break block4;
            }
            for (POStore sto : this.mapStores) {
                if (sto.isTmpStore()) continue;
                this.addOneOutputStats(sto);
            }
            for (POStore sto : this.reduceStores) {
                if (sto.isTmpStore()) continue;
                this.addOneOutputStats(sto);
            }
        }
    }

    private void addOneOutputStats(POStore sto) {
        long records = -1L;
        if (sto.isMultiStore()) {
            Long n = this.multiStoreCounters.get(PigStatsUtil.getMultiStoreCounterName(sto));
            if (n != null) {
                records = n;
            }
        } else {
            records = this.mapOutputRecords;
        }
        String location = sto.getSFile().getFileName();
        URI uri = null;
        try {
            uri = new URI(location);
        }
        catch (URISyntaxException e1) {
            LOG.warn((Object)("invalid syntax for output location: " + location), (Throwable)e1);
        }
        long bytes = -1L;
        if (uri != null && (uri.getScheme() == null || uri.getScheme().equalsIgnoreCase("hdfs"))) {
            try {
                Path p = new Path(location);
                FileSystem fs = p.getFileSystem(this.conf);
                FileStatus[] lst = fs.listStatus(p);
                if (lst != null) {
                    for (FileStatus status : lst) {
                        bytes += status.getLen();
                    }
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"unable to get byte written of the job", (Throwable)e);
            }
        }
        OutputStats ds = new OutputStats(location, bytes, records, this.state == JobState.SUCCESS);
        ds.setPOStore(sto);
        ds.setConf(this.conf);
        this.outputs.add(ds);
        if (this.state == JobState.SUCCESS) {
            ScriptState.get().emitOutputCompletedNotification(ds);
        }
    }

    void addInputStatistics() {
        if (this.loads == null) {
            LOG.warn((Object)"unable to get inputs of the job");
            return;
        }
        if (this.loads.size() == 1) {
            FileSpec fsp = this.loads.get(0);
            if (!PigStatsUtil.isTempFile(fsp.getFileName())) {
                long records = this.mapInputRecords;
                InputStats is = new InputStats(fsp.getFileName(), this.hdfsBytesRead, records, this.state == JobState.SUCCESS);
                is.setConf(this.conf);
                if (this.isSampler()) {
                    is.markSampleInput();
                }
                if (this.isIndexer()) {
                    is.markIndexerInput();
                }
                this.inputs.add(is);
            }
        } else {
            for (int i = 0; i < this.loads.size(); ++i) {
                FileSpec fsp = this.loads.get(i);
                if (PigStatsUtil.isTempFile(fsp.getFileName())) continue;
                this.addOneInputStats(fsp.getFileName(), i);
            }
        }
    }

    private void addOneInputStats(String fileName, int index) {
        long records = -1L;
        Long n = this.multiInputCounters.get(PigStatsUtil.getMultiInputsCounterName(fileName, index));
        if (n != null) {
            records = n;
        } else if (!this.disableCounter.booleanValue()) {
            records = 0L;
        } else {
            LOG.warn((Object)("unable to get input counter for " + fileName));
        }
        InputStats is = new InputStats(fileName, -1L, records, this.state == JobState.SUCCESS);
        is.setConf(this.conf);
        this.inputs.add(is);
    }

    private boolean isSampler() {
        return this.getFeature().contains(ScriptState.PIG_FEATURE.SAMPLER.name());
    }

    private boolean isIndexer() {
        return this.getFeature().contains(ScriptState.PIG_FEATURE.INDEXER.name());
    }

    public static enum JobState {
        UNKNOWN,
        SUCCESS,
        FAILED;

    }
}

