/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.builtins;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hive.pdk.HivePdkUnitTest;
import org.apache.hive.pdk.HivePdkUnitTests;

@HivePdkUnitTests(setup="", cleanup="", cases={@HivePdkUnitTest(query="SELECT size(UNION_MAP(MAP(sepal_width, sepal_length))) FROM iris", result="23")})
@Description(name="union_map", value="_FUNC_(col) - aggregate given maps into a single map", extended="Aggregate maps, returns as a HashMap.")
public class UDAFUnionMap
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] typeInfoArray) throws SemanticException {
        return new Evaluator();
    }

    public static class Evaluator
    extends GenericUDAFEvaluator {
        ObjectInspector inputOI;
        MapObjectInspector internalMergeOI;

        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] objectInspectorArray) throws HiveException {
            super.init(mode, objectInspectorArray);
            if (mode == GenericUDAFEvaluator.Mode.COMPLETE || mode == GenericUDAFEvaluator.Mode.PARTIAL1) {
                this.inputOI = (MapObjectInspector)objectInspectorArray[0];
            } else {
                this.internalMergeOI = (MapObjectInspector)objectInspectorArray[0];
            }
            return ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)objectInspectorArray[0]);
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            return new State();
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer aggregationBuffer, Object[] objectArray) throws HiveException {
            if (objectArray[0] != null) {
                State state = (State)aggregationBuffer;
                state.map.putAll((Map)ObjectInspectorUtils.copyToStandardObject((Object)objectArray[0], (ObjectInspector)this.inputOI));
            }
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer aggregationBuffer, Object object) throws HiveException {
            if (object != null) {
                State state = (State)aggregationBuffer;
                Map map = (Map)ObjectInspectorUtils.copyToStandardObject((Object)object, (ObjectInspector)this.internalMergeOI);
                state.map.putAll(map);
            }
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer aggregationBuffer) throws HiveException {
            ((State)aggregationBuffer).map.clear();
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer aggregationBuffer) throws HiveException {
            return ((State)aggregationBuffer).map;
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer aggregationBuffer) throws HiveException {
            return ((State)aggregationBuffer).map;
        }
    }

    public static class State
    implements GenericUDAFEvaluator.AggregationBuffer {
        HashMap<Object, Object> map = new HashMap();
    }
}

