/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.Rect;
import org.eclipse.swt.internal.win32.EMR;
import org.eclipse.swt.internal.win32.EMREXTCREATEFONTINDIRECTW;
import org.eclipse.swt.internal.win32.LOGBRUSH;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.OUTLINETEXTMETRIC;
import org.eclipse.swt.internal.win32.OUTLINETEXTMETRICA;
import org.eclipse.swt.internal.win32.OUTLINETEXTMETRICW;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCRIPT_ANALYSIS;
import org.eclipse.swt.internal.win32.SCRIPT_CONTROL;
import org.eclipse.swt.internal.win32.SCRIPT_FONTPROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_ITEM;
import org.eclipse.swt.internal.win32.SCRIPT_LOGATTR;
import org.eclipse.swt.internal.win32.SCRIPT_PROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_STATE;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    String segmentsText;
    int lineSpacing = 0;
    int ascent = -1;
    int descent = -1;
    int alignment;
    int wrapWidth = -1;
    int orientation = 0x2000000;
    int indent;
    int wrapIndent;
    boolean justify;
    int[] tabs;
    int[] segments;
    char[] segmentsChars;
    StyleItem[] styles = new StyleItem[2];
    int stylesCount;
    StyleItem[] allRuns;
    StyleItem[][] runs;
    int[] lineOffset;
    int[] lineY;
    int[] lineWidth;
    long mLangFontLink2;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final int SCRIPT_VISATTR_SIZEOF = 2;
    static final int GOFFSET_SIZEOF = 8;
    static final byte[] CLSID_CMultiLanguage = new byte[16];
    static final byte[] IID_IMLangFontLink2 = new byte[16];
    static final int MERGE_MAX = 512;
    static final int TOO_MANY_RUNS = 1024;
    static final int UNDERLINE_IME_DOT = 65536;
    static final int UNDERLINE_IME_DASH = 131072;
    static final int UNDERLINE_IME_THICK = 196608;

    static {
        OS.IIDFromString("{275c23e2-3747-11d0-9fea-00aa003f8646}\u0000".toCharArray(), CLSID_CMultiLanguage);
        OS.IIDFromString("{DCCFC162-2B38-11d2-B7EC-00C04F8F5D9A}\u0000".toCharArray(), IID_IMLangFontLink2);
    }

    public TextLayout(Device device) {
        super(device);
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.stylesCount = 2;
        this.text = "";
        long[] lArray = new long[1];
        OS.OleInitialize(0L);
        if (OS.CoCreateInstance(CLSID_CMultiLanguage, 0L, 1, IID_IMLangFontLink2, lArray) == 0) {
            this.mLangFontLink2 = lArray[0];
        }
        this.init();
    }

    RECT addClipRect(StyleItem styleItem, RECT rECT, RECT rECT2, int n, int n2) {
        if (rECT2 != null) {
            boolean bl;
            if (rECT == null) {
                rECT = new RECT();
                OS.SetRect(rECT, -1, rECT2.top, -1, rECT2.bottom);
            }
            boolean bl2 = bl = (this.orientation & 0x4000000) != 0;
            if (styleItem.start <= n && n <= styleItem.start + styleItem.length) {
                if (styleItem.analysis.fRTL ^ bl) {
                    rECT.right = rECT2.left;
                } else {
                    rECT.left = rECT2.left;
                }
            }
            if (styleItem.start <= n2 && n2 <= styleItem.start + styleItem.length) {
                if (styleItem.analysis.fRTL ^ bl) {
                    rECT.left = rECT2.right;
                } else {
                    rECT.right = rECT2.right;
                }
            }
        }
        return rECT;
    }

    void breakRun(StyleItem styleItem) {
        if (styleItem.psla != 0L) {
            return;
        }
        char[] cArray = new char[styleItem.length];
        this.segmentsText.getChars(styleItem.start, styleItem.start + styleItem.length, cArray, 0);
        long l = OS.GetProcessHeap();
        styleItem.psla = OS.HeapAlloc(l, 8, SCRIPT_LOGATTR.sizeof * cArray.length);
        if (styleItem.psla == 0L) {
            SWT.error(2);
        }
        OS.ScriptBreak(cArray, cArray.length, styleItem.analysis, styleItem.psla);
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns(GC gC) {
        int n;
        int n2;
        int n3;
        Object object;
        if (this.runs != null) {
            return;
        }
        long l = gC != null ? gC.handle : this.device.internal_new_GC(null);
        long l2 = OS.CreateCompatibleDC(l);
        this.allRuns = this.itemize();
        int n4 = 0;
        while (n4 < this.allRuns.length - 1) {
            object = this.allRuns[n4];
            OS.SelectObject(l2, this.getItemFont((StyleItem)object));
            this.shape(l2, (StyleItem)object);
            ++n4;
        }
        SCRIPT_LOGATTR sCRIPT_LOGATTR = new SCRIPT_LOGATTR();
        object = new SCRIPT_PROPERTIES();
        int n5 = this.indent;
        int n6 = 0;
        int n7 = 1;
        int n8 = 0;
        while (n8 < this.allRuns.length - 1) {
            int n9;
            int n10;
            StyleItem styleItem = this.allRuns[n8];
            if (this.tabs != null && styleItem.tab) {
                n3 = this.tabs.length;
                int n11 = 0;
                while (n11 < n3) {
                    if (this.tabs[n11] > n5) {
                        styleItem.width = this.tabs[n11] - n5;
                        break;
                    }
                    ++n11;
                }
                if (n11 == n3) {
                    n10 = this.tabs[n3 - 1];
                    int n12 = n2 = n3 > 1 ? this.tabs[n3 - 1] - this.tabs[n3 - 2] : this.tabs[0];
                    if (n2 > 0) {
                        while (n10 <= n5) {
                            n10 += n2;
                        }
                        styleItem.width = n10 - n5;
                    }
                }
                if ((n10 = styleItem.length) > 1) {
                    n2 = n11 + n10 - 1;
                    if (n2 < n3) {
                        styleItem.width += this.tabs[n2] - this.tabs[n11];
                    } else {
                        if (n11 < n3) {
                            styleItem.width += this.tabs[n3 - 1] - this.tabs[n11];
                            n10 -= n3 - 1 - n11;
                        }
                        n9 = n3 > 1 ? this.tabs[n3 - 1] - this.tabs[n3 - 2] : this.tabs[0];
                        styleItem.width += n9 * (n10 - 1);
                    }
                }
            }
            if (this.wrapWidth != -1 && n5 + styleItem.width > this.wrapWidth && !styleItem.tab && !styleItem.lineBreak) {
                StyleItem styleItem2;
                n3 = 0;
                int[] nArray = new int[styleItem.length];
                if (styleItem.style != null && styleItem.style.metrics != null) {
                    nArray[0] = styleItem.width;
                } else {
                    OS.ScriptGetLogicalWidths(styleItem.analysis, styleItem.length, styleItem.glyphCount, styleItem.advances, styleItem.clusters, styleItem.visAttrs, nArray);
                }
                n10 = 0;
                n2 = this.wrapWidth - n5;
                while (n10 + nArray[n3] < n2) {
                    n10 += nArray[n3++];
                }
                n9 = n3;
                int n13 = n8;
                while (n8 >= n6) {
                    this.breakRun(styleItem);
                    while (n3 >= 0) {
                        OS.MoveMemory(sCRIPT_LOGATTR, styleItem.psla + (long)(n3 * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                        if (sCRIPT_LOGATTR.fSoftBreak || sCRIPT_LOGATTR.fWhiteSpace) break;
                        --n3;
                    }
                    if (n3 == 0 && n8 != n6 && !styleItem.tab && sCRIPT_LOGATTR.fSoftBreak && !sCRIPT_LOGATTR.fWhiteSpace) {
                        OS.MoveMemory((SCRIPT_PROPERTIES)object, this.device.scripts[styleItem.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                        n = ((SCRIPT_PROPERTIES)object).langid;
                        styleItem2 = this.allRuns[n8 - 1];
                        OS.MoveMemory((SCRIPT_PROPERTIES)object, this.device.scripts[styleItem2.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                        if (((SCRIPT_PROPERTIES)object).langid == n || n == 0 || ((SCRIPT_PROPERTIES)object).langid == 0) {
                            this.breakRun(styleItem2);
                            OS.MoveMemory(sCRIPT_LOGATTR, styleItem2.psla + (long)((styleItem2.length - 1) * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                            if (!sCRIPT_LOGATTR.fWhiteSpace) {
                                n3 = -1;
                            }
                        }
                    }
                    if (n3 >= 0 || n8 == n6) break;
                    styleItem = this.allRuns[--n8];
                    n3 = styleItem.length - 1;
                }
                int n14 = n = n3 == 0 && n8 != n6 && !styleItem.tab ? 1 : 0;
                if (n != 0) {
                    this.breakRun(styleItem);
                    OS.MoveMemory(sCRIPT_LOGATTR, styleItem.psla + (long)(n3 * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                    int n15 = n = sCRIPT_LOGATTR.fWhiteSpace ? 0 : 1;
                }
                if (n != 0) {
                    styleItem = this.allRuns[--n8];
                    n3 = styleItem.length;
                } else if (n3 <= 0 && n8 == n6) {
                    if (n5 == this.wrapWidth && n13 > 0) {
                        n8 = n13 - 1;
                        styleItem = this.allRuns[n8];
                        n3 = styleItem.length;
                    } else {
                        n8 = n13;
                        styleItem = this.allRuns[n8];
                        n3 = Math.max(1, n9);
                    }
                }
                this.breakRun(styleItem);
                while (n3 < styleItem.length) {
                    OS.MoveMemory(sCRIPT_LOGATTR, styleItem.psla + (long)(n3 * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                    if (!sCRIPT_LOGATTR.fWhiteSpace) break;
                    ++n3;
                }
                if (n3 > 0 && n3 < styleItem.length) {
                    styleItem2 = new StyleItem();
                    styleItem2.start = styleItem.start + n3;
                    styleItem2.length = styleItem.length - n3;
                    styleItem2.style = styleItem.style;
                    styleItem2.analysis = this.cloneScriptAnalysis(styleItem.analysis);
                    styleItem.free();
                    styleItem.length = n3;
                    OS.SelectObject(l2, this.getItemFont(styleItem));
                    styleItem.analysis.fNoGlyphIndex = false;
                    this.shape(l2, styleItem);
                    OS.SelectObject(l2, this.getItemFont(styleItem2));
                    styleItem2.analysis.fNoGlyphIndex = false;
                    this.shape(l2, styleItem2);
                    StyleItem[] styleItemArray = new StyleItem[this.allRuns.length + 1];
                    System.arraycopy(this.allRuns, 0, styleItemArray, 0, n8 + 1);
                    System.arraycopy(this.allRuns, n8 + 1, styleItemArray, n8 + 2, this.allRuns.length - n8 - 1);
                    this.allRuns = styleItemArray;
                    this.allRuns[n8 + 1] = styleItem2;
                }
                if (n8 != this.allRuns.length - 2) {
                    styleItem.lineBreak = true;
                    styleItem.softBreak = true;
                }
            }
            n5 += styleItem.width;
            if (styleItem.lineBreak) {
                n6 = n8 + 1;
                n5 = styleItem.softBreak ? this.wrapIndent : this.indent;
                ++n7;
            }
            ++n8;
        }
        n5 = 0;
        this.runs = new StyleItem[n7][];
        this.lineOffset = new int[n7 + 1];
        this.lineY = new int[n7 + 1];
        this.lineWidth = new int[n7];
        n8 = 0;
        int n16 = 0;
        n3 = Math.max(0, this.ascent);
        int n17 = Math.max(0, this.descent);
        StyleItem[] styleItemArray = new StyleItem[this.allRuns.length];
        n2 = 0;
        while (n2 < this.allRuns.length) {
            StyleItem styleItem = this.allRuns[n2];
            styleItemArray[n8++] = styleItem;
            n5 += styleItem.width;
            n3 = Math.max(n3, styleItem.ascent);
            n17 = Math.max(n17, styleItem.descent);
            if (styleItem.lineBreak || n2 == this.allRuns.length - 1) {
                if (!(n8 != 1 || n2 != this.allRuns.length - 1 && styleItem.softBreak)) {
                    TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                    OS.SelectObject(l2, this.getItemFont(styleItem));
                    OS.GetTextMetrics(l2, tEXTMETRIC);
                    styleItem.ascent = tEXTMETRIC.tmAscent;
                    styleItem.descent = tEXTMETRIC.tmDescent;
                    n3 = Math.max(n3, styleItem.ascent);
                    n17 = Math.max(n17, styleItem.descent);
                }
                this.runs[n16] = new StyleItem[n8];
                System.arraycopy(styleItemArray, 0, this.runs[n16], 0, n8);
                if (this.justify && this.wrapWidth != -1 && styleItem.softBreak && n5 > 0) {
                    int n18 = this.wrapIndent;
                    if (n16 == 0) {
                        n18 = this.indent;
                    } else {
                        StyleItem[] styleItemArray2 = this.runs[n16 - 1];
                        StyleItem styleItem3 = styleItemArray2[styleItemArray2.length - 1];
                        if (styleItem3.lineBreak && !styleItem3.softBreak) {
                            n18 = this.indent;
                        }
                    }
                    n5 += n18;
                    long l3 = OS.GetProcessHeap();
                    int n19 = 0;
                    int n20 = 0;
                    while (n20 < this.runs[n16].length) {
                        StyleItem styleItem4 = this.runs[n16][n20];
                        int n21 = styleItem4.width * this.wrapWidth / n5;
                        if (n21 != styleItem4.width) {
                            styleItem4.justify = OS.HeapAlloc(l3, 8, styleItem4.glyphCount * 4);
                            if (styleItem4.justify == 0L) {
                                SWT.error(2);
                            }
                            OS.ScriptJustify(styleItem4.visAttrs, styleItem4.advances, styleItem4.glyphCount, n21 - styleItem4.width, 2, styleItem4.justify);
                            styleItem4.width = n21;
                        }
                        n19 += styleItem4.width;
                        ++n20;
                    }
                    n5 = n19;
                }
                this.lineWidth[n16] = n5;
                StyleItem styleItem5 = this.runs[n16][n8 - 1];
                n = styleItem5.start + styleItem5.length;
                this.runs[n16] = this.reorder(this.runs[n16], n2 == this.allRuns.length - 1);
                styleItem5 = this.runs[n16][n8 - 1];
                if (styleItem.softBreak && styleItem != styleItem5) {
                    styleItem.lineBreak = false;
                    styleItem.softBreak = false;
                    styleItem5.lineBreak = true;
                    styleItem5.softBreak = true;
                }
                n5 = this.getLineIndent(n16);
                int n22 = 0;
                while (n22 < this.runs[n16].length) {
                    this.runs[n16][n22].x = n5;
                    n5 += this.runs[n16][n22].width;
                    ++n22;
                }
                this.lineY[++n16] = this.lineY[n16 - 1] + n3 + n17 + this.lineSpacing;
                this.lineOffset[n16] = n;
                n5 = 0;
                n8 = 0;
                n3 = Math.max(0, this.ascent);
                n17 = Math.max(0, this.descent);
            }
            ++n2;
        }
        if (l2 != 0L) {
            OS.DeleteDC(l2);
        }
        if (gC == null) {
            this.device.internal_dispose_GC(l, null);
        }
    }

    void destroy() {
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.segmentsText = null;
        this.tabs = null;
        this.styles = null;
        this.runs = null;
        this.lineOffset = null;
        this.lineY = null;
        this.lineWidth = null;
        this.segments = null;
        this.segmentsChars = null;
        if (this.mLangFontLink2 != 0L) {
            OS.VtblCall(2, this.mLangFontLink2);
            this.mLangFontLink2 = 0L;
        }
        OS.OleUninitialize();
    }

    SCRIPT_ANALYSIS cloneScriptAnalysis(SCRIPT_ANALYSIS sCRIPT_ANALYSIS) {
        SCRIPT_ANALYSIS sCRIPT_ANALYSIS2 = new SCRIPT_ANALYSIS();
        sCRIPT_ANALYSIS2.eScript = sCRIPT_ANALYSIS.eScript;
        sCRIPT_ANALYSIS2.fRTL = sCRIPT_ANALYSIS.fRTL;
        sCRIPT_ANALYSIS2.fLayoutRTL = sCRIPT_ANALYSIS.fLayoutRTL;
        sCRIPT_ANALYSIS2.fLinkBefore = sCRIPT_ANALYSIS.fLinkBefore;
        sCRIPT_ANALYSIS2.fLinkAfter = sCRIPT_ANALYSIS.fLinkAfter;
        sCRIPT_ANALYSIS2.fLogicalOrder = sCRIPT_ANALYSIS.fLogicalOrder;
        sCRIPT_ANALYSIS2.fNoGlyphIndex = sCRIPT_ANALYSIS.fNoGlyphIndex;
        sCRIPT_ANALYSIS2.s = new SCRIPT_STATE();
        sCRIPT_ANALYSIS2.s.uBidiLevel = sCRIPT_ANALYSIS.s.uBidiLevel;
        sCRIPT_ANALYSIS2.s.fOverrideDirection = sCRIPT_ANALYSIS.s.fOverrideDirection;
        sCRIPT_ANALYSIS2.s.fInhibitSymSwap = sCRIPT_ANALYSIS.s.fInhibitSymSwap;
        sCRIPT_ANALYSIS2.s.fCharShape = sCRIPT_ANALYSIS.s.fCharShape;
        sCRIPT_ANALYSIS2.s.fDigitSubstitute = sCRIPT_ANALYSIS.s.fDigitSubstitute;
        sCRIPT_ANALYSIS2.s.fInhibitLigate = sCRIPT_ANALYSIS.s.fInhibitLigate;
        sCRIPT_ANALYSIS2.s.fDisplayZWG = sCRIPT_ANALYSIS.s.fDisplayZWG;
        sCRIPT_ANALYSIS2.s.fArabicNumContext = sCRIPT_ANALYSIS.s.fArabicNumContext;
        sCRIPT_ANALYSIS2.s.fGcpClusters = sCRIPT_ANALYSIS.s.fGcpClusters;
        sCRIPT_ANALYSIS2.s.fReserved = sCRIPT_ANALYSIS.s.fReserved;
        sCRIPT_ANALYSIS2.s.fEngineReserved = sCRIPT_ANALYSIS.s.fEngineReserved;
        return sCRIPT_ANALYSIS2;
    }

    int[] computePolyline(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n4 - n2;
        int n7 = 2 * n6;
        int n8 = Compatibility.ceil(n3 - n, n7);
        if (n8 == 0 && n3 - n > 2) {
            n8 = 1;
        }
        if ((n5 = (2 * n8 + 1) * 2) < 0) {
            return new int[0];
        }
        int[] nArray = new int[n5];
        int n9 = 0;
        while (n9 < n8) {
            int n10 = 4 * n9;
            nArray[n10] = n + n7 * n9;
            nArray[n10 + 1] = n4;
            nArray[n10 + 2] = nArray[n10] + n7 / 2;
            nArray[n10 + 3] = n2;
            ++n9;
        }
        nArray[n5 - 2] = n + n7 * n8;
        nArray[n5 - 1] = n4;
        return nArray;
    }

    long createGdipBrush(int n, int n2) {
        int n3 = (n2 & 0xFF) << 24 | n >> 16 & 0xFF | n & 0xFF00 | (n & 0xFF) << 16;
        long l = Gdip.Color_new(n3);
        long l2 = Gdip.SolidBrush_new(l);
        Gdip.Color_delete(l);
        return l2;
    }

    long createGdipBrush(Color color, int n) {
        return this.createGdipBrush(color.handle, n);
    }

    public void draw(GC gC, int n, int n2) {
        this.draw(gC, n, n2, -1, -1, null, null);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        this.draw(gC, n, n2, n3, n4, color, color2, 0);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2, int n5) {
        int n6;
        int n7;
        this.checkLayout();
        this.computeRuns(gC);
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 != null && color2.isDisposed()) {
            SWT.error(5);
        }
        if ((n7 = this.text.length()) == 0 && n5 == 0) {
            return;
        }
        long l = gC.handle;
        Rectangle rectangle = gC.getClipping();
        GCData gCData = gC.data;
        long l2 = gCData.gdipGraphics;
        int n8 = gCData.foreground;
        int n9 = OS.GetSysColor(OS.COLOR_HOTLIGHT);
        int n10 = gCData.alpha;
        boolean bl = l2 != 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n11 = 0;
        if (bl) {
            gC.checkGC(1);
            l3 = gC.getFgBrush();
        } else {
            n11 = OS.SaveDC(l);
            if ((gCData.style & 0x8000000) != 0) {
                OS.SetLayout(l, OS.GetLayout(l) | 1);
            }
        }
        boolean bl2 = n3 <= n4 && n3 != -1 && n4 != -1;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        int n12 = 0;
        if (bl2 || (n5 & 0x100000) != 0 && (n5 & 0x30000) != 0) {
            int n13 = color != null ? color.handle : OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT);
            int n14 = n6 = color2 != null ? color2.handle : OS.GetSysColor(OS.COLOR_HIGHLIGHT);
            if (bl) {
                l5 = this.createGdipBrush(n6, n10);
                l6 = this.createGdipBrush(n13, n10);
            } else {
                l9 = OS.CreateSolidBrush(n6);
                n12 = n13;
            }
            if (bl2) {
                n3 = this.translateOffset(Math.min(Math.max(0, n3), n7 - 1));
                n4 = this.translateOffset(Math.min(Math.max(0, n4), n7 - 1));
            }
        }
        RECT rECT = new RECT();
        OS.SetBkMode(l, 1);
        n6 = 0;
        while (n6 < this.runs.length) {
            int n15;
            int n16;
            int n17 = n + this.getLineIndent(n6);
            int n18 = n2 + this.lineY[n6];
            StyleItem[] styleItemArray = this.runs[n6];
            int n19 = this.lineY[n6 + 1] - this.lineY[n6] - this.lineSpacing;
            if ((n5 & 0x30000) != 0 && (bl2 || (n5 & 0x100000) != 0)) {
                n16 = 0;
                if (n6 == this.runs.length - 1 && (n5 & 0x100000) != 0) {
                    n16 = 1;
                } else {
                    StyleItem styleItem = styleItemArray[styleItemArray.length - 1];
                    if (styleItem.lineBreak && !styleItem.softBreak) {
                        if (n3 <= styleItem.start && styleItem.start <= n4) {
                            n16 = 1;
                        }
                    } else {
                        n15 = styleItem.start + styleItem.length - 1;
                        if (n3 <= n15 && n15 < n4 && (n5 & 0x10000) != 0) {
                            n16 = 1;
                        }
                    }
                }
                if (n16 != 0) {
                    int n20 = (n5 & 0x10000) != 0 ? (OS.IsWin95 ? Short.MAX_VALUE : 0x6FFFFFF) : n19 / 3;
                    if (bl) {
                        Gdip.Graphics_FillRectangle(l2, l5, n17 + this.lineWidth[n6], n18, n20, n19);
                    } else {
                        OS.SelectObject(l, l9);
                        OS.PatBlt(l, n17 + this.lineWidth[n6], n18, n20, n19, 15728673);
                    }
                }
            }
            if (n17 <= rectangle.x + rectangle.width && n17 + this.lineWidth[n6] >= rectangle.x) {
                n16 = n17;
                int n21 = 0;
                while (n21 < styleItemArray.length) {
                    StyleItem styleItem = styleItemArray[n21];
                    if (styleItem.length != 0) {
                        if (n17 > rectangle.x + rectangle.width) break;
                        if (n17 + styleItem.width >= rectangle.x && (!styleItem.lineBreak || styleItem.softBreak)) {
                            OS.SetRect(rECT, n17, n18, n17 + styleItem.width, n18 + n19);
                            if (bl) {
                                this.drawRunBackgroundGDIP(styleItem, l2, rECT, n3, n4, n10, l5, bl2);
                            } else {
                                this.drawRunBackground(styleItem, l, rECT, n3, n4, l9, bl2);
                            }
                        }
                        n17 += styleItem.width;
                    }
                    ++n21;
                }
                n21 = Math.max(0, this.ascent);
                n15 = 0;
                int n22 = 0;
                while (n22 < styleItemArray.length) {
                    n21 = Math.max(n21, styleItemArray[n22].ascent);
                    n15 = Math.min(n15, styleItemArray[n22].underlinePos);
                    ++n22;
                }
                RECT rECT2 = null;
                RECT rECT3 = null;
                RECT rECT4 = null;
                RECT rECT5 = null;
                n17 = n16;
                int n23 = 0;
                while (n23 < styleItemArray.length) {
                    boolean bl3;
                    StyleItem styleItem = styleItemArray[n23];
                    TextStyle textStyle = styleItem.style;
                    boolean bl4 = bl3 = textStyle != null && (textStyle.underline || textStyle.strikeout || textStyle.borderStyle != 0);
                    if (styleItem.length != 0) {
                        if (n17 > rectangle.x + rectangle.width) break;
                        if (n17 + styleItem.width >= rectangle.x) {
                            boolean bl5;
                            boolean bl6 = bl5 = styleItem.tab && !bl3;
                            if (!(bl5 || styleItem.lineBreak && !styleItem.softBreak || textStyle != null && textStyle.metrics != null)) {
                                OS.SetRect(rECT, n17, n18, n17 + styleItem.width, n18 + n19);
                                if (bl) {
                                    long l10;
                                    long l11 = this.getItemFont(styleItem);
                                    if (l11 != l8) {
                                        l8 = l11;
                                        if (l7 != 0L) {
                                            Gdip.Font_delete(l7);
                                        }
                                        l10 = OS.SelectObject(l, l11);
                                        l7 = Gdip.Font_new(l, l11);
                                        OS.SelectObject(l, l10);
                                        if (l7 == 0L) {
                                            SWT.error(2);
                                        }
                                        if (!Gdip.Font_IsAvailable(l7)) {
                                            Gdip.Font_delete(l7);
                                            l7 = 0L;
                                        }
                                    }
                                    l10 = l3;
                                    if (textStyle != null && textStyle.underline && textStyle.underlineStyle == 4) {
                                        if (l4 == 0L) {
                                            l4 = this.createGdipBrush(n9, n10);
                                        }
                                        l10 = l4;
                                    }
                                    if (l7 != 0L && !styleItem.analysis.fNoGlyphIndex) {
                                        rECT5 = this.drawRunTextGDIP(l2, styleItem, rECT, l7, n21, l10, l6, n3, n4, n10);
                                    } else {
                                        int n24 = textStyle != null && textStyle.underline && textStyle.underlineStyle == 4 ? n9 : n8;
                                        rECT5 = this.drawRunTextGDIPRaster(l2, styleItem, rECT, n21, n24, n12, n3, n4);
                                    }
                                    rECT3 = this.drawUnderlineGDIP(l2, n, n18 + n21, n15, n18 + n19, styleItemArray, n23, l10, l6, rECT3, rECT5, n3, n4, n10, rectangle);
                                    rECT4 = this.drawStrikeoutGDIP(l2, n, n18 + n21, styleItemArray, n23, l10, l6, rECT4, rECT5, n3, n4, n10, rectangle);
                                    rECT2 = this.drawBorderGDIP(l2, n, n18, n19, styleItemArray, n23, l10, l6, rECT2, rECT5, n3, n4, n10, rectangle);
                                } else {
                                    int n25 = textStyle != null && textStyle.underline && textStyle.underlineStyle == 4 ? n9 : n8;
                                    rECT5 = this.drawRunText(l, styleItem, rECT, n21, n25, n12, n3, n4);
                                    rECT3 = this.drawUnderline(l, n, n18 + n21, n15, n18 + n19, styleItemArray, n23, n25, n12, rECT3, rECT5, n3, n4, rectangle);
                                    rECT4 = this.drawStrikeout(l, n, n18 + n21, styleItemArray, n23, n25, n12, rECT4, rECT5, n3, n4, rectangle);
                                    rECT2 = this.drawBorder(l, n, n18, n19, styleItemArray, n23, n25, n12, rECT2, rECT5, n3, n4, rectangle);
                                }
                            }
                        }
                        n17 += styleItem.width;
                    }
                    ++n23;
                }
            }
            ++n6;
        }
        if (l5 != 0L) {
            Gdip.SolidBrush_delete(l5);
        }
        if (l6 != 0L) {
            Gdip.SolidBrush_delete(l6);
        }
        if (l4 != 0L) {
            Gdip.SolidBrush_delete(l4);
        }
        if (l7 != 0L) {
            Gdip.Font_delete(l7);
        }
        if (n11 != 0) {
            OS.RestoreDC(l, n11);
        }
        if (l9 != 0L) {
            OS.DeleteObject(l9);
        }
    }

    RECT drawBorder(long l, int n, int n2, int n3, StyleItem[] styleItemArray, int n4, int n5, int n6, RECT rECT, RECT rECT2, int n7, int n8, Rectangle rectangle) {
        boolean bl;
        StyleItem styleItem = styleItemArray[n4];
        TextStyle textStyle = styleItem.style;
        if (textStyle == null) {
            return null;
        }
        if (textStyle.borderStyle == 0) {
            return null;
        }
        rECT = this.addClipRect(styleItem, rECT, rECT2, n7, n8);
        boolean bl2 = bl = rectangle != null && n + styleItem.x + styleItem.width > rectangle.x + rectangle.width;
        if (n4 + 1 >= styleItemArray.length || bl || !textStyle.isAdherentBorder(styleItemArray[n4 + 1].style)) {
            int n9;
            boolean bl3;
            int n10 = styleItem.x;
            int n11 = styleItem.start;
            int n12 = styleItem.start + styleItem.length - 1;
            int n13 = n4;
            while (n13 > 0 && textStyle.isAdherentBorder(styleItemArray[n13 - 1].style)) {
                n10 = styleItemArray[n13 - 1].x;
                n11 = Math.min(n11, styleItemArray[n13 - 1].start);
                n12 = Math.max(n12, styleItemArray[n13 - 1].start + styleItemArray[n13 - 1].length - 1);
                --n13;
            }
            n13 = n7 <= n8 && n7 != -1 && n8 != -1 ? 1 : 0;
            boolean bl4 = bl3 = n13 != 0 && n7 <= n11 && n12 <= n8;
            if (textStyle.borderColor != null) {
                n5 = textStyle.borderColor.handle;
                rECT = null;
            } else if (bl3) {
                n5 = n6;
                rECT = null;
            } else if (textStyle.foreground != null) {
                n5 = textStyle.foreground.handle;
            }
            int n14 = 1;
            int n15 = 1;
            int n16 = 0;
            switch (textStyle.borderStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    n16 = 1;
                    n15 = 4;
                    break;
                }
                case 4: {
                    n16 = 2;
                    n15 = 2;
                }
            }
            long l2 = OS.SelectObject(l, OS.GetStockObject(5));
            LOGBRUSH lOGBRUSH = new LOGBRUSH();
            lOGBRUSH.lbStyle = 0;
            lOGBRUSH.lbColor = n5;
            long l3 = OS.ExtCreatePen(n16 | 0x10000, n14, lOGBRUSH, 0, null);
            long l4 = OS.SelectObject(l, l3);
            RECT rECT3 = new RECT();
            OS.SetRect(rECT3, n + n10, n2, n + styleItem.x + styleItem.width, n2 + n3);
            if (rectangle != null) {
                if (rECT3.left < rectangle.x) {
                    n9 = rECT3.left % n15;
                    rECT3.left = rectangle.x / n15 * n15 + n9 - n15;
                }
                if (rECT3.right > rectangle.x + rectangle.width) {
                    n9 = rECT3.right % n15;
                    rECT3.right = (rectangle.x + rectangle.width) / n15 * n15 + n9 + n15;
                }
            }
            OS.Rectangle(l, rECT3.left, rECT3.top, rECT3.right, rECT3.bottom);
            OS.SelectObject(l, l4);
            OS.DeleteObject(l3);
            if (rECT != null) {
                n9 = OS.SaveDC(l);
                if (rECT.left == -1) {
                    rECT.left = 0;
                }
                if (rECT.right == -1) {
                    rECT.right = 524287;
                }
                OS.IntersectClipRect(l, rECT.left, rECT.top, rECT.right, rECT.bottom);
                lOGBRUSH.lbColor = n6;
                long l5 = OS.ExtCreatePen(n16 | 0x10000, n14, lOGBRUSH, 0, null);
                l4 = OS.SelectObject(l, l5);
                OS.Rectangle(l, rECT3.left, rECT3.top, rECT3.right, rECT3.bottom);
                OS.RestoreDC(l, n9);
                OS.SelectObject(l, l4);
                OS.DeleteObject(l5);
            }
            OS.SelectObject(l, l2);
            return null;
        }
        return rECT;
    }

    RECT drawBorderGDIP(long l, int n, int n2, int n3, StyleItem[] styleItemArray, int n4, long l2, long l3, RECT rECT, RECT rECT2, int n5, int n6, int n7, Rectangle rectangle) {
        boolean bl;
        StyleItem styleItem = styleItemArray[n4];
        TextStyle textStyle = styleItem.style;
        if (textStyle == null) {
            return null;
        }
        if (textStyle.borderStyle == 0) {
            return null;
        }
        rECT = this.addClipRect(styleItem, rECT, rECT2, n5, n6);
        boolean bl2 = bl = rectangle != null && n + styleItem.x + styleItem.width > rectangle.x + rectangle.width;
        if (n4 + 1 >= styleItemArray.length || bl || !textStyle.isAdherentBorder(styleItemArray[n4 + 1].style)) {
            int n8 = styleItem.x;
            int n9 = styleItem.start;
            int n10 = styleItem.start + styleItem.length - 1;
            int n11 = n4;
            while (n11 > 0 && textStyle.isAdherentBorder(styleItemArray[n11 - 1].style)) {
                n8 = styleItemArray[n11 - 1].x;
                n9 = Math.min(n9, styleItemArray[n11 - 1].start);
                n10 = Math.max(n10, styleItemArray[n11 - 1].start + styleItemArray[n11 - 1].length - 1);
                --n11;
            }
            n11 = n5 <= n6 && n5 != -1 && n6 != -1 ? 1 : 0;
            boolean bl3 = n11 != 0 && n5 <= n9 && n10 <= n6;
            long l4 = l2;
            if (textStyle.borderColor != null) {
                l4 = this.createGdipBrush(textStyle.borderColor, n7);
                rECT = null;
            } else if (bl3) {
                l4 = l3;
                rECT = null;
            } else if (textStyle.foreground != null) {
                l4 = this.createGdipBrush(textStyle.foreground, n7);
            }
            boolean bl4 = true;
            int n12 = 0;
            switch (textStyle.borderStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    n12 = 1;
                    break;
                }
                case 4: {
                    n12 = 2;
                }
            }
            long l5 = Gdip.Pen_new(l4, (float)bl4);
            Gdip.Pen_SetDashStyle(l5, n12);
            Gdip.Graphics_SetPixelOffsetMode(l, 3);
            int n13 = Gdip.Graphics_GetSmoothingMode(l);
            Gdip.Graphics_SetSmoothingMode(l, 3);
            if (rECT != null) {
                int n14 = Gdip.Graphics_Save(l);
                if (rECT.left == -1) {
                    rECT.left = 0;
                }
                if (rECT.right == -1) {
                    rECT.right = 524287;
                }
                Rect rect = new Rect();
                rect.X = rECT.left;
                rect.Y = rECT.top;
                rect.Width = rECT.right - rECT.left;
                rect.Height = rECT.bottom - rECT.top;
                Gdip.Graphics_SetClip(l, rect, 4);
                Gdip.Graphics_DrawRectangle(l, l5, n + n8, n2, styleItem.x + styleItem.width - n8 - 1, n3 - 1);
                Gdip.Graphics_Restore(l, n14);
                n14 = Gdip.Graphics_Save(l);
                Gdip.Graphics_SetClip(l, rect, 1);
                long l6 = Gdip.Pen_new(l3, (float)bl4);
                Gdip.Pen_SetDashStyle(l6, n12);
                Gdip.Graphics_DrawRectangle(l, l6, n + n8, n2, styleItem.x + styleItem.width - n8 - 1, n3 - 1);
                Gdip.Pen_delete(l6);
                Gdip.Graphics_Restore(l, n14);
            } else {
                Gdip.Graphics_DrawRectangle(l, l5, n + n8, n2, styleItem.x + styleItem.width - n8 - 1, n3 - 1);
            }
            Gdip.Graphics_SetPixelOffsetMode(l, 4);
            Gdip.Graphics_SetSmoothingMode(l, n13);
            Gdip.Pen_delete(l5);
            if (l4 != l3 && l4 != l2) {
                Gdip.SolidBrush_delete(l4);
            }
            return null;
        }
        return rECT;
    }

    void drawRunBackground(StyleItem styleItem, long l, RECT rECT, int n, int n2, long l2, boolean bl) {
        boolean bl2;
        int n3 = styleItem.start + styleItem.length - 1;
        boolean bl3 = bl2 = bl && n <= styleItem.start && n2 >= n3;
        if (bl2) {
            OS.SelectObject(l, l2);
            OS.PatBlt(l, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, 15728673);
        } else {
            int n4;
            if (styleItem.style != null && styleItem.style.background != null) {
                n4 = styleItem.style.background.handle;
                long l3 = OS.CreateSolidBrush(n4);
                long l4 = OS.SelectObject(l, l3);
                OS.PatBlt(l, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, 15728673);
                OS.SelectObject(l, l4);
                OS.DeleteObject(l3);
            }
            int n5 = n4 = bl && n <= n3 && styleItem.start <= n2 ? 1 : 0;
            if (n4 != 0) {
                this.getPartialSelection(styleItem, n, n2, rECT);
                OS.SelectObject(l, l2);
                OS.PatBlt(l, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, 15728673);
            }
        }
    }

    void drawRunBackgroundGDIP(StyleItem styleItem, long l, RECT rECT, int n, int n2, int n3, long l2, boolean bl) {
        boolean bl2;
        int n4 = styleItem.start + styleItem.length - 1;
        boolean bl3 = bl2 = bl && n <= styleItem.start && n2 >= n4;
        if (bl2) {
            Gdip.Graphics_FillRectangle(l, l2, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
        } else {
            boolean bl4;
            if (styleItem.style != null && styleItem.style.background != null) {
                long l3 = this.createGdipBrush(styleItem.style.background, n3);
                Gdip.Graphics_FillRectangle(l, l3, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
                Gdip.SolidBrush_delete(l3);
            }
            boolean bl5 = bl4 = bl && n <= n4 && styleItem.start <= n2;
            if (bl4) {
                this.getPartialSelection(styleItem, n, n2, rECT);
                if (rECT.left > rECT.right) {
                    int n5 = rECT.left;
                    rECT.left = rECT.right;
                    rECT.right = n5;
                }
                Gdip.Graphics_FillRectangle(l, l2, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
            }
        }
    }

    RECT drawRunText(long l, StyleItem styleItem, RECT rECT, int n, int n2, int n3, int n4, int n5) {
        int n6 = styleItem.start + styleItem.length - 1;
        boolean bl = n4 <= n5 && n4 != -1 && n5 != -1;
        boolean bl2 = bl && n4 <= styleItem.start && n5 >= n6;
        boolean bl3 = bl && !bl2 && n4 <= n6 && styleItem.start <= n5;
        int n7 = (this.orientation & 0x4000000) != 0 ? -1 : 0;
        int n8 = rECT.left + n7;
        int n9 = rECT.top + (n - styleItem.ascent);
        long l2 = this.getItemFont(styleItem);
        OS.SelectObject(l, l2);
        if (bl2) {
            n2 = n3;
        } else if (styleItem.style != null && styleItem.style.foreground != null) {
            n2 = styleItem.style.foreground.handle;
        }
        OS.SetTextColor(l, n2);
        OS.ScriptTextOut(l, styleItem.psc, n8, n9, 0, null, styleItem.analysis, 0L, 0, styleItem.glyphs, styleItem.glyphCount, styleItem.advances, styleItem.justify, styleItem.goffsets);
        if (bl3) {
            this.getPartialSelection(styleItem, n4, n5, rECT);
            OS.SetTextColor(l, n3);
            OS.ScriptTextOut(l, styleItem.psc, n8, n9, 4, rECT, styleItem.analysis, 0L, 0, styleItem.glyphs, styleItem.glyphCount, styleItem.advances, styleItem.justify, styleItem.goffsets);
        }
        return bl2 || bl3 ? rECT : null;
    }

    RECT drawRunTextGDIP(long l, StyleItem styleItem, RECT rECT, long l2, int n, long l3, long l4, int n2, int n3, int n4) {
        boolean bl;
        int n5 = styleItem.start + styleItem.length - 1;
        boolean bl2 = n2 <= n3 && n2 != -1 && n3 != -1;
        boolean bl3 = bl2 && n2 <= styleItem.start && n3 >= n5;
        boolean bl4 = bl2 && !bl3 && n2 <= n5 && styleItem.start <= n3;
        int n6 = rECT.top + n;
        if (styleItem.style != null && styleItem.style.rise != 0) {
            n6 -= styleItem.style.rise;
        }
        int n7 = rECT.left;
        long l5 = l3;
        if (bl3) {
            l5 = l4;
        } else if (styleItem.style != null && styleItem.style.foreground != null) {
            l5 = this.createGdipBrush(styleItem.style.foreground, n4);
        }
        int n8 = 0;
        Rect rect = null;
        if (bl4) {
            rect = new Rect();
            this.getPartialSelection(styleItem, n2, n3, rECT);
            rect.X = rECT.left;
            rect.Y = rECT.top;
            rect.Width = rECT.right - rECT.left;
            rect.Height = rECT.bottom - rECT.top;
            n8 = Gdip.Graphics_Save(l);
            Gdip.Graphics_SetClip(l, rect, 4);
        }
        int n9 = 0;
        boolean bl5 = bl = (this.orientation & 0x4000000) != 0;
        if (bl) {
            switch (Gdip.Brush_GetType(l5)) {
                case 4: {
                    Gdip.LinearGradientBrush_ScaleTransform(l5, -1.0f, 1.0f, 0);
                    Gdip.LinearGradientBrush_TranslateTransform(l5, -2 * n7 - styleItem.width, 0.0f, 0);
                    break;
                }
                case 2: {
                    Gdip.TextureBrush_ScaleTransform(l5, -1.0f, 1.0f, 0);
                    Gdip.TextureBrush_TranslateTransform(l5, -2 * n7 - styleItem.width, 0.0f, 0);
                }
            }
            n9 = Gdip.Graphics_Save(l);
            Gdip.Graphics_ScaleTransform(l, -1.0f, 1.0f, 0);
            Gdip.Graphics_TranslateTransform(l, -2 * n7 - styleItem.width, 0.0f, 0);
        }
        int[] nArray = new int[styleItem.glyphCount];
        float[] fArray = new float[styleItem.glyphCount * 2];
        OS.memmove(nArray, styleItem.justify != 0L ? styleItem.justify : styleItem.advances, (long)(styleItem.glyphCount * 4));
        int n10 = n7;
        int n11 = 0;
        int n12 = 0;
        while (n11 < nArray.length) {
            fArray[n12++] = n10;
            fArray[n12++] = n6;
            n10 += nArray[n11];
            ++n11;
        }
        Gdip.Graphics_DrawDriverString(l, styleItem.glyphs, styleItem.glyphCount, l2, l5, fArray, 0, 0L);
        if (bl4) {
            if (bl) {
                Gdip.Graphics_Restore(l, n9);
            }
            Gdip.Graphics_Restore(l, n8);
            n8 = Gdip.Graphics_Save(l);
            Gdip.Graphics_SetClip(l, rect, 1);
            if (bl) {
                n9 = Gdip.Graphics_Save(l);
                Gdip.Graphics_ScaleTransform(l, -1.0f, 1.0f, 0);
                Gdip.Graphics_TranslateTransform(l, -2 * n7 - styleItem.width, 0.0f, 0);
            }
            Gdip.Graphics_DrawDriverString(l, styleItem.glyphs, styleItem.glyphCount, l2, l4, fArray, 0, 0L);
            Gdip.Graphics_Restore(l, n8);
        }
        if (bl) {
            switch (Gdip.Brush_GetType(l5)) {
                case 4: {
                    Gdip.LinearGradientBrush_ResetTransform(l5);
                    break;
                }
                case 2: {
                    Gdip.TextureBrush_ResetTransform(l5);
                }
            }
            Gdip.Graphics_Restore(l, n9);
        }
        if (l5 != l4 && l5 != l3) {
            Gdip.SolidBrush_delete(l5);
        }
        return bl3 || bl4 ? rECT : null;
    }

    RECT drawRunTextGDIPRaster(long l, StyleItem styleItem, RECT rECT, int n, int n2, int n3, int n4, int n5) {
        long l2 = 0L;
        Gdip.Graphics_SetPixelOffsetMode(l, 3);
        long l3 = Gdip.Region_new();
        if (l3 == 0L) {
            SWT.error(2);
        }
        Gdip.Graphics_GetClip(l, l3);
        if (!Gdip.Region_IsInfinite(l3, l)) {
            l2 = Gdip.Region_GetHRGN(l3, l);
        }
        Gdip.Region_delete(l3);
        Gdip.Graphics_SetPixelOffsetMode(l, 4);
        float[] fArray = null;
        long l4 = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        if (l4 == 0L) {
            SWT.error(2);
        }
        Gdip.Graphics_GetTransform(l, l4);
        if (!Gdip.Matrix_IsIdentity(l4)) {
            fArray = new float[6];
            Gdip.Matrix_GetElements(l4, fArray);
        }
        Gdip.Matrix_delete(l4);
        long l5 = Gdip.Graphics_GetHDC(l);
        int n6 = OS.SaveDC(l5);
        if (fArray != null) {
            OS.SetGraphicsMode(l5, 2);
            OS.SetWorldTransform(l5, fArray);
        }
        if (l2 != 0L) {
            OS.SelectClipRgn(l5, l2);
            OS.DeleteObject(l2);
        }
        if ((this.orientation & 0x4000000) != 0) {
            OS.SetLayout(l5, OS.GetLayout(l5) | 1);
        }
        OS.SetBkMode(l5, 1);
        RECT rECT2 = this.drawRunText(l5, styleItem, rECT, n, n2, n3, n4, n5);
        OS.RestoreDC(l5, n6);
        Gdip.Graphics_ReleaseHDC(l, l5);
        return rECT2;
    }

    RECT drawStrikeout(long l, int n, int n2, StyleItem[] styleItemArray, int n3, int n4, int n5, RECT rECT, RECT rECT2, int n6, int n7, Rectangle rectangle) {
        boolean bl;
        StyleItem styleItem = styleItemArray[n3];
        TextStyle textStyle = styleItem.style;
        if (textStyle == null) {
            return null;
        }
        if (!textStyle.strikeout) {
            return null;
        }
        rECT = this.addClipRect(styleItem, rECT, rECT2, n6, n7);
        boolean bl2 = bl = rectangle != null && n + styleItem.x + styleItem.width > rectangle.x + rectangle.width;
        if (n3 + 1 >= styleItemArray.length || bl || !textStyle.isAdherentStrikeout(styleItemArray[n3 + 1].style)) {
            boolean bl3;
            int n8 = styleItem.x;
            int n9 = styleItem.start;
            int n10 = styleItem.start + styleItem.length - 1;
            int n11 = n3;
            while (n11 > 0 && textStyle.isAdherentStrikeout(styleItemArray[n11 - 1].style)) {
                n8 = styleItemArray[n11 - 1].x;
                n9 = Math.min(n9, styleItemArray[n11 - 1].start);
                n10 = Math.max(n10, styleItemArray[n11 - 1].start + styleItemArray[n11 - 1].length - 1);
                --n11;
            }
            n11 = n6 <= n7 && n6 != -1 && n7 != -1 ? 1 : 0;
            boolean bl4 = bl3 = n11 != 0 && n6 <= n9 && n10 <= n7;
            if (textStyle.strikeoutColor != null) {
                n4 = textStyle.strikeoutColor.handle;
                rECT = null;
            } else if (bl3) {
                n4 = n5;
                rECT = null;
            } else if (textStyle.foreground != null) {
                n4 = textStyle.foreground.handle;
            }
            RECT rECT3 = new RECT();
            OS.SetRect(rECT3, n + n8, n2 - styleItem.strikeoutPos, n + styleItem.x + styleItem.width, n2 - styleItem.strikeoutPos + styleItem.strikeoutThickness);
            long l2 = OS.CreateSolidBrush(n4);
            OS.FillRect(l, rECT3, l2);
            OS.DeleteObject(l2);
            if (rECT != null) {
                long l3 = OS.CreateSolidBrush(n5);
                if (rECT.left == -1) {
                    rECT.left = 0;
                }
                if (rECT.right == -1) {
                    rECT.right = 524287;
                }
                OS.SetRect(rECT, Math.max(rECT3.left, rECT.left), rECT3.top, Math.min(rECT3.right, rECT.right), rECT3.bottom);
                OS.FillRect(l, rECT, l3);
                OS.DeleteObject(l3);
            }
            return null;
        }
        return rECT;
    }

    RECT drawStrikeoutGDIP(long l, int n, int n2, StyleItem[] styleItemArray, int n3, long l2, long l3, RECT rECT, RECT rECT2, int n4, int n5, int n6, Rectangle rectangle) {
        boolean bl;
        StyleItem styleItem = styleItemArray[n3];
        TextStyle textStyle = styleItem.style;
        if (textStyle == null) {
            return null;
        }
        if (!textStyle.strikeout) {
            return null;
        }
        rECT = this.addClipRect(styleItem, rECT, rECT2, n4, n5);
        boolean bl2 = bl = rectangle != null && n + styleItem.x + styleItem.width > rectangle.x + rectangle.width;
        if (n3 + 1 >= styleItemArray.length || bl || !textStyle.isAdherentStrikeout(styleItemArray[n3 + 1].style)) {
            int n7 = styleItem.x;
            int n8 = styleItem.start;
            int n9 = styleItem.start + styleItem.length - 1;
            int n10 = n3;
            while (n10 > 0 && textStyle.isAdherentStrikeout(styleItemArray[n10 - 1].style)) {
                n7 = styleItemArray[n10 - 1].x;
                n8 = Math.min(n8, styleItemArray[n10 - 1].start);
                n9 = Math.max(n9, styleItemArray[n10 - 1].start + styleItemArray[n10 - 1].length - 1);
                --n10;
            }
            n10 = n4 <= n5 && n4 != -1 && n5 != -1 ? 1 : 0;
            boolean bl3 = n10 != 0 && n4 <= n8 && n9 <= n5;
            long l4 = l2;
            if (textStyle.strikeoutColor != null) {
                l4 = this.createGdipBrush(textStyle.strikeoutColor, n6);
                rECT = null;
            } else if (bl3) {
                l4 = l3;
                rECT = null;
            } else if (textStyle.foreground != null) {
                l4 = this.createGdipBrush(textStyle.foreground, n6);
            }
            if (rECT != null) {
                int n11 = Gdip.Graphics_Save(l);
                if (rECT.left == -1) {
                    rECT.left = 0;
                }
                if (rECT.right == -1) {
                    rECT.right = 524287;
                }
                Rect rect = new Rect();
                rect.X = rECT.left;
                rect.Y = rECT.top;
                rect.Width = rECT.right - rECT.left;
                rect.Height = rECT.bottom - rECT.top;
                Gdip.Graphics_SetClip(l, rect, 4);
                Gdip.Graphics_FillRectangle(l, l4, n + n7, n2 - styleItem.strikeoutPos, styleItem.x + styleItem.width - n7, styleItem.strikeoutThickness);
                Gdip.Graphics_Restore(l, n11);
                n11 = Gdip.Graphics_Save(l);
                Gdip.Graphics_SetClip(l, rect, 1);
                Gdip.Graphics_FillRectangle(l, l3, n + n7, n2 - styleItem.strikeoutPos, styleItem.x + styleItem.width - n7, styleItem.strikeoutThickness);
                Gdip.Graphics_Restore(l, n11);
            } else {
                Gdip.Graphics_FillRectangle(l, l4, n + n7, n2 - styleItem.strikeoutPos, styleItem.x + styleItem.width - n7, styleItem.strikeoutThickness);
            }
            if (l4 != l3 && l4 != l2) {
                Gdip.SolidBrush_delete(l4);
            }
            return null;
        }
        return rECT;
    }

    RECT drawUnderline(long l, int n, int n2, int n3, int n4, StyleItem[] styleItemArray, int n5, int n6, int n7, RECT rECT, RECT rECT2, int n8, int n9, Rectangle rectangle) {
        boolean bl;
        StyleItem styleItem = styleItemArray[n5];
        TextStyle textStyle = styleItem.style;
        if (textStyle == null) {
            return null;
        }
        if (!textStyle.underline) {
            return null;
        }
        rECT = this.addClipRect(styleItem, rECT, rECT2, n8, n9);
        boolean bl2 = bl = rectangle != null && n + styleItem.x + styleItem.width > rectangle.x + rectangle.width;
        if (n5 + 1 >= styleItemArray.length || bl || !textStyle.isAdherentUnderline(styleItemArray[n5 + 1].style)) {
            boolean bl3;
            int n10 = styleItem.x;
            int n11 = styleItem.start;
            int n12 = styleItem.start + styleItem.length - 1;
            int n13 = n5;
            while (n13 > 0 && textStyle.isAdherentUnderline(styleItemArray[n13 - 1].style)) {
                n10 = styleItemArray[n13 - 1].x;
                n11 = Math.min(n11, styleItemArray[n13 - 1].start);
                n12 = Math.max(n12, styleItemArray[n13 - 1].start + styleItemArray[n13 - 1].length - 1);
                --n13;
            }
            n13 = n8 <= n9 && n8 != -1 && n9 != -1 ? 1 : 0;
            boolean bl4 = bl3 = n13 != 0 && n8 <= n11 && n12 <= n9;
            if (textStyle.underlineColor != null) {
                n6 = textStyle.underlineColor.handle;
                rECT = null;
            } else if (bl3) {
                n6 = n7;
                rECT = null;
            } else if (textStyle.foreground != null) {
                n6 = textStyle.foreground.handle;
            }
            RECT rECT3 = new RECT();
            OS.SetRect(rECT3, n + n10, n2 - n3, n + styleItem.x + styleItem.width, n2 - n3 + styleItem.underlineThickness);
            if (rECT != null) {
                if (rECT.left == -1) {
                    rECT.left = 0;
                }
                if (rECT.right == -1) {
                    rECT.right = 524287;
                }
                OS.SetRect(rECT, Math.max(rECT3.left, rECT.left), rECT3.top, Math.min(rECT3.right, rECT.right), rECT3.bottom);
            }
            switch (textStyle.underlineStyle) {
                case 2: 
                case 3: {
                    int n14 = 1;
                    int n15 = 2 * n14;
                    int n16 = Math.min(rECT3.top - n15 / 2, n4 - n15 - 1);
                    int[] nArray = this.computePolyline(rECT3.left, n16, rECT3.right, n16 + n15);
                    long l2 = OS.CreatePen(0, n14, n6);
                    long l3 = OS.SelectObject(l, l2);
                    int n17 = OS.SaveDC(l);
                    OS.IntersectClipRect(l, rECT3.left, n16, rECT3.right + 1, n16 + n15 + 1);
                    OS.Polyline(l, nArray, nArray.length / 2);
                    int n18 = nArray.length;
                    if (n18 >= 2 && n14 <= 1) {
                        OS.SetPixel(l, nArray[n18 - 2], nArray[n18 - 1], n6);
                    }
                    OS.SelectObject(l, l3);
                    OS.DeleteObject(l2);
                    OS.RestoreDC(l, n17);
                    if (rECT == null) break;
                    l2 = OS.CreatePen(0, n14, n7);
                    l3 = OS.SelectObject(l, l2);
                    n17 = OS.SaveDC(l);
                    OS.IntersectClipRect(l, rECT.left, n16, rECT.right + 1, n16 + n15 + 1);
                    OS.Polyline(l, nArray, nArray.length / 2);
                    if (n18 >= 2 && n14 <= 1) {
                        OS.SetPixel(l, nArray[n18 - 2], nArray[n18 - 1], n7);
                    }
                    OS.SelectObject(l, l3);
                    OS.DeleteObject(l2);
                    OS.RestoreDC(l, n17);
                    break;
                }
                case 0: 
                case 1: 
                case 4: 
                case 196608: {
                    int n19;
                    if (textStyle.underlineStyle == 196608) {
                        rECT3.top -= styleItem.underlineThickness;
                        if (rECT != null) {
                            rECT.top -= styleItem.underlineThickness;
                        }
                    }
                    int n20 = n19 = textStyle.underlineStyle == 1 ? rECT3.bottom + styleItem.underlineThickness * 2 : rECT3.bottom;
                    if (n19 > n4) {
                        OS.OffsetRect(rECT3, 0, n4 - n19);
                        if (rECT != null) {
                            OS.OffsetRect(rECT, 0, n4 - n19);
                        }
                    }
                    long l4 = OS.CreateSolidBrush(n6);
                    OS.FillRect(l, rECT3, l4);
                    if (textStyle.underlineStyle == 1) {
                        OS.SetRect(rECT3, rECT3.left, rECT3.top + styleItem.underlineThickness * 2, rECT3.right, rECT3.bottom + styleItem.underlineThickness * 2);
                        OS.FillRect(l, rECT3, l4);
                    }
                    OS.DeleteObject(l4);
                    if (rECT == null) break;
                    long l5 = OS.CreateSolidBrush(n7);
                    OS.FillRect(l, rECT, l5);
                    if (textStyle.underlineStyle == 1) {
                        OS.SetRect(rECT, rECT.left, rECT3.top, rECT.right, rECT3.bottom);
                        OS.FillRect(l, rECT, l5);
                    }
                    OS.DeleteObject(l5);
                    break;
                }
                case 65536: 
                case 131072: {
                    int n21 = textStyle.underlineStyle == 131072 ? 1 : 2;
                    long l6 = OS.CreatePen(n21, 1, n6);
                    long l7 = OS.SelectObject(l, l6);
                    OS.SetRect(rECT3, rECT3.left, n2 + styleItem.descent, rECT3.right, n2 + styleItem.descent + styleItem.underlineThickness);
                    OS.MoveToEx(l, rECT3.left, rECT3.top, 0L);
                    OS.LineTo(l, rECT3.right, rECT3.top);
                    OS.SelectObject(l, l7);
                    OS.DeleteObject(l6);
                    if (rECT == null) break;
                    l6 = OS.CreatePen(n21, 1, n7);
                    l7 = OS.SelectObject(l, l6);
                    OS.SetRect(rECT, rECT.left, rECT3.top, rECT.right, rECT3.bottom);
                    OS.MoveToEx(l, rECT.left, rECT.top, 0L);
                    OS.LineTo(l, rECT.right, rECT.top);
                    OS.SelectObject(l, l7);
                    OS.DeleteObject(l6);
                }
            }
            return null;
        }
        return rECT;
    }

    RECT drawUnderlineGDIP(long l, int n, int n2, int n3, int n4, StyleItem[] styleItemArray, int n5, long l2, long l3, RECT rECT, RECT rECT2, int n6, int n7, int n8, Rectangle rectangle) {
        boolean bl;
        StyleItem styleItem = styleItemArray[n5];
        TextStyle textStyle = styleItem.style;
        if (textStyle == null) {
            return null;
        }
        if (!textStyle.underline) {
            return null;
        }
        rECT = this.addClipRect(styleItem, rECT, rECT2, n6, n7);
        boolean bl2 = bl = rectangle != null && n + styleItem.x + styleItem.width > rectangle.x + rectangle.width;
        if (n5 + 1 >= styleItemArray.length || bl || !textStyle.isAdherentUnderline(styleItemArray[n5 + 1].style)) {
            int n9 = styleItem.x;
            int n10 = styleItem.start;
            int n11 = styleItem.start + styleItem.length - 1;
            int n12 = n5;
            while (n12 > 0 && textStyle.isAdherentUnderline(styleItemArray[n12 - 1].style)) {
                n9 = styleItemArray[n12 - 1].x;
                n10 = Math.min(n10, styleItemArray[n12 - 1].start);
                n11 = Math.max(n11, styleItemArray[n12 - 1].start + styleItemArray[n12 - 1].length - 1);
                --n12;
            }
            n12 = n6 <= n7 && n6 != -1 && n7 != -1 ? 1 : 0;
            boolean bl3 = n12 != 0 && n6 <= n10 && n11 <= n7;
            long l4 = l2;
            if (textStyle.underlineColor != null) {
                l4 = this.createGdipBrush(textStyle.underlineColor, n8);
                rECT = null;
            } else if (bl3) {
                l4 = l3;
                rECT = null;
            } else if (textStyle.foreground != null) {
                l4 = this.createGdipBrush(textStyle.foreground, n8);
            }
            RECT rECT3 = new RECT();
            OS.SetRect(rECT3, n + n9, n2 - n3, n + styleItem.x + styleItem.width, n2 - n3 + styleItem.underlineThickness);
            Rect rect = null;
            if (rECT != null) {
                if (rECT.left == -1) {
                    rECT.left = 0;
                }
                if (rECT.right == -1) {
                    rECT.right = 524287;
                }
                OS.SetRect(rECT, Math.max(rECT3.left, rECT.left), rECT3.top, Math.min(rECT3.right, rECT.right), rECT3.bottom);
                rect = new Rect();
                rect.X = rECT.left;
                rect.Y = rECT.top;
                rect.Width = rECT.right - rECT.left;
                rect.Height = rECT.bottom - rECT.top;
            }
            int n13 = 0;
            Gdip.Graphics_SetPixelOffsetMode(l, 3);
            int n14 = Gdip.Graphics_GetSmoothingMode(l);
            Gdip.Graphics_SetSmoothingMode(l, 3);
            switch (textStyle.underlineStyle) {
                case 2: 
                case 3: {
                    int n15 = 1;
                    int n16 = 2 * n15;
                    int n17 = Math.min(rECT3.top - n16 / 2, n4 - n16 - 1);
                    int[] nArray = this.computePolyline(rECT3.left, n17, rECT3.right, n17 + n16);
                    long l5 = Gdip.Pen_new(l4, n15);
                    n13 = Gdip.Graphics_Save(l);
                    if (rect != null) {
                        Gdip.Graphics_SetClip(l, rect, 4);
                    } else {
                        Rect rect2 = new Rect();
                        rect2.X = rECT3.left;
                        rect2.Y = n17;
                        rect2.Width = rECT3.right - rECT3.left;
                        rect2.Height = n16 + 1;
                        Gdip.Graphics_SetClip(l, rect2, 1);
                    }
                    Gdip.Graphics_DrawLines(l, l5, nArray, nArray.length / 2);
                    if (rect != null) {
                        long l6 = Gdip.Pen_new(l3, n15);
                        Gdip.Graphics_Restore(l, n13);
                        n13 = Gdip.Graphics_Save(l);
                        Gdip.Graphics_SetClip(l, rect, 1);
                        Gdip.Graphics_DrawLines(l, l6, nArray, nArray.length / 2);
                        Gdip.Pen_delete(l6);
                    }
                    Gdip.Graphics_Restore(l, n13);
                    Gdip.Pen_delete(l5);
                    if (n13 == 0) break;
                    Gdip.Graphics_Restore(l, n13);
                    break;
                }
                case 0: 
                case 1: 
                case 4: 
                case 196608: {
                    int n18;
                    if (textStyle.underlineStyle == 196608) {
                        rECT3.top -= styleItem.underlineThickness;
                    }
                    int n19 = n18 = textStyle.underlineStyle == 1 ? rECT3.bottom + styleItem.underlineThickness * 2 : rECT3.bottom;
                    if (n18 > n4) {
                        OS.OffsetRect(rECT3, 0, n4 - n18);
                    }
                    if (rect != null) {
                        rect.Y = rECT3.top;
                        if (textStyle.underlineStyle == 196608) {
                            rect.Height = styleItem.underlineThickness * 2;
                        }
                        if (textStyle.underlineStyle == 1) {
                            rect.Height = styleItem.underlineThickness * 3;
                        }
                        n13 = Gdip.Graphics_Save(l);
                        Gdip.Graphics_SetClip(l, rect, 4);
                    }
                    Gdip.Graphics_FillRectangle(l, l4, rECT3.left, rECT3.top, rECT3.right - rECT3.left, rECT3.bottom - rECT3.top);
                    if (textStyle.underlineStyle == 1) {
                        Gdip.Graphics_FillRectangle(l, l4, rECT3.left, rECT3.top + styleItem.underlineThickness * 2, rECT3.right - rECT3.left, rECT3.bottom - rECT3.top);
                    }
                    if (rect == null) break;
                    Gdip.Graphics_Restore(l, n13);
                    n13 = Gdip.Graphics_Save(l);
                    Gdip.Graphics_SetClip(l, rect, 1);
                    Gdip.Graphics_FillRectangle(l, l3, rECT3.left, rECT3.top, rECT3.right - rECT3.left, rECT3.bottom - rECT3.top);
                    if (textStyle.underlineStyle == 1) {
                        Gdip.Graphics_FillRectangle(l, l3, rECT3.left, rECT3.top + styleItem.underlineThickness * 2, rECT3.right - rECT3.left, rECT3.bottom - rECT3.top);
                    }
                    Gdip.Graphics_Restore(l, n13);
                    break;
                }
                case 65536: 
                case 131072: {
                    long l7 = Gdip.Pen_new(l4, 1.0f);
                    int n20 = textStyle.underlineStyle == 65536 ? 2 : 1;
                    Gdip.Pen_SetDashStyle(l7, n20);
                    if (rect != null) {
                        n13 = Gdip.Graphics_Save(l);
                        Gdip.Graphics_SetClip(l, rect, 4);
                    }
                    Gdip.Graphics_DrawLine(l, l7, rECT3.left, n2 + styleItem.descent, styleItem.width - styleItem.length, n2 + styleItem.descent);
                    if (rect != null) {
                        Gdip.Graphics_Restore(l, n13);
                        n13 = Gdip.Graphics_Save(l);
                        Gdip.Graphics_SetClip(l, rect, 1);
                        long l8 = Gdip.Pen_new(l4, 1.0f);
                        Gdip.Pen_SetDashStyle(l8, n20);
                        Gdip.Graphics_DrawLine(l, l8, rECT3.left, n2 + styleItem.descent, styleItem.width - styleItem.length, n2 + styleItem.descent);
                        Gdip.Graphics_Restore(l, n13);
                        Gdip.Pen_delete(l8);
                    }
                    Gdip.Pen_delete(l7);
                }
            }
            if (l4 != l3 && l4 != l2) {
                Gdip.SolidBrush_delete(l4);
            }
            Gdip.Graphics_SetPixelOffsetMode(l, 4);
            Gdip.Graphics_SetSmoothingMode(l, n14);
            return null;
        }
        return rECT;
    }

    void freeRuns() {
        if (this.allRuns == null) {
            return;
        }
        int n = 0;
        while (n < this.allRuns.length) {
            StyleItem styleItem = this.allRuns[n];
            styleItem.free();
            ++n;
        }
        this.allRuns = null;
        this.runs = null;
        this.segmentsText = null;
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns(null);
        int n = 0;
        if (this.wrapWidth != -1) {
            n = this.wrapWidth;
        } else {
            int n2 = 0;
            while (n2 < this.runs.length) {
                n = Math.max(n, this.lineWidth[n2] + this.getLineIndent(n2));
                ++n2;
            }
        }
        return new Rectangle(0, 0, n, this.lineY[this.lineY.length - 1]);
    }

    public Rectangle getBounds(int n, int n2) {
        this.checkLayout();
        this.computeRuns(null);
        int n3 = this.text.length();
        if (n3 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (n > n2) {
            return new Rectangle(0, 0, 0, 0);
        }
        n = Math.min(Math.max(0, n), n3 - 1);
        n2 = Math.min(Math.max(0, n2), n3 - 1);
        n = this.translateOffset(n);
        n2 = this.translateOffset(n2);
        n3 = this.segmentsText.length();
        char c = this.segmentsText.charAt(n);
        if ('\udc00' <= c && c <= '\udfff' && n - 1 >= 0 && '\ud800' <= (c = this.segmentsText.charAt(n - 1)) && c <= '\udbff') {
            --n;
        }
        if ('\ud800' <= (c = this.segmentsText.charAt(n2)) && c <= '\udbff' && n2 + 1 < n3 && '\udc00' <= (c = this.segmentsText.charAt(n2 + 1)) && c <= '\udfff') {
            ++n2;
        }
        int n4 = Integer.MAX_VALUE;
        int n5 = 0;
        int n6 = Integer.MAX_VALUE;
        int n7 = 0;
        boolean bl = (this.orientation & 0x4000000) != 0;
        int n8 = 0;
        while (n8 < this.allRuns.length - 1) {
            StyleItem styleItem = this.allRuns[n8];
            int n9 = styleItem.start + styleItem.length;
            if (n9 > n) {
                long l;
                Object object;
                int n10;
                if (styleItem.start > n2) break;
                int n11 = styleItem.x;
                int n12 = styleItem.x + styleItem.width;
                if (styleItem.start <= n && n < n9) {
                    n10 = 0;
                    if (styleItem.style != null && styleItem.style.metrics != null) {
                        object = styleItem.style.metrics;
                        n10 = object.width * (n - styleItem.start);
                    } else if (!styleItem.tab) {
                        object = new int[1];
                        l = styleItem.justify != 0L ? styleItem.justify : styleItem.advances;
                        OS.ScriptCPtoX(n - styleItem.start, false, styleItem.length, styleItem.glyphCount, styleItem.clusters, styleItem.visAttrs, l, styleItem.analysis, object);
                        int n13 = n10 = bl ? styleItem.width - object[0] : object[0];
                    }
                    if (styleItem.analysis.fRTL ^ bl) {
                        n12 = styleItem.x + n10;
                    } else {
                        n11 = styleItem.x + n10;
                    }
                }
                if (styleItem.start <= n2 && n2 < n9) {
                    n10 = styleItem.width;
                    if (styleItem.style != null && styleItem.style.metrics != null) {
                        object = styleItem.style.metrics;
                        n10 = object.width * (n2 - styleItem.start + 1);
                    } else if (!styleItem.tab) {
                        object = new int[1];
                        l = styleItem.justify != 0L ? styleItem.justify : styleItem.advances;
                        OS.ScriptCPtoX(n2 - styleItem.start, true, styleItem.length, styleItem.glyphCount, styleItem.clusters, styleItem.visAttrs, l, styleItem.analysis, object);
                        int n14 = n10 = bl ? styleItem.width - object[0] : object[0];
                    }
                    if (styleItem.analysis.fRTL ^ bl) {
                        n11 = styleItem.x + n10;
                    } else {
                        n12 = styleItem.x + n10;
                    }
                }
                n10 = 0;
                while (n10 < this.runs.length && this.lineOffset[n10 + 1] <= styleItem.start) {
                    ++n10;
                }
                n4 = Math.min(n4, n11);
                n5 = Math.max(n5, n12);
                n6 = Math.min(n6, this.lineY[n10]);
                n7 = Math.max(n7, this.lineY[n10 + 1] - this.lineSpacing);
            }
            ++n8;
        }
        return new Rectangle(n4, n6, n5 - n4, n7 - n6);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    long getItemFont(StyleItem styleItem) {
        if (styleItem.fallbackFont != 0L) {
            return styleItem.fallbackFont;
        }
        if (styleItem.style != null && styleItem.style.font != null) {
            return styleItem.style.font.handle;
        }
        if (this.font != null) {
            return this.font.handle;
        }
        return this.device.systemFont.handle;
    }

    public int getLevel(int n) {
        this.checkLayout();
        this.computeRuns(null);
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        n = this.translateOffset(n);
        int n3 = 1;
        while (n3 < this.allRuns.length) {
            if (this.allRuns[n3].start > n) {
                return this.allRuns[n3 - 1].analysis.s.uBidiLevel;
            }
            ++n3;
        }
        return (this.orientation & 0x4000000) != 0 ? 1 : 0;
    }

    public Rectangle getLineBounds(int n) {
        this.checkLayout();
        this.computeRuns(null);
        if (n < 0 || n >= this.runs.length) {
            SWT.error(6);
        }
        int n2 = this.getLineIndent(n);
        int n3 = this.lineY[n];
        int n4 = this.lineWidth[n];
        int n5 = this.lineY[n + 1] - n3 - this.lineSpacing;
        return new Rectangle(n2, n3, n4, n5);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns(null);
        return this.runs.length;
    }

    int getLineIndent(int n) {
        StyleItem[] styleItemArray;
        int n2 = this.wrapIndent;
        if (n == 0) {
            n2 = this.indent;
        } else {
            StyleItem[] styleItemArray2 = this.runs[n - 1];
            styleItemArray = styleItemArray2[styleItemArray2.length - 1];
            if (styleItemArray.lineBreak && !styleItemArray.softBreak) {
                n2 = this.indent;
            }
        }
        if (this.wrapWidth != -1) {
            boolean bl = true;
            if (this.justify) {
                styleItemArray = this.runs[n];
                if (styleItemArray[styleItemArray.length - 1].softBreak) {
                    bl = false;
                }
            }
            if (bl) {
                int n3 = this.lineWidth[n] + n2;
                switch (this.alignment) {
                    case 0x1000000: {
                        n2 += (this.wrapWidth - n3) / 2;
                        break;
                    }
                    case 131072: {
                        n2 += this.wrapWidth - n3;
                    }
                }
            }
        }
        return n2;
    }

    public int getLineIndex(int n) {
        this.checkLayout();
        this.computeRuns(null);
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        n = this.translateOffset(n);
        int n3 = 0;
        while (n3 < this.runs.length) {
            if (this.lineOffset[n3 + 1] > n) {
                return n3;
            }
            ++n3;
        }
        return this.runs.length - 1;
    }

    public FontMetrics getLineMetrics(int n) {
        this.checkLayout();
        this.computeRuns(null);
        if (n < 0 || n >= this.runs.length) {
            SWT.error(6);
        }
        long l = this.device.internal_new_GC(null);
        long l2 = OS.CreateCompatibleDC(l);
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.SelectObject(l2, this.font != null ? this.font.handle : this.device.systemFont.handle);
        OS.GetTextMetrics(l2, tEXTMETRIC);
        OS.DeleteDC(l2);
        this.device.internal_dispose_GC(l, null);
        int n2 = Math.max(tEXTMETRIC.tmAscent, this.ascent);
        int n3 = Math.max(tEXTMETRIC.tmDescent, this.descent);
        int n4 = tEXTMETRIC.tmInternalLeading;
        if (this.text.length() != 0) {
            StyleItem[] styleItemArray = this.runs[n];
            int n5 = 0;
            while (n5 < styleItemArray.length) {
                StyleItem styleItem = styleItemArray[n5];
                if (styleItem.ascent > n2) {
                    n2 = styleItem.ascent;
                    n4 = styleItem.leading;
                }
                n3 = Math.max(n3, styleItem.descent);
                ++n5;
            }
        }
        tEXTMETRIC.tmAscent = n2;
        tEXTMETRIC.tmDescent = n3;
        tEXTMETRIC.tmHeight = n2 + n3;
        tEXTMETRIC.tmInternalLeading = n4;
        tEXTMETRIC.tmAveCharWidth = 0;
        return FontMetrics.win32_new(tEXTMETRIC);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns(null);
        int[] nArray = new int[this.lineOffset.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.untranslateOffset(this.lineOffset[n]);
            ++n;
        }
        return nArray;
    }

    public Point getLocation(int n, boolean bl) {
        this.checkLayout();
        this.computeRuns(null);
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        n2 = this.segmentsText.length();
        n = this.translateOffset(n);
        int n3 = 0;
        while (n3 < this.runs.length) {
            if (this.lineOffset[n3 + 1] > n) break;
            ++n3;
        }
        n3 = Math.min(n3, this.runs.length - 1);
        if (n == n2) {
            return new Point(this.getLineIndent(n3) + this.lineWidth[n3], this.lineY[n3]);
        }
        char c = this.segmentsText.charAt(n);
        if (bl) {
            if ('\ud800' <= c && c <= '\udbff' && n + 1 < n2 && '\udc00' <= (c = this.segmentsText.charAt(n + 1)) && c <= '\udfff') {
                ++n;
            }
        } else if ('\udc00' <= c && c <= '\udfff' && n - 1 >= 0 && '\ud800' <= (c = this.segmentsText.charAt(n - 1)) && c <= '\udbff') {
            --n;
        }
        int n4 = -1;
        int n5 = this.allRuns.length;
        while (n5 - n4 > 1) {
            int n6;
            int n7 = (n5 + n4) / 2;
            StyleItem styleItem = this.allRuns[n7];
            if (styleItem.start > n) {
                n5 = n7;
                continue;
            }
            if (styleItem.start + styleItem.length <= n) {
                n4 = n7;
                continue;
            }
            if (styleItem.style != null && styleItem.style.metrics != null) {
                GlyphMetrics glyphMetrics = styleItem.style.metrics;
                n6 = glyphMetrics.width * (n - styleItem.start + (bl ? 1 : 0));
            } else if (styleItem.tab) {
                n6 = bl || n == n2 ? styleItem.width : 0;
            } else {
                int n8 = n - styleItem.start;
                int n9 = styleItem.length;
                int n10 = styleItem.glyphCount;
                int[] nArray = new int[1];
                long l = styleItem.justify != 0L ? styleItem.justify : styleItem.advances;
                OS.ScriptCPtoX(n8, bl, n9, n10, styleItem.clusters, styleItem.visAttrs, l, styleItem.analysis, nArray);
                n6 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
            }
            return new Point(styleItem.x + n6, this.lineY[n3]);
        }
        return new Point(0, 0);
    }

    public int getNextOffset(int n, int n2) {
        this.checkLayout();
        return this._getOffset(n, n2, true);
    }

    int _getOffset(int n, int n2, boolean bl) {
        int n3;
        this.computeRuns(null);
        int n4 = this.text.length();
        if (n < 0 || n > n4) {
            SWT.error(6);
        }
        if (bl && n == n4) {
            return n4;
        }
        if (!bl && n == 0) {
            return 0;
        }
        int n5 = n3 = bl ? 1 : -1;
        if ((n2 & 1) != 0) {
            return n + n3;
        }
        n4 = this.segmentsText.length();
        n = this.translateOffset(n);
        SCRIPT_LOGATTR sCRIPT_LOGATTR = new SCRIPT_LOGATTR();
        SCRIPT_PROPERTIES sCRIPT_PROPERTIES = new SCRIPT_PROPERTIES();
        int n6 = bl ? 0 : this.allRuns.length - 1;
        n = this.validadeOffset(n, n3);
        do {
            boolean bl2;
            StyleItem styleItem = this.allRuns[n6];
            if (styleItem.start > n || n >= styleItem.start + styleItem.length) continue;
            if (styleItem.lineBreak && !styleItem.softBreak) {
                return this.untranslateOffset(styleItem.start);
            }
            if (styleItem.tab) {
                return this.untranslateOffset(styleItem.start);
            }
            OS.MoveMemory(sCRIPT_PROPERTIES, this.device.scripts[styleItem.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
            boolean bl3 = bl2 = sCRIPT_PROPERTIES.fNeedsCaretInfo || sCRIPT_PROPERTIES.fNeedsWordBreaking;
            if (bl2) {
                this.breakRun(styleItem);
            }
            while (styleItem.start <= n && n < styleItem.start + styleItem.length) {
                if (bl2) {
                    OS.MoveMemory(sCRIPT_LOGATTR, styleItem.psla + (long)((n - styleItem.start) * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                }
                switch (n2) {
                    case 2: {
                        if (sCRIPT_PROPERTIES.fNeedsCaretInfo && (sCRIPT_LOGATTR.fInvalid || !sCRIPT_LOGATTR.fCharStop)) break;
                        char c2 = this.segmentsText.charAt(n);
                        if ('\udc00' <= c2 && c2 <= '\udfff' && n > 0 && '\ud800' <= (c2 = this.segmentsText.charAt(n - 1)) && c2 <= '\udbff') {
                            n += n3;
                        }
                        return this.untranslateOffset(n);
                    }
                    case 4: 
                    case 16: {
                        char c;
                        char c2;
                        if (!(sCRIPT_PROPERTIES.fNeedsWordBreaking ? !sCRIPT_LOGATTR.fInvalid && sCRIPT_LOGATTR.fWordStop : n > 0 && ((c2 = (char)(Compatibility.isLetterOrDigit(this.segmentsText.charAt(n)) ? 1 : 0)) != (c = Compatibility.isLetterOrDigit(this.segmentsText.charAt(n - 1))) || c2 == '\u0000') && !Compatibility.isWhitespace(this.segmentsText.charAt(n)))) break;
                        return this.untranslateOffset(n);
                    }
                    case 8: {
                        if (n <= 0) break;
                        char c2 = (char)(Compatibility.isLetterOrDigit(this.segmentsText.charAt(n)) ? 1 : 0);
                        char c = Compatibility.isLetterOrDigit(this.segmentsText.charAt(n - 1));
                        if (c2 != '\u0000' || c == '\u0000') break;
                        return this.untranslateOffset(n);
                    }
                }
                n = this.validadeOffset(n, n3);
            }
        } while ((n6 += n3) >= 0 && n6 < this.allRuns.length - 1 && n >= 0 && n < n4);
        return bl ? this.text.length() : 0;
    }

    public int getOffset(Point point, int[] nArray) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, nArray);
    }

    public int getOffset(int n, int n2, int[] nArray) {
        this.checkLayout();
        this.computeRuns(null);
        if (nArray != null && nArray.length < 1) {
            SWT.error(5);
        }
        int n3 = this.runs.length;
        int n4 = 0;
        while (n4 < n3) {
            if (this.lineY[n4 + 1] > n2) break;
            ++n4;
        }
        n4 = Math.min(n4, this.runs.length - 1);
        StyleItem[] styleItemArray = this.runs[n4];
        int n5 = this.getLineIndent(n4);
        if (n >= n5 + this.lineWidth[n4]) {
            n = n5 + this.lineWidth[n4] - 1;
        }
        if (n < n5) {
            n = n5;
        }
        int n6 = -1;
        int n7 = styleItemArray.length;
        while (n7 - n6 > 1) {
            int n8 = (n7 + n6) / 2;
            StyleItem styleItem = styleItemArray[n8];
            if (styleItem.x > n) {
                n7 = n8;
                continue;
            }
            if (styleItem.x + styleItem.width <= n) {
                n6 = n8;
                continue;
            }
            if (styleItem.lineBreak && !styleItem.softBreak) {
                return this.untranslateOffset(styleItem.start);
            }
            int n9 = n - styleItem.x;
            if (styleItem.style != null && styleItem.style.metrics != null) {
                GlyphMetrics glyphMetrics = styleItem.style.metrics;
                if (glyphMetrics.width > 0) {
                    if (nArray != null) {
                        nArray[0] = n9 % glyphMetrics.width < glyphMetrics.width / 2 ? 0 : 1;
                    }
                    return this.untranslateOffset(styleItem.start + n9 / glyphMetrics.width);
                }
            }
            if (styleItem.tab) {
                if (nArray != null) {
                    nArray[0] = n < styleItem.x + styleItem.width / 2 ? 0 : 1;
                }
                return this.untranslateOffset(styleItem.start);
            }
            int n10 = styleItem.length;
            int n11 = styleItem.glyphCount;
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            if ((this.orientation & 0x4000000) != 0) {
                n9 = styleItem.width - n9;
            }
            long l = styleItem.justify != 0L ? styleItem.justify : styleItem.advances;
            OS.ScriptXtoCP(n9, n10, n11, styleItem.clusters, styleItem.visAttrs, l, styleItem.analysis, nArray2, nArray3);
            int n12 = styleItem.start + nArray2[0];
            char c = this.segmentsText.charAt(n12);
            int n13 = this.segmentsText.length();
            if ('\ud800' <= c && c <= '\udbff') {
                if (n12 + 1 < n13 && '\udc00' <= (c = this.segmentsText.charAt(n12 + 1)) && c <= '\udfff' && nArray != null) {
                    nArray[0] = 0;
                }
            } else if ('\udc00' <= c && c <= '\udfff') {
                if (n12 - 1 >= 0 && '\ud800' <= (c = this.segmentsText.charAt(n12 - 1)) && c <= '\udbff') {
                    --n12;
                    if (nArray != null) {
                        nArray[0] = 2;
                    }
                }
            } else if (nArray != null) {
                nArray[0] = nArray3[0];
            }
            return this.untranslateOffset(n12);
        }
        if (nArray != null) {
            nArray[0] = 0;
        }
        if (styleItemArray.length == 1) {
            StyleItem styleItem = styleItemArray[0];
            if (styleItem.lineBreak && !styleItem.softBreak) {
                return this.untranslateOffset(styleItem.start);
            }
        }
        return this.untranslateOffset(this.lineOffset[n4 + 1]);
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    void getPartialSelection(StyleItem styleItem, int n, int n2, RECT rECT) {
        int n3 = styleItem.start + styleItem.length - 1;
        int n4 = Math.max(n, styleItem.start) - styleItem.start;
        int n5 = Math.min(n2, n3) - styleItem.start;
        int n6 = styleItem.length;
        int n7 = styleItem.glyphCount;
        int[] nArray = new int[1];
        int n8 = rECT.left;
        long l = styleItem.justify != 0L ? styleItem.justify : styleItem.advances;
        OS.ScriptCPtoX(n4, false, n6, n7, styleItem.clusters, styleItem.visAttrs, l, styleItem.analysis, nArray);
        int n9 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
        rECT.left = n8 + n9;
        OS.ScriptCPtoX(n5, true, n6, n7, styleItem.clusters, styleItem.visAttrs, l, styleItem.analysis, nArray);
        n9 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
        rECT.right = n8 + n9;
    }

    public int getPreviousOffset(int n, int n2) {
        this.checkLayout();
        return this._getOffset(n, n2, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] nArray = new int[this.stylesCount * 2];
        int n = 0;
        int n2 = 0;
        while (n2 < this.stylesCount - 1) {
            if (this.styles[n2].style != null) {
                nArray[n++] = this.styles[n2].start;
                nArray[n++] = this.styles[n2 + 1].start - 1;
            }
            ++n2;
        }
        if (n != nArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        return nArray;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public char[] getSegmentsChars() {
        this.checkLayout();
        return this.segmentsChars;
    }

    String getSegmentsText() {
        int n;
        int n2 = this.text.length();
        if (n2 == 0) {
            return this.text;
        }
        if (this.segments == null) {
            return this.text;
        }
        int n3 = this.segments.length;
        if (n3 == 0) {
            return this.text;
        }
        if (this.segmentsChars == null) {
            if (n3 == 1) {
                return this.text;
            }
            if (n3 == 2 && this.segments[0] == 0 && this.segments[1] == n2) {
                return this.text;
            }
        }
        char[] cArray = new char[n2];
        this.text.getChars(0, n2, cArray, 0);
        char[] cArray2 = new char[n2 + n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = this.orientation == 0x4000000 ? 8207 : 8206;
        while (n4 < n2) {
            if (n5 < n3 && n4 == this.segments[n5]) {
                n = this.segmentsChars != null && this.segmentsChars.length > n5 ? this.segmentsChars[n5] : n6;
                cArray2[n4 + n5++] = n;
                continue;
            }
            cArray2[n4 + n5] = cArray[n4++];
        }
        while (n5 < n3) {
            this.segments[n5] = n4;
            n = this.segmentsChars != null && this.segmentsChars.length > n5 ? this.segmentsChars[n5] : n6;
            cArray2[n4 + n5++] = n;
        }
        return new String(cArray2, 0, cArray2.length);
    }

    public int getSpacing() {
        this.checkLayout();
        return this.lineSpacing;
    }

    public TextStyle getStyle(int n) {
        this.checkLayout();
        int n2 = this.text.length();
        if (n < 0 || n >= n2) {
            SWT.error(6);
        }
        int n3 = 1;
        while (n3 < this.stylesCount) {
            if (this.styles[n3].start > n) {
                return this.styles[n3 - 1].style;
            }
            ++n3;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] textStyleArray = new TextStyle[this.stylesCount];
        int n = 0;
        int n2 = 0;
        while (n2 < this.stylesCount) {
            if (this.styles[n2].style != null) {
                textStyleArray[n++] = this.styles[n2].style;
            }
            ++n2;
        }
        if (n != textStyleArray.length) {
            TextStyle[] textStyleArray2 = new TextStyle[n];
            System.arraycopy(textStyleArray, 0, textStyleArray2, 0, n);
            textStyleArray = textStyleArray2;
        }
        return textStyleArray;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public int getWrapIndent() {
        this.checkLayout();
        return this.wrapIndent;
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    StyleItem[] itemize() {
        this.segmentsText = this.getSegmentsText();
        int n = this.segmentsText.length();
        SCRIPT_CONTROL sCRIPT_CONTROL = new SCRIPT_CONTROL();
        SCRIPT_STATE sCRIPT_STATE = new SCRIPT_STATE();
        int n2 = n + 1;
        if ((this.orientation & 0x4000000) != 0) {
            sCRIPT_STATE.uBidiLevel = 1;
            sCRIPT_STATE.fArabicNumContext = true;
        }
        OS.ScriptApplyDigitSubstitution(null, sCRIPT_CONTROL, sCRIPT_STATE);
        long l = OS.GetProcessHeap();
        long l2 = OS.HeapAlloc(l, 8, n2 * SCRIPT_ITEM.sizeof);
        if (l2 == 0L) {
            SWT.error(2);
        }
        int[] nArray = new int[1];
        char[] cArray = new char[n];
        this.segmentsText.getChars(0, n, cArray, 0);
        OS.ScriptItemize(cArray, n, n2, sCRIPT_CONTROL, sCRIPT_STATE, l2, nArray);
        StyleItem[] styleItemArray = this.merge(l2, nArray[0]);
        OS.HeapFree(l, 0, l2);
        return styleItemArray;
    }

    StyleItem[] merge(long l, int n) {
        StyleItem styleItem;
        if (this.styles.length > this.stylesCount) {
            StyleItem[] styleItemArray = new StyleItem[this.stylesCount];
            System.arraycopy(this.styles, 0, styleItemArray, 0, this.stylesCount);
            this.styles = styleItemArray;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = this.segmentsText.length();
        int n5 = 0;
        int n6 = 0;
        StyleItem[] styleItemArray = new StyleItem[n + this.stylesCount];
        SCRIPT_ITEM sCRIPT_ITEM = new SCRIPT_ITEM();
        int n7 = -1;
        int n8 = 0;
        boolean bl = false;
        boolean bl2 = n > 1024;
        SCRIPT_PROPERTIES sCRIPT_PROPERTIES = new SCRIPT_PROPERTIES();
        while (n3 < n4) {
            char c;
            int n9;
            styleItem = new StyleItem();
            styleItem.start = n3;
            styleItem.style = this.styles[n6].style;
            styleItemArray[n2++] = styleItem;
            OS.MoveMemory(sCRIPT_ITEM, l + (long)(n5 * SCRIPT_ITEM.sizeof), SCRIPT_ITEM.sizeof);
            styleItem.analysis = sCRIPT_ITEM.a;
            sCRIPT_ITEM.a = new SCRIPT_ANALYSIS();
            if (bl) {
                styleItem.analysis.fLinkBefore = true;
                bl = false;
            }
            char c2 = this.segmentsText.charAt(n3);
            switch (c2) {
                case '\n': 
                case '\r': {
                    styleItem.lineBreak = true;
                    break;
                }
                case '\t': {
                    styleItem.tab = true;
                }
            }
            if (n7 == -1) {
                n8 = n5 + 1;
                OS.MoveMemory(sCRIPT_ITEM, l + (long)(n8 * SCRIPT_ITEM.sizeof), SCRIPT_ITEM.sizeof);
                n7 = sCRIPT_ITEM.iCharPos;
                if (n8 < n && c2 == '\r' && this.segmentsText.charAt(n7) == '\n') {
                    n8 = n5 + 2;
                    OS.MoveMemory(sCRIPT_ITEM, l + (long)(n8 * SCRIPT_ITEM.sizeof), SCRIPT_ITEM.sizeof);
                    n7 = sCRIPT_ITEM.iCharPos;
                }
                if (n8 < n && bl2 && !styleItem.lineBreak) {
                    OS.MoveMemory(sCRIPT_PROPERTIES, this.device.scripts[styleItem.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                    if (!sCRIPT_PROPERTIES.fComplex || styleItem.tab) {
                        n9 = 0;
                        while (n9 < 512) {
                            if (n8 == n || (c = this.segmentsText.charAt(n7)) == '\n' || c == '\r' || c == '\t' != styleItem.tab) break;
                            OS.MoveMemory(sCRIPT_PROPERTIES, this.device.scripts[sCRIPT_ITEM.a.eScript], SCRIPT_PROPERTIES.sizeof);
                            if (!styleItem.tab && sCRIPT_PROPERTIES.fComplex) break;
                            OS.MoveMemory(sCRIPT_ITEM, l + (long)(++n8 * SCRIPT_ITEM.sizeof), SCRIPT_ITEM.sizeof);
                            n7 = sCRIPT_ITEM.iCharPos;
                            ++n9;
                        }
                    }
                }
            }
            if ((n9 = this.translateOffset(this.styles[n6 + 1].start)) <= n7) {
                ++n6;
                n3 = n9;
                if (n3 < n7 && n3 > 0 && n3 < n4) {
                    c = this.segmentsText.charAt(n3 - 1);
                    char c3 = this.segmentsText.charAt(n3);
                    if (Compatibility.isLetter(c) && Compatibility.isLetter(c3)) {
                        styleItem.analysis.fLinkAfter = true;
                        bl = true;
                    }
                }
            }
            if (n7 <= n9) {
                n5 = n8;
                n3 = n7;
                n7 = -1;
            }
            styleItem.length = n3 - styleItem.start;
        }
        styleItem = new StyleItem();
        styleItem.start = n4;
        OS.MoveMemory(sCRIPT_ITEM, l + (long)(n * SCRIPT_ITEM.sizeof), SCRIPT_ITEM.sizeof);
        styleItem.analysis = sCRIPT_ITEM.a;
        styleItemArray[n2++] = styleItem;
        if (styleItemArray.length != n2) {
            StyleItem[] styleItemArray2 = new StyleItem[n2];
            System.arraycopy(styleItemArray, 0, styleItemArray2, 0, n2);
            return styleItemArray2;
        }
        return styleItemArray;
    }

    StyleItem[] reorder(StyleItem[] styleItemArray, boolean bl) {
        int n = styleItemArray.length;
        if (n <= 1) {
            return styleItemArray;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)(styleItemArray[n2].analysis.s.uBidiLevel & 0x1F);
            ++n2;
        }
        StyleItem styleItem = styleItemArray[n - 1];
        if (styleItem.lineBreak && !styleItem.softBreak) {
            byArray[n - 1] = 0;
        }
        int[] nArray = new int[n];
        OS.ScriptLayout(n, byArray, null, nArray);
        StyleItem[] styleItemArray2 = new StyleItem[n];
        int n3 = 0;
        while (n3 < n) {
            styleItemArray2[nArray[n3]] = styleItemArray[n3];
            ++n3;
        }
        if ((this.orientation & 0x4000000) != 0) {
            if (bl) {
                --n;
            }
            n3 = 0;
            while (n3 < n / 2) {
                StyleItem styleItem2 = styleItemArray2[n3];
                styleItemArray2[n3] = styleItemArray2[n - n3 - 1];
                styleItemArray2[n - n3 - 1] = styleItem2;
                ++n3;
            }
        }
        return styleItemArray2;
    }

    public void setAlignment(int n) {
        this.checkLayout();
        int n2 = 16924672;
        if ((n &= n2) == 0) {
            return;
        }
        if ((n & 0x4000) != 0) {
            n = 16384;
        }
        if ((n & 0x20000) != 0) {
            n = 131072;
        }
        if (this.alignment == n) {
            return;
        }
        this.freeRuns();
        this.alignment = n;
    }

    public void setAscent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.ascent == n) {
            return;
        }
        this.freeRuns();
        this.ascent = n;
    }

    public void setDescent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.descent == n) {
            return;
        }
        this.freeRuns();
        this.descent = n;
    }

    public void setFont(Font font) {
        Font font2;
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        this.freeRuns();
    }

    public void setIndent(int n) {
        this.checkLayout();
        if (n < 0) {
            return;
        }
        if (this.indent == n) {
            return;
        }
        this.freeRuns();
        this.indent = n;
    }

    public void setJustify(boolean bl) {
        this.checkLayout();
        if (this.justify == bl) {
            return;
        }
        this.freeRuns();
        this.justify = bl;
    }

    public void setOrientation(int n) {
        this.checkLayout();
        int n2 = 0x6000000;
        if ((n &= n2) == 0) {
            return;
        }
        if ((n & 0x2000000) != 0) {
            n = 0x2000000;
        }
        if (this.orientation == n) {
            return;
        }
        this.orientation = n;
        this.freeRuns();
    }

    public void setSegments(int[] nArray) {
        this.checkLayout();
        if (this.segments == null && nArray == null) {
            return;
        }
        if (this.segments != null && nArray != null && this.segments.length == nArray.length) {
            int n = 0;
            while (n < nArray.length) {
                if (this.segments[n] != nArray[n]) break;
                ++n;
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = nArray;
    }

    public void setSegmentsChars(char[] cArray) {
        this.checkLayout();
        if (this.segmentsChars == null && cArray == null) {
            return;
        }
        if (this.segmentsChars != null && cArray != null && this.segmentsChars.length == cArray.length) {
            int n = 0;
            while (n < cArray.length) {
                if (this.segmentsChars[n] != cArray[n]) break;
                ++n;
            }
            if (n == cArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.segmentsChars = cArray;
    }

    public void setSpacing(int n) {
        this.checkLayout();
        if (n < 0) {
            SWT.error(5);
        }
        if (this.lineSpacing == n) {
            return;
        }
        this.freeRuns();
        this.lineSpacing = n;
    }

    public void setStyle(TextStyle textStyle, int n, int n2) {
        int n3;
        int n4;
        int n5;
        this.checkLayout();
        int n6 = this.text.length();
        if (n6 == 0) {
            return;
        }
        if (n > n2) {
            return;
        }
        n = Math.min(Math.max(0, n), n6 - 1);
        n2 = Math.min(Math.max(0, n2), n6 - 1);
        int n7 = -1;
        int n8 = this.stylesCount;
        while (n8 - n7 > 1) {
            n5 = (n8 + n7) / 2;
            if (this.styles[n5 + 1].start > n) {
                n8 = n5;
                continue;
            }
            n7 = n5;
        }
        if (n8 >= 0 && n8 < this.stylesCount) {
            StyleItem styleItem = this.styles[n8];
            if (styleItem.start == n && this.styles[n8 + 1].start - 1 == n2 && (textStyle == null ? styleItem.style == null : textStyle.equals(styleItem.style))) {
                return;
            }
        }
        this.freeRuns();
        int n9 = n5 = n8;
        while (n9 < this.stylesCount) {
            if (this.styles[n9 + 1].start > n2) break;
            ++n9;
        }
        if (n5 == n9) {
            n4 = this.styles[n5].start;
            n3 = this.styles[n9 + 1].start - 1;
            if (n4 == n && n3 == n2) {
                this.styles[n5].style = textStyle;
                return;
            }
            if (n4 != n && n3 != n2) {
                int n10 = this.stylesCount + 2;
                if (n10 > this.styles.length) {
                    int n11 = Math.min(n10 + 1024, Math.max(64, n10 * 2));
                    StyleItem[] styleItemArray = new StyleItem[n11];
                    System.arraycopy(this.styles, 0, styleItemArray, 0, this.stylesCount);
                    this.styles = styleItemArray;
                }
                System.arraycopy(this.styles, n9 + 1, this.styles, n9 + 3, this.stylesCount - n9 - 1);
                StyleItem styleItem = new StyleItem();
                styleItem.start = n;
                styleItem.style = textStyle;
                this.styles[n5 + 1] = styleItem;
                styleItem = new StyleItem();
                styleItem.start = n2 + 1;
                styleItem.style = this.styles[n5].style;
                this.styles[n5 + 2] = styleItem;
                this.stylesCount = n10;
                return;
            }
        }
        if (n == this.styles[n5].start) {
            --n5;
        }
        if (n2 == this.styles[n9 + 1].start - 1) {
            ++n9;
        }
        if ((n4 = this.stylesCount + 1 - (n9 - n5 - 1)) > this.styles.length) {
            n3 = Math.min(n4 + 1024, Math.max(64, n4 * 2));
            StyleItem[] styleItemArray = new StyleItem[n3];
            System.arraycopy(this.styles, 0, styleItemArray, 0, this.stylesCount);
            this.styles = styleItemArray;
        }
        System.arraycopy(this.styles, n9, this.styles, n5 + 2, this.stylesCount - n9);
        StyleItem styleItem = new StyleItem();
        styleItem.start = n;
        styleItem.style = textStyle;
        this.styles[n5 + 1] = styleItem;
        this.styles[n5 + 2].start = n2 + 1;
        this.stylesCount = n4;
    }

    public void setTabs(int[] nArray) {
        this.checkLayout();
        if (this.tabs == null && nArray == null) {
            return;
        }
        if (this.tabs != null && nArray != null && this.tabs.length == nArray.length) {
            int n = 0;
            while (n < nArray.length) {
                if (this.tabs[n] != nArray[n]) break;
                ++n;
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.tabs = nArray;
    }

    public void setText(String string) {
        this.checkLayout();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = string;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = string.length();
        this.stylesCount = 2;
    }

    public void setWidth(int n) {
        this.checkLayout();
        if (n < -1 || n == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == n) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = n;
    }

    public void setWrapIndent(int n) {
        this.checkLayout();
        if (n < 0) {
            return;
        }
        if (this.wrapIndent == n) {
            return;
        }
        this.freeRuns();
        this.wrapIndent = n;
    }

    boolean shape(long l, StyleItem styleItem, char[] cArray, int[] nArray, int n, SCRIPT_PROPERTIES sCRIPT_PROPERTIES) {
        short[] sArray;
        boolean bl;
        boolean bl2 = bl = !sCRIPT_PROPERTIES.fComplex && !styleItem.analysis.fNoGlyphIndex;
        if (bl && OS.ScriptGetCMap(l, styleItem.psc, cArray, cArray.length, 0, sArray = new short[cArray.length]) != 0) {
            if (styleItem.psc != 0L) {
                OS.ScriptFreeCache(styleItem.psc);
                nArray[0] = 0;
                OS.MoveMemory(styleItem.psc, new long[1], OS.PTR_SIZEOF);
            }
            return false;
        }
        int n2 = OS.ScriptShape(l, styleItem.psc, cArray, cArray.length, n, styleItem.analysis, styleItem.glyphs, styleItem.clusters, styleItem.visAttrs, nArray);
        styleItem.glyphCount = nArray[0];
        if (bl) {
            return true;
        }
        if (n2 != -2147220992) {
            if (styleItem.analysis.fNoGlyphIndex) {
                return true;
            }
            SCRIPT_FONTPROPERTIES sCRIPT_FONTPROPERTIES = new SCRIPT_FONTPROPERTIES();
            sCRIPT_FONTPROPERTIES.cBytes = SCRIPT_FONTPROPERTIES.sizeof;
            OS.ScriptGetFontProperties(l, styleItem.psc, sCRIPT_FONTPROPERTIES);
            short[] sArray2 = new short[nArray[0]];
            OS.MoveMemory(sArray2, styleItem.glyphs, sArray2.length * 2);
            int n3 = 0;
            while (n3 < sArray2.length) {
                if (sArray2[n3] == sCRIPT_FONTPROPERTIES.wgDefault) break;
                ++n3;
            }
            if (n3 == sArray2.length) {
                return true;
            }
        }
        if (styleItem.psc != 0L) {
            OS.ScriptFreeCache(styleItem.psc);
            nArray[0] = 0;
            OS.MoveMemory(styleItem.psc, new long[1], OS.PTR_SIZEOF);
        }
        styleItem.glyphCount = 0;
        return false;
    }

    void shape(long l, StyleItem styleItem) {
        if (styleItem.tab || styleItem.lineBreak) {
            return;
        }
        if (styleItem.glyphs != 0L) {
            return;
        }
        int[] nArray = new int[1];
        char[] cArray = new char[styleItem.length];
        this.segmentsText.getChars(styleItem.start, styleItem.start + styleItem.length, cArray, 0);
        int n = cArray.length * 3 / 2 + 16;
        long l2 = OS.GetProcessHeap();
        styleItem.glyphs = OS.HeapAlloc(l2, 8, n * 2);
        if (styleItem.glyphs == 0L) {
            SWT.error(2);
        }
        styleItem.clusters = OS.HeapAlloc(l2, 8, n * 2);
        if (styleItem.clusters == 0L) {
            SWT.error(2);
        }
        styleItem.visAttrs = OS.HeapAlloc(l2, 8, n * 2);
        if (styleItem.visAttrs == 0L) {
            SWT.error(2);
        }
        styleItem.psc = OS.HeapAlloc(l2, 8, OS.PTR_SIZEOF);
        if (styleItem.psc == 0L) {
            SWT.error(2);
        }
        short s = styleItem.analysis.eScript;
        SCRIPT_PROPERTIES sCRIPT_PROPERTIES = new SCRIPT_PROPERTIES();
        OS.MoveMemory(sCRIPT_PROPERTIES, this.device.scripts[s], SCRIPT_PROPERTIES.sizeof);
        boolean bl = this.shape(l, styleItem, cArray, nArray, n, sCRIPT_PROPERTIES);
        if (!bl && sCRIPT_PROPERTIES.fPrivateUseArea) {
            styleItem.analysis.fNoGlyphIndex = true;
            bl = this.shape(l, styleItem, cArray, nArray, n, sCRIPT_PROPERTIES);
        }
        if (!bl) {
            Object object;
            long l3;
            long l4;
            long l5 = OS.GetCurrentObject(l, 6);
            long l6 = 0L;
            char[] cArray2 = new char[Math.min(cArray.length, 2)];
            SCRIPT_LOGATTR sCRIPT_LOGATTR = new SCRIPT_LOGATTR();
            this.breakRun(styleItem);
            int n2 = 0;
            int n3 = 0;
            while (n3 < cArray.length) {
                OS.MoveMemory(sCRIPT_LOGATTR, styleItem.psla + (long)(n3 * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                if (!sCRIPT_LOGATTR.fWhiteSpace) {
                    cArray2[n2++] = cArray[n3];
                    if (n2 == cArray2.length) break;
                }
                ++n3;
            }
            if (n2 > 0) {
                Callback callback;
                long l7;
                long l8 = OS.HeapAlloc(l2, 8, OS.SCRIPT_STRING_ANALYSIS_sizeof());
                l4 = OS.CreateEnhMetaFile(l, null, null, null);
                l3 = OS.SelectObject(l4, l5);
                int n4 = 6304;
                if (OS.ScriptStringAnalyse(l4, cArray2, n2, 0, -1, n4, 0, null, null, 0L, 0L, 0L, l8) == 0) {
                    OS.ScriptStringOut(l8, 0, 0, 0, null, 0, 0, false);
                    OS.ScriptStringFree(l8);
                }
                OS.HeapFree(l2, 0, l8);
                OS.SelectObject(l4, l3);
                long l9 = OS.CloseEnhMetaFile(l4);
                EMREXTCREATEFONTINDIRECTW eMREXTCREATEFONTINDIRECTW = new EMREXTCREATEFONTINDIRECTW();
                class MetaFileEnumProc {
                    final /* synthetic */ TextLayout this$0;
                    private final /* synthetic */ EMREXTCREATEFONTINDIRECTW val$emr;

                    MetaFileEnumProc(TextLayout textLayout, EMREXTCREATEFONTINDIRECTW eMREXTCREATEFONTINDIRECTW) {
                        this.this$0 = textLayout;
                        this.val$emr = eMREXTCREATEFONTINDIRECTW;
                    }

                    long metaFileEnumProc(long l, long l2, long l3, long l4, long l5) {
                        OS.MoveMemory(this.val$emr.emr, l3, EMR.sizeof);
                        switch (this.val$emr.emr.iType) {
                            case 82: {
                                OS.MoveMemory(this.val$emr, l3, EMREXTCREATEFONTINDIRECTW.sizeof);
                                break;
                            }
                            case 84: {
                                return 0L;
                            }
                        }
                        return 1L;
                    }
                }
                MetaFileEnumProc metaFileEnumProc = new MetaFileEnumProc(this, eMREXTCREATEFONTINDIRECTW);
                boolean bl2 = false;
                if (bl2) {
                    metaFileEnumProc.metaFileEnumProc(0L, 0L, 0L, 0L, 0L);
                }
                if ((l7 = (callback = new Callback(metaFileEnumProc, "metaFileEnumProc", 5)).getAddress()) == 0L) {
                    SWT.error(3);
                }
                OS.EnumEnhMetaFile(0L, l9, l7, 0L, null);
                OS.DeleteEnhMetaFile(l9);
                callback.dispose();
                l6 = OS.CreateFontIndirectW(eMREXTCREATEFONTINDIRECTW.elfw.elfLogFont);
            } else {
                n3 = 0;
                while (n3 < this.allRuns.length - 1) {
                    if (this.allRuns[n3] == styleItem) {
                        LOGFONT lOGFONT;
                        if (n3 > 0) {
                            object = this.allRuns[n3 - 1];
                            if (((StyleItem)object).analysis.eScript == styleItem.analysis.eScript) {
                                l4 = this.getItemFont((StyleItem)object);
                                lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
                                OS.GetObject(l4, LOGFONT.sizeof, lOGFONT);
                                l6 = OS.CreateFontIndirect(lOGFONT);
                            }
                        }
                        if (l6 != 0L || n3 + 1 >= this.allRuns.length - 1) break;
                        object = this.allRuns[n3 + 1];
                        if (((StyleItem)object).analysis.eScript != styleItem.analysis.eScript) break;
                        OS.SelectObject(l, this.getItemFont((StyleItem)object));
                        this.shape(l, (StyleItem)object);
                        l4 = this.getItemFont((StyleItem)object);
                        lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
                        OS.GetObject(l4, LOGFONT.sizeof, lOGFONT);
                        l6 = OS.CreateFontIndirect(lOGFONT);
                        break;
                    }
                    ++n3;
                }
            }
            if (l6 != 0L) {
                OS.SelectObject(l, l6);
                bl = this.shape(l, styleItem, cArray, nArray, n, sCRIPT_PROPERTIES);
                if (bl) {
                    styleItem.fallbackFont = l6;
                }
            }
            if (!bl && !sCRIPT_PROPERTIES.fComplex) {
                styleItem.analysis.fNoGlyphIndex = true;
                bl = this.shape(l, styleItem, cArray, nArray, n, sCRIPT_PROPERTIES);
                if (bl) {
                    styleItem.fallbackFont = l6;
                } else {
                    styleItem.analysis.fNoGlyphIndex = false;
                }
            }
            if (!bl && this.mLangFontLink2 != 0L) {
                long[] lArray = new long[1];
                object = new int[1];
                int[] nArray2 = new int[1];
                OS.VtblCall(4, this.mLangFontLink2, cArray, cArray.length, 0, (int[])object, nArray2);
                if (OS.VtblCall(10, this.mLangFontLink2, l, (int)object[0], (int)cArray[0], lArray) == 0) {
                    LOGFONT lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
                    OS.GetObject(lArray[0], LOGFONT.sizeof, lOGFONT);
                    OS.VtblCall(8, this.mLangFontLink2, lArray[0]);
                    l3 = OS.CreateFontIndirect(lOGFONT);
                    long l10 = OS.SelectObject(l, l3);
                    bl = this.shape(l, styleItem, cArray, nArray, n, sCRIPT_PROPERTIES);
                    if (bl) {
                        styleItem.fallbackFont = l3;
                    } else {
                        OS.SelectObject(l, l10);
                        OS.DeleteObject(l3);
                    }
                }
            }
            if (!bl) {
                OS.SelectObject(l, l5);
            }
            if (l6 != 0L && l6 != styleItem.fallbackFont) {
                OS.DeleteObject(l6);
            }
        }
        if (!bl) {
            OS.ScriptShape(l, styleItem.psc, cArray, cArray.length, n, styleItem.analysis, styleItem.glyphs, styleItem.clusters, styleItem.visAttrs, nArray);
            styleItem.glyphCount = nArray[0];
        }
        int[] nArray3 = new int[3];
        styleItem.advances = OS.HeapAlloc(l2, 8, styleItem.glyphCount * 4);
        if (styleItem.advances == 0L) {
            SWT.error(2);
        }
        styleItem.goffsets = OS.HeapAlloc(l2, 8, styleItem.glyphCount * 8);
        if (styleItem.goffsets == 0L) {
            SWT.error(2);
        }
        OS.ScriptPlace(l, styleItem.psc, styleItem.glyphs, styleItem.glyphCount, styleItem.visAttrs, styleItem.analysis, styleItem.advances, styleItem.goffsets, nArray3);
        styleItem.width = nArray3[0] + nArray3[1] + nArray3[2];
        TextStyle textStyle = styleItem.style;
        if (textStyle != null) {
            OUTLINETEXTMETRIC oUTLINETEXTMETRIC = null;
            if (textStyle.underline || textStyle.strikeout) {
                OUTLINETEXTMETRIC oUTLINETEXTMETRIC2 = oUTLINETEXTMETRIC = OS.IsUnicode ? new OUTLINETEXTMETRICW() : new OUTLINETEXTMETRICA();
                if (OS.GetOutlineTextMetrics(l, OUTLINETEXTMETRIC.sizeof, oUTLINETEXTMETRIC) == 0) {
                    oUTLINETEXTMETRIC = null;
                }
            }
            if (textStyle.metrics != null) {
                GlyphMetrics glyphMetrics = textStyle.metrics;
                styleItem.width = glyphMetrics.width * Math.max(1, styleItem.glyphCount);
                styleItem.ascent = glyphMetrics.ascent;
                styleItem.descent = glyphMetrics.descent;
                styleItem.leading = 0;
            } else {
                TEXTMETRIC tEXTMETRIC = null;
                if (oUTLINETEXTMETRIC != null) {
                    tEXTMETRIC = OS.IsUnicode ? oUTLINETEXTMETRIC.otmTextMetrics : ((OUTLINETEXTMETRICA)oUTLINETEXTMETRIC).otmTextMetrics;
                } else {
                    tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                    OS.GetTextMetrics(l, tEXTMETRIC);
                }
                styleItem.ascent = tEXTMETRIC.tmAscent;
                styleItem.descent = tEXTMETRIC.tmDescent;
                styleItem.leading = tEXTMETRIC.tmInternalLeading;
            }
            if (oUTLINETEXTMETRIC != null) {
                styleItem.underlinePos = oUTLINETEXTMETRIC.otmsUnderscorePosition;
                styleItem.underlineThickness = Math.max(1, oUTLINETEXTMETRIC.otmsUnderscoreSize);
                styleItem.strikeoutPos = oUTLINETEXTMETRIC.otmsStrikeoutPosition;
                styleItem.strikeoutThickness = Math.max(1, oUTLINETEXTMETRIC.otmsStrikeoutSize);
            } else {
                styleItem.underlinePos = 1;
                styleItem.underlineThickness = 1;
                styleItem.strikeoutPos = styleItem.ascent / 2;
                styleItem.strikeoutThickness = 1;
            }
            styleItem.ascent += textStyle.rise;
            styleItem.descent -= textStyle.rise;
        } else {
            TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(l, tEXTMETRIC);
            styleItem.ascent = tEXTMETRIC.tmAscent;
            styleItem.descent = tEXTMETRIC.tmDescent;
            styleItem.leading = tEXTMETRIC.tmInternalLeading;
        }
    }

    int validadeOffset(int n, int n2) {
        n = this.untranslateOffset(n);
        return this.translateOffset(n + n2);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {}";
    }

    int translateOffset(int n) {
        int n2 = this.text.length();
        if (n2 == 0) {
            return n;
        }
        if (this.segments == null) {
            return n;
        }
        int n3 = this.segments.length;
        if (n3 == 0) {
            return n;
        }
        if (this.segmentsChars == null) {
            if (n3 == 1) {
                return n;
            }
            if (n3 == 2 && this.segments[0] == 0 && this.segments[1] == n2) {
                return n;
            }
        }
        int n4 = 0;
        while (n4 < n3 && n - n4 >= this.segments[n4]) {
            ++n;
            ++n4;
        }
        return n;
    }

    int untranslateOffset(int n) {
        int n2 = this.text.length();
        if (n2 == 0) {
            return n;
        }
        if (this.segments == null) {
            return n;
        }
        int n3 = this.segments.length;
        if (n3 == 0) {
            return n;
        }
        if (this.segmentsChars == null) {
            if (n3 == 1) {
                return n;
            }
            if (n3 == 2 && this.segments[0] == 0 && this.segments[1] == n2) {
                return n;
            }
        }
        int n4 = 0;
        while (n4 < n3 && n > this.segments[n4]) {
            --n;
            ++n4;
        }
        return n;
    }

    class StyleItem {
        TextStyle style;
        int start;
        int length;
        boolean lineBreak;
        boolean softBreak;
        boolean tab;
        SCRIPT_ANALYSIS analysis;
        long psc = 0L;
        long glyphs;
        int glyphCount;
        long clusters;
        long visAttrs;
        long advances;
        long goffsets;
        int width;
        int ascent;
        int descent;
        int leading;
        int x;
        int underlinePos;
        int underlineThickness;
        int strikeoutPos;
        int strikeoutThickness;
        long justify;
        long psla;
        long fallbackFont;

        StyleItem() {
        }

        void free() {
            long l = OS.GetProcessHeap();
            if (this.psc != 0L) {
                OS.ScriptFreeCache(this.psc);
                OS.HeapFree(l, 0, this.psc);
                this.psc = 0L;
            }
            if (this.glyphs != 0L) {
                OS.HeapFree(l, 0, this.glyphs);
                this.glyphs = 0L;
                this.glyphCount = 0;
            }
            if (this.clusters != 0L) {
                OS.HeapFree(l, 0, this.clusters);
                this.clusters = 0L;
            }
            if (this.visAttrs != 0L) {
                OS.HeapFree(l, 0, this.visAttrs);
                this.visAttrs = 0L;
            }
            if (this.advances != 0L) {
                OS.HeapFree(l, 0, this.advances);
                this.advances = 0L;
            }
            if (this.goffsets != 0L) {
                OS.HeapFree(l, 0, this.goffsets);
                this.goffsets = 0L;
            }
            if (this.justify != 0L) {
                OS.HeapFree(l, 0, this.justify);
                this.justify = 0L;
            }
            if (this.psla != 0L) {
                OS.HeapFree(l, 0, this.psla);
                this.psla = 0L;
            }
            if (this.fallbackFont != 0L) {
                OS.DeleteObject(this.fallbackFont);
                this.fallbackFont = 0L;
            }
            this.x = 0;
            this.descent = 0;
            this.ascent = 0;
            this.width = 0;
            this.softBreak = false;
            this.lineBreak = false;
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

