/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;

public class ButtonDrawData
extends DrawData {
    public ButtonDrawData() {
        this.state = new int[1];
    }

    int[] getPartId(int n) {
        int n2 = this.state[n];
        int n3 = this.style;
        int n4 = 0;
        int n5 = 0;
        if ((n3 & 8) != 0) {
            n4 = 1;
            n5 = 1;
            if ((n2 & 0x80) != 0 && (n2 & 0x10) != 0) {
                n5 = 5;
            }
            if ((n2 & 0x40) != 0) {
                n5 = 2;
            }
            if ((n2 & 8) != 0) {
                n5 = 3;
            }
            if ((n2 & 0x20) != 0) {
                n5 = 4;
            }
        }
        if ((n3 & 0x10) != 0) {
            n4 = 2;
        }
        if ((n3 & 0x20) != 0) {
            n4 = 3;
        }
        if ((n3 & 0x30) != 0) {
            if ((n2 & 2) != 0) {
                n5 = 5;
                if ((n2 & 0x40) != 0) {
                    n5 = 6;
                }
                if ((n2 & 8) != 0) {
                    n5 = 7;
                }
                if ((n2 & 0x20) != 0) {
                    n5 = 8;
                }
            } else {
                n5 = 1;
                if ((n2 & 0x40) != 0) {
                    n5 = 2;
                }
                if ((n2 & 8) != 0) {
                    n5 = 3;
                }
                if ((n2 & 0x20) != 0) {
                    n5 = 4;
                }
            }
        }
        return new int[]{n4, n5};
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            Object object;
            long l = OS.OpenThemeData(0L, this.getClassId());
            RECT rECT = new RECT();
            rECT.left = rectangle.x;
            rECT.right = rectangle.x + rectangle.width;
            rECT.top = rectangle.y;
            rECT.bottom = rectangle.y + rectangle.height;
            int[] nArray = this.getPartId(0);
            if ((this.style & 0x30) != 0) {
                object = new SIZE();
                OS.GetThemePartSize(l, gC.handle, nArray[0], nArray[1], rECT, 2, (SIZE)object);
                rECT.right = rECT.left + ((SIZE)object).cx;
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                rECT.left = rECT.right + 3;
                rECT.right = rECT.left + rectangle.width - ((SIZE)object).cx - 3;
            } else {
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
            }
            object = this.clientArea;
            if (object != null) {
                RECT rECT2 = new RECT();
                OS.GetThemeBackgroundContentRect(l, gC.handle, nArray[0], nArray[1], rECT, rECT2);
                ((Rectangle)object).x = rECT2.left;
                ((Rectangle)object).y = rECT2.top;
                ((Rectangle)object).width = rECT2.right - rECT2.left;
                ((Rectangle)object).height = rECT2.bottom - rECT2.top;
            }
            OS.CloseThemeData(l);
        }
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
            return -1;
        }
        if (!rectangle.contains(point)) {
            return -1;
        }
        long l = OS.OpenThemeData(0L, this.getClassId());
        RECT rECT = new RECT();
        rECT.left = rectangle.x;
        rECT.right = rectangle.x + rectangle.width;
        rECT.top = rectangle.y;
        rECT.bottom = rectangle.y + rectangle.height;
        POINT pOINT = new POINT();
        pOINT.x = point.x;
        pOINT.y = point.y;
        short[] sArray = new short[1];
        int[] nArray = this.getPartId(0);
        OS.HitTestThemeBackground(l, 0L, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
        OS.CloseThemeData(l);
        return sArray[0] == 0 ? -1 : 0;
    }
}

