/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.mapreduce;

import com.cloudera.sqoop.SqoopOptions;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.sqoop.config.ConfigurationHelper;
import org.apache.sqoop.manager.ConnManager;
import org.apache.sqoop.validation.ValidationContext;
import org.apache.sqoop.validation.ValidationException;
import org.apache.sqoop.validation.ValidationFailureHandler;
import org.apache.sqoop.validation.ValidationThreshold;
import org.apache.sqoop.validation.Validator;

public class JobBase
extends org.apache.sqoop.mapreduce.JobBase {
    public JobBase() {
    }

    public JobBase(SqoopOptions opts) {
        super(opts);
    }

    public JobBase(SqoopOptions opts, Class<? extends Mapper> mapperClass, Class<? extends InputFormat> inputFormatClass, Class<? extends OutputFormat> outputFormatClass) {
        super(opts, mapperClass, inputFormatClass, outputFormatClass);
    }

    protected long getRowCountFromDB(ConnManager connManager, String tableName) throws SQLException {
        return connManager.getTableRowCount(tableName);
    }

    protected long getRowCountFromHadoop(Job job) throws IOException, InterruptedException {
        return ConfigurationHelper.getNumMapOutputRecords(job);
    }

    protected void doValidate(SqoopOptions options, Configuration conf, ValidationContext validationContext) throws ValidationException {
        Validator validator = (Validator)ReflectionUtils.newInstance((Class)options.getValidatorClass(), (Configuration)conf);
        ValidationThreshold threshold = (ValidationThreshold)ReflectionUtils.newInstance((Class)options.getValidationThresholdClass(), (Configuration)conf);
        ValidationFailureHandler failureHandler = (ValidationFailureHandler)ReflectionUtils.newInstance((Class)options.getValidationFailureHandlerClass(), (Configuration)conf);
        validator.validate(validationContext, threshold, failureHandler);
    }
}

