/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.hbase;

import com.cloudera.sqoop.hbase.PutTransformer;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;

public class ToStringPutTransformer
extends PutTransformer {
    public static final Log LOG = LogFactory.getLog((String)ToStringPutTransformer.class.getName());
    private Map<String, byte[]> serializedFieldNames = new TreeMap<String, byte[]>();
    protected boolean bigDecimalFormatString;
    protected boolean addRowKey;

    private byte[] getFieldNameBytes(String fieldName) {
        byte[] cachedName = this.serializedFieldNames.get(fieldName);
        if (null != cachedName) {
            return cachedName;
        }
        byte[] nameBytes = Bytes.toBytes((String)fieldName);
        this.serializedFieldNames.put(fieldName, nameBytes);
        return nameBytes;
    }

    @Override
    public List<Put> getPutCommand(Map<String, Object> fields) throws IOException {
        String rowKeyCol = this.getRowKeyColumn();
        String colFamily = this.getColumnFamily();
        byte[] colFamilyBytes = Bytes.toBytes((String)colFamily);
        Object rowKey = fields.get(rowKeyCol);
        if (null == rowKey) {
            LOG.warn((Object)("Could not insert row with null value for row-key column: " + rowKeyCol));
            return null;
        }
        Put put = new Put(Bytes.toBytes((String)this.toHBaseString(rowKey)));
        for (Map.Entry<String, Object> fieldEntry : fields.entrySet()) {
            Object val;
            String colName = fieldEntry.getKey();
            if (colName.equals(rowKeyCol) && !this.addRowKey || null == (val = fieldEntry.getValue())) continue;
            put.add(colFamilyBytes, this.getFieldNameBytes(colName), Bytes.toBytes((String)this.toHBaseString(val)));
        }
        return Collections.singletonList(put);
    }

    private String toHBaseString(Object val) {
        String valString = val instanceof BigDecimal && this.bigDecimalFormatString ? ((BigDecimal)val).toPlainString() : val.toString();
        return valString;
    }
}

