/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.io.NamedFifo;
import com.cloudera.sqoop.manager.MySQLUtils;
import com.cloudera.sqoop.mapreduce.db.DBConfiguration;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.sqoop.mapreduce.SqoopMapper;
import org.apache.sqoop.util.AsyncSink;
import org.apache.sqoop.util.JdbcUrl;
import org.apache.sqoop.util.LoggingAsyncSink;
import org.apache.sqoop.util.NullAsyncSink;
import org.apache.sqoop.util.TaskId;

public class MySQLExportMapper<KEYIN, VALIN>
extends SqoopMapper<KEYIN, VALIN, NullWritable, NullWritable> {
    public static final Log LOG = LogFactory.getLog((String)MySQLExportMapper.class.getName());
    public static final String MYSQL_CHECKPOINT_BYTES_KEY = "sqoop.mysql.export.checkpoint.bytes";
    public static final long DEFAULT_CHECKPOINT_BYTES = 0x2000000L;
    protected long checkpointDistInBytes;
    public static final String MYSQL_CHECKPOINT_SLEEP_KEY = "sqoop.mysql.export.sleep.ms";
    public static final long DEFAULT_CHECKPOINT_SLEEP_MS = 0L;
    protected long checkpointSleepMs;
    protected Configuration conf;
    protected File fifoFile;
    protected Process mysqlImportProcess;
    protected OutputStream importStream;
    protected AsyncSink outSink;
    protected AsyncSink errSink;
    protected File passwordFile;
    protected String mysqlCharSet;
    private long bytesWritten;

    private void initMySQLImportProcess() throws IOException {
        String username;
        File taskAttemptDir = TaskId.getLocalWorkPath(this.conf);
        this.fifoFile = new File(taskAttemptDir, this.conf.get(MySQLUtils.TABLE_NAME_KEY, "UNKNOWN_TABLE") + ".txt");
        String filename = this.fifoFile.toString();
        try {
            new NamedFifo(this.fifoFile).create();
        }
        catch (IOException ioe) {
            LOG.error((Object)("Could not mknod " + filename));
            this.fifoFile = null;
            throw new IOException("Could not create FIFO to interface with mysqlimport", ioe);
        }
        ArrayList<String> args = new ArrayList<String>();
        String connectString = this.conf.get(MySQLUtils.CONNECT_STRING_KEY);
        String databaseName = JdbcUrl.getDatabaseName(connectString);
        String hostname = JdbcUrl.getHostName(connectString);
        int port = JdbcUrl.getPort(connectString);
        if (null == databaseName) {
            throw new IOException("Could not determine database name");
        }
        args.add("mysqlimport");
        String password = this.conf.get(MySQLUtils.PASSWORD_KEY);
        if (null != password && password.length() > 0) {
            this.passwordFile = new File(MySQLUtils.writePasswordFile(this.conf));
            args.add("--defaults-file=" + this.passwordFile);
        }
        if (null != (username = this.conf.get(MySQLUtils.USERNAME_KEY))) {
            args.add("--user=" + username);
        }
        args.add("--host=" + hostname);
        if (-1 != port) {
            args.add("--port=" + Integer.toString(port));
        }
        args.add("--compress");
        args.add("--local");
        args.add("--silent");
        DBConfiguration dbConf = new DBConfiguration(this.conf);
        String[] cols = dbConf.getInputFieldNames();
        if (null != cols) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String col : cols) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(col);
                first = false;
            }
            args.add("--columns=" + sb.toString());
        }
        int outputFieldDelim = this.conf.getInt("sqoop.output.field.delim", 44);
        int outputRecordDelim = this.conf.getInt("sqoop.output.record.delim", 10);
        int enclosedBy = this.conf.getInt("sqoop.output.enclosed.by", 0);
        int escapedBy = this.conf.getInt("sqoop.output.escaped.by", 0);
        boolean encloseRequired = this.conf.getBoolean("sqoop.output.enclose.required", false);
        args.add("--fields-terminated-by=0x" + Integer.toString(outputFieldDelim, 16));
        args.add("--lines-terminated-by=0x" + Integer.toString(outputRecordDelim, 16));
        if (0 != enclosedBy) {
            if (encloseRequired) {
                args.add("--fields-enclosed-by=0x" + Integer.toString(enclosedBy, 16));
            } else {
                args.add("--fields-optionally-enclosed-by=0x" + Integer.toString(enclosedBy, 16));
            }
        }
        if (0 != escapedBy) {
            args.add("--escaped-by=0x" + Integer.toString(escapedBy, 16));
        }
        args.add(databaseName);
        args.add(filename);
        LOG.debug((Object)"Starting mysqlimport with arguments:");
        for (String arg : args) {
            LOG.debug((Object)("  " + arg));
        }
        this.mysqlImportProcess = Runtime.getRuntime().exec(args.toArray(new String[0]));
        this.outSink = new NullAsyncSink();
        this.outSink.processStream(this.mysqlImportProcess.getInputStream());
        this.errSink = new LoggingAsyncSink(LOG);
        this.errSink.processStream(this.mysqlImportProcess.getErrorStream());
        this.importStream = new BufferedOutputStream(new FileOutputStream(this.fifoFile));
        this.bytesWritten = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Mapper.Context context) throws IOException, InterruptedException {
        this.conf = context.getConfiguration();
        this.setup(context);
        this.initMySQLImportProcess();
        try {
            while (context.nextKeyValue()) {
                this.map(context.getCurrentKey(), context.getCurrentValue(), context);
            }
            this.cleanup(context);
        }
        finally {
            this.closeExportHandles();
        }
    }

    private void closeExportHandles() throws IOException, InterruptedException {
        int ret = 0;
        if (null != this.importStream) {
            LOG.debug((Object)"Closing import stream");
            this.importStream.close();
            this.importStream = null;
        }
        if (null != this.mysqlImportProcess) {
            LOG.info((Object)"Waiting for mysqlimport to complete");
            ret = this.mysqlImportProcess.waitFor();
            LOG.info((Object)"mysqlimport closed connection");
            this.mysqlImportProcess = null;
        }
        if (null != this.passwordFile && this.passwordFile.exists()) {
            if (!this.passwordFile.delete()) {
                LOG.error((Object)("Could not remove mysql password file " + this.passwordFile));
                LOG.error((Object)"You should remove this file to protect your credentials.");
            }
            this.passwordFile = null;
        }
        if (null != this.outSink) {
            LOG.debug((Object)"Waiting for any additional stdout from mysqlimport");
            this.outSink.join();
            this.outSink = null;
        }
        if (null != this.errSink) {
            LOG.debug((Object)"Waiting for any additional stderr from mysqlimport");
            this.errSink.join();
            this.errSink = null;
        }
        if (this.fifoFile != null && this.fifoFile.exists()) {
            LOG.debug((Object)"Removing fifo file");
            if (!this.fifoFile.delete()) {
                LOG.error((Object)"Could not clean up named FIFO after completing mapper");
            }
            File fifoParentDir = this.fifoFile.getParentFile();
            LOG.debug((Object)"Removing task attempt tmpdir");
            if (!fifoParentDir.delete()) {
                LOG.error((Object)"Could not clean up task dir after completing mapper");
            }
            this.fifoFile = null;
        }
        if (0 != ret) {
            throw new IOException("mysqlimport terminated with error code " + ret);
        }
    }

    @Override
    protected void setup(Mapper.Context context) {
        this.conf = context.getConfiguration();
        this.mysqlCharSet = "ISO_8859_1";
        this.checkpointDistInBytes = this.conf.getLong(MYSQL_CHECKPOINT_BYTES_KEY, 0x2000000L);
        if (this.checkpointDistInBytes < 0L) {
            LOG.warn((Object)"Invalid value for sqoop.mysql.export.checkpoint.bytes");
            this.checkpointDistInBytes = 0x2000000L;
        }
        this.checkpointSleepMs = this.conf.getLong(MYSQL_CHECKPOINT_SLEEP_KEY, 0L);
        if (this.checkpointSleepMs < 0L) {
            LOG.warn((Object)"Invalid value for sqoop.mysql.export.sleep.ms");
            this.checkpointSleepMs = 0L;
        }
        if (this.checkpointSleepMs >= this.conf.getLong("mapred.task.timeout", 0L)) {
            LOG.warn((Object)"Value for sqoop.mysql.export.sleep.ms has to be smaller than mapred.task.timeout");
            this.checkpointSleepMs = 0L;
        }
    }

    protected void writeRecord(String record, String terminator) throws IOException, InterruptedException {
        byte[] mysqlBytes = record.getBytes(this.mysqlCharSet);
        this.importStream.write(mysqlBytes, 0, mysqlBytes.length);
        this.bytesWritten += (long)mysqlBytes.length;
        if (null != terminator) {
            byte[] termBytes = terminator.getBytes(this.mysqlCharSet);
            this.importStream.write(termBytes, 0, termBytes.length);
            this.bytesWritten += (long)termBytes.length;
        }
        if (this.checkpointDistInBytes != 0L && this.bytesWritten > this.checkpointDistInBytes) {
            LOG.info((Object)"Checkpointing current export.");
            if (this.checkpointSleepMs != 0L) {
                LOG.info((Object)"Pausing.");
                Thread.sleep(this.checkpointSleepMs);
            }
            this.closeExportHandles();
            this.initMySQLImportProcess();
            this.bytesWritten = 0L;
        }
    }
}

