/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.mapreduce;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.KettleLoggingEvent;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.SingleThreadedTransExecutor;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.hadoop.mapreduce.InKeyValueOrdinals;
import org.pentaho.hadoop.mapreduce.MRUtil;
import org.pentaho.hadoop.mapreduce.OutputCollectorRowListener;
import org.pentaho.hadoop.mapreduce.PentahoMapReduceBase;
import org.pentaho.hadoop.mapreduce.converter.TypeConverterFactory;
import org.pentaho.hadoop.mapreduce.converter.spi.ITypeConverter;

public class GenericTransReduce<K extends WritableComparable<?>, V extends Iterator<Writable>, K2, V2>
extends PentahoMapReduceBase<K2, V2>
implements Reducer<K, V, K2, V2> {
    protected RowProducer rowProducer;
    protected Object value;
    protected InKeyValueOrdinals inOrdinals = null;
    protected TypeConverterFactory typeConverterFactory;
    protected ITypeConverter inConverterK = null;
    protected ITypeConverter inConverterV = null;
    protected RowMetaInterface injectorRowMeta;
    protected SingleThreadedTransExecutor executor;

    public GenericTransReduce() throws KettleException {
        this.setMRType(PentahoMapReduceBase.MROperations.Reduce);
        this.typeConverterFactory = new TypeConverterFactory();
    }

    public boolean isSingleThreaded() {
        return this.reduceSingleThreaded;
    }

    public String getInputStepName() {
        return this.reduceInputStepName;
    }

    public String getOutputStepName() {
        return this.reduceOutputStepName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reduce(K key, Iterator<V> values, OutputCollector<K2, V2> output, Reporter reporter) throws IOException {
        try {
            if (this.debug) {
                reporter.setStatus("Begin processing record");
            }
            if (this.trans == null) {
                throw new RuntimeException("Error initializing transformation.  See error log.");
            }
            if (this.isSingleThreaded()) {
                if (!this.trans.isRunning()) {
                    this.shareVariableSpaceWithTrans(reporter);
                    this.setTransLogLevel(reporter);
                    this.prepareExecution(reporter);
                    this.addInjectorAndProducerToTrans(key, values, output, reporter, this.getInputStepName(), this.getOutputStepName());
                    this.executor = new SingleThreadedTransExecutor(this.trans);
                    boolean ok = this.executor.init();
                    if (!ok) {
                        throw new KettleException("Unable to initialize the single threaded transformation, check the log for details.");
                    }
                }
                this.injectValues(key, values, output, reporter);
                this.executor.oneIteration();
            } else {
                KettleLogStore.discardLines((String)this.trans.getLogChannelId(), (boolean)true);
                this.trans = MRUtil.recreateTrans(this.trans);
                this.shareVariableSpaceWithTrans(reporter);
                this.setTransLogLevel(reporter);
                this.prepareExecution(reporter);
                this.addInjectorAndProducerToTrans(key, values, output, reporter, this.getInputStepName(), this.getOutputStepName());
                try {
                    this.injectValues(key, values, output, reporter);
                    this.trans.waitUntilFinished();
                    this.setDebugStatus(reporter, "Transformation has finished");
                }
                finally {
                    this.disposeTransformation();
                }
            }
            if (this.trans.getErrors() > 0) {
                this.setDebugStatus(reporter, "Errors detected in reducer/combiner transformation");
                List logList = KettleLogStore.getLogBufferFromTo((String)this.trans.getLogChannelId(), (boolean)false, (int)0, (int)KettleLogStore.getLastBufferLineNr());
                StringBuffer buff = new StringBuffer();
                for (KettleLoggingEvent le : logList) {
                    if (le.getLevel() != LogLevel.ERROR) continue;
                    buff.append(le.getMessage().toString()).append("\n");
                }
                throw new Exception("Errors were detected for reducer/combiner transformation:\n\n" + buff.toString());
            }
        }
        catch (Exception e) {
            this.printException(reporter, e);
            this.setDebugStatus(reporter, "An exception was raised");
            throw new IOException(e);
        }
        if (this.debug) {
            reporter.setStatus("Completed processing record");
        }
    }

    private void printException(Reporter reporter, Exception e) throws IOException {
        e.printStackTrace(System.err);
        this.setDebugStatus(reporter, "An exception was raised");
        throw new IOException(e);
    }

    private void disposeTransformation() {
        try {
            this.trans.stopAll();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.trans.cleanup();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void injectValues(K key, Iterator<V> values, OutputCollector<K2, V2> output, Reporter reporter) throws Exception {
        if (this.rowProducer != null) {
            if (this.value != null) {
                if (this.inOrdinals != null) {
                    this.injectValue(key, this.inOrdinals.getKeyOrdinal(), this.inConverterK, this.value, this.inOrdinals.getValueOrdinal(), this.inConverterV, this.injectorRowMeta, this.rowProducer, reporter);
                } else {
                    this.injectValue(key, this.inConverterK, this.value, this.inConverterV, this.injectorRowMeta, this.rowProducer, reporter);
                }
            }
            while (values.hasNext()) {
                this.value = values.next();
                if (this.inOrdinals != null) {
                    this.injectValue(key, this.inOrdinals.getKeyOrdinal(), this.inConverterK, this.value, this.inOrdinals.getValueOrdinal(), this.inConverterV, this.injectorRowMeta, this.rowProducer, reporter);
                    continue;
                }
                this.injectValue(key, this.inConverterK, this.value, this.inConverterV, this.injectorRowMeta, this.rowProducer, reporter);
            }
            this.value = null;
            this.rowProducer.finished();
        }
    }

    private void prepareExecution(Reporter reporter) throws KettleException {
        this.setDebugStatus(reporter, "Preparing transformation for execution");
        this.trans.prepareExecution(null);
    }

    private void setTransLogLevel(Reporter reporter) {
        if (this.logLevel != null) {
            this.setDebugStatus(reporter, "Setting the trans.logLevel to " + this.logLevel.toString());
            this.trans.setLogLevel(this.logLevel);
        } else {
            this.setDebugStatus(reporter, ((Object)((Object)this)).getClass().getName() + ".logLevel is null.  The trans log level will not be set.");
        }
    }

    private void shareVariableSpaceWithTrans(Reporter reporter) {
        if (this.variableSpace != null) {
            this.setDebugStatus(reporter, "Sharing the VariableSpace from the PDI job.");
            this.trans.shareVariablesWith(this.variableSpace);
            if (this.debug) {
                List<String> variables = Arrays.asList(this.trans.listVariables());
                Collections.sort(variables);
                if (variables != null) {
                    this.setDebugStatus(reporter, "Variables: ");
                    for (String variable : variables) {
                        this.setDebugStatus(reporter, "     " + variable + " = " + this.trans.getVariable(variable));
                    }
                }
            }
        } else {
            this.setDebugStatus(reporter, "variableSpace is null.  We are not going to share it with the trans.");
        }
    }

    private void addInjectorAndProducerToTrans(K key, Iterator<V> values, OutputCollector<K2, V2> output, Reporter reporter, String inputStepName, String outputStepName) throws Exception {
        this.setDebugStatus(reporter, "Locating output step: " + outputStepName);
        StepInterface outputStep = this.trans.findRunThread(outputStepName);
        if (outputStep != null) {
            this.rowCollector = new OutputCollectorRowListener<K2, V2>(output, this.outClassK, this.outClassV, reporter, this.debug);
            outputStep.addRowListener((RowListener)this.rowCollector);
            this.injectorRowMeta = new RowMeta();
            this.setDebugStatus(reporter, "Locating input step: " + inputStepName);
            if (inputStepName != null) {
                this.rowProducer = this.trans.addRowProducer(inputStepName, 0);
                StepInterface inputStep = this.rowProducer.getStepInterface();
                StepMetaInterface inputStepMeta = inputStep.getStepMeta().getStepMetaInterface();
                this.inOrdinals = null;
                if (inputStepMeta instanceof BaseStepMeta) {
                    this.setDebugStatus(reporter, "Generating converters from RowMeta for injection into the transformation");
                    ((BaseStepMeta)inputStepMeta).getFields(this.injectorRowMeta, null, null, null, null);
                    this.inOrdinals = new InKeyValueOrdinals(this.injectorRowMeta);
                    if (this.inOrdinals.getKeyOrdinal() < 0 || this.inOrdinals.getValueOrdinal() < 0) {
                        throw new KettleException("key or value is not defined in transformation injector step");
                    }
                    if (this.injectorRowMeta.getValueMeta(this.inOrdinals.getKeyOrdinal()) != null) {
                        this.inConverterK = this.typeConverterFactory.getConverter(key.getClass(), this.injectorRowMeta.getValueMeta(this.inOrdinals.getKeyOrdinal()));
                    }
                    if (values.hasNext()) {
                        this.value = values.next();
                    }
                    if (this.value != null && this.injectorRowMeta.getValueMeta(this.inOrdinals.getValueOrdinal()) != null) {
                        this.inConverterV = this.typeConverterFactory.getConverter(this.value.getClass(), this.injectorRowMeta.getValueMeta(this.inOrdinals.getValueOrdinal()));
                    }
                }
                this.trans.startThreads();
            } else {
                this.setDebugStatus(reporter, "No input stepname was defined");
            }
            if (this.getException() != null) {
                this.setDebugStatus(reporter, "An exception was generated by the transformation");
                throw this.getException();
            }
        } else {
            if (outputStepName != null) {
                this.setDebugStatus(reporter, "Output step [" + outputStepName + "] could not be found");
                throw new KettleException("Output step not defined in transformation");
            }
            this.setDebugStatus(reporter, "Output step name not specified");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isSingleThreaded() && this.executor != null) {
            try {
                this.executor.dispose();
            }
            catch (KettleException e) {
                e.printStackTrace(System.err);
                this.trans.getLogChannel().logError("Error disposing of single threading transformation: ", (Throwable)e);
            }
            KettleLogStore.discardLines((String)this.trans.getLogChannelId(), (boolean)true);
        }
        super.close();
    }
}

