/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che.util.ftpfile;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import org.ftp4che.util.ftpfile.FTPFile;
import org.ftp4che.util.ftpfile.FileParser;

public class NetwareFileParser
implements FileParser {
    private static final char NORMAL_FILE_IDENTIFICATION = '-';
    private static final char NORMAL_DIRECTORY_IDENTIFICATION = 'd';
    private static final String[] formatString = new String[]{"MMM dd HH:mm"};
    private SimpleDateFormat formatter;
    private Locale locale;

    public NetwareFileParser(Locale locale) {
        this.locale = locale;
    }

    public FTPFile parse(String serverString, String parentDirectory) throws ParseException {
        if (serverString.charAt(0) != 'd' && serverString.charAt(0) != '-') {
            return null;
        }
        boolean directory = serverString.charAt(0) == 'd';
        StringTokenizer st = new StringTokenizer(serverString, " ");
        st.nextToken();
        String modes = st.nextToken();
        if (modes.indexOf("-") < 0 || modes.indexOf("R") < 0 || modes.indexOf("F") < 0) {
            throw new ParseException("Couldn't identify second token as mode token: " + modes, 0);
        }
        if (modes.charAt(0) == '[' && modes.charAt(modes.length() - 1) == ']') {
            modes = modes.substring(1, modes.length() - 1);
        }
        String user = st.nextToken();
        long size = Long.parseLong(st.nextToken());
        String dateToken = "";
        while (st.countTokens() > 1) {
            dateToken = dateToken + " " + st.nextToken();
        }
        dateToken = dateToken.substring(1);
        Date date = null;
        boolean formatted = false;
        for (int i = 0; i < formatString.length; ++i) {
            try {
                this.formatter = new SimpleDateFormat(formatString[i], this.locale);
                date = this.formatter.parse(dateToken);
                formatted = true;
            }
            catch (ParseException pe) {
                try {
                    this.formatter = new SimpleDateFormat(formatString[i], Locale.ENGLISH);
                    date = this.formatter.parse(dateToken);
                    this.locale = Locale.ENGLISH;
                    formatted = true;
                }
                catch (ParseException pe2) {
                    formatted = false;
                }
            }
            if (formatted) break;
        }
        String file = st.nextToken();
        FTPFile ftpFile = new FTPFile(3, parentDirectory, file, serverString);
        ftpFile.setSize(size);
        ftpFile.setDate(date);
        ftpFile.setMode(modes);
        ftpFile.setOwner(user);
        return ftpFile;
    }
}

