/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.VersionMismatchException;
import org.apache.hadoop.io.VersionedWritable;

public class ClusterStatus
extends VersionedWritable {
    private static final byte VERSION_MASTER_BACKUPMASTERS = 2;
    private static final byte VERSION = 2;
    private String hbaseVersion;
    private Map<ServerName, HServerLoad> liveServers;
    private Collection<ServerName> deadServers;
    private ServerName master;
    private Collection<ServerName> backupMasters;
    private Map<String, AssignmentManager.RegionState> intransition;
    private String clusterId;
    private String[] masterCoprocessors;

    public ClusterStatus() {
    }

    public ClusterStatus(String hbaseVersion, String clusterid, Map<ServerName, HServerLoad> servers, Collection<ServerName> deadServers, ServerName master, Collection<ServerName> backupMasters, Map<String, AssignmentManager.RegionState> rit, String[] masterCoprocessors) {
        this.hbaseVersion = hbaseVersion;
        this.liveServers = servers;
        this.deadServers = deadServers;
        this.master = master;
        this.backupMasters = backupMasters;
        this.intransition = rit;
        this.clusterId = clusterid;
        this.masterCoprocessors = masterCoprocessors;
    }

    public Collection<ServerName> getDeadServerNames() {
        return Collections.unmodifiableCollection(this.deadServers);
    }

    public int getServersSize() {
        return this.liveServers.size();
    }

    public int getDeadServers() {
        return this.deadServers.size();
    }

    public double getAverageLoad() {
        int load = this.getRegionsCount();
        return (double)load / (double)this.getServersSize();
    }

    public int getRegionsCount() {
        int count = 0;
        for (Map.Entry<ServerName, HServerLoad> e : this.liveServers.entrySet()) {
            count += e.getValue().getNumberOfRegions();
        }
        return count;
    }

    public int getRequestsCount() {
        int count = 0;
        for (Map.Entry<ServerName, HServerLoad> e : this.liveServers.entrySet()) {
            count += e.getValue().getNumberOfRequests();
        }
        return count;
    }

    public String getHBaseVersion() {
        return this.hbaseVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterStatus)) {
            return false;
        }
        return this.getVersion() == ((ClusterStatus)((Object)o)).getVersion() && this.getHBaseVersion().equals(((ClusterStatus)((Object)o)).getHBaseVersion()) && ((Object)this.liveServers).equals(((ClusterStatus)((Object)o)).liveServers) && this.deadServers.containsAll(((ClusterStatus)((Object)o)).deadServers) && Arrays.equals(this.masterCoprocessors, ((ClusterStatus)((Object)o)).masterCoprocessors) && this.master.equals(((ClusterStatus)((Object)o)).master) && this.backupMasters.containsAll(((ClusterStatus)((Object)o)).backupMasters);
    }

    public int hashCode() {
        return 2 + this.hbaseVersion.hashCode() + ((Object)this.liveServers).hashCode() + ((Object)this.deadServers).hashCode() + this.master.hashCode() + ((Object)this.backupMasters).hashCode();
    }

    public byte getVersion() {
        return 2;
    }

    public Collection<ServerName> getServerInfo() {
        return this.getServers();
    }

    public Collection<ServerName> getServers() {
        return Collections.unmodifiableCollection(this.liveServers.keySet());
    }

    public ServerName getMaster() {
        return this.master;
    }

    public int getBackupMastersSize() {
        return this.backupMasters.size();
    }

    public Collection<ServerName> getBackupMasters() {
        return Collections.unmodifiableCollection(this.backupMasters);
    }

    public HServerLoad getLoad(ServerName sn) {
        return this.liveServers.get(sn);
    }

    public Map<String, AssignmentManager.RegionState> getRegionsInTransition() {
        return this.intransition;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String[] getMasterCoprocessors() {
        return this.masterCoprocessors;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.hbaseVersion);
        out.writeInt(this.getServersSize());
        for (Map.Entry<ServerName, HServerLoad> entry : this.liveServers.entrySet()) {
            Bytes.writeByteArray(out, entry.getKey().getVersionedBytes());
            entry.getValue().write(out);
        }
        out.writeInt(this.deadServers.size());
        for (ServerName serverName : this.deadServers) {
            Bytes.writeByteArray(out, serverName.getVersionedBytes());
        }
        out.writeInt(this.intransition.size());
        for (Map.Entry entry : this.intransition.entrySet()) {
            out.writeUTF((String)entry.getKey());
            ((AssignmentManager.RegionState)entry.getValue()).write(out);
        }
        out.writeUTF(this.clusterId);
        out.writeInt(this.masterCoprocessors.length);
        for (String masterCoprocessor : this.masterCoprocessors) {
            out.writeUTF(masterCoprocessor);
        }
        Bytes.writeByteArray(out, this.master.getVersionedBytes());
        out.writeInt(this.backupMasters.size());
        for (ServerName serverName : this.backupMasters) {
            Bytes.writeByteArray(out, serverName.getVersionedBytes());
        }
    }

    public void readFields(DataInput in) throws IOException {
        int i;
        int i2;
        int version = this.getVersion();
        try {
            super.readFields(in);
        }
        catch (VersionMismatchException e) {
            int startIndex = e.toString().lastIndexOf(118) + 1;
            version = Integer.parseInt(e.toString().substring(startIndex));
        }
        this.hbaseVersion = in.readUTF();
        int count = in.readInt();
        this.liveServers = new HashMap<ServerName, HServerLoad>(count);
        for (i2 = 0; i2 < count; ++i2) {
            byte[] versionedBytes = Bytes.readByteArray(in);
            HServerLoad hsl = new HServerLoad();
            hsl.readFields(in);
            this.liveServers.put(ServerName.parseVersionedServerName(versionedBytes), hsl);
        }
        count = in.readInt();
        this.deadServers = new ArrayList<ServerName>(count);
        for (i2 = 0; i2 < count; ++i2) {
            this.deadServers.add(ServerName.parseVersionedServerName(Bytes.readByteArray(in)));
        }
        count = in.readInt();
        this.intransition = new TreeMap<String, AssignmentManager.RegionState>();
        for (i2 = 0; i2 < count; ++i2) {
            String key = in.readUTF();
            AssignmentManager.RegionState regionState = new AssignmentManager.RegionState();
            regionState.readFields(in);
            this.intransition.put(key, regionState);
        }
        this.clusterId = in.readUTF();
        int masterCoprocessorsLength = in.readInt();
        this.masterCoprocessors = new String[masterCoprocessorsLength];
        for (i = 0; i < masterCoprocessorsLength; ++i) {
            this.masterCoprocessors[i] = in.readUTF();
        }
        if (version >= 2) {
            this.master = ServerName.parseVersionedServerName(Bytes.readByteArray(in));
            count = in.readInt();
            this.backupMasters = new ArrayList<ServerName>(count);
            for (i = 0; i < count; ++i) {
                this.backupMasters.add(ServerName.parseVersionedServerName(Bytes.readByteArray(in)));
            }
        } else {
            this.master = new ServerName("#unknown#", -1, -1L);
            this.backupMasters = new ArrayList<ServerName>(0);
        }
    }
}

