/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.catalog;

import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.ipc.RemoteException;

public class MetaReader {
    private static final Log LOG = LogFactory.getLog(MetaReader.class);
    static final byte[] META_REGION_PREFIX;

    private static boolean isRootTableRow(byte[] row) {
        if (row.length < META_REGION_PREFIX.length + 2) {
            return false;
        }
        return Bytes.equals(row, 0, META_REGION_PREFIX.length, META_REGION_PREFIX, 0, META_REGION_PREFIX.length);
    }

    public static Map<HRegionInfo, ServerName> fullScan(CatalogTracker catalogTracker, Set<String> disabledTables) throws IOException {
        return MetaReader.fullScan(catalogTracker, disabledTables, false);
    }

    public static Map<HRegionInfo, ServerName> fullScan(CatalogTracker catalogTracker, final Set<String> disabledTables, final boolean excludeOfflinedSplitParents) throws IOException {
        final TreeMap<HRegionInfo, ServerName> regions = new TreeMap<HRegionInfo, ServerName>();
        Visitor v = new Visitor(){

            @Override
            public boolean visit(Result r) throws IOException {
                if (r == null || r.isEmpty()) {
                    return true;
                }
                Pair<HRegionInfo, ServerName> region = MetaReader.parseCatalogResult(r);
                if (region == null) {
                    return true;
                }
                HRegionInfo hri = region.getFirst();
                if (hri == null) {
                    return true;
                }
                if (hri.getTableNameAsString() == null) {
                    return true;
                }
                if (disabledTables.contains(hri.getTableNameAsString())) {
                    return true;
                }
                if (excludeOfflinedSplitParents && hri.isSplitParent()) {
                    return true;
                }
                regions.put(hri, region.getSecond());
                return true;
            }
        };
        MetaReader.fullScan(catalogTracker, v);
        return regions;
    }

    public static List<Result> fullScan(CatalogTracker catalogTracker) throws IOException {
        CollectAllVisitor v = new CollectAllVisitor();
        MetaReader.fullScan(catalogTracker, v, null);
        return v.getResults();
    }

    public static List<Result> fullScanOfRoot(CatalogTracker catalogTracker) throws IOException {
        CollectAllVisitor v = new CollectAllVisitor();
        MetaReader.fullScan(catalogTracker, (Visitor)v, null, true);
        return v.getResults();
    }

    public static void fullScan(CatalogTracker catalogTracker, Visitor visitor) throws IOException {
        MetaReader.fullScan(catalogTracker, visitor, null);
    }

    public static void fullScan(CatalogTracker catalogTracker, Visitor visitor, byte[] startrow) throws IOException {
        MetaReader.fullScan(catalogTracker, visitor, startrow, false);
    }

    private static HTable getHTable(CatalogTracker catalogTracker, byte[] tableName) throws IOException {
        HConnection c = catalogTracker.getConnection();
        if (c == null) {
            throw new NullPointerException("No connection");
        }
        return new HTable(catalogTracker.getConnection().getConfiguration(), tableName);
    }

    static HTable getCatalogHTable(CatalogTracker catalogTracker, byte[] row) throws IOException {
        return MetaReader.isRootTableRow(row) ? MetaReader.getRootHTable(catalogTracker) : MetaReader.getMetaHTable(catalogTracker);
    }

    static HTable getMetaHTable(CatalogTracker ct) throws IOException {
        return MetaReader.getHTable(ct, HConstants.META_TABLE_NAME);
    }

    static HTable getRootHTable(CatalogTracker ct) throws IOException {
        return MetaReader.getHTable(ct, HConstants.ROOT_TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Result get(HTable t, Get g) throws IOException {
        try {
            Result result = t.get(g);
            return result;
        }
        finally {
            t.close();
        }
    }

    public static ServerName readMetaLocation(HRegionInterface metaServer) throws IOException {
        return MetaReader.readLocation(metaServer, CatalogTracker.ROOT_REGION_NAME, CatalogTracker.META_REGION_NAME);
    }

    static ServerName getMetaRegionLocation(CatalogTracker ct) throws IOException {
        return MetaReader.readRegionLocation(ct, CatalogTracker.META_REGION_NAME);
    }

    static ServerName readRegionLocation(CatalogTracker catalogTracker, byte[] regionName) throws IOException {
        Pair<HRegionInfo, ServerName> pair = MetaReader.getRegion(catalogTracker, regionName);
        return pair == null || pair.getSecond() == null ? null : pair.getSecond();
    }

    private static ServerName readLocation(HRegionInterface metaServer, byte[] catalogRegionName, byte[] regionName) throws IOException {
        Result r;
        block7: {
            r = null;
            try {
                r = metaServer.get(catalogRegionName, new Get(regionName).addColumn(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER).addColumn(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER));
            }
            catch (SocketTimeoutException e) {
            }
            catch (SocketException e) {
            }
            catch (RemoteException re) {
                IOException ioe = re.unwrapRemoteException();
                if (!(ioe instanceof NotServingRegionException) && !ioe.getMessage().contains("Server not running")) {
                    throw re;
                }
            }
            catch (IOException e) {
                if (e.getCause() != null && e.getCause() instanceof IOException && e.getCause().getMessage() != null && e.getCause().getMessage().contains("Connection reset by peer")) break block7;
                throw e;
            }
        }
        if (r == null || r.isEmpty()) {
            return null;
        }
        return MetaReader.getServerNameFromCatalogResult(r);
    }

    public static Pair<HRegionInfo, ServerName> getRegion(CatalogTracker catalogTracker, byte[] regionName) throws IOException {
        Get get2 = new Get(regionName);
        get2.addFamily(HConstants.CATALOG_FAMILY);
        Result r = MetaReader.get(MetaReader.getCatalogHTable(catalogTracker, regionName), get2);
        return r == null || r.isEmpty() ? null : MetaReader.parseCatalogResult(r);
    }

    public static ServerName getServerNameFromCatalogResult(Result r) {
        byte[] value = r.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
        if (value == null || value.length == 0) {
            return null;
        }
        String hostAndPort = Bytes.toString(value);
        value = r.getValue(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER);
        if (value == null || value.length == 0) {
            return null;
        }
        return new ServerName(hostAndPort, Bytes.toLong(value));
    }

    public static Pair<HRegionInfo, ServerName> parseCatalogResult(Result r) throws IOException {
        HRegionInfo info = MetaReader.parseHRegionInfoFromCatalogResult(r, HConstants.REGIONINFO_QUALIFIER);
        ServerName sn = MetaReader.getServerNameFromCatalogResult(r);
        return new Pair<HRegionInfo, ServerName>(info, sn);
    }

    public static HRegionInfo parseHRegionInfoFromCatalogResult(Result r, byte[] qualifier) throws IOException {
        byte[] bytes = r.getValue(HConstants.CATALOG_FAMILY, qualifier);
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        return Writables.getHRegionInfoOrNull(bytes);
    }

    public static boolean tableExists(CatalogTracker catalogTracker, String tableName) throws IOException {
        if (tableName.equals(HTableDescriptor.ROOT_TABLEDESC.getNameAsString()) || tableName.equals(HTableDescriptor.META_TABLEDESC.getNameAsString())) {
            return true;
        }
        final byte[] tableNameBytes = Bytes.toBytes(tableName);
        CollectingVisitor<HRegionInfo> visitor = new CollectingVisitor<HRegionInfo>(){
            private HRegionInfo current = null;

            @Override
            public boolean visit(Result r) throws IOException {
                this.current = MetaReader.parseHRegionInfoFromCatalogResult(r, HConstants.REGIONINFO_QUALIFIER);
                if (this.current == null) {
                    LOG.warn((Object)("No serialized HRegionInfo in " + r));
                    return true;
                }
                if (!MetaReader.isInsideTable(this.current, tableNameBytes)) {
                    return false;
                }
                super.visit(r);
                return false;
            }

            @Override
            void add(Result r) {
                this.results.add(this.current);
            }
        };
        MetaReader.fullScan(catalogTracker, visitor, MetaReader.getTableStartRowForMeta(tableNameBytes));
        return visitor.getResults().size() >= 1;
    }

    public static List<HRegionInfo> getTableRegions(CatalogTracker catalogTracker, byte[] tableName) throws IOException {
        return MetaReader.getTableRegions(catalogTracker, tableName, false);
    }

    public static List<HRegionInfo> getTableRegions(CatalogTracker catalogTracker, byte[] tableName, boolean excludeOfflinedSplitParents) throws IOException {
        List<Pair<HRegionInfo, ServerName>> result = null;
        try {
            result = MetaReader.getTableRegionsAndLocations(catalogTracker, tableName, excludeOfflinedSplitParents);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return MetaReader.getListOfHRegionInfos(result);
    }

    static List<HRegionInfo> getListOfHRegionInfos(List<Pair<HRegionInfo, ServerName>> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            return null;
        }
        ArrayList<HRegionInfo> result = new ArrayList<HRegionInfo>(pairs.size());
        for (Pair<HRegionInfo, ServerName> pair : pairs) {
            result.add(pair.getFirst());
        }
        return result;
    }

    static boolean isInsideTable(HRegionInfo current, byte[] tableName) {
        return Bytes.equals(tableName, current.getTableName());
    }

    static byte[] getTableStartRowForMeta(byte[] tableName) {
        byte[] startRow = new byte[tableName.length + 2];
        System.arraycopy(tableName, 0, startRow, 0, tableName.length);
        startRow[startRow.length - 2] = 44;
        startRow[startRow.length - 1] = 44;
        return startRow;
    }

    public static Scan getScanForTableName(byte[] tableName) {
        String strName = Bytes.toString(tableName);
        byte[] startKey = Bytes.toBytes(strName + ",,");
        byte[] stopKey = Bytes.toBytes(strName + " ,,");
        Scan scan = new Scan(startKey);
        scan.setStopRow(stopKey);
        return scan;
    }

    public static List<Pair<HRegionInfo, ServerName>> getTableRegionsAndLocations(CatalogTracker catalogTracker, String tableName) throws IOException, InterruptedException {
        return MetaReader.getTableRegionsAndLocations(catalogTracker, Bytes.toBytes(tableName), true);
    }

    public static List<Pair<HRegionInfo, ServerName>> getTableRegionsAndLocations(CatalogTracker catalogTracker, final byte[] tableName, final boolean excludeOfflinedSplitParents) throws IOException, InterruptedException {
        if (Bytes.equals(tableName, HConstants.ROOT_TABLE_NAME)) {
            ServerName serverName = catalogTracker.getRootLocation();
            ArrayList<Pair<HRegionInfo, ServerName>> list = new ArrayList<Pair<HRegionInfo, ServerName>>();
            list.add(new Pair<HRegionInfo, ServerName>(HRegionInfo.ROOT_REGIONINFO, serverName));
            return list;
        }
        CollectingVisitor<Pair<HRegionInfo, ServerName>> visitor = new CollectingVisitor<Pair<HRegionInfo, ServerName>>(){
            private Pair<HRegionInfo, ServerName> current = null;

            @Override
            public boolean visit(Result r) throws IOException {
                HRegionInfo hri = MetaReader.parseHRegionInfoFromCatalogResult(r, HConstants.REGIONINFO_QUALIFIER);
                if (hri == null) {
                    LOG.warn((Object)("No serialized HRegionInfo in " + r));
                    return true;
                }
                if (!MetaReader.isInsideTable(hri, tableName)) {
                    return false;
                }
                if (excludeOfflinedSplitParents && hri.isSplitParent()) {
                    return true;
                }
                ServerName sn = MetaReader.getServerNameFromCatalogResult(r);
                this.current = new Pair<HRegionInfo, ServerName>(hri, sn);
                return super.visit(r);
            }

            @Override
            void add(Result r) {
                this.results.add(this.current);
            }
        };
        MetaReader.fullScan(catalogTracker, (Visitor)visitor, MetaReader.getTableStartRowForMeta(tableName), Bytes.equals(tableName, HConstants.META_TABLE_NAME));
        return visitor.getResults();
    }

    public static NavigableMap<HRegionInfo, Result> getServerUserRegions(CatalogTracker catalogTracker, final ServerName serverName) throws IOException {
        TreeMap<HRegionInfo, Result> hris = new TreeMap<HRegionInfo, Result>();
        CollectingVisitor<Result> v = new CollectingVisitor<Result>(){

            @Override
            void add(Result r) {
                if (r == null || r.isEmpty()) {
                    return;
                }
                ServerName sn = MetaReader.getServerNameFromCatalogResult(r);
                if (sn != null && sn.equals(serverName)) {
                    this.results.add(r);
                }
            }
        };
        MetaReader.fullScan(catalogTracker, v);
        List results = v.getResults();
        if (results != null && !results.isEmpty()) {
            for (Result r : results) {
                Pair<HRegionInfo, ServerName> p = MetaReader.parseCatalogResult(r);
                if (p == null || p.getFirst() == null) continue;
                hris.put(p.getFirst(), r);
            }
        }
        return hris;
    }

    public static void fullScanMetaAndPrint(CatalogTracker catalogTracker) throws IOException {
        Visitor v = new Visitor(){

            @Override
            public boolean visit(Result r) throws IOException {
                if (r == null || r.isEmpty()) {
                    return true;
                }
                LOG.info((Object)("fullScanMetaAndPrint.Current Meta Row: " + r));
                HRegionInfo hrim = MetaEditor.getHRegionInfo(r);
                LOG.info((Object)("fullScanMetaAndPrint.HRI Print= " + (Object)((Object)hrim)));
                return true;
            }
        };
        MetaReader.fullScan(catalogTracker, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fullScan(HRegionInterface hRegionInterface, Visitor visitor, byte[] regionName, byte[] startrow) throws IOException {
        if (hRegionInterface == null) {
            return;
        }
        Scan scan = new Scan();
        if (startrow != null) {
            scan.setStartRow(startrow);
        }
        scan.addFamily(HConstants.CATALOG_FAMILY);
        long scannerid = hRegionInterface.openScanner(regionName, scan);
        try {
            Result data;
            while ((data = hRegionInterface.next(scannerid)) != null) {
                if (data.isEmpty()) continue;
                visitor.visit(data);
            }
        }
        finally {
            hRegionInterface.close(scannerid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fullScan(CatalogTracker catalogTracker, Visitor visitor, byte[] startrow, boolean scanRoot) throws IOException {
        Scan scan = new Scan();
        if (startrow != null) {
            scan.setStartRow(startrow);
        }
        if (startrow == null && !scanRoot) {
            int caching = catalogTracker.getConnection().getConfiguration().getInt(HConstants.HBASE_META_SCANNER_CACHING, 100);
            scan.setCaching(caching);
        }
        scan.addFamily(HConstants.CATALOG_FAMILY);
        HTable metaTable = scanRoot ? MetaReader.getRootHTable(catalogTracker) : MetaReader.getMetaHTable(catalogTracker);
        ResultScanner scanner = metaTable.getScanner(scan);
        try {
            Result data;
            while ((data = scanner.next()) != null && (data.isEmpty() || visitor.visit(data))) {
            }
        }
        finally {
            scanner.close();
            metaTable.close();
        }
    }

    static {
        int len = HRegionInfo.FIRST_META_REGIONINFO.getRegionName().length - 2;
        META_REGION_PREFIX = new byte[len];
        System.arraycopy(HRegionInfo.FIRST_META_REGIONINFO.getRegionName(), 0, META_REGION_PREFIX, 0, len);
    }

    static class CollectAllVisitor
    extends CollectingVisitor<Result> {
        CollectAllVisitor() {
        }

        @Override
        void add(Result r) {
            this.results.add(r);
        }
    }

    static abstract class CollectingVisitor<T>
    implements Visitor {
        final List<T> results = new ArrayList<T>();

        CollectingVisitor() {
        }

        @Override
        public boolean visit(Result r) throws IOException {
            if (r == null || r.isEmpty()) {
                return true;
            }
            this.add(r);
            return true;
        }

        abstract void add(Result var1);

        List<T> getResults() {
            return this.results;
        }
    }

    public static interface Visitor {
        public boolean visit(Result var1) throws IOException;
    }
}

