/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;

public class Delete
extends Mutation
implements Writable,
Comparable<Row> {
    private static final byte DELETE_VERSION = 3;

    public Delete() {
        this((byte[])null);
    }

    public Delete(byte[] row) {
        this(row, Long.MAX_VALUE, null);
    }

    public Delete(byte[] row, long timestamp) {
        this.row = row;
        this.ts = timestamp;
    }

    public Delete(byte[] row, long timestamp, RowLock rowLock) {
        this.row = row;
        this.ts = timestamp;
        if (rowLock != null) {
            this.lockId = rowLock.getLockId();
        }
    }

    public Delete(Delete d) {
        this.row = d.getRow();
        this.ts = d.getTimeStamp();
        this.lockId = d.getLockId();
        this.familyMap.putAll(d.getFamilyMap());
        this.writeToWAL = d.writeToWAL;
    }

    public Delete addDeleteMarker(KeyValue kv) throws IOException {
        if (!kv.isDelete()) {
            throw new IOException("The recently added KeyValue is not of type delete. Rowkey: " + Bytes.toStringBinary(this.row));
        }
        if (Bytes.compareTo(this.row, 0, this.row.length, kv.getBuffer(), kv.getRowOffset(), kv.getRowLength()) != 0) {
            throw new IOException("The row in the recently added KeyValue " + Bytes.toStringBinary(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength()) + " doesn't match the original one " + Bytes.toStringBinary(this.row));
        }
        byte[] family = kv.getFamily();
        ArrayList<KeyValue> list = (ArrayList<KeyValue>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>();
        }
        list.add(kv);
        this.familyMap.put(family, list);
        return this;
    }

    public Delete deleteFamily(byte[] family) {
        this.deleteFamily(family, Long.MAX_VALUE);
        return this;
    }

    public Delete deleteFamily(byte[] family, long timestamp) {
        ArrayList<KeyValue> list = (ArrayList<KeyValue>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>();
        } else if (!list.isEmpty()) {
            list.clear();
        }
        list.add(new KeyValue(this.row, family, null, timestamp, KeyValue.Type.DeleteFamily));
        this.familyMap.put(family, list);
        return this;
    }

    public Delete deleteColumns(byte[] family, byte[] qualifier) {
        this.deleteColumns(family, qualifier, Long.MAX_VALUE);
        return this;
    }

    public Delete deleteColumns(byte[] family, byte[] qualifier, long timestamp) {
        ArrayList<KeyValue> list = (ArrayList<KeyValue>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>();
        }
        list.add(new KeyValue(this.row, family, qualifier, timestamp, KeyValue.Type.DeleteColumn));
        this.familyMap.put(family, list);
        return this;
    }

    public Delete deleteColumn(byte[] family, byte[] qualifier) {
        this.deleteColumn(family, qualifier, Long.MAX_VALUE);
        return this;
    }

    public Delete deleteColumn(byte[] family, byte[] qualifier, long timestamp) {
        ArrayList<KeyValue> list = (ArrayList<KeyValue>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>();
        }
        list.add(new KeyValue(this.row, family, qualifier, timestamp, KeyValue.Type.Delete));
        this.familyMap.put(family, list);
        return this;
    }

    public void setTimestamp(long timestamp) {
        this.ts = timestamp;
    }

    @Override
    public Map<String, Object> toMap(int maxCols) {
        Map<String, Object> map = super.toMap(maxCols);
        map.put("ts", this.ts);
        return map;
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version > 3) {
            throw new IOException("version not supported");
        }
        this.row = Bytes.readByteArray(in);
        this.ts = in.readLong();
        this.lockId = in.readLong();
        if (version > 2) {
            this.writeToWAL = in.readBoolean();
        }
        this.familyMap.clear();
        int numFamilies = in.readInt();
        for (int i = 0; i < numFamilies; ++i) {
            byte[] family = Bytes.readByteArray(in);
            int numColumns = in.readInt();
            ArrayList<KeyValue> list = new ArrayList<KeyValue>(numColumns);
            for (int j = 0; j < numColumns; ++j) {
                KeyValue kv = new KeyValue();
                kv.readFields(in);
                list.add(kv);
            }
            this.familyMap.put(family, list);
        }
        if (version > 1) {
            this.readAttributes(in);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(3);
        Bytes.writeByteArray(out, this.row);
        out.writeLong(this.ts);
        out.writeLong(this.lockId);
        out.writeBoolean(this.writeToWAL);
        out.writeInt(this.familyMap.size());
        for (Map.Entry entry : this.familyMap.entrySet()) {
            Bytes.writeByteArray(out, (byte[])entry.getKey());
            List list = (List)entry.getValue();
            out.writeInt(list.size());
            for (KeyValue kv : list) {
                kv.write(out);
            }
        }
        this.writeAttributes(out);
    }
}

