/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.util.StringUtils;

public class MultiResponse
implements Writable {
    private Map<byte[], List<Pair<Integer, Object>>> results = new TreeMap<byte[], List<Pair<Integer, Object>>>(Bytes.BYTES_COMPARATOR);

    public int size() {
        int size = 0;
        for (List<Pair<Integer, Object>> c : this.results.values()) {
            size += c.size();
        }
        return size;
    }

    public void add(byte[] regionName, Pair<Integer, Object> r) {
        List<Pair<Integer, Object>> rs = this.results.get(regionName);
        if (rs == null) {
            rs = new ArrayList<Pair<Integer, Object>>();
            this.results.put(regionName, rs);
        }
        rs.add(r);
    }

    public void add(byte[] regionName, int originalIndex, Object resOrEx) {
        this.add(regionName, new Pair<Integer, Object>(originalIndex, resOrEx));
    }

    public Map<byte[], List<Pair<Integer, Object>>> getResults() {
        return this.results;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.results.size());
        for (Map.Entry<byte[], List<Pair<Integer, Object>>> e : this.results.entrySet()) {
            Bytes.writeByteArray(out, e.getKey());
            List<Pair<Integer, Object>> lst = e.getValue();
            out.writeInt(lst.size());
            for (Pair<Integer, Object> r : lst) {
                if (r == null) {
                    out.writeInt(-1);
                    continue;
                }
                out.writeInt(r.getFirst());
                Object obj = r.getSecond();
                if (obj instanceof Throwable) {
                    out.writeBoolean(true);
                    Throwable t = (Throwable)obj;
                    WritableUtils.writeString((DataOutput)out, (String)t.getClass().getName());
                    WritableUtils.writeString((DataOutput)out, (String)StringUtils.stringifyException((Throwable)t));
                    continue;
                }
                out.writeBoolean(false);
                if (!(obj instanceof Writable)) {
                    obj = null;
                }
                HbaseObjectWritable.writeObject(out, r.getSecond(), obj != null ? obj.getClass() : Writable.class, null);
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.results.clear();
        int mapSize = in.readInt();
        for (int i = 0; i < mapSize; ++i) {
            byte[] key = Bytes.readByteArray(in);
            int listSize = in.readInt();
            ArrayList<Pair<Integer, Object>> lst = new ArrayList<Pair<Integer, Object>>(listSize);
            for (int j = 0; j < listSize; ++j) {
                Integer idx = in.readInt();
                if (idx == -1) {
                    lst.add(null);
                    continue;
                }
                boolean isException = in.readBoolean();
                Object o = null;
                if (isException) {
                    String klass = WritableUtils.readString((DataInput)in);
                    String desc = WritableUtils.readString((DataInput)in);
                    try {
                        Class<?> c = Class.forName(klass);
                        Constructor<?> cn = c.getDeclaredConstructor(String.class);
                        o = cn.newInstance(desc);
                    }
                    catch (ClassNotFoundException ignored) {
                    }
                    catch (NoSuchMethodException ignored) {
                    }
                    catch (InvocationTargetException ignored) {
                    }
                    catch (InstantiationException ignored) {
                    }
                    catch (IllegalAccessException ignored) {}
                } else {
                    o = HbaseObjectWritable.readObject(in, null);
                }
                lst.add(new Pair<Integer, Object>(idx, o));
            }
            this.results.put(key, lst);
        }
    }
}

