/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.executor;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Server;

public abstract class EventHandler
implements Runnable,
Comparable<Runnable> {
    private static final Log LOG = LogFactory.getLog(EventHandler.class);
    protected EventType eventType;
    protected Server server;
    protected static AtomicLong seqids = new AtomicLong(0L);
    private final long seqid;
    private EventHandlerListener listener;
    protected final int waitingTimeForEvents;

    public EventHandler(Server server, EventType eventType) {
        this.server = server;
        this.eventType = eventType;
        this.seqid = seqids.incrementAndGet();
        this.waitingTimeForEvents = server.getConfiguration().getInt("hbase.master.event.waiting.time", 1000);
    }

    @Override
    public void run() {
        try {
            if (this.getListener() != null) {
                this.getListener().beforeProcess(this);
            }
            this.process();
            if (this.getListener() != null) {
                this.getListener().afterProcess(this);
            }
        }
        catch (Throwable t) {
            LOG.error((Object)("Caught throwable while processing event " + (Object)((Object)this.eventType)), t);
        }
    }

    public abstract void process() throws IOException;

    public EventType getEventType() {
        return this.eventType;
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public long getSeqid() {
        return this.seqid;
    }

    @Override
    public int compareTo(Runnable o) {
        EventHandler eh = (EventHandler)o;
        if (this.getPriority() != eh.getPriority()) {
            return this.getPriority() < eh.getPriority() ? -1 : 1;
        }
        return this.seqid < eh.seqid ? -1 : 1;
    }

    public synchronized EventHandlerListener getListener() {
        return this.listener;
    }

    public synchronized void setListener(EventHandlerListener listener) {
        this.listener = listener;
    }

    public String toString() {
        return "Event #" + this.getSeqid() + " of type " + (Object)((Object)this.eventType) + " (" + this.getInformativeName() + ")";
    }

    public String getInformativeName() {
        return this.getClass().toString();
    }

    public static enum EventType {
        RS_ZK_REGION_CLOSED(2),
        RS_ZK_REGION_OPENING(3),
        RS_ZK_REGION_OPENED(4),
        RS_ZK_REGION_SPLITTING(5),
        RS_ZK_REGION_SPLIT(6),
        RS_ZK_REGION_FAILED_OPEN(7),
        M_RS_OPEN_REGION(20),
        M_RS_OPEN_ROOT(21),
        M_RS_OPEN_META(22),
        M_RS_CLOSE_REGION(23),
        M_RS_CLOSE_ROOT(24),
        M_RS_CLOSE_META(25),
        C_M_DELETE_TABLE(40),
        C_M_DISABLE_TABLE(41),
        C_M_ENABLE_TABLE(42),
        C_M_MODIFY_TABLE(43),
        C_M_ADD_FAMILY(44),
        C_M_DELETE_FAMILY(45),
        C_M_MODIFY_FAMILY(46),
        C_M_CREATE_TABLE(47),
        M_ZK_REGION_OFFLINE(50),
        M_ZK_REGION_CLOSING(51),
        M_SERVER_SHUTDOWN(70),
        M_META_SERVER_SHUTDOWN(72);


        private EventType(int value) {
        }

        public boolean isOnlineSchemaChangeSupported() {
            return this.equals((Object)C_M_ADD_FAMILY) || this.equals((Object)C_M_DELETE_FAMILY) || this.equals((Object)C_M_MODIFY_FAMILY) || this.equals((Object)C_M_MODIFY_TABLE);
        }
    }

    public static interface EventHandlerListener {
        public void beforeProcess(EventHandler var1);

        public void afterProcess(EventHandler var1);
    }
}

