/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Exec;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BitComparator;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.DependentColumnFilter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RandomRowFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.io.DataOutputOutputStream;
import org.apache.hadoop.hbase.io.HbaseMapWritable;
import org.apache.hadoop.hbase.io.WritableWithSize;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionOpeningState;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ProtoUtil;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableUtils;

public class HbaseObjectWritable
implements Writable,
WritableWithSize,
Configurable {
    protected static final Log LOG = LogFactory.getLog(HbaseObjectWritable.class);
    static final Map<Integer, Class<?>> CODE_TO_CLASS = new HashMap();
    static final Map<Class<?>, Integer> CLASS_TO_CODE = new HashMap();
    private static final byte NOT_ENCODED = 0;
    private static final int GENERIC_ARRAY_CODE;
    private static final int NEXT_CLASS_CODE;
    private Class<?> declaredClass;
    private Object instance;
    private Configuration conf;

    public HbaseObjectWritable() {
    }

    public HbaseObjectWritable(Object instance) {
        this.set(instance);
    }

    public HbaseObjectWritable(Class<?> declaredClass, Object instance) {
        this.declaredClass = declaredClass;
        this.instance = instance;
    }

    public Object get() {
        return this.instance;
    }

    public Class<?> getDeclaredClass() {
        return this.declaredClass;
    }

    public void set(Object instance) {
        this.declaredClass = instance.getClass();
        this.instance = instance;
    }

    public String toString() {
        return "OW[class=" + this.declaredClass + ",value=" + this.instance + "]";
    }

    public void readFields(DataInput in) throws IOException {
        HbaseObjectWritable.readObject(in, this, this.conf);
    }

    public void write(DataOutput out) throws IOException {
        HbaseObjectWritable.writeObject(out, this.instance, this.declaredClass, this.conf);
    }

    @Override
    public long getWritableSize() {
        return HbaseObjectWritable.getWritableSize(this.instance, this.declaredClass, this.conf);
    }

    static Integer getClassCode(Class<?> c) throws IOException {
        Integer code = CLASS_TO_CODE.get(c);
        if (code == null) {
            if (List.class.isAssignableFrom(c)) {
                code = CLASS_TO_CODE.get(List.class);
            } else if (Writable.class.isAssignableFrom(c)) {
                code = CLASS_TO_CODE.get(Writable.class);
            } else if (c.isArray()) {
                code = CLASS_TO_CODE.get(Array.class);
            } else if (Message.class.isAssignableFrom(c)) {
                code = CLASS_TO_CODE.get(Message.class);
            } else if (Serializable.class.isAssignableFrom(c)) {
                code = CLASS_TO_CODE.get(Serializable.class);
            }
        }
        return code;
    }

    static int getNextClassCode() {
        return NEXT_CLASS_CODE;
    }

    static void writeClassCode(DataOutput out, Class<?> c) throws IOException {
        Integer code = HbaseObjectWritable.getClassCode(c);
        if (code == null) {
            StackTraceElement[] els;
            LOG.error((Object)("Unsupported type " + c));
            for (StackTraceElement elem : els = new Exception().getStackTrace()) {
                LOG.error((Object)elem.getMethodName());
            }
            throw new UnsupportedOperationException("No code for unexpected " + c);
        }
        WritableUtils.writeVInt((DataOutput)out, (int)code);
    }

    public static long getWritableSize(Object instance, Class declaredClass, Configuration conf) {
        long size = 1L;
        if (instance == null) {
            return 0L;
        }
        if (declaredClass.isArray() && declaredClass.equals(Result[].class)) {
            return size + Result.getWriteArraySize((Result[])instance);
        }
        if (declaredClass.equals(Result.class)) {
            Result r = (Result)instance;
            return r.getWritableSize() + size + 1L;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(DataOutput out, Object instance, Class declaredClass, Configuration conf) throws IOException {
        Object instanceObj = instance;
        Class<Writable> declClass = declaredClass;
        if (instanceObj == null) {
            instanceObj = new NullInstance(declClass, conf);
            declClass = Writable.class;
        }
        HbaseObjectWritable.writeClassCode(out, declClass);
        if (declClass.isArray()) {
            if (declClass.equals(byte[].class)) {
                Bytes.writeByteArray(out, (byte[])instanceObj);
            } else if (declClass.equals(Result[].class)) {
                Result.writeArray(out, (Result[])instanceObj);
            } else {
                if (HbaseObjectWritable.getClassCode(declaredClass) == GENERIC_ARRAY_CODE) {
                    Class<?> componentType = declaredClass.getComponentType();
                    HbaseObjectWritable.writeClass(out, componentType);
                }
                int length = Array.getLength(instanceObj);
                out.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    Object item = Array.get(instanceObj, i);
                    HbaseObjectWritable.writeObject(out, item, item.getClass(), conf);
                }
            }
        } else if (List.class.isAssignableFrom(declClass)) {
            List list = (List)instanceObj;
            int length = list.size();
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                Object elem;
                HbaseObjectWritable.writeObject(out, elem, (elem = list.get(i)) == null ? Writable.class : elem.getClass(), conf);
            }
        } else if (declClass == String.class) {
            Text.writeString((DataOutput)out, (String)((String)instanceObj));
        } else if (declClass.isPrimitive()) {
            if (declClass == Boolean.TYPE) {
                out.writeBoolean((Boolean)instanceObj);
            } else if (declClass == Character.TYPE) {
                out.writeChar(((Character)instanceObj).charValue());
            } else if (declClass == Byte.TYPE) {
                out.writeByte(((Byte)instanceObj).byteValue());
            } else if (declClass == Short.TYPE) {
                out.writeShort(((Short)instanceObj).shortValue());
            } else if (declClass == Integer.TYPE) {
                out.writeInt((Integer)instanceObj);
            } else if (declClass == Long.TYPE) {
                out.writeLong((Long)instanceObj);
            } else if (declClass == Float.TYPE) {
                out.writeFloat(((Float)instanceObj).floatValue());
            } else if (declClass == Double.TYPE) {
                out.writeDouble((Double)instanceObj);
            } else if (declClass != Void.TYPE) {
                throw new IllegalArgumentException("Not a primitive: " + declClass);
            }
        } else if (declClass.isEnum()) {
            Text.writeString((DataOutput)out, (String)((Enum)instanceObj).name());
        } else if (Message.class.isAssignableFrom(declaredClass)) {
            Text.writeString((DataOutput)out, (String)instanceObj.getClass().getName());
            ((Message)instance).writeDelimitedTo(DataOutputOutputStream.constructOutputStream(out));
        } else if (Writable.class.isAssignableFrom(declClass)) {
            Class<?> c = instanceObj.getClass();
            Integer code = CLASS_TO_CODE.get(c);
            if (code == null) {
                out.writeByte(0);
                Text.writeString((DataOutput)out, (String)c.getName());
            } else {
                HbaseObjectWritable.writeClassCode(out, c);
            }
            ((Writable)instanceObj).write(out);
        } else if (Serializable.class.isAssignableFrom(declClass)) {
            Class<?> c = instanceObj.getClass();
            Integer code = CLASS_TO_CODE.get(c);
            if (code == null) {
                out.writeByte(0);
                Text.writeString((DataOutput)out, (String)c.getName());
            } else {
                HbaseObjectWritable.writeClassCode(out, c);
            }
            ByteArrayOutputStream bos = null;
            ObjectOutputStream oos = null;
            try {
                bos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(bos);
                oos.writeObject(instanceObj);
                byte[] value = bos.toByteArray();
                out.writeInt(value.length);
                out.write(value);
            }
            finally {
                if (bos != null) {
                    bos.close();
                }
                if (oos != null) {
                    oos.close();
                }
            }
        } else {
            throw new IOException("Can't write: " + instanceObj + " as " + declClass);
        }
    }

    static void writeClass(DataOutput out, Class<?> c) throws IOException {
        Integer code = CLASS_TO_CODE.get(c);
        if (code == null) {
            WritableUtils.writeVInt((DataOutput)out, (int)0);
            Text.writeString((DataOutput)out, (String)c.getName());
        } else {
            WritableUtils.writeVInt((DataOutput)out, (int)code);
        }
    }

    static Class<?> readClass(Configuration conf, DataInput in) throws IOException {
        Class instanceClass = null;
        byte b = (byte)WritableUtils.readVInt((DataInput)in);
        if (b == 0) {
            String className = Text.readString((DataInput)in);
            try {
                instanceClass = HbaseObjectWritable.getClassByName(conf, className);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("Can't find class " + className), (Throwable)e);
                throw new IOException("Can't find class " + className, e);
            }
        } else {
            instanceClass = CODE_TO_CLASS.get(b);
        }
        return instanceClass;
    }

    public static Object readObject(DataInput in, Configuration conf) throws IOException {
        return HbaseObjectWritable.readObject(in, null, conf);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object readObject(DataInput in, HbaseObjectWritable objectWritable, Configuration conf) throws IOException {
        void var4_25;
        Class<?> declaredClass = CODE_TO_CLASS.get(WritableUtils.readVInt((DataInput)in));
        if (declaredClass.isPrimitive()) {
            if (declaredClass == Boolean.TYPE) {
                Boolean bl = in.readBoolean();
            } else if (declaredClass == Character.TYPE) {
                Character c = Character.valueOf(in.readChar());
            } else if (declaredClass == Byte.TYPE) {
                Byte by = in.readByte();
            } else if (declaredClass == Short.TYPE) {
                Short s = in.readShort();
            } else if (declaredClass == Integer.TYPE) {
                Integer n = in.readInt();
            } else if (declaredClass == Long.TYPE) {
                Long l = in.readLong();
            } else if (declaredClass == Float.TYPE) {
                Float f = Float.valueOf(in.readFloat());
            } else if (declaredClass == Double.TYPE) {
                Double d = in.readDouble();
            } else {
                if (declaredClass != Void.TYPE) throw new IllegalArgumentException("Not a primitive: " + declaredClass);
                Object var4_12 = null;
            }
        } else if (declaredClass.isArray()) {
            if (declaredClass.equals(byte[].class)) {
                byte[] byArray = Bytes.readByteArray(in);
            } else if (declaredClass.equals(Result[].class)) {
                Result[] resultArray = Result.readArray(in);
            } else {
                int length = in.readInt();
                Object object = Array.newInstance(declaredClass.getComponentType(), length);
                for (int i = 0; i < length; ++i) {
                    Array.set(object, i, HbaseObjectWritable.readObject(in, conf));
                }
            }
        } else if (declaredClass.equals(Array.class)) {
            Class<?> componentType = HbaseObjectWritable.readClass(conf, in);
            int length = in.readInt();
            Object object = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Array.set(object, i, HbaseObjectWritable.readObject(in, conf));
            }
        } else if (List.class.isAssignableFrom(declaredClass)) {
            int length = in.readInt();
            ArrayList<Object> arrayList = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                arrayList.add(HbaseObjectWritable.readObject(in, conf));
            }
        } else if (declaredClass == String.class) {
            String string = Text.readString((DataInput)in);
        } else if (declaredClass.isEnum()) {
            Object obj = Enum.valueOf(declaredClass, Text.readString((DataInput)in));
        } else {
            if (declaredClass == Message.class) {
                String className = Text.readString((DataInput)in);
                try {
                    declaredClass = HbaseObjectWritable.getClassByName(conf, className);
                    Message message = HbaseObjectWritable.tryInstantiateProtobuf(declaredClass, in);
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Object)("Can't find class " + className), (Throwable)e);
                    throw new IOException("Can't find class " + className, e);
                }
            }
            Class instanceClass = null;
            byte b = (byte)WritableUtils.readVInt((DataInput)in);
            if (b == 0) {
                String className = Text.readString((DataInput)in);
                try {
                    instanceClass = HbaseObjectWritable.getClassByName(conf, className);
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Object)("Can't find class " + className), (Throwable)e);
                    throw new IOException("Can't find class " + className, e);
                }
            } else {
                instanceClass = CODE_TO_CLASS.get(b);
            }
            if (Writable.class.isAssignableFrom(instanceClass)) {
                Writable writable = WritableFactories.newInstance((Class)instanceClass, (Configuration)conf);
                try {
                    writable.readFields(in);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error in readFields", (Throwable)e);
                    throw new IOException("Error in readFields", e);
                }
                Writable writable2 = writable;
                if (instanceClass == NullInstance.class) {
                    declaredClass = ((NullInstance)writable2).declaredClass;
                    Object var4_22 = null;
                }
            } else {
                int length = in.readInt();
                byte[] objectBytes = new byte[length];
                in.readFully(objectBytes);
                ByteArrayInputStream bis = null;
                ObjectInputStream ois = null;
                try {
                    bis = new ByteArrayInputStream(objectBytes);
                    ois = new ObjectInputStream(bis);
                    Object object = ois.readObject();
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Object)"Class not found when attempting to deserialize object", (Throwable)e);
                    throw new IOException("Class not found when attempting to deserialize object", e);
                }
                finally {
                    if (bis != null) {
                        bis.close();
                    }
                    if (ois != null) {
                        ois.close();
                    }
                }
            }
        }
        if (objectWritable == null) return var4_25;
        objectWritable.declaredClass = declaredClass;
        objectWritable.instance = var4_25;
        return var4_25;
    }

    private static Message tryInstantiateProtobuf(Class<?> protoClass, DataInput dataIn) throws IOException {
        try {
            if (dataIn instanceof InputStream) {
                Method parseMethod = HbaseObjectWritable.getStaticProtobufMethod(protoClass, "parseDelimitedFrom", InputStream.class);
                return (Message)parseMethod.invoke(null, (InputStream)((Object)dataIn));
            }
            int size = ProtoUtil.readRawVarint32(dataIn);
            if (size < 0) {
                throw new IOException("Invalid size: " + size);
            }
            byte[] data = new byte[size];
            dataIn.readFully(data);
            Method parseMethod = HbaseObjectWritable.getStaticProtobufMethod(protoClass, "parseFrom", byte[].class);
            return (Message)parseMethod.invoke(null, new Object[]{data});
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
        catch (IllegalAccessException iae) {
            throw new AssertionError((Object)("Could not access parse method in " + protoClass));
        }
    }

    static Method getStaticProtobufMethod(Class<?> declaredClass, String method, Class<?> ... args) {
        try {
            return declaredClass.getMethod(method, args);
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Protocol buffer class " + declaredClass + " does not have an accessible parseFrom(InputStream) method!"));
        }
    }

    private static Class getClassByName(Configuration conf, String className) throws ClassNotFoundException {
        if (conf != null) {
            return conf.getClassByName(className);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = HbaseObjectWritable.class.getClassLoader();
        }
        return Class.forName(className, true, cl);
    }

    private static void addToMap(Class<?> clazz, int code) {
        CLASS_TO_CODE.put(clazz, code);
        CODE_TO_CLASS.put(code, clazz);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    static {
        int code = 1;
        HbaseObjectWritable.addToMap(Boolean.TYPE, code++);
        HbaseObjectWritable.addToMap(Byte.TYPE, code++);
        HbaseObjectWritable.addToMap(Character.TYPE, code++);
        HbaseObjectWritable.addToMap(Short.TYPE, code++);
        HbaseObjectWritable.addToMap(Integer.TYPE, code++);
        HbaseObjectWritable.addToMap(Long.TYPE, code++);
        HbaseObjectWritable.addToMap(Float.TYPE, code++);
        HbaseObjectWritable.addToMap(Double.TYPE, code++);
        HbaseObjectWritable.addToMap(Void.TYPE, code++);
        HbaseObjectWritable.addToMap(String.class, code++);
        HbaseObjectWritable.addToMap(byte[].class, code++);
        HbaseObjectWritable.addToMap(byte[][].class, code++);
        HbaseObjectWritable.addToMap(Text.class, code++);
        HbaseObjectWritable.addToMap(Writable.class, code++);
        HbaseObjectWritable.addToMap(Writable[].class, code++);
        HbaseObjectWritable.addToMap(HbaseMapWritable.class, code++);
        HbaseObjectWritable.addToMap(NullInstance.class, code++);
        HbaseObjectWritable.addToMap(HColumnDescriptor.class, code++);
        HbaseObjectWritable.addToMap(HConstants.Modify.class, code++);
        HbaseObjectWritable.addToMap(Integer.class, code++);
        HbaseObjectWritable.addToMap(Integer[].class, code++);
        HbaseObjectWritable.addToMap(HRegion.class, code++);
        HbaseObjectWritable.addToMap(HRegion[].class, code++);
        HbaseObjectWritable.addToMap(HRegionInfo.class, code++);
        HbaseObjectWritable.addToMap(HRegionInfo[].class, code++);
        HbaseObjectWritable.addToMap(HServerAddress.class, code++);
        HbaseObjectWritable.addToMap(HServerInfo.class, code++);
        HbaseObjectWritable.addToMap(HTableDescriptor.class, code++);
        HbaseObjectWritable.addToMap(MapWritable.class, code++);
        HbaseObjectWritable.addToMap(ClusterStatus.class, code++);
        HbaseObjectWritable.addToMap(Delete.class, code++);
        HbaseObjectWritable.addToMap(Get.class, code++);
        HbaseObjectWritable.addToMap(KeyValue.class, code++);
        HbaseObjectWritable.addToMap(KeyValue[].class, code++);
        HbaseObjectWritable.addToMap(Put.class, code++);
        HbaseObjectWritable.addToMap(Put[].class, code++);
        HbaseObjectWritable.addToMap(Result.class, code++);
        HbaseObjectWritable.addToMap(Result[].class, code++);
        HbaseObjectWritable.addToMap(Scan.class, code++);
        HbaseObjectWritable.addToMap(WhileMatchFilter.class, code++);
        HbaseObjectWritable.addToMap(PrefixFilter.class, code++);
        HbaseObjectWritable.addToMap(PageFilter.class, code++);
        HbaseObjectWritable.addToMap(InclusiveStopFilter.class, code++);
        HbaseObjectWritable.addToMap(ColumnCountGetFilter.class, code++);
        HbaseObjectWritable.addToMap(SingleColumnValueFilter.class, code++);
        HbaseObjectWritable.addToMap(SingleColumnValueExcludeFilter.class, code++);
        HbaseObjectWritable.addToMap(BinaryComparator.class, code++);
        HbaseObjectWritable.addToMap(BitComparator.class, code++);
        HbaseObjectWritable.addToMap(CompareFilter.class, code++);
        HbaseObjectWritable.addToMap(RowFilter.class, code++);
        HbaseObjectWritable.addToMap(ValueFilter.class, code++);
        HbaseObjectWritable.addToMap(QualifierFilter.class, code++);
        HbaseObjectWritable.addToMap(SkipFilter.class, code++);
        HbaseObjectWritable.addToMap(WritableByteArrayComparable.class, code++);
        HbaseObjectWritable.addToMap(FirstKeyOnlyFilter.class, code++);
        HbaseObjectWritable.addToMap(DependentColumnFilter.class, code++);
        HbaseObjectWritable.addToMap(Delete[].class, code++);
        HbaseObjectWritable.addToMap(HLog.Entry.class, code++);
        HbaseObjectWritable.addToMap(HLog.Entry[].class, code++);
        HbaseObjectWritable.addToMap(HLogKey.class, code++);
        HbaseObjectWritable.addToMap(List.class, code++);
        HbaseObjectWritable.addToMap(NavigableSet.class, code++);
        HbaseObjectWritable.addToMap(ColumnPrefixFilter.class, code++);
        HbaseObjectWritable.addToMap(Row.class, code++);
        HbaseObjectWritable.addToMap(Action.class, code++);
        HbaseObjectWritable.addToMap(MultiAction.class, code++);
        HbaseObjectWritable.addToMap(MultiResponse.class, code++);
        HbaseObjectWritable.addToMap(Exec.class, code++);
        HbaseObjectWritable.addToMap(Increment.class, code++);
        HbaseObjectWritable.addToMap(KeyOnlyFilter.class, code++);
        HbaseObjectWritable.addToMap(Serializable.class, code++);
        HbaseObjectWritable.addToMap(RandomRowFilter.class, code++);
        HbaseObjectWritable.addToMap(CompareFilter.CompareOp.class, code++);
        HbaseObjectWritable.addToMap(ColumnRangeFilter.class, code++);
        HbaseObjectWritable.addToMap(HServerLoad.class, code++);
        HbaseObjectWritable.addToMap(RegionOpeningState.class, code++);
        HbaseObjectWritable.addToMap(HTableDescriptor[].class, code++);
        HbaseObjectWritable.addToMap(Append.class, code++);
        HbaseObjectWritable.addToMap(RowMutations.class, code++);
        HbaseObjectWritable.addToMap(Message.class, code++);
        GENERIC_ARRAY_CODE = code++;
        HbaseObjectWritable.addToMap(Array.class, GENERIC_ARRAY_CODE);
        HbaseObjectWritable.addToMap(FuzzyRowFilter.class, code++);
        NEXT_CLASS_CODE = code;
    }

    private static class NullInstance
    extends Configured
    implements Writable {
        Class<?> declaredClass;

        public NullInstance() {
            super(null);
        }

        public NullInstance(Class<?> declaredClass, Configuration conf) {
            super(conf);
            this.declaredClass = declaredClass;
        }

        public void readFields(DataInput in) throws IOException {
            this.declaredClass = CODE_TO_CLASS.get(WritableUtils.readVInt((DataInput)in));
        }

        public void write(DataOutput out) throws IOException {
            HbaseObjectWritable.writeClassCode(out, this.declaredClass);
        }
    }
}

