/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.ipc.ConnectionHeader;
import org.apache.hadoop.hbase.security.HBaseSaslRpcServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;

class SecureConnectionHeader
extends ConnectionHeader {
    private User user = null;
    private HBaseSaslRpcServer.AuthMethod authMethod;

    public SecureConnectionHeader() {
    }

    public SecureConnectionHeader(String protocol, User user, HBaseSaslRpcServer.AuthMethod authMethod) {
        this.protocol = protocol;
        this.user = user;
        this.authMethod = authMethod;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        boolean ugiUsernamePresent;
        this.protocol = Text.readString((DataInput)in);
        if (this.protocol.isEmpty()) {
            this.protocol = null;
        }
        if (ugiUsernamePresent = in.readBoolean()) {
            String username = in.readUTF();
            boolean realUserNamePresent = in.readBoolean();
            if (realUserNamePresent) {
                String realUserName = in.readUTF();
                UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)realUserName);
                this.user = User.create(UserGroupInformation.createProxyUser((String)username, (UserGroupInformation)realUserUgi));
            } else {
                this.user = User.create(UserGroupInformation.createRemoteUser((String)username));
            }
        } else {
            this.user = null;
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)(this.protocol == null ? "" : this.protocol));
        if (this.user != null) {
            UserGroupInformation ugi = this.user.getUGI();
            if (this.authMethod == HBaseSaslRpcServer.AuthMethod.KERBEROS) {
                out.writeBoolean(true);
                out.writeUTF(ugi.getUserName());
                out.writeBoolean(false);
            } else if (this.authMethod == HBaseSaslRpcServer.AuthMethod.DIGEST) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(ugi.getUserName());
                if (ugi.getRealUser() != null) {
                    out.writeBoolean(true);
                    out.writeUTF(ugi.getRealUser().getUserName());
                } else {
                    out.writeBoolean(false);
                }
            }
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public String toString() {
        return this.protocol + "-" + this.user;
    }
}

