/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HRegionPartitioner;
import org.apache.hadoop.hbase.mapreduce.MultiTableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.StringUtils;
import org.apache.zookeeper.ZooKeeper;

public class TableMapReduceUtil {
    static Log LOG = LogFactory.getLog(TableMapReduceUtil.class);

    public static void initTableMapperJob(String table, Scan scan, Class<? extends TableMapper> mapper, Class<? extends WritableComparable> outputKeyClass, Class<? extends Writable> outputValueClass, Job job) throws IOException {
        TableMapReduceUtil.initTableMapperJob(table, scan, mapper, outputKeyClass, outputValueClass, job, true);
    }

    public static void initTableMapperJob(byte[] table, Scan scan, Class<? extends TableMapper> mapper, Class<? extends WritableComparable> outputKeyClass, Class<? extends Writable> outputValueClass, Job job) throws IOException {
        TableMapReduceUtil.initTableMapperJob(Bytes.toString(table), scan, mapper, outputKeyClass, outputValueClass, job, true);
    }

    public static void initTableMapperJob(String table, Scan scan, Class<? extends TableMapper> mapper, Class<? extends WritableComparable> outputKeyClass, Class<? extends Writable> outputValueClass, Job job, boolean addDependencyJars, Class<? extends InputFormat> inputFormatClass) throws IOException {
        job.setInputFormatClass(inputFormatClass);
        if (outputValueClass != null) {
            job.setMapOutputValueClass(outputValueClass);
        }
        if (outputKeyClass != null) {
            job.setMapOutputKeyClass(outputKeyClass);
        }
        job.setMapperClass(mapper);
        Configuration conf = job.getConfiguration();
        HBaseConfiguration.merge(conf, HBaseConfiguration.create(conf));
        conf.set("hbase.mapreduce.inputtable", table);
        conf.set("hbase.mapreduce.scan", TableMapReduceUtil.convertScanToString(scan));
        if (addDependencyJars) {
            TableMapReduceUtil.addDependencyJars(job);
        }
        TableMapReduceUtil.initCredentials(job);
    }

    public static void initTableMapperJob(byte[] table, Scan scan, Class<? extends TableMapper> mapper, Class<? extends WritableComparable> outputKeyClass, Class<? extends Writable> outputValueClass, Job job, boolean addDependencyJars, Class<? extends InputFormat> inputFormatClass) throws IOException {
        TableMapReduceUtil.initTableMapperJob(Bytes.toString(table), scan, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, inputFormatClass);
    }

    public static void initTableMapperJob(byte[] table, Scan scan, Class<? extends TableMapper> mapper, Class<? extends WritableComparable> outputKeyClass, Class<? extends Writable> outputValueClass, Job job, boolean addDependencyJars) throws IOException {
        TableMapReduceUtil.initTableMapperJob(Bytes.toString(table), scan, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, TableInputFormat.class);
    }

    public static void initTableMapperJob(String table, Scan scan, Class<? extends TableMapper> mapper, Class<? extends WritableComparable> outputKeyClass, Class<? extends Writable> outputValueClass, Job job, boolean addDependencyJars) throws IOException {
        TableMapReduceUtil.initTableMapperJob(table, scan, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, TableInputFormat.class);
    }

    public static void initTableMapperJob(List<Scan> scans, Class<? extends TableMapper> mapper, Class<? extends WritableComparable> outputKeyClass, Class<? extends Writable> outputValueClass, Job job) throws IOException {
        TableMapReduceUtil.initTableMapperJob(scans, mapper, outputKeyClass, outputValueClass, job, true);
    }

    public static void initTableMapperJob(List<Scan> scans, Class<? extends TableMapper> mapper, Class<? extends WritableComparable> outputKeyClass, Class<? extends Writable> outputValueClass, Job job, boolean addDependencyJars) throws IOException {
        job.setInputFormatClass(MultiTableInputFormat.class);
        if (outputValueClass != null) {
            job.setMapOutputValueClass(outputValueClass);
        }
        if (outputKeyClass != null) {
            job.setMapOutputKeyClass(outputKeyClass);
        }
        job.setMapperClass(mapper);
        HBaseConfiguration.addHbaseResources(job.getConfiguration());
        ArrayList<String> scanStrings = new ArrayList<String>();
        for (Scan scan : scans) {
            scanStrings.add(TableMapReduceUtil.convertScanToString(scan));
        }
        job.getConfiguration().setStrings("hbase.mapreduce.scans", scanStrings.toArray(new String[scanStrings.size()]));
        if (addDependencyJars) {
            TableMapReduceUtil.addDependencyJars(job);
        }
    }

    public static void initCredentials(Job job) throws IOException {
        if (User.isHBaseSecurityEnabled(job.getConfiguration())) {
            try {
                String quorumAddress = job.getConfiguration().get("hbase.mapred.output.quorum");
                if (quorumAddress != null) {
                    String[] parts = ZKUtil.transformClusterKey(quorumAddress);
                    Configuration peerConf = HBaseConfiguration.create(job.getConfiguration());
                    peerConf.set("hbase.zookeeper.quorum", parts[0]);
                    peerConf.set("hbase.zookeeper.client.port", parts[1]);
                    peerConf.set("zookeeper.znode.parent", parts[2]);
                    User.getCurrent().obtainAuthTokenForJob(peerConf, job);
                }
                User.getCurrent().obtainAuthTokenForJob(job.getConfiguration(), job);
            }
            catch (InterruptedException ie) {
                LOG.info((Object)"Interrupted obtaining user authentication token");
                Thread.interrupted();
            }
        }
    }

    static String convertScanToString(Scan scan) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(out);
        scan.write(dos);
        return Base64.encodeBytes(out.toByteArray());
    }

    static Scan convertStringToScan(String base64) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(Base64.decode(base64));
        DataInputStream dis = new DataInputStream(bis);
        Scan scan = new Scan();
        scan.readFields(dis);
        return scan;
    }

    public static void initTableReducerJob(String table, Class<? extends TableReducer> reducer, Job job) throws IOException {
        TableMapReduceUtil.initTableReducerJob(table, reducer, job, null);
    }

    public static void initTableReducerJob(String table, Class<? extends TableReducer> reducer, Job job, Class partitioner) throws IOException {
        TableMapReduceUtil.initTableReducerJob(table, reducer, job, partitioner, null, null, null);
    }

    public static void initTableReducerJob(String table, Class<? extends TableReducer> reducer, Job job, Class partitioner, String quorumAddress, String serverClass, String serverImpl) throws IOException {
        TableMapReduceUtil.initTableReducerJob(table, reducer, job, partitioner, quorumAddress, serverClass, serverImpl, true);
    }

    public static void initTableReducerJob(String table, Class<? extends TableReducer> reducer, Job job, Class partitioner, String quorumAddress, String serverClass, String serverImpl, boolean addDependencyJars) throws IOException {
        Configuration conf = job.getConfiguration();
        HBaseConfiguration.merge(conf, HBaseConfiguration.create(conf));
        job.setOutputFormatClass(TableOutputFormat.class);
        if (reducer != null) {
            job.setReducerClass(reducer);
        }
        conf.set("hbase.mapred.outputtable", table);
        if (quorumAddress != null) {
            ZKUtil.transformClusterKey(quorumAddress);
            conf.set("hbase.mapred.output.quorum", quorumAddress);
        }
        if (serverClass != null && serverImpl != null) {
            conf.set("hbase.mapred.output.rs.class", serverClass);
            conf.set("hbase.mapred.output.rs.impl", serverImpl);
        }
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(Writable.class);
        if (partitioner == HRegionPartitioner.class) {
            job.setPartitionerClass(HRegionPartitioner.class);
            HTable outputTable = new HTable(conf, table);
            int regions = outputTable.getRegionsInfo().size();
            if (job.getNumReduceTasks() > regions) {
                job.setNumReduceTasks(outputTable.getRegionsInfo().size());
            }
        } else if (partitioner != null) {
            job.setPartitionerClass(partitioner);
        }
        if (addDependencyJars) {
            TableMapReduceUtil.addDependencyJars(job);
        }
        TableMapReduceUtil.initCredentials(job);
    }

    public static void limitNumReduceTasks(String table, Job job) throws IOException {
        HTable outputTable = new HTable(job.getConfiguration(), table);
        int regions = outputTable.getRegionsInfo().size();
        if (job.getNumReduceTasks() > regions) {
            job.setNumReduceTasks(regions);
        }
    }

    public static void setNumReduceTasks(String table, Job job) throws IOException {
        HTable outputTable = new HTable(job.getConfiguration(), table);
        int regions = outputTable.getRegionsInfo().size();
        job.setNumReduceTasks(regions);
    }

    public static void setScannerCaching(Job job, int batchSize) {
        job.getConfiguration().setInt("hbase.client.scanner.caching", batchSize);
    }

    public static void addDependencyJars(Job job) throws IOException {
        try {
            TableMapReduceUtil.addDependencyJars(job.getConfiguration(), ZooKeeper.class, Message.class, job.getMapOutputKeyClass(), job.getMapOutputValueClass(), job.getInputFormatClass(), job.getOutputKeyClass(), job.getOutputValueClass(), job.getOutputFormatClass(), job.getPartitionerClass(), job.getCombinerClass());
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public static void addDependencyJars(Configuration conf, Class ... classes) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        HashSet<String> jars = new HashSet<String>();
        jars.addAll(conf.getStringCollection("tmpjars"));
        for (Class clazz : classes) {
            if (clazz == null) continue;
            String pathStr = TableMapReduceUtil.findOrCreateJar(clazz);
            if (pathStr == null) {
                LOG.warn((Object)("Could not find jar for class " + clazz + " in order to ship it to the cluster."));
                continue;
            }
            Path path = new Path(pathStr);
            if (!localFs.exists(path)) {
                LOG.warn((Object)("Could not validate jar file " + path + " for class " + clazz));
                continue;
            }
            jars.add(path.makeQualified((FileSystem)localFs).toString());
        }
        if (jars.isEmpty()) {
            return;
        }
        conf.set("tmpjars", StringUtils.arrayToString((String[])jars.toArray(new String[0])));
    }

    private static String findOrCreateJar(Class my_class) throws IOException {
        try {
            Class<?> jarFinder = Class.forName("org.apache.hadoop.util.JarFinder");
            Method m = jarFinder.getMethod("getJar", Class.class);
            return (String)m.invoke(null, my_class);
        }
        catch (InvocationTargetException ite) {
            throw new IOException(ite.getCause());
        }
        catch (Exception exception) {
            LOG.debug((Object)"New JarFinder: org.apache.hadoop.util.JarFinder.getJar not available.  Using old findContainingJar");
            return TableMapReduceUtil.findContainingJar(my_class);
        }
    }

    private static String findContainingJar(Class my_class) {
        ClassLoader loader = my_class.getClassLoader();
        String class_file = my_class.getName().replaceAll("\\.", "/") + ".class";
        try {
            Enumeration<URL> itr = loader.getResources(class_file);
            while (itr.hasMoreElements()) {
                URL url = itr.nextElement();
                if (!"jar".equals(url.getProtocol())) continue;
                String toReturn = url.getPath();
                if (toReturn.startsWith("file:")) {
                    toReturn = toReturn.substring("file:".length());
                }
                toReturn = toReturn.replaceAll("\\+", "%2B");
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                return toReturn.replaceAll("!.*$", "");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

