/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.regionserver.CompactionRequestor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.SplitRequest;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;

public class CompactSplitThread
implements CompactionRequestor {
    static final Log LOG = LogFactory.getLog(CompactSplitThread.class);
    private final HRegionServer server;
    private final Configuration conf;
    private final ThreadPoolExecutor largeCompactions;
    private final ThreadPoolExecutor smallCompactions;
    private final ThreadPoolExecutor splits;
    private int regionSplitLimit;

    CompactSplitThread(HRegionServer server) {
        this.server = server;
        this.conf = server.getConfiguration();
        this.regionSplitLimit = this.conf.getInt("hbase.regionserver.regionSplitLimit", Integer.MAX_VALUE);
        int largeThreads = Math.max(1, this.conf.getInt("hbase.regionserver.thread.compaction.large", 1));
        int smallThreads = this.conf.getInt("hbase.regionserver.thread.compaction.small", 1);
        int splitThreads = this.conf.getInt("hbase.regionserver.thread.split", 1);
        Preconditions.checkArgument((largeThreads > 0 && smallThreads > 0 ? 1 : 0) != 0);
        final String n = Thread.currentThread().getName();
        this.largeCompactions = new ThreadPoolExecutor(largeThreads, largeThreads, 60L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName(n + "-largeCompactions-" + System.currentTimeMillis());
                return t;
            }
        });
        this.largeCompactions.setRejectedExecutionHandler(new CompactionRequest.Rejection());
        this.smallCompactions = new ThreadPoolExecutor(smallThreads, smallThreads, 60L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName(n + "-smallCompactions-" + System.currentTimeMillis());
                return t;
            }
        });
        this.smallCompactions.setRejectedExecutionHandler(new CompactionRequest.Rejection());
        this.splits = (ThreadPoolExecutor)Executors.newFixedThreadPool(splitThreads, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName(n + "-splits-" + System.currentTimeMillis());
                return t;
            }
        });
    }

    public String toString() {
        return "compaction_queue=(" + this.largeCompactions.getQueue().size() + ":" + this.smallCompactions.getQueue().size() + ")" + ", split_queue=" + this.splits.getQueue().size();
    }

    public String dumpQueue() {
        StringBuffer queueLists = new StringBuffer();
        queueLists.append("Compaction/Split Queue dump:\n");
        queueLists.append("  LargeCompation Queue:\n");
        BlockingQueue<Runnable> lq = this.largeCompactions.getQueue();
        Iterator it = lq.iterator();
        while (it.hasNext()) {
            queueLists.append("    " + it.next().toString());
            queueLists.append("\n");
        }
        if (this.smallCompactions != null) {
            queueLists.append("\n");
            queueLists.append("  SmallCompation Queue:\n");
            lq = this.smallCompactions.getQueue();
            it = lq.iterator();
            while (it.hasNext()) {
                queueLists.append("    " + it.next().toString());
                queueLists.append("\n");
            }
        }
        queueLists.append("\n");
        queueLists.append("  Split Queue:\n");
        lq = this.splits.getQueue();
        it = lq.iterator();
        while (it.hasNext()) {
            queueLists.append("    " + it.next().toString());
            queueLists.append("\n");
        }
        return queueLists.toString();
    }

    public synchronized boolean requestSplit(HRegion r) {
        byte[] midKey;
        if (this.shouldSplitRegion() && r.getCompactPriority() >= 1 && (midKey = r.checkSplit()) != null) {
            this.requestSplit(r, midKey);
            return true;
        }
        return false;
    }

    public synchronized void requestSplit(HRegion r, byte[] midKey) {
        if (midKey == null) {
            LOG.debug((Object)("Region " + r.getRegionNameAsString() + " not splittable because midkey=null"));
            return;
        }
        try {
            this.splits.execute(new SplitRequest(r, midKey, this.server));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Split requested for " + r + ".  " + this));
            }
        }
        catch (RejectedExecutionException ree) {
            LOG.info((Object)("Could not execute split for " + r), (Throwable)ree);
        }
    }

    @Override
    public synchronized void requestCompaction(HRegion r, String why) throws IOException {
        for (Store s : r.getStores().values()) {
            this.requestCompaction(r, s, why, Integer.MIN_VALUE);
        }
    }

    @Override
    public synchronized void requestCompaction(HRegion r, Store s, String why) throws IOException {
        this.requestCompaction(r, s, why, Integer.MIN_VALUE);
    }

    @Override
    public synchronized void requestCompaction(HRegion r, String why, int p) throws IOException {
        for (Store s : r.getStores().values()) {
            this.requestCompaction(r, s, why, p);
        }
    }

    @Override
    public synchronized void requestCompaction(HRegion r, Store s, String why, int priority) throws IOException {
        if (this.server.isStopped()) {
            return;
        }
        CompactionRequest cr = s.requestCompaction(priority);
        if (cr != null) {
            cr.setServer(this.server);
            if (priority != Integer.MIN_VALUE) {
                cr.setPriority(priority);
            }
            ThreadPoolExecutor pool = s.throttleCompaction(cr.getSize()) ? this.largeCompactions : this.smallCompactions;
            pool.execute(cr);
            if (LOG.isDebugEnabled()) {
                String type = pool == this.smallCompactions ? "Small " : "Large ";
                LOG.debug((Object)(type + "Compaction requested: " + cr + (why != null && !why.isEmpty() ? "; Because: " + why : "") + "; " + this));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Not compacting " + r.getRegionNameAsString() + " because compaction request was cancelled"));
        }
    }

    void interruptIfNecessary() {
        this.splits.shutdown();
        this.largeCompactions.shutdown();
        this.smallCompactions.shutdown();
    }

    private void waitFor(ThreadPoolExecutor t, String name) {
        boolean done = false;
        while (!done) {
            try {
                done = t.awaitTermination(60L, TimeUnit.SECONDS);
                LOG.debug((Object)("Waiting for " + name + " to finish..."));
                if (done) continue;
                t.shutdownNow();
            }
            catch (InterruptedException ie) {
                LOG.debug((Object)("Interrupted waiting for " + name + " to finish..."));
            }
        }
    }

    void join() {
        this.waitFor(this.splits, "Split Thread");
        this.waitFor(this.largeCompactions, "Large Compaction Thread");
        this.waitFor(this.smallCompactions, "Small Compaction Thread");
    }

    public int getCompactionQueueSize() {
        return this.largeCompactions.getQueue().size() + this.smallCompactions.getQueue().size();
    }

    private boolean shouldSplitRegion() {
        return this.regionSplitLimit > this.server.getNumberOfOnlineRegions();
    }

    public int getRegionSplitLimit() {
        return this.regionSplitLimit;
    }
}

