/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.master;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl;
import org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl;
import org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.JvmVersion;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.util.StringUtils;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class MasterStatusTmplImpl
extends AbstractTemplateImpl
implements MasterStatusTmpl.Intf {
    private final HMaster master;
    private final HBaseAdmin admin;
    private final List<ServerName> servers;
    private final Map<String, Integer> frags;
    private final ServerName rootLocation;
    private final boolean showAppendWarning;
    private final String format;
    private final Set<ServerName> deadServers;
    private final String filter;
    private final ServerName metaLocation;

    protected static MasterStatusTmpl.ImplData __jamon_setOptionalArguments(MasterStatusTmpl.ImplData p_implData) {
        if (!p_implData.getServers__IsNotDefault()) {
            p_implData.setServers(null);
        }
        if (!p_implData.getFrags__IsNotDefault()) {
            p_implData.setFrags(null);
        }
        if (!p_implData.getRootLocation__IsNotDefault()) {
            p_implData.setRootLocation(null);
        }
        if (!p_implData.getShowAppendWarning__IsNotDefault()) {
            p_implData.setShowAppendWarning(false);
        }
        if (!p_implData.getFormat__IsNotDefault()) {
            p_implData.setFormat("html");
        }
        if (!p_implData.getDeadServers__IsNotDefault()) {
            p_implData.setDeadServers(null);
        }
        if (!p_implData.getFilter__IsNotDefault()) {
            p_implData.setFilter("general");
        }
        if (!p_implData.getMetaLocation__IsNotDefault()) {
            p_implData.setMetaLocation(null);
        }
        return p_implData;
    }

    public MasterStatusTmplImpl(TemplateManager p_templateManager, MasterStatusTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)MasterStatusTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.master = p_implData.getMaster();
        this.admin = p_implData.getAdmin();
        this.servers = p_implData.getServers();
        this.frags = p_implData.getFrags();
        this.rootLocation = p_implData.getRootLocation();
        this.showAppendWarning = p_implData.getShowAppendWarning();
        this.format = p_implData.getFormat();
        this.deadServers = p_implData.getDeadServers();
        this.filter = p_implData.getFilter();
        this.metaLocation = p_implData.getMetaLocation();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        if (this.format.equals("json")) {
            jamonWriter.write("\n  ");
            TaskMonitorTmpl __jamon__var_2 = new TaskMonitorTmpl(this.getTemplateManager());
            __jamon__var_2.setFilter(this.filter);
            __jamon__var_2.setFormat("json");
            __jamon__var_2.renderNoFlush(jamonWriter);
            jamonWriter.write("\n  ");
            return;
        }
        jamonWriter.write("\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!-- Commenting out DOCTYPE so our blue outline shows on hadoop 0.20.205.0, etc.\n     See tail of HBASE-2110 for explaination.\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \n  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"> \n-->\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head><meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n<title>HBase Master: ");
        Escaping.HTML.write(StandardEmitter.valueOf((Object)this.master.getServerName()), jamonWriter);
        jamonWriter.write("</title>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hbase.css\" />\n</head>\n<body>\n<a id=\"logo\" href=\"http://wiki.apache.org/lucene-hadoop/Hbase\"><img src=\"/static/hbase_logo.png\" alt=\"HBase Logo\" title=\"HBase Logo\" /></a>\n<h1 id=\"page_title\">Master: ");
        Escaping.HTML.write(StandardEmitter.valueOf((String)this.master.getServerName().getHostname()), jamonWriter);
        jamonWriter.write(":");
        Escaping.HTML.write(StandardEmitter.valueOf((int)this.master.getServerName().getPort()), jamonWriter);
        jamonWriter.write("</h1>\n<p id=\"links_menu\">\n  <a href=\"/logs/\">Local logs</a>,\n  <a href=\"/stacks\">Thread Dump</a>,\n  <a href=\"/logLevel\">Log Level</a>,\n  <a href=\"/dump\">Debug dump</a>,\n");
        if (HBaseConfiguration.isShowConfInServlet()) {
            jamonWriter.write("\n  <a href=\"/conf\">HBase Configuration</a>\n");
        }
        jamonWriter.write("\n</p>\n\n<!-- Various warnings that cluster admins should be aware of -->\n");
        if (JvmVersion.isBadJvmVersion()) {
            jamonWriter.write("\n  <div class=\"warning\">\n  Your current JVM version ");
            Escaping.HTML.write(StandardEmitter.valueOf((String)System.getProperty("java.version")), jamonWriter);
            jamonWriter.write(" is known to be\n  unstable with HBase. Please see the\n  <a href=\"http://wiki.apache.org/hadoop/Hbase/Troubleshooting#A18\">HBase wiki</a>\n  for details.\n  </div>\n");
        }
        jamonWriter.write("\n");
        if (this.showAppendWarning) {
            jamonWriter.write(" \n  <div class=\"warning\">\n  You are currently running the HMaster without HDFS append support enabled.\n  This may result in data loss.\n  Please see the <a href=\"http://wiki.apache.org/hadoop/Hbase/HdfsSyncSupport\">HBase wiki</a>\n  for details.\n  </div>\n");
        }
        jamonWriter.write("\n\n<hr id=\"head_rule\" />\n<h2>Attributes</h2>\n<table id=\"attributes_table\">\n<tr><th>Attribute Name</th><th>Value</th><th>Description</th></tr>\n<tr><td>HBase Version</td><td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)VersionInfo.getVersion()), jamonWriter);
        jamonWriter.write(", r");
        Escaping.HTML.write(StandardEmitter.valueOf((String)VersionInfo.getRevision()), jamonWriter);
        jamonWriter.write("</td><td>HBase version and revision</td></tr>\n<tr><td>HBase Compiled</td><td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)VersionInfo.getDate()), jamonWriter);
        jamonWriter.write(", ");
        Escaping.HTML.write(StandardEmitter.valueOf((String)VersionInfo.getUser()), jamonWriter);
        jamonWriter.write("</td><td>When HBase version was compiled and by whom</td></tr>\n<tr><td>Hadoop Version</td><td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
        jamonWriter.write(", r");
        Escaping.HTML.write(StandardEmitter.valueOf((String)org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
        jamonWriter.write("</td><td>Hadoop version and revision</td></tr>\n<tr><td>Hadoop Compiled</td><td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
        jamonWriter.write(", ");
        Escaping.HTML.write(StandardEmitter.valueOf((String)org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
        jamonWriter.write("</td><td>When Hadoop version was compiled and by whom</td></tr>\n<tr><td>HBase Root Directory</td><td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)FSUtils.getRootDir(this.master.getConfiguration()).toString()), jamonWriter);
        jamonWriter.write("</td><td>Location of HBase home directory</td></tr>\n<tr><td>HBase Cluster ID</td><td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)(this.master.getClusterId() != null ? this.master.getClusterId() : "Not set")), jamonWriter);
        jamonWriter.write("<td>Unique identifier generated for each HBase cluster</td></tr>\n<tr><td>Load average</td><td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.limitDecimalTo2((double)this.master.getServerManager().getAverageLoad())), jamonWriter);
        jamonWriter.write("</td><td>Average number of regions per regionserver. Naive computation.</td></tr>\n");
        if (this.frags != null) {
            jamonWriter.write("\n        <tr><td>Fragmentation</td><td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)(this.frags.get("-TOTAL-") != null ? this.frags.get("-TOTAL-") + "%" : "n/a")), jamonWriter);
            jamonWriter.write("</td><td>Overall fragmentation of all tables, including .META. and -ROOT-.</td></tr>\n");
        }
        jamonWriter.write("\n<tr><td>Zookeeper Quorum</td><td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)this.master.getZooKeeperWatcher().getQuorum()), jamonWriter);
        jamonWriter.write("</td><td>Addresses of all registered ZK servers. For more, see <a href=\"/zk.jsp\">zk dump</a>.</td></tr>\n<tr>\n  <td>\n   Coprocessors</td><td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)Arrays.toString(this.master.getCoprocessors())), jamonWriter);
        jamonWriter.write("\n  </td>\n  <td>Coprocessors currently loaded loaded by the master</td>\n</tr>\n<tr><td>HMaster Start Time</td><td>");
        Escaping.HTML.write(StandardEmitter.valueOf((Object)new Date(this.master.getMasterStartTime())), jamonWriter);
        jamonWriter.write("</td><td>Date stamp of when this HMaster was started</td></tr>\n<tr><td>HMaster Active Time</td><td>");
        Escaping.HTML.write(StandardEmitter.valueOf((Object)new Date(this.master.getMasterActiveTime())), jamonWriter);
        jamonWriter.write("</td><td>Date stamp of when this HMaster became active</td></tr>\n</table>\n\n");
        TaskMonitorTmpl __jamon__var_3 = new TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_3.setFilter(this.filter);
        __jamon__var_3.renderNoFlush(jamonWriter);
        jamonWriter.write("\n\n");
        if (this.rootLocation != null) {
            jamonWriter.write("\n");
            this.__jamon_innerUnit__catalogTables(jamonWriter);
            jamonWriter.write("\n");
        }
        jamonWriter.write("\n");
        if (this.metaLocation != null) {
            jamonWriter.write("\n");
            this.__jamon_innerUnit__userTables(jamonWriter);
            jamonWriter.write("\n");
        }
        jamonWriter.write("\n");
        if (this.servers != null) {
            jamonWriter.write("\n");
            this.__jamon_innerUnit__regionServers(jamonWriter);
            jamonWriter.write("\n");
        }
        jamonWriter.write("\n");
        if (this.deadServers != null) {
            jamonWriter.write("\n");
            this.__jamon_innerUnit__deadRegionServers(jamonWriter);
            jamonWriter.write("\n");
        }
        jamonWriter.write("\n\n");
        AssignmentManagerStatusTmpl __jamon__var_4 = new AssignmentManagerStatusTmpl(this.getTemplateManager());
        __jamon__var_4.renderNoFlush(jamonWriter, this.master.getAssignmentManager());
        jamonWriter.write("\n\n</body>\n</html>\n\n\n");
    }

    private void __jamon_innerUnit__catalogTables(Writer jamonWriter) throws IOException {
        jamonWriter.write("<h2>Tables</h2>\n<table>\n<tr>\n    <th>Catalog Table</th>\n    ");
        if (this.frags != null) {
            jamonWriter.write("\n        <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n    ");
        }
        jamonWriter.write("\n    <th>Description</th>\n</tr>\n<tr>\n    <td><a href=\"table.jsp?name=");
        Escaping.HTML.write(StandardEmitter.valueOf((String)Bytes.toString(HConstants.ROOT_TABLE_NAME)), jamonWriter);
        jamonWriter.write("\">");
        Escaping.HTML.write(StandardEmitter.valueOf((String)Bytes.toString(HConstants.ROOT_TABLE_NAME)), jamonWriter);
        jamonWriter.write("</a></td>\n  ");
        if (this.frags != null) {
            jamonWriter.write("\n        <td align=\"center\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)(this.frags.get("-ROOT-") != null ? this.frags.get("-ROOT-") + "%" : "n/a")), jamonWriter);
            jamonWriter.write("</td>\n  ");
        }
        jamonWriter.write("\n    <td>The -ROOT- table holds references to all .META. regions.</td>\n</tr>\n  ");
        if (this.metaLocation != null) {
            jamonWriter.write("\n<tr>\n    <td><a href=\"table.jsp?name=");
            Escaping.HTML.write(StandardEmitter.valueOf((String)Bytes.toString(HConstants.META_TABLE_NAME)), jamonWriter);
            jamonWriter.write("\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)Bytes.toString(HConstants.META_TABLE_NAME)), jamonWriter);
            jamonWriter.write("</a></td>\n    ");
            if (this.frags != null) {
                jamonWriter.write("\n        <td align=\"center\">");
                Escaping.HTML.write(StandardEmitter.valueOf((String)(this.frags.get(".META.") != null ? this.frags.get(".META.") + "%" : "n/a")), jamonWriter);
                jamonWriter.write("</td>\n    ");
            }
            jamonWriter.write("\n    <td>The .META. table holds references to all User Table regions</td>\n</tr>\n  \n  ");
        }
        jamonWriter.write("\n</table>\n");
    }

    private void __jamon_innerUnit__userTables(Writer jamonWriter) throws IOException {
        HTableDescriptor[] tables = this.admin.listTables();
        HConnectionManager.deleteConnection(this.admin.getConfiguration());
        if (tables != null && tables.length > 0) {
            jamonWriter.write("\n<table>\n<tr>\n    <th>User Table</th>\n");
            if (this.frags != null) {
                jamonWriter.write("\n        <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n");
            }
            jamonWriter.write("\n    <th>Online Regions</th>\n    <th>Description</th>\n</tr>\n");
            for (HTableDescriptor htDesc : tables) {
                jamonWriter.write("\n<tr>\n    <td><a href=table.jsp?name=");
                Escaping.HTML.write(StandardEmitter.valueOf((String)htDesc.getNameAsString()), jamonWriter);
                jamonWriter.write(">");
                Escaping.HTML.write(StandardEmitter.valueOf((String)htDesc.getNameAsString()), jamonWriter);
                jamonWriter.write("</a> </td>\n    ");
                if (this.frags != null) {
                    jamonWriter.write("\n        <td align=\"center\">");
                    Escaping.HTML.write(StandardEmitter.valueOf((String)(this.frags.get(htDesc.getNameAsString()) != null ? this.frags.get(htDesc.getNameAsString()) + "%" : "n/a")), jamonWriter);
                    jamonWriter.write("</td>\n    ");
                }
                jamonWriter.write("\n    <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((int)this.master.getAssignmentManager().getRegionsOfTable(htDesc.getName()).size()), jamonWriter);
                jamonWriter.write("\n    <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)htDesc.toStringCustomizedValues()), jamonWriter);
                jamonWriter.write("</td>\n</tr>\n");
            }
            jamonWriter.write("\n\n<p> ");
            Escaping.HTML.write(StandardEmitter.valueOf((int)tables.length), jamonWriter);
            jamonWriter.write(" table(s) in set. [<a href=tablesDetailed.jsp>Details</a>]</p>\n</table>\n");
        }
        jamonWriter.write("\n");
    }

    private void __jamon_innerUnit__regionServers(Writer jamonWriter) throws IOException {
        jamonWriter.write("<h2>Region Servers</h2>\n");
        if (this.servers != null && this.servers.size() > 0) {
            jamonWriter.write("\n");
            int totalRegions = 0;
            int totalRequests = 0;
            jamonWriter.write("<table>\n<tr><th rowspan=\"");
            Escaping.HTML.write(StandardEmitter.valueOf((int)(this.servers.size() + 1)), jamonWriter);
            jamonWriter.write("\"></th><th>ServerName</th><th>Start time</th><th>Load</th></tr>\n");
            Object[] serverNames = this.servers.toArray(new ServerName[this.servers.size()]);
            Arrays.sort(serverNames);
            for (Object serverName : serverNames) {
                String loadStr;
                int infoPort = this.master.getConfiguration().getInt("hbase.regionserver.info.port", 60030);
                String url = "http://" + ((ServerName)serverName).getHostname() + ":" + infoPort + "/";
                HServerLoad hsl = this.master.getServerManager().getLoad((ServerName)serverName);
                String string = loadStr = hsl == null ? "-" : hsl.toString();
                if (hsl != null) {
                    totalRegions += hsl.getNumberOfRegions();
                    totalRequests += hsl.getNumberOfRequests();
                }
                long startcode = ((ServerName)serverName).getStartcode();
                jamonWriter.write("<tr><td><a href=\"");
                Escaping.HTML.write(StandardEmitter.valueOf((String)url), jamonWriter);
                jamonWriter.write("\">");
                Escaping.HTML.write(StandardEmitter.valueOf((Object)serverName), jamonWriter);
                jamonWriter.write("</a></td><td>");
                Escaping.HTML.write(StandardEmitter.valueOf((Object)new Date(startcode)), jamonWriter);
                jamonWriter.write("</td><td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)loadStr), jamonWriter);
                jamonWriter.write("</td></tr>\n");
            }
            jamonWriter.write("<tr><th>Total: </th><td>servers: ");
            Escaping.HTML.write(StandardEmitter.valueOf((int)this.servers.size()), jamonWriter);
            jamonWriter.write("</td><td></td><td>requestsPerSecond=");
            Escaping.HTML.write(StandardEmitter.valueOf((int)totalRequests), jamonWriter);
            jamonWriter.write(", numberOfOnlineRegions=");
            Escaping.HTML.write(StandardEmitter.valueOf((int)totalRegions), jamonWriter);
            jamonWriter.write("</td></tr>\n</table>\n\n<p>Load is requests per second and count of regions loaded</p>\n");
        }
        jamonWriter.write("\n");
    }

    private void __jamon_innerUnit__deadRegionServers(Writer jamonWriter) throws IOException {
        jamonWriter.write("<h3>Dead Region Servers</h3>\n");
        if (this.deadServers != null && this.deadServers.size() > 0) {
            jamonWriter.write("\n\n<table>\n<tr><th rowspan=\"");
            Escaping.HTML.write(StandardEmitter.valueOf((int)(this.deadServers.size() + 1)), jamonWriter);
            jamonWriter.write("\"></th><th>ServerName</th></tr>\n");
            Object[] deadServerNames = this.deadServers.toArray(new ServerName[this.deadServers.size()]);
            Arrays.sort(deadServerNames);
            for (Object deadServerName : deadServerNames) {
                int infoPort = this.master.getConfiguration().getInt("hbase.regionserver.info.port", 60030);
                jamonWriter.write("<tr><td>");
                Escaping.HTML.write(StandardEmitter.valueOf((Object)deadServerName), jamonWriter);
                jamonWriter.write("</td></tr>\n");
            }
            jamonWriter.write("<tr><th>Total: </th><td>servers: ");
            Escaping.HTML.write(StandardEmitter.valueOf((int)this.deadServers.size()), jamonWriter);
            jamonWriter.write("</td></tr>\n</table>\n");
        }
        jamonWriter.write("\n");
    }
}

