/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.FSUtils;

public class HFileArchiveUtil {
    private HFileArchiveUtil() {
    }

    public static Path getStoreArchivePath(Configuration conf, HRegion region, byte[] family) {
        return HFileArchiveUtil.getStoreArchivePath(conf, region.getRegionInfo(), region.getTableDir(), family);
    }

    public static Path getStoreArchivePath(Configuration conf, HRegionInfo region, Path tabledir, byte[] family) {
        Path tableArchiveDir = HFileArchiveUtil.getTableArchivePath(tabledir);
        return Store.getStoreHomedir(tableArchiveDir, HRegionInfo.encodeRegionName(region.getRegionName()), family);
    }

    public static Path getRegionArchiveDir(Configuration conf, Path tabledir, Path regiondir) {
        Path archiveDir = HFileArchiveUtil.getTableArchivePath(tabledir);
        String encodedRegionName = regiondir.getName();
        return HRegion.getRegionDir(archiveDir, encodedRegionName);
    }

    public static Path getTableArchivePath(Path tabledir) {
        Path root = tabledir.getParent();
        return new Path(new Path(root, ".archive"), tabledir.getName());
    }

    public static Path getArchivePath(Configuration conf) throws IOException {
        return new Path(FSUtils.getRootDir(conf), ".archive");
    }
}

