/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.facebook.fb303.FacebookBase;
import com.facebook.fb303.fb_status;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.common.cli.CommonCliOptions;
import org.apache.hadoop.hive.common.metrics.Metrics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.AlterHandler;
import org.apache.hadoop.hive.metastore.HiveAlterHandler;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreEndFunctionContext;
import org.apache.hadoop.hive.metastore.MetaStoreEndFunctionListener;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.MetaStorePreEventListener;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.RetryingHMSHandler;
import org.apache.hadoop.hive.metastore.RetryingRawStore;
import org.apache.hadoop.hive.metastore.TServerSocketKeepAlive;
import org.apache.hadoop.hive.metastore.TSetIpAddressProcessor;
import org.apache.hadoop.hive.metastore.TUGIBasedProcessor;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.IndexAlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.events.EventCleanerTask;
import org.apache.hadoop.hive.metastore.events.LoadPartitionDoneEvent;
import org.apache.hadoop.hive.metastore.events.PreAddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterTableEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateTableEvent;
import org.apache.hadoop.hive.metastore.events.PreDropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreDropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreDropTableEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.metastore.events.PreLoadPartitionDoneEvent;
import org.apache.hadoop.hive.metastore.model.MDBPrivilege;
import org.apache.hadoop.hive.metastore.model.MGlobalPrivilege;
import org.apache.hadoop.hive.metastore.model.MPartitionColumnPrivilege;
import org.apache.hadoop.hive.metastore.model.MPartitionPrivilege;
import org.apache.hadoop.hive.metastore.model.MRole;
import org.apache.hadoop.hive.metastore.model.MRoleMap;
import org.apache.hadoop.hive.metastore.model.MTableColumnPrivilege;
import org.apache.hadoop.hive.metastore.model.MTablePrivilege;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.thrift.TUGIContainingTransport;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;

public class HiveMetaStore
extends ThriftHiveMetastore {
    public static final Log LOG = LogFactory.getLog(HiveMetaStore.class);
    private static final int DEFAULT_HIVE_METASTORE_PORT = 9083;
    private static HadoopThriftAuthBridge.Server saslServer;
    private static boolean useSasl;

    public static IHMSHandler newHMSHandler(String name, HiveConf hiveConf) throws MetaException {
        return RetryingHMSHandler.getProxy(hiveConf, name);
    }

    public static void cancelDelegationToken(String tokenStrForm) throws IOException {
        saslServer.cancelDelegationToken(tokenStrForm);
    }

    public static String getDelegationToken(String owner, String renewer) throws IOException, InterruptedException {
        return saslServer.getDelegationToken(owner, renewer);
    }

    public static long renewDelegationToken(String tokenStrForm) throws IOException {
        return saslServer.renewDelegationToken(tokenStrForm);
    }

    public static void main(String[] args) throws Throwable {
        HiveMetastoreCli cli = new HiveMetastoreCli();
        cli.parse(args);
        final boolean isCliVerbose = cli.isVerbose();
        Properties hiveconf = cli.addHiveconfToSystemProperties();
        if (System.getProperty("log4j.configuration") == null) {
            try {
                LogUtils.initHiveLog4j();
            }
            catch (LogUtils.LogInitializationException e) {
                HMSHandler.LOG.warn((Object)e.getMessage());
            }
        }
        try {
            String msg = "Starting hive metastore on port " + cli.port;
            HMSHandler.LOG.info((Object)msg);
            if (cli.isVerbose()) {
                System.err.println(msg);
            }
            HiveConf conf = new HiveConf(HMSHandler.class);
            for (Map.Entry<Object, Object> item : hiveconf.entrySet()) {
                conf.set((String)item.getKey(), (String)item.getValue());
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    String shutdownMsg = "Shutting down hive metastore.";
                    HMSHandler.LOG.info((Object)shutdownMsg);
                    if (isCliVerbose) {
                        System.err.println(shutdownMsg);
                    }
                }
            });
            HiveMetaStore.startMetaStore(cli.port, ShimLoader.getHadoopThriftAuthBridge(), conf);
        }
        catch (Throwable t) {
            HMSHandler.LOG.error((Object)"Metastore Thrift Server threw an exception...", t);
            throw t;
        }
    }

    public static void startMetaStore(int port, HadoopThriftAuthBridge bridge) throws Throwable {
        HiveMetaStore.startMetaStore(port, bridge, new HiveConf(HMSHandler.class));
    }

    public static void startMetaStore(int port, HadoopThriftAuthBridge bridge, HiveConf conf) throws Throwable {
        try {
            TProcessor processor;
            ChainedTTransportFactory transFactory;
            TServerSocketKeepAlive serverTransport;
            int minWorkerThreads = conf.getIntVar(HiveConf.ConfVars.METASTORESERVERMINTHREADS);
            int maxWorkerThreads = conf.getIntVar(HiveConf.ConfVars.METASTORESERVERMAXTHREADS);
            boolean tcpKeepAlive = conf.getBoolVar(HiveConf.ConfVars.METASTORE_TCP_KEEP_ALIVE);
            boolean useFramedTransport = conf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_FRAMED_TRANSPORT);
            useSasl = conf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL);
            TServerSocketKeepAlive tServerSocketKeepAlive = serverTransport = tcpKeepAlive ? new TServerSocketKeepAlive(port) : new TServerSocket(port);
            if (useSasl) {
                if (useFramedTransport) {
                    throw new HiveMetaException("Framed transport is not supported with SASL enabled.");
                }
                saslServer = bridge.createServer(conf.getVar(HiveConf.ConfVars.METASTORE_KERBEROS_KEYTAB_FILE), conf.getVar(HiveConf.ConfVars.METASTORE_KERBEROS_PRINCIPAL));
                saslServer.startDelegationTokenSecretManager((Configuration)conf);
                transFactory = saslServer.createTransportFactory();
                processor = saslServer.wrapProcessor(new ThriftHiveMetastore.Processor<IHMSHandler>(HiveMetaStore.newHMSHandler("new db based metaserver", conf)));
                LOG.info((Object)"Starting DB backed MetaStore Server in Secure Mode");
            } else {
                IHMSHandler handler = HiveMetaStore.newHMSHandler("new db based metaserver", conf);
                if (conf.getBoolVar(HiveConf.ConfVars.METASTORE_EXECUTE_SET_UGI)) {
                    transFactory = useFramedTransport ? new ChainedTTransportFactory((TTransportFactory)new TFramedTransport.Factory(), (TTransportFactory)new TUGIContainingTransport.Factory()) : new TUGIContainingTransport.Factory();
                    processor = new TUGIBasedProcessor<IHMSHandler>(handler);
                    LOG.info((Object)"Starting DB backed MetaStore Server with SetUGI enabled");
                } else {
                    transFactory = useFramedTransport ? new TFramedTransport.Factory() : new TTransportFactory();
                    processor = new TSetIpAddressProcessor<IHMSHandler>(handler);
                    LOG.info((Object)"Starting DB backed MetaStore Server");
                }
            }
            TThreadPoolServer.Args args = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor(processor)).transportFactory((TTransportFactory)transFactory)).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).minWorkerThreads(minWorkerThreads).maxWorkerThreads(maxWorkerThreads);
            TThreadPoolServer tServer = new TThreadPoolServer(args);
            HMSHandler.LOG.info((Object)("Started the new metaserver on port [" + port + "]..."));
            HMSHandler.LOG.info((Object)("Options.minWorkerThreads = " + minWorkerThreads));
            HMSHandler.LOG.info((Object)("Options.maxWorkerThreads = " + maxWorkerThreads));
            HMSHandler.LOG.info((Object)("TCP keepalive = " + tcpKeepAlive));
            tServer.serve();
        }
        catch (Throwable x) {
            x.printStackTrace();
            HMSHandler.LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)x));
            throw x;
        }
    }

    public static class HiveMetastoreCli
    extends CommonCliOptions {
        int port = 9083;

        public HiveMetastoreCli() {
            super("hivemetastore", true);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"port");
            OptionBuilder.withDescription((String)"Hive Metastore port number, default:9083");
            this.OPTIONS.addOption(OptionBuilder.create((char)'p'));
        }

        public void parse(String[] args) {
            super.parse(args);
            args = this.commandLine.getArgs();
            if (args.length > 0) {
                System.err.println("This usage has been deprecated, consider using the new command line syntax (run with -h to see usage information)");
                this.port = new Integer(args[0]);
            }
            if (this.commandLine.hasOption('p')) {
                this.port = Integer.parseInt(this.commandLine.getOptionValue('p'));
            } else {
                String metastorePort = System.getenv("METASTORE_PORT");
                if (metastorePort != null) {
                    this.port = Integer.parseInt(metastorePort);
                }
            }
        }
    }

    public static class HMSHandler
    extends FacebookBase
    implements IHMSHandler {
        public static final Log LOG = LOG;
        private static boolean createDefaultDB = false;
        private String rawStoreClassName;
        private final HiveConf hiveConf;
        private Warehouse wh;
        private final ThreadLocal<RawStore> threadLocalMS = new ThreadLocal<RawStore>(){

            @Override
            protected synchronized RawStore initialValue() {
                return null;
            }
        };
        private final ThreadLocal<Configuration> threadLocalConf = new ThreadLocal<Configuration>(){

            @Override
            protected synchronized Configuration initialValue() {
                return null;
            }
        };
        public static final String AUDIT_FORMAT = "ugi=%s\tip=%s\tcmd=%s\t";
        public static final Log auditLog = LogFactory.getLog((String)(HiveMetaStore.class.getName() + ".audit"));
        private static final ThreadLocal<Formatter> auditFormatter = new ThreadLocal<Formatter>(){

            @Override
            protected Formatter initialValue() {
                return new Formatter(new StringBuilder(HMSHandler.AUDIT_FORMAT.length() * 4));
            }
        };
        private boolean checkForDefaultDb;
        private static int nextSerialNum = 0;
        private static ThreadLocal<Integer> threadLocalId = new ThreadLocal<Integer>(){

            @Override
            protected synchronized Integer initialValue() {
                return new Integer(nextSerialNum++);
            }
        };
        private static ThreadLocal<String> threadLocalIpAddress = new ThreadLocal<String>(){

            @Override
            protected synchronized String initialValue() {
                return null;
            }
        };
        private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        private AlterHandler alterHandler;
        private List<MetaStorePreEventListener> preListeners;
        private List<MetaStoreEventListener> listeners;
        private List<MetaStoreEndFunctionListener> endFunctionListeners;

        private final void logAuditEvent(String cmd) {
            UserGroupInformation ugi;
            if (cmd == null) {
                return;
            }
            try {
                ugi = ShimLoader.getHadoopShims().getUGIForConf(this.getConf());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            Formatter fmt = auditFormatter.get();
            ((StringBuilder)fmt.out()).setLength(0);
            String address = useSasl ? saslServer.getRemoteAddress().toString() : HMSHandler.getIpAddress();
            if (address == null) {
                address = "unknown-ip-addr";
            }
            auditLog.info((Object)fmt.format(AUDIT_FORMAT, ugi.getUserName(), address, cmd).toString());
        }

        public static void setIpAddress(String ipAddress) {
            threadLocalIpAddress.set(ipAddress);
        }

        public static String getIpAddress() {
            return threadLocalIpAddress.get();
        }

        public static Integer get() {
            return threadLocalId.get();
        }

        public HMSHandler(String name) throws MetaException {
            super(name);
            if (this.classLoader == null) {
                this.classLoader = Configuration.class.getClassLoader();
            }
            this.hiveConf = new HiveConf(this.getClass());
            this.init();
        }

        public HMSHandler(String name, HiveConf conf) throws MetaException {
            super(name);
            if (this.classLoader == null) {
                this.classLoader = Configuration.class.getClassLoader();
            }
            this.hiveConf = conf;
            this.init();
        }

        public HiveConf getHiveConf() {
            return this.hiveConf;
        }

        private boolean init() throws MetaException {
            this.rawStoreClassName = this.hiveConf.getVar(HiveConf.ConfVars.METASTORE_RAW_STORE_IMPL);
            this.checkForDefaultDb = this.hiveConf.getBoolean("hive.metastore.checkForDefaultDb", true);
            String alterHandlerName = this.hiveConf.get("hive.metastore.alter.impl", HiveAlterHandler.class.getName());
            this.alterHandler = (AlterHandler)ReflectionUtils.newInstance(MetaStoreUtils.getClass(alterHandlerName), (Configuration)this.hiveConf);
            this.wh = new Warehouse((Configuration)this.hiveConf);
            this.createDefaultDB();
            if (this.hiveConf.getBoolean("hive.metastore.metrics.enabled", false)) {
                try {
                    Metrics.init();
                }
                catch (Exception e) {
                    LOG.error((Object)("error in Metrics init: " + e.getClass().getName() + " " + e.getMessage()));
                    MetaStoreUtils.printStackTrace(e);
                }
            }
            this.preListeners = MetaStoreUtils.getMetaStoreListeners(MetaStorePreEventListener.class, this.hiveConf, this.hiveConf.getVar(HiveConf.ConfVars.METASTORE_PRE_EVENT_LISTENERS));
            this.listeners = MetaStoreUtils.getMetaStoreListeners(MetaStoreEventListener.class, this.hiveConf, this.hiveConf.getVar(HiveConf.ConfVars.METASTORE_EVENT_LISTENERS));
            this.endFunctionListeners = MetaStoreUtils.getMetaStoreListeners(MetaStoreEndFunctionListener.class, this.hiveConf, this.hiveConf.getVar(HiveConf.ConfVars.METASTORE_END_FUNCTION_LISTENERS));
            long cleanFreq = this.hiveConf.getLongVar(HiveConf.ConfVars.METASTORE_EVENT_CLEAN_FREQ) * 1000L;
            if (cleanFreq > 0L) {
                Timer cleaner = new Timer("Metastore Events Cleaner Thread", true);
                cleaner.schedule((TimerTask)new EventCleanerTask(this), cleanFreq, cleanFreq);
            }
            return true;
        }

        private String addPrefix(String s) {
            return threadLocalId.get() + ": " + s;
        }

        @Override
        public void setConf(Configuration conf) {
            this.threadLocalConf.set(conf);
            RawStore ms = this.threadLocalMS.get();
            if (ms != null) {
                ms.setConf(conf);
            }
        }

        private Configuration getConf() {
            Configuration conf = this.threadLocalConf.get();
            if (conf == null) {
                conf = new Configuration((Configuration)this.hiveConf);
                this.threadLocalConf.set(conf);
            }
            return conf;
        }

        public Warehouse getWh() {
            return this.wh;
        }

        @InterfaceAudience.LimitedPrivate(value={"HCATALOG"})
        @InterfaceStability.Evolving
        public RawStore getMS() throws MetaException {
            RawStore ms = this.threadLocalMS.get();
            if (ms == null) {
                ms = this.newRawStore();
                this.threadLocalMS.set(ms);
                ms = this.threadLocalMS.get();
            }
            return ms;
        }

        private RawStore newRawStore() throws MetaException {
            LOG.info((Object)this.addPrefix("Opening raw store with implemenation class:" + this.rawStoreClassName));
            Configuration conf = this.getConf();
            return RetryingRawStore.getProxy(this.hiveConf, conf, this.rawStoreClassName, threadLocalId.get());
        }

        private void createDefaultDB_core(RawStore ms) throws MetaException, InvalidObjectException {
            try {
                ms.getDatabase("default");
            }
            catch (NoSuchObjectException e) {
                ms.createDatabase(new Database("default", "Default Hive database", this.wh.getDefaultDatabasePath("default").toString(), null));
            }
            createDefaultDB = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createDefaultDB() throws MetaException {
            Class<HMSHandler> clazz = HMSHandler.class;
            synchronized (HMSHandler.class) {
                if (createDefaultDB || !this.checkForDefaultDb) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                try {
                    this.createDefaultDB_core(this.getMS());
                }
                catch (InvalidObjectException e) {
                    throw new MetaException(e.getMessage());
                }
                catch (MetaException e) {
                    throw e;
                }
                catch (Exception e) {
                    assert (e instanceof RuntimeException);
                    throw (RuntimeException)e;
                }
                return;
            }
        }

        private void logInfo(String m) {
            LOG.info((Object)(threadLocalId.get().toString() + ": " + m));
            this.logAuditEvent(m);
        }

        public String startFunction(String function, String extraLogInfo) {
            this.incrementCounter(function);
            this.logInfo((HMSHandler.getIpAddress() == null ? "" : "source:" + HMSHandler.getIpAddress() + " ") + function + extraLogInfo);
            try {
                Metrics.startScope((String)function);
            }
            catch (IOException e) {
                LOG.debug((Object)("Exception when starting metrics scope" + e.getClass().getName() + " " + e.getMessage()));
                MetaStoreUtils.printStackTrace(e);
            }
            return function;
        }

        public String startFunction(String function) {
            return this.startFunction(function, "");
        }

        public String startTableFunction(String function, String db, String tbl) {
            return this.startFunction(function, " : db=" + db + " tbl=" + tbl);
        }

        public String startMultiTableFunction(String function, String db, List<String> tbls) {
            String tableNames = StringUtils.join(tbls, (String)",");
            return this.startFunction(function, " : db=" + db + " tbls=" + tableNames);
        }

        public String startPartitionFunction(String function, String db, String tbl, List<String> partVals) {
            return this.startFunction(function, " : db=" + db + " tbl=" + tbl + "[" + StringUtils.join(partVals, (String)",") + "]");
        }

        public String startPartitionFunction(String function, String db, String tbl, Map<String, String> partName) {
            return this.startFunction(function, " : db=" + db + " tbl=" + tbl + "partition=" + partName);
        }

        public void endFunction(String function, boolean successful, Exception e) {
            this.endFunction(function, new MetaStoreEndFunctionContext(successful, e));
        }

        public void endFunction(String function, MetaStoreEndFunctionContext context) {
            try {
                Metrics.endScope((String)function);
            }
            catch (IOException e) {
                LOG.debug((Object)("Exception when closing metrics scope" + e));
            }
            for (MetaStoreEndFunctionListener listener : this.endFunctionListeners) {
                listener.onEndFunction(function, context);
            }
        }

        public fb_status getStatus() {
            return fb_status.ALIVE;
        }

        public void shutdown() {
            this.logInfo("Shutting down the object store...");
            RawStore ms = this.threadLocalMS.get();
            if (ms != null) {
                ms.shutdown();
                this.threadLocalMS.remove();
            }
            this.logInfo("Metastore shutdown complete.");
        }

        public AbstractMap<String, Long> getCounters() {
            AbstractMap counters = super.getCounters();
            if (this.endFunctionListeners != null) {
                for (MetaStoreEndFunctionListener listener : this.endFunctionListeners) {
                    listener.exportCounters(counters);
                }
            }
            return counters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create_database_core(RawStore ms, Database db) throws AlreadyExistsException, InvalidObjectException, MetaException {
            if (!MetaStoreUtils.validateName(db.getName())) {
                throw new InvalidObjectException(db.getName() + " is not a valid database name");
            }
            if (null == db.getLocationUri()) {
                db.setLocationUri(this.wh.getDefaultDatabasePath(db.getName()).toString());
            } else {
                db.setLocationUri(this.wh.getDnsPath(new Path(db.getLocationUri())).toString());
            }
            Path dbPath = new Path(db.getLocationUri());
            boolean success = false;
            boolean madeDir = false;
            try {
                this.firePreEvent(new PreCreateDatabaseEvent(db, this));
                if (!this.wh.isDir(dbPath)) {
                    if (!this.wh.mkdirs(dbPath)) {
                        throw new MetaException("Unable to create database path " + dbPath + ", failed to create database " + db.getName());
                    }
                    madeDir = true;
                }
                ms.openTransaction();
                ms.createDatabase(db);
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                    if (madeDir) {
                        this.wh.deleteDir(dbPath, true);
                    }
                }
                for (MetaStoreEventListener listener : this.listeners) {
                    listener.onCreateDatabase(new CreateDatabaseEvent(db, success, this));
                }
            }
        }

        @Override
        public void create_database(Database db) throws AlreadyExistsException, InvalidObjectException, MetaException {
            this.startFunction("create_database", ": " + db.toString());
            boolean success = false;
            Exception ex = null;
            try {
                try {
                    if (null != this.get_database(db.getName())) {
                        throw new AlreadyExistsException("Database " + db.getName() + " already exists");
                    }
                }
                catch (NoSuchObjectException e) {
                    // empty catch block
                }
                this.create_database_core(this.getMS(), db);
                success = true;
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)((Object)e);
                }
                if (e instanceof InvalidObjectException) {
                    throw (InvalidObjectException)((Object)e);
                }
                if (e instanceof AlreadyExistsException) {
                    throw (AlreadyExistsException)((Object)e);
                }
                MetaException me = new MetaException(e.toString());
                me.initCause(e);
                throw me;
            }
            finally {
                this.endFunction("create_database", success, ex);
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Database get_database(String name) throws NoSuchObjectException, MetaException {
            this.startFunction("get_database", ": " + name);
            Database db = null;
            Serializable ex = null;
            try {
                db = this.getMS().getDatabase(name);
                this.endFunction("get_database", db != null, (Exception)ex);
                return db;
            }
            catch (MetaException e) {
                try {
                    ex = e;
                    throw e;
                    catch (NoSuchObjectException e2) {
                        ex = e2;
                        throw e2;
                    }
                    catch (Exception e3) {
                        ex = e3;
                        if ($assertionsDisabled) throw (RuntimeException)e3;
                        if (e3 instanceof RuntimeException) throw (RuntimeException)e3;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_database", db != null, (Exception)ex);
                    throw throwable;
                }
            }
        }

        @Override
        public void alter_database(String dbName, Database db) throws NoSuchObjectException, TException, MetaException {
            this.startFunction("alter_database" + dbName);
            boolean success = false;
            Exception ex = null;
            try {
                this.getMS().alterDatabase(dbName, db);
                success = true;
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)((Object)e);
                }
                if (e instanceof NoSuchObjectException) {
                    throw (NoSuchObjectException)((Object)e);
                }
                if (e instanceof TException) {
                    throw (TException)e;
                }
                MetaException me = new MetaException(e.toString());
                me.initCause(e);
                throw me;
            }
            finally {
                this.endFunction("alter_database", success, ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drop_database_core(RawStore ms, String name, boolean deleteData, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException, IOException, InvalidObjectException, InvalidInputException {
            boolean success = false;
            Database db = null;
            ArrayList<Path> tablePaths = new ArrayList<Path>();
            List<Path> partitionPaths = new ArrayList<Path>();
            try {
                ms.openTransaction();
                db = ms.getDatabase(name);
                this.firePreEvent(new PreDropDatabaseEvent(db, this));
                List<String> allTables = this.get_all_tables(db.getName());
                if (!cascade && !allTables.isEmpty()) {
                    throw new InvalidOperationException("Database " + db.getName() + " is not empty");
                }
                Path path = new Path(db.getLocationUri()).getParent();
                if (!this.wh.isWritable(path)) {
                    throw new MetaException("Database not dropped since " + path + " is not writable by " + this.hiveConf.getUser());
                }
                Path databasePath = this.wh.getDnsPath(this.wh.getDatabasePath(db));
                int tableBatchSize = HiveConf.getIntVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX);
                int startIndex = 0;
                int endIndex = -1;
                while (endIndex < allTables.size() - 1) {
                    startIndex = endIndex + 1;
                    if ((endIndex += tableBatchSize) >= allTables.size()) {
                        endIndex = allTables.size() - 1;
                    }
                    List<Table> tables = null;
                    try {
                        tables = ms.getTableObjectsByName(name, allTables.subList(startIndex, endIndex));
                    }
                    catch (UnknownDBException e) {
                        throw new MetaException(e.getMessage());
                    }
                    if (tables == null || tables.isEmpty()) continue;
                    for (Table table : tables) {
                        Path tablePath = null;
                        if (table.getSd().getLocation() != null && !this.isExternal(table)) {
                            tablePath = this.wh.getDnsPath(new Path(table.getSd().getLocation()));
                            if (!this.wh.isWritable(tablePath.getParent())) {
                                throw new MetaException("Database metadata not deleted since table: " + table.getTableName() + " has a parent location " + tablePath.getParent() + " which is not writable by " + this.hiveConf.getUser());
                            }
                            if (!this.isSubdirectory(databasePath, tablePath)) {
                                tablePaths.add(tablePath);
                            }
                        }
                        partitionPaths = this.dropPartitionsAndGetLocations(ms, name, table.getTableName(), tablePath, table.getPartitionKeys(), deleteData && !this.isExternal(table));
                        this.drop_table(name, table.getTableName(), false);
                    }
                }
                if (ms.dropDatabase(name)) {
                    success = ms.commitTransaction();
                }
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                } else if (deleteData) {
                    this.deletePartitionData(partitionPaths);
                    for (Path tablePath : tablePaths) {
                        this.deleteTableData(tablePath);
                    }
                    try {
                        this.wh.deleteDir(new Path(db.getLocationUri()), true);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to delete database directory: " + db.getLocationUri() + " " + e.getMessage()));
                    }
                }
                for (MetaStoreEventListener listener : this.listeners) {
                    listener.onDropDatabase(new DropDatabaseEvent(db, success, this));
                }
            }
        }

        private boolean isSubdirectory(Path parent, Path other) {
            return other.toString().startsWith(parent.toString().endsWith("/") ? parent.toString() : parent.toString() + "/");
        }

        @Override
        public void drop_database(String dbName, boolean deleteData, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException {
            this.startFunction("drop_database", ": " + dbName);
            if ("default".equalsIgnoreCase(dbName)) {
                this.endFunction("drop_database", false, null);
                throw new MetaException("Can not drop default database");
            }
            boolean success = false;
            Exception ex = null;
            try {
                this.drop_database_core(this.getMS(), dbName, deleteData, cascade);
                success = true;
            }
            catch (IOException e) {
                ex = e;
                throw new MetaException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)((Object)e);
                }
                if (e instanceof InvalidOperationException) {
                    throw (InvalidOperationException)((Object)e);
                }
                if (e instanceof NoSuchObjectException) {
                    throw (NoSuchObjectException)((Object)e);
                }
                MetaException me = new MetaException(e.toString());
                me.initCause(e);
                throw me;
            }
            finally {
                this.endFunction("drop_database", success, ex);
            }
        }

        @Override
        public List<String> get_databases(String pattern) throws MetaException {
            this.startFunction("get_databases", ": " + pattern);
            List<String> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getDatabases(pattern);
                this.endFunction("get_databases", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_databases", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<String> get_all_databases() throws MetaException {
            this.startFunction("get_all_databases");
            List<String> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getAllDatabases();
                this.endFunction("get_all_databases", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_all_databases", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create_type_core(RawStore ms, Type type) throws AlreadyExistsException, MetaException, InvalidObjectException {
            if (!MetaStoreUtils.validateName(type.getName())) {
                throw new InvalidObjectException("Invalid type name");
            }
            boolean success = false;
            try {
                ms.openTransaction();
                if (this.is_type_exists(ms, type.getName())) {
                    throw new AlreadyExistsException("Type " + type.getName() + " already exists");
                }
                ms.createType(type);
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
            }
        }

        @Override
        public boolean create_type(Type type) throws AlreadyExistsException, MetaException, InvalidObjectException {
            this.startFunction("create_type", ": " + type.toString());
            boolean success = false;
            Exception ex = null;
            try {
                this.create_type_core(this.getMS(), type);
                success = true;
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)((Object)e);
                }
                if (e instanceof InvalidObjectException) {
                    throw (InvalidObjectException)((Object)e);
                }
                if (e instanceof AlreadyExistsException) {
                    throw (AlreadyExistsException)((Object)e);
                }
                MetaException me = new MetaException(e.toString());
                me.initCause(e);
                throw me;
            }
            finally {
                this.endFunction("create_type", success, ex);
            }
            return success;
        }

        @Override
        public Type get_type(String name) throws MetaException, NoSuchObjectException {
            this.startFunction("get_type", ": " + name);
            Type ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getType(name);
                if (null == ret) {
                    throw new NoSuchObjectException("Type \"" + name + "\" not found.");
                }
                this.endFunction("get_type", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    if (e instanceof NoSuchObjectException) {
                        throw (NoSuchObjectException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_type", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        private boolean is_type_exists(RawStore ms, String typeName) throws MetaException {
            return ms.getType(typeName) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drop_type_core(RawStore ms, String typeName) throws NoSuchObjectException, MetaException {
            boolean success = false;
            try {
                ms.openTransaction();
                if (!this.is_type_exists(ms, typeName)) {
                    throw new NoSuchObjectException(typeName + " doesn't exist");
                }
                if (!ms.dropType(typeName)) {
                    throw new MetaException("Unable to drop type " + typeName);
                }
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
            }
        }

        @Override
        public boolean drop_type(String name) throws MetaException, NoSuchObjectException {
            this.startFunction("drop_type", ": " + name);
            boolean success = false;
            Exception ex = null;
            try {
                success = this.getMS().dropType(name);
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)((Object)e);
                }
                if (e instanceof NoSuchObjectException) {
                    throw (NoSuchObjectException)((Object)e);
                }
                MetaException me = new MetaException(e.toString());
                me.initCause(e);
                throw me;
            }
            finally {
                this.endFunction("drop_type", success, ex);
            }
            return success;
        }

        @Override
        public Map<String, Type> get_type_all(String name) throws MetaException {
            this.startFunction("get_type_all", ": " + name);
            this.endFunction("get_type_all", false, null);
            throw new MetaException("Not yet implemented");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create_table_core(RawStore ms, Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, MetaException, InvalidObjectException, NoSuchObjectException {
            boolean success;
            block16: {
                if (!(MetaStoreUtils.validateName(tbl.getTableName()) && MetaStoreUtils.validateColNames(tbl.getSd().getCols()) && (tbl.getPartitionKeys() == null || MetaStoreUtils.validateColNames(tbl.getPartitionKeys())) && MetaStoreUtils.validateSkewedColNames(null == tbl.getSd().getSkewedInfo() ? null : tbl.getSd().getSkewedInfo().getSkewedColNames()) && MetaStoreUtils.validateSkewedColNamesSubsetCol(null == tbl.getSd().getSkewedInfo() ? null : tbl.getSd().getSkewedInfo().getSkewedColNames(), tbl.getSd().getCols()))) {
                    throw new InvalidObjectException(tbl.getTableName() + " is not a valid object name");
                }
                Path tblPath = null;
                success = false;
                boolean madeDir = false;
                try {
                    this.firePreEvent(new PreCreateTableEvent(tbl, this));
                    ms.openTransaction();
                    if (ms.getDatabase(tbl.getDbName()) == null) {
                        throw new NoSuchObjectException("The database " + tbl.getDbName() + " does not exist");
                    }
                    if (this.is_table_exists(ms, tbl.getDbName(), tbl.getTableName())) {
                        throw new AlreadyExistsException("Table " + tbl.getTableName() + " already exists");
                    }
                    if (!TableType.VIRTUAL_VIEW.toString().equals(tbl.getTableType())) {
                        if (tbl.getSd().getLocation() == null || tbl.getSd().getLocation().isEmpty()) {
                            tblPath = this.wh.getTablePath(ms.getDatabase(tbl.getDbName()), tbl.getTableName());
                        } else {
                            if (!this.isExternal(tbl) && !MetaStoreUtils.isNonNativeTable(tbl)) {
                                LOG.warn((Object)("Location: " + tbl.getSd().getLocation() + " specified for non-external table:" + tbl.getTableName()));
                            }
                            tblPath = this.wh.getDnsPath(new Path(tbl.getSd().getLocation()));
                        }
                        tbl.getSd().setLocation(tblPath.toString());
                    }
                    if (tblPath != null && !this.wh.isDir(tblPath)) {
                        if (!this.wh.mkdirs(tblPath)) {
                            throw new MetaException(tblPath + " is not a directory or unable to create one");
                        }
                        madeDir = true;
                    }
                    long time = System.currentTimeMillis() / 1000L;
                    tbl.setCreateTime((int)time);
                    if (tbl.getParameters() == null || tbl.getParameters().get("transient_lastDdlTime") == null) {
                        tbl.putToParameters("transient_lastDdlTime", Long.toString(time));
                    }
                    ms.createTable(tbl);
                    success = ms.commitTransaction();
                    if (success) break block16;
                    ms.rollbackTransaction();
                    if (!madeDir) break block16;
                    this.wh.deleteDir(tblPath, true);
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                        if (madeDir) {
                            this.wh.deleteDir(tblPath, true);
                        }
                    }
                    for (MetaStoreEventListener listener : this.listeners) {
                        CreateTableEvent createTableEvent = new CreateTableEvent(tbl, success, this);
                        createTableEvent.setEnvironmentContext(envContext);
                        listener.onCreateTable(createTableEvent);
                    }
                    throw throwable;
                }
            }
            for (MetaStoreEventListener listener : this.listeners) {
                CreateTableEvent createTableEvent = new CreateTableEvent(tbl, success, this);
                createTableEvent.setEnvironmentContext(envContext);
                listener.onCreateTable(createTableEvent);
            }
        }

        @Override
        public void create_table(Table tbl) throws AlreadyExistsException, MetaException, InvalidObjectException {
            this.create_table(tbl, null);
        }

        @Override
        public void create_table_with_environment_context(Table table, EnvironmentContext envContext) throws AlreadyExistsException, MetaException, InvalidObjectException {
            this.create_table(table, envContext);
        }

        private void create_table(Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, MetaException, InvalidObjectException {
            this.startFunction("create_table", ": " + tbl.toString());
            boolean success = false;
            Serializable ex = null;
            try {
                this.create_table_core(this.getMS(), tbl, envContext);
                success = true;
            }
            catch (NoSuchObjectException e) {
                ex = e;
                throw new InvalidObjectException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)((Object)e);
                }
                if (e instanceof InvalidObjectException) {
                    throw (InvalidObjectException)((Object)e);
                }
                if (e instanceof AlreadyExistsException) {
                    throw (AlreadyExistsException)((Object)e);
                }
                MetaException me = new MetaException(e.toString());
                me.initCause(e);
                throw me;
            }
            finally {
                this.endFunction("create_table", success, (Exception)ex);
            }
        }

        private boolean is_table_exists(RawStore ms, String dbname, String name) throws MetaException {
            return ms.getTable(dbname, name) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drop_table_core(RawStore ms, String dbname, String name, boolean deleteData) throws NoSuchObjectException, MetaException, IOException, InvalidObjectException, InvalidInputException {
            boolean success = false;
            boolean isExternal = false;
            Path tblPath = null;
            List<Path> partPaths = null;
            Table tbl = null;
            isExternal = false;
            boolean isIndexTable = false;
            try {
                ms.openTransaction();
                tbl = this.get_table(dbname, name);
                if (tbl == null) {
                    throw new NoSuchObjectException(name + " doesn't exist");
                }
                if (tbl.getSd() == null) {
                    throw new MetaException("Table metadata is corrupted");
                }
                this.firePreEvent(new PreDropTableEvent(tbl, this));
                isIndexTable = this.isIndexTable(tbl);
                if (isIndexTable) {
                    throw new RuntimeException("The table " + name + " is an index table. Please do drop index instead.");
                }
                if (!isIndexTable) {
                    try {
                        List<Index> indexes = ms.getIndexes(dbname, name, Short.MAX_VALUE);
                        while (indexes != null && indexes.size() > 0) {
                            for (Index idx : indexes) {
                                this.drop_index_by_name(dbname, name, idx.getIndexName(), true);
                            }
                            indexes = ms.getIndexes(dbname, name, Short.MAX_VALUE);
                        }
                    }
                    catch (TException e) {
                        throw new MetaException(e.getMessage());
                    }
                }
                isExternal = this.isExternal(tbl);
                if (tbl.getSd().getLocation() != null && !this.wh.isWritable((tblPath = new Path(tbl.getSd().getLocation())).getParent())) {
                    throw new MetaException("Table metadata not deleted since " + tblPath.getParent() + " is not writable by " + this.hiveConf.getUser());
                }
                partPaths = this.dropPartitionsAndGetLocations(ms, dbname, name, tblPath, tbl.getPartitionKeys(), deleteData && !isExternal);
                if (!ms.dropTable(dbname, name)) {
                    throw new MetaException("Unable to drop table");
                }
                success = ms.commitTransaction();
                if (!success) {
                    ms.rollbackTransaction();
                } else if (deleteData && !isExternal) {
                    this.deletePartitionData(partPaths);
                    this.deleteTableData(tblPath);
                }
            }
            catch (Throwable throwable) {
                if (!success) {
                    ms.rollbackTransaction();
                } else if (deleteData && !isExternal) {
                    this.deletePartitionData(partPaths);
                    this.deleteTableData(tblPath);
                }
                for (MetaStoreEventListener listener : this.listeners) {
                    listener.onDropTable(new DropTableEvent(tbl, success, this));
                }
                throw throwable;
            }
            for (MetaStoreEventListener listener : this.listeners) {
                listener.onDropTable(new DropTableEvent(tbl, success, this));
            }
        }

        private void deleteTableData(Path tablePath) {
            if (tablePath != null) {
                try {
                    this.wh.deleteDir(tablePath, true);
                }
                catch (Exception e) {
                    LOG.error((Object)("Failed to delete table directory: " + tablePath + " " + e.getMessage()));
                }
            }
        }

        private void deletePartitionData(List<Path> partPaths) {
            if (partPaths != null && !partPaths.isEmpty()) {
                for (Path partPath : partPaths) {
                    try {
                        this.wh.deleteDir(partPath, true);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to delete partition directory: " + partPath + " " + e.getMessage()));
                    }
                }
            }
        }

        private List<Path> dropPartitionsAndGetLocations(RawStore ms, String dbName, String tableName, Path tablePath, List<FieldSchema> partitionKeys, boolean checkLocation) throws MetaException, IOException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
            List<Partition> partsToDelete;
            int partitionBatchSize = HiveConf.getIntVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX);
            Path tableDnsPath = null;
            if (tablePath != null) {
                tableDnsPath = this.wh.getDnsPath(tablePath);
            }
            ArrayList<Path> partPaths = new ArrayList<Path>();
            while ((partsToDelete = ms.getPartitions(dbName, tableName, partitionBatchSize)) != null && !partsToDelete.isEmpty()) {
                for (Partition part : partsToDelete) {
                    if (checkLocation && part.getSd() != null && part.getSd().getLocation() != null) {
                        Path partPath = this.wh.getDnsPath(new Path(part.getSd().getLocation()));
                        if (tableDnsPath == null || partPath != null && !this.isSubdirectory(tableDnsPath, partPath)) {
                            if (!this.wh.isWritable(partPath.getParent())) {
                                throw new MetaException("Table metadata not deleted since the partition " + Warehouse.makePartName(partitionKeys, part.getValues()) + " has parent location " + partPath.getParent() + " which is not writable " + "by " + this.hiveConf.getUser());
                            }
                            partPaths.add(partPath);
                        }
                    }
                    ms.dropPartition(dbName, tableName, part.getValues());
                }
            }
            return partPaths;
        }

        @Override
        public void drop_table(String dbname, String name, boolean deleteData) throws NoSuchObjectException, MetaException {
            this.startTableFunction("drop_table", dbname, name);
            boolean success = false;
            Exception ex = null;
            try {
                this.drop_table_core(this.getMS(), dbname, name, deleteData);
                success = true;
            }
            catch (IOException e) {
                ex = e;
                throw new MetaException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)((Object)e);
                }
                if (e instanceof NoSuchObjectException) {
                    throw (NoSuchObjectException)((Object)e);
                }
                MetaException me = new MetaException(e.toString());
                me.initCause(e);
                throw me;
            }
            finally {
                this.endFunction("drop_table", success, ex);
            }
        }

        private boolean isExternal(Table table) {
            return MetaStoreUtils.isExternalTable(table);
        }

        private boolean isIndexTable(Table table) {
            return MetaStoreUtils.isIndexTable(table);
        }

        @Override
        public Table get_table(String dbname, String name) throws MetaException, NoSuchObjectException {
            Table t = null;
            this.startTableFunction("get_table", dbname, name);
            Exception ex = null;
            try {
                t = this.getMS().getTable(dbname, name);
                if (t == null) {
                    throw new NoSuchObjectException(dbname + "." + name + " table not found");
                }
                this.endFunction("get_table", t != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    if (e instanceof NoSuchObjectException) {
                        throw (NoSuchObjectException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_table", t != null, ex);
                    throw throwable;
                }
            }
            return t;
        }

        @Override
        public List<Table> get_table_objects_by_name(String dbname, List<String> names) throws MetaException, InvalidOperationException, UnknownDBException {
            List<Table> tables = null;
            this.startMultiTableFunction("get_multi_table", dbname, names);
            Exception ex = null;
            try {
                if (dbname == null || dbname.isEmpty()) {
                    throw new UnknownDBException("DB name is null or empty");
                }
                if (names == null) {
                    throw new InvalidOperationException(dbname + " cannot find null tables");
                }
                tables = this.getMS().getTableObjectsByName(dbname, names);
                this.endFunction("get_multi_table", tables != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    if (e instanceof InvalidOperationException) {
                        throw (InvalidOperationException)((Object)e);
                    }
                    if (e instanceof UnknownDBException) {
                        throw (UnknownDBException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_multi_table", tables != null, ex);
                    throw throwable;
                }
            }
            return tables;
        }

        @Override
        public List<String> get_table_names_by_filter(String dbName, String filter, short maxTables) throws MetaException, InvalidOperationException, UnknownDBException {
            List<String> tables = null;
            this.startFunction("get_table_names_by_filter", ": db = " + dbName + ", filter = " + filter);
            Exception ex = null;
            try {
                if (dbName == null || dbName.isEmpty()) {
                    throw new UnknownDBException("DB name is null or empty");
                }
                if (filter == null) {
                    throw new InvalidOperationException(filter + " cannot apply null filter");
                }
                tables = this.getMS().listTableNamesByFilter(dbName, filter, maxTables);
                this.endFunction("get_table_names_by_filter", tables != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    if (e instanceof InvalidOperationException) {
                        throw (InvalidOperationException)((Object)e);
                    }
                    if (e instanceof UnknownDBException) {
                        throw (UnknownDBException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_table_names_by_filter", tables != null, ex);
                    throw throwable;
                }
            }
            return tables;
        }

        public boolean set_table_parameters(String dbname, String name, Map<String, String> params) throws NoSuchObjectException, MetaException {
            this.endFunction(this.startTableFunction("set_table_parameters", dbname, name), false, null);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Partition append_partition_common(RawStore ms, String dbName, String tableName, List<String> part_vals) throws InvalidObjectException, AlreadyExistsException, MetaException {
            Table tbl;
            boolean success;
            Partition part;
            block14: {
                part = new Partition();
                success = false;
                boolean madeDir = false;
                Path partLocation = null;
                tbl = null;
                try {
                    ms.openTransaction();
                    part.setDbName(dbName);
                    part.setTableName(tableName);
                    part.setValues(part_vals);
                    PreAddPartitionEvent event = new PreAddPartitionEvent(part, this);
                    this.firePreEvent(event);
                    tbl = ms.getTable(part.getDbName(), part.getTableName());
                    if (tbl == null) {
                        throw new InvalidObjectException("Unable to add partition because table or database do not exist");
                    }
                    if (tbl.getSd().getLocation() == null) {
                        throw new MetaException("Cannot append a partition to a view");
                    }
                    part.setSd(tbl.getSd());
                    partLocation = new Path(tbl.getSd().getLocation(), Warehouse.makePartName(tbl.getPartitionKeys(), part_vals));
                    part.getSd().setLocation(partLocation.toString());
                    Partition old_part = null;
                    try {
                        old_part = ms.getPartition(part.getDbName(), part.getTableName(), part.getValues());
                    }
                    catch (NoSuchObjectException e) {
                        old_part = null;
                    }
                    if (old_part != null) {
                        throw new AlreadyExistsException("Partition already exists:" + part);
                    }
                    if (!this.wh.isDir(partLocation)) {
                        if (!this.wh.mkdirs(partLocation)) {
                            throw new MetaException(partLocation + " is not a directory or unable to create one");
                        }
                        madeDir = true;
                    }
                    long time = System.currentTimeMillis() / 1000L;
                    part.setCreateTime((int)time);
                    part.putToParameters("transient_lastDdlTime", Long.toString(time));
                    success = ms.addPartition(part);
                    if (success) {
                        success = ms.commitTransaction();
                    }
                    if (success) break block14;
                    ms.rollbackTransaction();
                    if (!madeDir) break block14;
                    this.wh.deleteDir(partLocation, true);
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                        if (madeDir) {
                            this.wh.deleteDir(partLocation, true);
                        }
                    }
                    for (MetaStoreEventListener listener : this.listeners) {
                        AddPartitionEvent addPartitionEvent = new AddPartitionEvent(tbl, part, success, this);
                        listener.onAddPartition(addPartitionEvent);
                    }
                    throw throwable;
                }
            }
            for (MetaStoreEventListener listener : this.listeners) {
                AddPartitionEvent addPartitionEvent = new AddPartitionEvent(tbl, part, success, this);
                listener.onAddPartition(addPartitionEvent);
            }
            return part;
        }

        private void firePreEvent(PreEventContext event) throws MetaException {
            for (MetaStorePreEventListener listener : this.preListeners) {
                try {
                    listener.onEvent(event);
                }
                catch (NoSuchObjectException e) {
                    throw new MetaException(e.getMessage());
                }
                catch (InvalidOperationException e) {
                    throw new MetaException(e.getMessage());
                }
            }
        }

        @Override
        public Partition append_partition(String dbName, String tableName, List<String> part_vals) throws InvalidObjectException, AlreadyExistsException, MetaException {
            this.startPartitionFunction("append_partition", dbName, tableName, part_vals);
            if (LOG.isDebugEnabled()) {
                for (String part : part_vals) {
                    LOG.debug((Object)part);
                }
            }
            Partition ret = null;
            Exception ex = null;
            try {
                ret = this.append_partition_common(this.getMS(), dbName, tableName, part_vals);
                this.endFunction("append_partition", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    if (e instanceof InvalidObjectException) {
                        throw (InvalidObjectException)((Object)e);
                    }
                    if (e instanceof AlreadyExistsException) {
                        throw (AlreadyExistsException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("append_partition", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int add_partitions_core(RawStore ms, List<Partition> parts) throws MetaException, InvalidObjectException, AlreadyExistsException {
            block6: {
                String db = parts.get(0).getDbName();
                String tbl = parts.get(0).getTableName();
                this.logInfo("add_partitions : db=" + db + " tbl=" + tbl);
                boolean success = false;
                HashMap<Partition, Boolean> addedPartitions = new HashMap<Partition, Boolean>();
                try {
                    ms.openTransaction();
                    for (Partition partition : parts) {
                        Map.Entry<Partition, Boolean> e = this.add_partition_core_notxn(ms, partition, null);
                        addedPartitions.put(e.getKey(), e.getValue());
                    }
                    success = true;
                    ms.commitTransaction();
                    if (success) break block6;
                    ms.rollbackTransaction();
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                        for (Map.Entry e : addedPartitions.entrySet()) {
                            if (!((Boolean)e.getValue()).booleanValue()) continue;
                            this.wh.deleteDir(new Path(((Partition)e.getKey()).getSd().getLocation()), true);
                        }
                    }
                    throw throwable;
                }
                for (Map.Entry entry : addedPartitions.entrySet()) {
                    if (!((Boolean)entry.getValue()).booleanValue()) continue;
                    this.wh.deleteDir(new Path(((Partition)entry.getKey()).getSd().getLocation()), true);
                }
            }
            return parts.size();
        }

        @Override
        public int add_partitions(List<Partition> parts) throws MetaException, InvalidObjectException, AlreadyExistsException {
            this.startFunction("add_partition");
            if (parts.size() == 0) {
                return 0;
            }
            Integer ret = null;
            Exception ex = null;
            try {
                ret = this.add_partitions_core(this.getMS(), parts);
                this.endFunction("add_partition", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    if (e instanceof InvalidObjectException) {
                        throw (InvalidObjectException)((Object)e);
                    }
                    if (e instanceof AlreadyExistsException) {
                        throw (AlreadyExistsException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("add_partition", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map.Entry<Partition, Boolean> add_partition_core_notxn(RawStore ms, Partition part, EnvironmentContext envContext) throws InvalidObjectException, AlreadyExistsException, MetaException {
            Table tbl;
            boolean madeDir;
            boolean success;
            block20: {
                success = false;
                madeDir = false;
                Path partLocation = null;
                tbl = null;
                try {
                    this.firePreEvent(new PreAddPartitionEvent(part, this));
                    Partition old_part = null;
                    try {
                        old_part = ms.getPartition(part.getDbName(), part.getTableName(), part.getValues());
                    }
                    catch (NoSuchObjectException e) {
                        old_part = null;
                    }
                    if (old_part != null) {
                        throw new AlreadyExistsException("Partition already exists:" + part);
                    }
                    tbl = ms.getTable(part.getDbName(), part.getTableName());
                    if (tbl == null) {
                        throw new InvalidObjectException("Unable to add partition because table or database do not exist");
                    }
                    String partLocationStr = null;
                    if (part.getSd() != null) {
                        partLocationStr = part.getSd().getLocation();
                    }
                    if (partLocationStr == null || partLocationStr.isEmpty()) {
                        if (tbl.getSd().getLocation() != null) {
                            partLocation = new Path(tbl.getSd().getLocation(), Warehouse.makePartName(tbl.getPartitionKeys(), part.getValues()));
                        }
                    } else {
                        if (tbl.getSd().getLocation() == null) {
                            throw new MetaException("Cannot specify location for a view partition");
                        }
                        partLocation = this.wh.getDnsPath(new Path(partLocationStr));
                    }
                    if (partLocation != null) {
                        part.getSd().setLocation(partLocation.toString());
                        if (!this.wh.isDir(partLocation)) {
                            if (!this.wh.mkdirs(partLocation)) {
                                throw new MetaException(partLocation + " is not a directory or unable to create one");
                            }
                            madeDir = true;
                        }
                    }
                    long time = System.currentTimeMillis() / 1000L;
                    part.setCreateTime((int)time);
                    if (part.getParameters() == null || part.getParameters().get("transient_lastDdlTime") == null) {
                        part.putToParameters("transient_lastDdlTime", Long.toString(time));
                    }
                    Map<String, String> tblParams = tbl.getParameters();
                    String inheritProps = this.hiveConf.getVar(HiveConf.ConfVars.METASTORE_PART_INHERIT_TBL_PROPS).trim();
                    Set<String> inheritKeys = new HashSet<String>(Arrays.asList(inheritProps.split(",")));
                    if (inheritKeys.contains("*")) {
                        inheritKeys = tblParams.keySet();
                    }
                    for (String key : inheritKeys) {
                        String paramVal = tblParams.get(key);
                        if (null == paramVal) continue;
                        part.putToParameters(key, paramVal);
                    }
                    success = ms.addPartition(part);
                    if (success || !madeDir) break block20;
                    this.wh.deleteDir(partLocation, true);
                }
                catch (Throwable throwable) {
                    if (!success && madeDir) {
                        this.wh.deleteDir(partLocation, true);
                    }
                    for (MetaStoreEventListener listener : this.listeners) {
                        AddPartitionEvent addPartitionEvent = new AddPartitionEvent(tbl, part, success, this);
                        addPartitionEvent.setEnvironmentContext(envContext);
                        listener.onAddPartition(addPartitionEvent);
                    }
                    throw throwable;
                }
            }
            for (MetaStoreEventListener listener : this.listeners) {
                AddPartitionEvent addPartitionEvent = new AddPartitionEvent(tbl, part, success, this);
                addPartitionEvent.setEnvironmentContext(envContext);
                listener.onAddPartition(addPartitionEvent);
            }
            HashMap<Partition, Boolean> returnVal = new HashMap<Partition, Boolean>();
            returnVal.put(part, madeDir);
            return returnVal.entrySet().iterator().next();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Partition add_partition_core(RawStore ms, Partition part, EnvironmentContext envContext) throws InvalidObjectException, AlreadyExistsException, MetaException {
            boolean success = false;
            Partition retPtn = null;
            try {
                ms.openTransaction();
                retPtn = this.add_partition_core_notxn(ms, part, envContext).getKey();
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
            }
            return retPtn;
        }

        @Override
        public Partition add_partition(Partition part) throws InvalidObjectException, AlreadyExistsException, MetaException {
            return this.add_partition(part, null);
        }

        @Override
        public Partition add_partition_with_environment_context(Partition part, EnvironmentContext envContext) throws InvalidObjectException, AlreadyExistsException, MetaException {
            return this.add_partition(part, envContext);
        }

        private Partition add_partition(Partition part, EnvironmentContext envContext) throws InvalidObjectException, AlreadyExistsException, MetaException {
            this.startTableFunction("add_partition", part.getDbName(), part.getTableName());
            Partition ret = null;
            Exception ex = null;
            try {
                ret = this.add_partition_core(this.getMS(), part, envContext);
                this.endFunction("add_partition", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    if (e instanceof InvalidObjectException) {
                        throw (InvalidObjectException)((Object)e);
                    }
                    if (e instanceof AlreadyExistsException) {
                        throw (AlreadyExistsException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("add_partition", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean drop_partition_common(RawStore ms, String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws MetaException, NoSuchObjectException, IOException, InvalidObjectException, InvalidInputException {
            Partition part;
            Table tbl;
            boolean success;
            block17: {
                Path partPath;
                block18: {
                    Path archiveParentDir;
                    block19: {
                        success = false;
                        partPath = null;
                        tbl = null;
                        part = null;
                        boolean isArchived = false;
                        archiveParentDir = null;
                        try {
                            ms.openTransaction();
                            part = ms.getPartition(db_name, tbl_name, part_vals);
                            this.firePreEvent(new PreDropPartitionEvent(part, this));
                            if (part == null) {
                                throw new NoSuchObjectException("Partition doesn't exist. " + part_vals);
                            }
                            isArchived = MetaStoreUtils.isArchived(part);
                            if (isArchived && !this.wh.isWritable((archiveParentDir = MetaStoreUtils.getOriginalLocation(part)).getParent())) {
                                throw new MetaException("Table partition not deleted since " + archiveParentDir.getParent() + " is not writable by " + this.hiveConf.getUser());
                            }
                            if (!ms.dropPartition(db_name, tbl_name, part_vals)) {
                                throw new MetaException("Unable to drop partition");
                            }
                            success = ms.commitTransaction();
                            if (part.getSd() != null && part.getSd().getLocation() != null && !this.wh.isWritable((partPath = new Path(part.getSd().getLocation())).getParent())) {
                                throw new MetaException("Table partition not deleted since " + partPath.getParent() + " is not writable by " + this.hiveConf.getUser());
                            }
                            tbl = this.get_table(db_name, tbl_name);
                            if (!success) {
                                ms.rollbackTransaction();
                                break block17;
                            }
                            if (!deleteData || partPath == null && archiveParentDir == null || tbl == null || this.isExternal(tbl)) break block17;
                            if (!isArchived) break block18;
                            if ($assertionsDisabled || archiveParentDir != null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (!success) {
                                ms.rollbackTransaction();
                            } else if (deleteData && (partPath != null || archiveParentDir != null) && tbl != null && !this.isExternal(tbl)) {
                                if (isArchived) {
                                    assert (archiveParentDir != null);
                                    this.wh.deleteDir(archiveParentDir, true);
                                } else {
                                    assert (partPath != null);
                                    this.wh.deleteDir(partPath, true);
                                }
                            }
                            for (MetaStoreEventListener listener : this.listeners) {
                                listener.onDropPartition(new DropPartitionEvent(tbl, part, success, this));
                            }
                            throw throwable;
                        }
                        throw new AssertionError();
                    }
                    this.wh.deleteDir(archiveParentDir, true);
                    break block17;
                }
                assert (partPath != null);
                this.wh.deleteDir(partPath, true);
            }
            for (MetaStoreEventListener listener : this.listeners) {
                listener.onDropPartition(new DropPartitionEvent(tbl, part, success, this));
            }
            return true;
        }

        @Override
        public boolean drop_partition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
            this.startPartitionFunction("drop_partition", db_name, tbl_name, part_vals);
            LOG.info((Object)("Partition values:" + part_vals));
            boolean ret = false;
            Exception ex = null;
            try {
                ret = this.drop_partition_common(this.getMS(), db_name, tbl_name, part_vals, deleteData);
            }
            catch (IOException e) {
                ex = e;
                throw new MetaException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)((Object)e);
                }
                if (e instanceof NoSuchObjectException) {
                    throw (NoSuchObjectException)((Object)e);
                }
                if (e instanceof TException) {
                    throw (TException)((Object)e);
                }
                MetaException me = new MetaException(e.toString());
                me.initCause(e);
                throw me;
            }
            finally {
                this.endFunction("drop_partition", ret, ex);
            }
            return ret;
        }

        @Override
        public Partition get_partition(String db_name, String tbl_name, List<String> part_vals) throws MetaException, NoSuchObjectException {
            this.startPartitionFunction("get_partition", db_name, tbl_name, part_vals);
            Partition ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getPartition(db_name, tbl_name, part_vals);
                this.endFunction("get_partition", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    if (e instanceof NoSuchObjectException) {
                        throw (NoSuchObjectException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partition", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Partition get_partition_with_auth(String db_name, String tbl_name, List<String> part_vals, String user_name, List<String> group_names) throws MetaException, NoSuchObjectException, TException {
            this.startPartitionFunction("get_partition_with_auth", db_name, tbl_name, part_vals);
            Partition ret = null;
            Serializable ex = null;
            try {
                ret = this.getMS().getPartitionWithAuth(db_name, tbl_name, part_vals, user_name, group_names);
                this.endFunction("get_partition_with_auth", ret != null, (Exception)ex);
                return ret;
            }
            catch (InvalidObjectException e) {
                try {
                    ex = e;
                    throw new NoSuchObjectException(e.getMessage());
                    catch (Exception e2) {
                        ex = e2;
                        if (e2 instanceof MetaException) {
                            throw (MetaException)((Object)e2);
                        }
                        if (e2 instanceof NoSuchObjectException) {
                            throw (NoSuchObjectException)((Object)e2);
                        }
                        if (e2 instanceof TException) {
                            throw (TException)((Object)e2);
                        }
                        MetaException me = new MetaException(e2.toString());
                        me.initCause(e2);
                        throw me;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partition_with_auth", ret != null, (Exception)ex);
                    throw throwable;
                }
            }
        }

        @Override
        public List<Partition> get_partitions(String db_name, String tbl_name, short max_parts) throws NoSuchObjectException, MetaException {
            this.startTableFunction("get_partitions", db_name, tbl_name);
            List<Partition> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getPartitions(db_name, tbl_name, max_parts);
                this.endFunction("get_partitions", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    if (e instanceof NoSuchObjectException) {
                        throw (NoSuchObjectException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<Partition> get_partitions_with_auth(String dbName, String tblName, short maxParts, String userName, List<String> groupNames) throws NoSuchObjectException, MetaException, TException {
            this.startTableFunction("get_partitions_with_auth", dbName, tblName);
            List<Partition> ret = null;
            Serializable ex = null;
            try {
                ret = this.getMS().getPartitionsWithAuth(dbName, tblName, maxParts, userName, groupNames);
                this.endFunction("get_partitions_with_auth", ret != null, (Exception)ex);
                return ret;
            }
            catch (InvalidObjectException e) {
                try {
                    ex = e;
                    throw new NoSuchObjectException(e.getMessage());
                    catch (Exception e2) {
                        ex = e2;
                        if (e2 instanceof MetaException) {
                            throw (MetaException)((Object)e2);
                        }
                        if (e2 instanceof NoSuchObjectException) {
                            throw (NoSuchObjectException)((Object)e2);
                        }
                        if (e2 instanceof TException) {
                            throw (TException)((Object)e2);
                        }
                        MetaException me = new MetaException(e2.toString());
                        me.initCause(e2);
                        throw me;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_with_auth", ret != null, (Exception)ex);
                    throw throwable;
                }
            }
        }

        @Override
        public List<String> get_partition_names(String db_name, String tbl_name, short max_parts) throws MetaException {
            this.startTableFunction("get_partition_names", db_name, tbl_name);
            List<String> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().listPartitionNames(db_name, tbl_name, max_parts);
                this.endFunction("get_partition_names", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partition_names", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public void alter_partition(String db_name, String tbl_name, Partition new_part) throws InvalidOperationException, MetaException, TException {
            this.rename_partition(db_name, tbl_name, null, new_part);
        }

        @Override
        public void alter_partition_with_environment_context(String dbName, String tableName, Partition newPartition, EnvironmentContext envContext) throws InvalidOperationException, MetaException, TException {
            this.rename_partition(dbName, tableName, null, newPartition, envContext);
        }

        @Override
        public void rename_partition(String db_name, String tbl_name, List<String> part_vals, Partition new_part) throws InvalidOperationException, MetaException, TException {
            this.rename_partition(db_name, tbl_name, part_vals, new_part, null);
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void rename_partition(String db_name, String tbl_name, List<String> part_vals, Partition new_part, EnvironmentContext envContext) throws InvalidOperationException, MetaException, TException {
            this.startTableFunction("alter_partition", db_name, tbl_name);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("New partition values:" + new_part.getValues()));
                if (part_vals != null && part_vals.size() > 0) {
                    LOG.info((Object)("Old Partition values:" + part_vals));
                }
            }
            Partition oldPart = null;
            Serializable ex = null;
            try {
                this.firePreEvent(new PreAlterPartitionEvent(db_name, tbl_name, part_vals, new_part, this));
                oldPart = this.alterHandler.alterPartition(this.getMS(), this.wh, db_name, tbl_name, part_vals, new_part);
                for (MetaStoreEventListener listener : this.listeners) {
                    AlterPartitionEvent alterPartitionEvent = new AlterPartitionEvent(oldPart, new_part, true, this);
                    alterPartitionEvent.setEnvironmentContext(envContext);
                    listener.onAlterPartition(alterPartitionEvent);
                }
                this.endFunction("alter_partition", oldPart != null, (Exception)ex);
                return;
            }
            catch (InvalidObjectException e) {
                try {
                    ex = e;
                    throw new InvalidOperationException(e.getMessage());
                    catch (AlreadyExistsException e2) {
                        ex = e2;
                        throw new InvalidOperationException(e2.getMessage());
                    }
                    catch (Exception e3) {
                        ex = e3;
                        if (e3 instanceof MetaException) {
                            throw (MetaException)((Object)e3);
                        }
                        if (e3 instanceof InvalidOperationException) {
                            throw (InvalidOperationException)((Object)e3);
                        }
                        if (e3 instanceof TException) {
                            throw (TException)((Object)e3);
                        }
                        MetaException me = new MetaException(e3.toString());
                        me.initCause(e3);
                        throw me;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("alter_partition", oldPart != null, (Exception)ex);
                    throw throwable;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void alter_partitions(String db_name, String tbl_name, List<Partition> new_parts) throws InvalidOperationException, MetaException, TException {
            this.startTableFunction("alter_partitions", db_name, tbl_name);
            if (LOG.isInfoEnabled()) {
                for (Partition tmpPart : new_parts) {
                    LOG.info((Object)("New partition values:" + tmpPart.getValues()));
                }
            }
            List<Partition> oldParts = null;
            Serializable ex = null;
            try {
                for (Partition tmpPart : new_parts) {
                    try {
                        for (MetaStorePreEventListener listener : this.preListeners) {
                            listener.onEvent(new PreAlterPartitionEvent(db_name, tbl_name, null, tmpPart, this));
                        }
                    }
                    catch (NoSuchObjectException e) {
                        throw new MetaException(e.getMessage());
                    }
                }
                oldParts = this.alterHandler.alterPartitions(this.getMS(), this.wh, db_name, tbl_name, new_parts);
                Iterator<Partition> olditr = oldParts.iterator();
                for (Partition tmpPart : new_parts) {
                    Partition oldTmpPart = null;
                    if (!olditr.hasNext()) throw new InvalidOperationException("failed to alterpartitions");
                    oldTmpPart = olditr.next();
                    for (MetaStoreEventListener listener : this.listeners) {
                        AlterPartitionEvent alterPartitionEvent = new AlterPartitionEvent(oldTmpPart, tmpPart, true, this);
                        listener.onAlterPartition(alterPartitionEvent);
                    }
                }
                this.endFunction("alter_partition", oldParts != null, (Exception)ex);
                return;
            }
            catch (InvalidObjectException e) {
                try {
                    ex = e;
                    throw new InvalidOperationException(e.getMessage());
                    catch (AlreadyExistsException e2) {
                        ex = e2;
                        throw new InvalidOperationException(e2.getMessage());
                    }
                    catch (Exception e3) {
                        ex = e3;
                        if (e3 instanceof MetaException) {
                            throw (MetaException)((Object)e3);
                        }
                        if (e3 instanceof InvalidOperationException) {
                            throw (InvalidOperationException)((Object)e3);
                        }
                        if (e3 instanceof TException) {
                            throw (TException)((Object)e3);
                        }
                        MetaException me = new MetaException(e3.toString());
                        me.initCause(e3);
                        throw me;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("alter_partition", oldParts != null, (Exception)ex);
                    throw throwable;
                }
            }
        }

        public boolean create_index(Index index_def) throws IndexAlreadyExistsException, MetaException {
            this.endFunction(this.startFunction("create_index"), false, null);
            throw new MetaException("Not yet implemented");
        }

        @Override
        public void alter_index(String dbname, String base_table_name, String index_name, Index newIndex) throws InvalidOperationException, MetaException {
            this.startFunction("alter_index", ": db=" + dbname + " base_tbl=" + base_table_name + " idx=" + index_name + " newidx=" + newIndex.getIndexName());
            newIndex.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
            boolean success = false;
            Serializable ex = null;
            try {
                this.getMS().alterIndex(dbname, base_table_name, index_name, newIndex);
                success = true;
            }
            catch (InvalidObjectException e) {
                ex = e;
                throw new InvalidOperationException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)((Object)e);
                }
                if (e instanceof InvalidOperationException) {
                    throw (InvalidOperationException)((Object)e);
                }
                MetaException me = new MetaException(e.toString());
                me.initCause(e);
                throw me;
            }
            finally {
                this.endFunction("alter_index", success, (Exception)ex);
            }
        }

        public String getVersion() throws TException {
            this.endFunction(this.startFunction("getVersion"), true, null);
            return "3.0";
        }

        @Override
        public void alter_table(String dbname, String name, Table newTable) throws InvalidOperationException, MetaException {
            this.alter_table(dbname, name, newTable, null);
        }

        @Override
        public void alter_table_with_environment_context(String dbname, String name, Table newTable, EnvironmentContext envContext) throws InvalidOperationException, MetaException {
            this.alter_table(dbname, name, newTable, envContext);
        }

        private void alter_table(String dbname, String name, Table newTable, EnvironmentContext envContext) throws InvalidOperationException, MetaException {
            this.startFunction("alter_table", ": db=" + dbname + " tbl=" + name + " newtbl=" + newTable.getTableName());
            if (newTable.getParameters() == null || newTable.getParameters().get("transient_lastDdlTime") == null) {
                newTable.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
            }
            boolean success = false;
            Serializable ex = null;
            try {
                Table oldt = this.get_table(dbname, name);
                this.firePreEvent(new PreAlterTableEvent(oldt, newTable, this));
                this.alterHandler.alterTable(this.getMS(), this.wh, dbname, name, newTable);
                success = true;
                for (MetaStoreEventListener listener : this.listeners) {
                    AlterTableEvent alterTableEvent = new AlterTableEvent(oldt, newTable, success, this);
                    alterTableEvent.setEnvironmentContext(envContext);
                    listener.onAlterTable(alterTableEvent);
                }
            }
            catch (NoSuchObjectException e) {
                ex = e;
                throw new InvalidOperationException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)((Object)e);
                }
                if (e instanceof InvalidOperationException) {
                    throw (InvalidOperationException)((Object)e);
                }
                MetaException me = new MetaException(e.toString());
                me.initCause(e);
                throw me;
            }
            finally {
                this.endFunction("alter_table", success, (Exception)ex);
            }
        }

        @Override
        public List<String> get_tables(String dbname, String pattern) throws MetaException {
            this.startFunction("get_tables", ": db=" + dbname + " pat=" + pattern);
            List<String> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getTables(dbname, pattern);
                this.endFunction("get_tables", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_tables", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<String> get_all_tables(String dbname) throws MetaException {
            this.startFunction("get_all_tables", ": db=" + dbname);
            List<String> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getAllTables(dbname);
                this.endFunction("get_all_tables", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_all_tables", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<FieldSchema> get_fields(String db, String tableName) throws MetaException, UnknownTableException, UnknownDBException {
            this.startFunction("get_fields", ": db=" + db + "tbl=" + tableName);
            String[] names = tableName.split("\\.");
            String base_table_name = names[0];
            List<FieldSchema> ret = null;
            Exception ex = null;
            try {
                Table tbl;
                try {
                    tbl = this.get_table(db, base_table_name);
                }
                catch (NoSuchObjectException e) {
                    throw new UnknownTableException(e.getMessage());
                }
                boolean getColsFromSerDe = SerDeUtils.shouldGetColsFromSerDe((String)tbl.getSd().getSerdeInfo().getSerializationLib());
                if (!getColsFromSerDe) {
                    ret = tbl.getSd().getCols();
                } else {
                    try {
                        Deserializer s = MetaStoreUtils.getDeserializer((Configuration)this.hiveConf, tbl);
                        ret = MetaStoreUtils.getFieldsFromDeserializer(tableName, s);
                    }
                    catch (SerDeException e) {
                        org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e);
                        throw new MetaException(e.getMessage());
                    }
                }
                this.endFunction("get_fields", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof UnknownDBException) {
                        throw (UnknownDBException)((Object)e);
                    }
                    if (e instanceof UnknownTableException) {
                        throw (UnknownTableException)((Object)e);
                    }
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_fields", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<FieldSchema> get_schema(String db, String tableName) throws MetaException, UnknownTableException, UnknownDBException {
            this.startFunction("get_schema", ": db=" + db + "tbl=" + tableName);
            boolean success = false;
            Exception ex = null;
            try {
                Table tbl;
                String[] names = tableName.split("\\.");
                String base_table_name = names[0];
                try {
                    tbl = this.get_table(db, base_table_name);
                }
                catch (NoSuchObjectException e) {
                    throw new UnknownTableException(e.getMessage());
                }
                List<FieldSchema> fieldSchemas = this.get_fields(db, base_table_name);
                if (tbl == null || fieldSchemas == null) {
                    throw new UnknownTableException(tableName + " doesn't exist");
                }
                if (tbl.getPartitionKeys() != null) {
                    fieldSchemas.addAll(tbl.getPartitionKeys());
                }
                success = true;
                List<FieldSchema> list = fieldSchemas;
                return list;
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof UnknownDBException) {
                    throw (UnknownDBException)((Object)e);
                }
                if (e instanceof UnknownTableException) {
                    throw (UnknownTableException)((Object)e);
                }
                if (e instanceof MetaException) {
                    throw (MetaException)((Object)e);
                }
                MetaException me = new MetaException(e.toString());
                me.initCause(e);
                throw me;
            }
            finally {
                this.endFunction("get_schema", success, ex);
            }
        }

        public String getCpuProfile(int profileDurationInSec) throws TException {
            return "";
        }

        @Override
        public String get_config_value(String name, String defaultValue) throws TException, ConfigValSecurityException {
            this.startFunction("get_config_value", ": name=" + name + " defaultValue=" + defaultValue);
            boolean success = false;
            Exception ex = null;
            try {
                if (name == null) {
                    success = true;
                    String string = defaultValue;
                    return string;
                }
                if (!Pattern.matches("(hive|hdfs|mapred|maprfs|s3|s3n|mapreduce).*", name)) {
                    throw new ConfigValSecurityException("For security reasons, the config key " + name + " cannot be accessed");
                }
                String toReturn = defaultValue;
                try {
                    toReturn = this.hiveConf.get(name, defaultValue);
                }
                catch (RuntimeException e) {
                    LOG.error((Object)(threadLocalId.get().toString() + ": " + "RuntimeException thrown in get_config_value - msg: " + e.getMessage() + " cause: " + e.getCause()));
                }
                success = true;
                String e = toReturn;
                return e;
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof ConfigValSecurityException) {
                    throw (ConfigValSecurityException)((Object)e);
                }
                if (e instanceof TException) {
                    throw (TException)((Object)e);
                }
                TException te = new TException(e.toString());
                te.initCause((Throwable)e);
                throw te;
            }
            finally {
                this.endFunction("get_config_value", success, ex);
            }
        }

        private List<String> getPartValsFromName(RawStore ms, String dbName, String tblName, String partName) throws MetaException, InvalidObjectException {
            LinkedHashMap<String, String> hm = Warehouse.makeSpecFromName(partName);
            Table t = ms.getTable(dbName, tblName);
            if (t == null) {
                throw new InvalidObjectException(dbName + "." + tblName + " table not found");
            }
            ArrayList<String> partVals = new ArrayList<String>();
            for (FieldSchema field : t.getPartitionKeys()) {
                String key = field.getName();
                String val = hm.get(key);
                if (val == null) {
                    throw new InvalidObjectException("incomplete partition name - missing " + key);
                }
                partVals.add(val);
            }
            return partVals;
        }

        private Partition get_partition_by_name_core(RawStore ms, String db_name, String tbl_name, String part_name) throws MetaException, NoSuchObjectException, TException {
            List<String> partVals = null;
            try {
                partVals = this.getPartValsFromName(ms, db_name, tbl_name, part_name);
            }
            catch (InvalidObjectException e) {
                throw new NoSuchObjectException(e.getMessage());
            }
            Partition p = ms.getPartition(db_name, tbl_name, partVals);
            if (p == null) {
                throw new NoSuchObjectException(db_name + "." + tbl_name + " partition (" + part_name + ") not found");
            }
            return p;
        }

        @Override
        public Partition get_partition_by_name(String db_name, String tbl_name, String part_name) throws MetaException, NoSuchObjectException, TException {
            this.startFunction("get_partition_by_name", ": db=" + db_name + " tbl=" + tbl_name + " part=" + part_name);
            Partition ret = null;
            Exception ex = null;
            try {
                ret = this.get_partition_by_name_core(this.getMS(), db_name, tbl_name, part_name);
                this.endFunction("get_partition_by_name", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    if (e instanceof NoSuchObjectException) {
                        throw (NoSuchObjectException)((Object)e);
                    }
                    if (e instanceof TException) {
                        throw (TException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partition_by_name", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public Partition append_partition_by_name(String db_name, String tbl_name, String part_name) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
            this.startFunction("append_partition_by_name", ": db=" + db_name + " tbl=" + tbl_name + " part=" + part_name);
            Partition ret = null;
            Exception ex = null;
            try {
                RawStore ms = this.getMS();
                List<String> partVals = this.getPartValsFromName(ms, db_name, tbl_name, part_name);
                ret = this.append_partition_common(ms, db_name, tbl_name, partVals);
                this.endFunction("append_partition_by_name", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof InvalidObjectException) {
                        throw (InvalidObjectException)((Object)e);
                    }
                    if (e instanceof AlreadyExistsException) {
                        throw (AlreadyExistsException)((Object)e);
                    }
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    if (e instanceof TException) {
                        throw (TException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("append_partition_by_name", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        private boolean drop_partition_by_name_core(RawStore ms, String db_name, String tbl_name, String part_name, boolean deleteData) throws NoSuchObjectException, MetaException, TException, IOException, InvalidObjectException, InvalidInputException {
            List<String> partVals = null;
            try {
                partVals = this.getPartValsFromName(ms, db_name, tbl_name, part_name);
            }
            catch (InvalidObjectException e) {
                throw new NoSuchObjectException(e.getMessage());
            }
            return this.drop_partition_common(ms, db_name, tbl_name, partVals, deleteData);
        }

        @Override
        public boolean drop_partition_by_name(String db_name, String tbl_name, String part_name, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
            this.startFunction("drop_partition_by_name", ": db=" + db_name + " tbl=" + tbl_name + " part=" + part_name);
            boolean ret = false;
            Exception ex = null;
            try {
                ret = this.drop_partition_by_name_core(this.getMS(), db_name, tbl_name, part_name, deleteData);
            }
            catch (IOException e) {
                ex = e;
                throw new MetaException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)((Object)e);
                }
                if (e instanceof NoSuchObjectException) {
                    throw (NoSuchObjectException)((Object)e);
                }
                if (e instanceof TException) {
                    throw (TException)((Object)e);
                }
                MetaException me = new MetaException(e.toString());
                me.initCause(e);
                throw me;
            }
            finally {
                this.endFunction("drop_partition_by_name", ret, ex);
            }
            return ret;
        }

        @Override
        public List<Partition> get_partitions_ps(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws MetaException, TException, NoSuchObjectException {
            this.startPartitionFunction("get_partitions_ps", db_name, tbl_name, part_vals);
            List<Partition> ret = null;
            Exception ex = null;
            try {
                ret = this.get_partitions_ps_with_auth(db_name, tbl_name, part_vals, max_parts, null, null);
                this.endFunction("get_partitions_ps", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    if (e instanceof NoSuchObjectException) {
                        throw (NoSuchObjectException)((Object)e);
                    }
                    if (e instanceof TException) {
                        throw (TException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_ps", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<Partition> get_partitions_ps_with_auth(String db_name, String tbl_name, List<String> part_vals, short max_parts, String userName, List<String> groupNames) throws MetaException, TException, NoSuchObjectException {
            this.startPartitionFunction("get_partitions_ps_with_auth", db_name, tbl_name, part_vals);
            List<Partition> ret = null;
            Serializable ex = null;
            try {
                ret = this.getMS().listPartitionsPsWithAuth(db_name, tbl_name, part_vals, max_parts, userName, groupNames);
                this.endFunction("get_partitions_ps_with_auth", ret != null, (Exception)ex);
                return ret;
            }
            catch (InvalidObjectException e) {
                try {
                    ex = e;
                    throw new MetaException(e.getMessage());
                    catch (Exception e2) {
                        ex = e2;
                        if (e2 instanceof MetaException) {
                            throw (MetaException)((Object)e2);
                        }
                        if (e2 instanceof NoSuchObjectException) {
                            throw (NoSuchObjectException)((Object)e2);
                        }
                        if (e2 instanceof TException) {
                            throw (TException)((Object)e2);
                        }
                        MetaException me = new MetaException(e2.toString());
                        me.initCause(e2);
                        throw me;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_ps_with_auth", ret != null, (Exception)ex);
                    throw throwable;
                }
            }
        }

        @Override
        public List<String> get_partition_names_ps(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws MetaException, TException, NoSuchObjectException {
            this.startPartitionFunction("get_partitions_names_ps", db_name, tbl_name, part_vals);
            List<String> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().listPartitionNamesPs(db_name, tbl_name, part_vals, max_parts);
                this.endFunction("get_partitions_names_ps", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    if (e instanceof NoSuchObjectException) {
                        throw (NoSuchObjectException)((Object)e);
                    }
                    if (e instanceof TException) {
                        throw (TException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_names_ps", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<String> partition_name_to_vals(String part_name) throws MetaException, TException {
            if (part_name.length() == 0) {
                return new ArrayList<String>();
            }
            LinkedHashMap<String, String> map = Warehouse.makeSpecFromName(part_name);
            ArrayList<String> part_vals = new ArrayList<String>();
            part_vals.addAll(map.values());
            return part_vals;
        }

        @Override
        public Map<String, String> partition_name_to_spec(String part_name) throws MetaException, TException {
            if (part_name.length() == 0) {
                return new HashMap<String, String>();
            }
            return Warehouse.makeSpecFromName(part_name);
        }

        @Override
        public Index add_index(Index newIndex, Table indexTable) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
            this.startFunction("add_index", ": " + newIndex.toString() + " " + indexTable.toString());
            Index ret = null;
            Exception ex = null;
            try {
                ret = this.add_index_core(this.getMS(), newIndex, indexTable);
                this.endFunction("add_index", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof InvalidObjectException) {
                        throw (InvalidObjectException)((Object)e);
                    }
                    if (e instanceof AlreadyExistsException) {
                        throw (AlreadyExistsException)((Object)e);
                    }
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    if (e instanceof TException) {
                        throw (TException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("add_index", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Index add_index_core(RawStore ms, Index index, Table indexTable) throws InvalidObjectException, AlreadyExistsException, MetaException {
            boolean success = false;
            boolean indexTableCreated = false;
            try {
                ms.openTransaction();
                Index old_index = null;
                try {
                    old_index = this.get_index_by_name(index.getDbName(), index.getOrigTableName(), index.getIndexName());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (old_index != null) {
                    throw new AlreadyExistsException("Index already exists:" + index);
                }
                Table origTbl = ms.getTable(index.getDbName(), index.getOrigTableName());
                if (origTbl == null) {
                    throw new InvalidObjectException("Unable to add index because database or the orginal table do not exist");
                }
                long time = System.currentTimeMillis() / 1000L;
                Table indexTbl = indexTable;
                if (indexTbl != null) {
                    try {
                        indexTbl = ms.getTable(index.getDbName(), index.getIndexTableName());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (indexTbl != null) {
                        throw new InvalidObjectException("Unable to add index because index table already exists");
                    }
                    this.create_table(indexTable);
                    indexTableCreated = true;
                }
                index.setCreateTime((int)time);
                index.putToParameters("transient_lastDdlTime", Long.toString(time));
                ms.addIndex(index);
                success = ms.commitTransaction();
                Index index2 = index;
                return index2;
            }
            finally {
                if (!success) {
                    if (indexTableCreated) {
                        try {
                            this.drop_table(index.getDbName(), index.getIndexTableName(), false);
                        }
                        catch (Exception e) {}
                    }
                    ms.rollbackTransaction();
                }
            }
        }

        @Override
        public boolean drop_index_by_name(String dbName, String tblName, String indexName, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
            this.startFunction("drop_index_by_name", ": db=" + dbName + " tbl=" + tblName + " index=" + indexName);
            boolean ret = false;
            Exception ex = null;
            try {
                ret = this.drop_index_by_name_core(this.getMS(), dbName, tblName, indexName, deleteData);
            }
            catch (IOException e) {
                ex = e;
                throw new MetaException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)((Object)e);
                }
                if (e instanceof NoSuchObjectException) {
                    throw (NoSuchObjectException)((Object)e);
                }
                if (e instanceof TException) {
                    throw (TException)((Object)e);
                }
                MetaException me = new MetaException(e.toString());
                me.initCause(e);
                throw me;
            }
            finally {
                this.endFunction("drop_index_by_name", ret, ex);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean drop_index_by_name_core(RawStore ms, String dbName, String tblName, String indexName, boolean deleteData) throws NoSuchObjectException, MetaException, TException, IOException, InvalidObjectException, InvalidInputException {
            boolean success = false;
            Path tblPath = null;
            List<Path> partPaths = null;
            try {
                ms.openTransaction();
                Index index = this.get_index_by_name(dbName, tblName, indexName);
                if (index == null) {
                    throw new NoSuchObjectException(indexName + " doesn't exist");
                }
                ms.dropIndex(dbName, tblName, indexName);
                String idxTblName = index.getIndexTableName();
                if (idxTblName != null) {
                    Table tbl = null;
                    tbl = this.get_table(dbName, idxTblName);
                    if (tbl.getSd() == null) {
                        throw new MetaException("Table metadata is corrupted");
                    }
                    if (tbl.getSd().getLocation() != null && !this.wh.isWritable((tblPath = new Path(tbl.getSd().getLocation())).getParent())) {
                        throw new MetaException("Index table metadata not deleted since " + tblPath.getParent() + " is not writable by " + this.hiveConf.getUser());
                    }
                    partPaths = this.dropPartitionsAndGetLocations(ms, dbName, idxTblName, tblPath, tbl.getPartitionKeys(), deleteData);
                    if (!ms.dropTable(dbName, idxTblName)) {
                        throw new MetaException("Unable to drop underlying data table " + idxTblName + " for index " + idxTblName);
                    }
                }
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                    return false;
                }
                if (deleteData && tblPath != null) {
                    this.deletePartitionData(partPaths);
                    this.deleteTableData(tblPath);
                }
            }
            return true;
        }

        @Override
        public Index get_index_by_name(String dbName, String tblName, String indexName) throws MetaException, NoSuchObjectException, TException {
            this.startFunction("get_index_by_name", ": db=" + dbName + " tbl=" + tblName + " index=" + indexName);
            Index ret = null;
            Exception ex = null;
            try {
                ret = this.get_index_by_name_core(this.getMS(), dbName, tblName, indexName);
                this.endFunction("drop_index_by_name", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    if (e instanceof NoSuchObjectException) {
                        throw (NoSuchObjectException)((Object)e);
                    }
                    if (e instanceof TException) {
                        throw (TException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("drop_index_by_name", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        private Index get_index_by_name_core(RawStore ms, String db_name, String tbl_name, String index_name) throws MetaException, NoSuchObjectException, TException {
            Index index = ms.getIndex(db_name, tbl_name, index_name);
            if (index == null) {
                throw new NoSuchObjectException(db_name + "." + tbl_name + " index=" + index_name + " not found");
            }
            return index;
        }

        @Override
        public List<String> get_index_names(String dbName, String tblName, short maxIndexes) throws MetaException, TException {
            this.startTableFunction("get_index_names", dbName, tblName);
            List<String> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().listIndexNames(dbName, tblName, maxIndexes);
                this.endFunction("get_index_names", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    if (e instanceof TException) {
                        throw (TException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_index_names", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<Index> get_indexes(String dbName, String tblName, short maxIndexes) throws NoSuchObjectException, MetaException, TException {
            this.startTableFunction("get_indexes", dbName, tblName);
            List<Index> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getIndexes(dbName, tblName, maxIndexes);
                this.endFunction("get_indexes", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    if (e instanceof NoSuchObjectException) {
                        throw (NoSuchObjectException)((Object)e);
                    }
                    if (e instanceof TException) {
                        throw (TException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_indexes", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        private String lowerCaseConvertPartName(String partName) throws MetaException {
            boolean isFirst = true;
            Map<String, String> partSpec = Warehouse.makeEscSpecFromName(partName);
            String convertedPartName = new String();
            for (Map.Entry<String, String> entry : partSpec.entrySet()) {
                String partColName = entry.getKey();
                String partColVal = entry.getValue();
                if (!isFirst) {
                    convertedPartName = convertedPartName + "/";
                } else {
                    isFirst = false;
                }
                convertedPartName = convertedPartName + partColName.toLowerCase() + "=" + partColVal;
            }
            return convertedPartName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ColumnStatistics get_table_column_statistics(String dbName, String tableName, String colName) throws NoSuchObjectException, MetaException, TException, InvalidInputException, InvalidObjectException {
            dbName = dbName.toLowerCase();
            tableName = tableName.toLowerCase();
            colName = colName.toLowerCase();
            this.startFunction("get_column_statistics_by_table: db=" + dbName + " table=" + tableName + " column=" + colName);
            ColumnStatistics statsObj = null;
            try {
                statsObj = this.getMS().getTableColumnStatistics(dbName, tableName, colName);
                this.endFunction("get_column_statistics_by_table: ", statsObj != null, null);
            }
            catch (Throwable throwable) {
                this.endFunction("get_column_statistics_by_table: ", statsObj != null, null);
                throw throwable;
            }
            return statsObj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ColumnStatistics get_partition_column_statistics(String dbName, String tableName, String partName, String colName) throws NoSuchObjectException, MetaException, InvalidInputException, TException, InvalidObjectException {
            dbName = dbName.toLowerCase();
            tableName = tableName.toLowerCase();
            colName = colName.toLowerCase();
            String convertedPartName = this.lowerCaseConvertPartName(partName);
            this.startFunction("get_column_statistics_by_partition: db=" + dbName + " table=" + tableName + " partition=" + convertedPartName + " column=" + colName);
            ColumnStatistics statsObj = null;
            try {
                List<String> partVals = this.getPartValsFromName(this.getMS(), dbName, tableName, partName);
                statsObj = this.getMS().getPartitionColumnStatistics(dbName, tableName, convertedPartName, partVals, colName);
                this.endFunction("get_column_statistics_by_partition: ", statsObj != null, null);
            }
            catch (Throwable throwable) {
                this.endFunction("get_column_statistics_by_partition: ", statsObj != null, null);
                throw throwable;
            }
            return statsObj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean update_table_column_statistics(ColumnStatistics colStats) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
            String dbName = null;
            String tableName = null;
            String colName = null;
            ColumnStatisticsDesc statsDesc = colStats.getStatsDesc();
            dbName = statsDesc.getDbName().toLowerCase();
            tableName = statsDesc.getTableName().toLowerCase();
            statsDesc.setDbName(dbName);
            statsDesc.setTableName(tableName);
            long time = System.currentTimeMillis() / 1000L;
            statsDesc.setLastAnalyzed(time);
            List<ColumnStatisticsObj> statsObjs = colStats.getStatsObj();
            for (ColumnStatisticsObj statsObj : statsObjs) {
                colName = statsObj.getColName().toLowerCase();
                statsObj.setColName(colName);
                this.startFunction("write_column_statistics:  db=" + dbName + " table=" + tableName + " column=" + colName);
            }
            colStats.setStatsDesc(statsDesc);
            colStats.setStatsObj(statsObjs);
            boolean ret = false;
            try {
                boolean bl = ret = this.getMS().updateTableColumnStatistics(colStats);
                this.endFunction("write_column_statistics: ", ret, null);
                return bl;
            }
            catch (Throwable throwable) {
                this.endFunction("write_column_statistics: ", ret, null);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean update_partition_column_statistics(ColumnStatistics colStats) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
            String dbName = null;
            String tableName = null;
            String partName = null;
            String colName = null;
            ColumnStatisticsDesc statsDesc = colStats.getStatsDesc();
            dbName = statsDesc.getDbName().toLowerCase();
            tableName = statsDesc.getTableName().toLowerCase();
            partName = this.lowerCaseConvertPartName(statsDesc.getPartName());
            statsDesc.setDbName(dbName);
            statsDesc.setTableName(tableName);
            statsDesc.setPartName(partName);
            long time = System.currentTimeMillis() / 1000L;
            statsDesc.setLastAnalyzed(time);
            List<ColumnStatisticsObj> statsObjs = colStats.getStatsObj();
            for (ColumnStatisticsObj statsObj : statsObjs) {
                colName = statsObj.getColName().toLowerCase();
                statsObj.setColName(colName);
                this.startFunction("write_partition_column_statistics:  db=" + dbName + " table=" + tableName + " part=" + partName + "column=" + colName);
            }
            colStats.setStatsDesc(statsDesc);
            colStats.setStatsObj(statsObjs);
            boolean ret = false;
            try {
                List<String> partVals = this.getPartValsFromName(this.getMS(), dbName, tableName, partName);
                boolean bl = ret = this.getMS().updatePartitionColumnStatistics(colStats, partVals);
                this.endFunction("write_partition_column_statistics: ", ret, null);
                return bl;
            }
            catch (Throwable throwable) {
                this.endFunction("write_partition_column_statistics: ", ret, null);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean delete_partition_column_statistics(String dbName, String tableName, String partName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
            dbName = dbName.toLowerCase();
            tableName = tableName.toLowerCase();
            if (colName != null) {
                colName = colName.toLowerCase();
            }
            String convertedPartName = this.lowerCaseConvertPartName(partName);
            this.startFunction("delete_column_statistics_by_partition: db=" + dbName + " table=" + tableName + " partition=" + convertedPartName + " column=" + colName);
            boolean ret = false;
            try {
                List<String> partVals = this.getPartValsFromName(this.getMS(), dbName, tableName, convertedPartName);
                ret = this.getMS().deletePartitionColumnStatistics(dbName, tableName, convertedPartName, partVals, colName);
                this.endFunction("delete_column_statistics_by_partition: ", ret, null);
            }
            catch (Throwable throwable) {
                this.endFunction("delete_column_statistics_by_partition: ", ret, null);
                throw throwable;
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean delete_table_column_statistics(String dbName, String tableName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
            dbName = dbName.toLowerCase();
            tableName = tableName.toLowerCase();
            if (colName != null) {
                colName = colName.toLowerCase();
            }
            this.startFunction("delete_column_statistics_by_table: db=" + dbName + " table=" + tableName + " column=" + colName);
            boolean ret = false;
            try {
                ret = this.getMS().deleteTableColumnStatistics(dbName, tableName, colName);
                this.endFunction("delete_column_statistics_by_table: ", ret, null);
            }
            catch (Throwable throwable) {
                this.endFunction("delete_column_statistics_by_table: ", ret, null);
                throw throwable;
            }
            return ret;
        }

        @Override
        public List<Partition> get_partitions_by_filter(String dbName, String tblName, String filter, short maxParts) throws MetaException, NoSuchObjectException, TException {
            this.startTableFunction("get_partitions_by_filter", dbName, tblName);
            List<Partition> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getPartitionsByFilter(dbName, tblName, filter, maxParts);
                this.endFunction("get_partitions_by_filter", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    if (e instanceof NoSuchObjectException) {
                        throw (NoSuchObjectException)((Object)e);
                    }
                    if (e instanceof TException) {
                        throw (TException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_by_filter", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<Partition> get_partitions_by_names(String dbName, String tblName, List<String> partNames) throws MetaException, NoSuchObjectException, TException {
            this.startTableFunction("get_partitions_by_names", dbName, tblName);
            List<Partition> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getPartitionsByNames(dbName, tblName, partNames);
                this.endFunction("get_partitions_by_names", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)((Object)e);
                    }
                    if (e instanceof NoSuchObjectException) {
                        throw (NoSuchObjectException)((Object)e);
                    }
                    if (e instanceof TException) {
                        throw (TException)((Object)e);
                    }
                    MetaException me = new MetaException(e.toString());
                    me.initCause(e);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_by_names", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef hiveObject, String userName, List<String> groupNames) throws MetaException, TException {
            if (hiveObject.getObjectType() == HiveObjectType.COLUMN) {
                String partName = this.getPartName(hiveObject);
                return this.get_column_privilege_set(hiveObject.getDbName(), hiveObject.getObjectName(), partName, hiveObject.getColumnName(), userName, groupNames);
            }
            if (hiveObject.getObjectType() == HiveObjectType.PARTITION) {
                String partName = this.getPartName(hiveObject);
                return this.get_partition_privilege_set(hiveObject.getDbName(), hiveObject.getObjectName(), partName, userName, groupNames);
            }
            if (hiveObject.getObjectType() == HiveObjectType.DATABASE) {
                return this.get_db_privilege_set(hiveObject.getDbName(), userName, groupNames);
            }
            if (hiveObject.getObjectType() == HiveObjectType.TABLE) {
                return this.get_table_privilege_set(hiveObject.getDbName(), hiveObject.getObjectName(), userName, groupNames);
            }
            if (hiveObject.getObjectType() == HiveObjectType.GLOBAL) {
                return this.get_user_privilege_set(userName, groupNames);
            }
            return null;
        }

        private String getPartName(HiveObjectRef hiveObject) throws MetaException {
            String partName = null;
            List<String> partValue = hiveObject.getPartValues();
            if (partValue != null && partValue.size() > 0) {
                try {
                    Table table = this.get_table(hiveObject.getDbName(), hiveObject.getObjectName());
                    partName = Warehouse.makePartName(table.getPartitionKeys(), partValue);
                }
                catch (NoSuchObjectException e) {
                    throw new MetaException(e.getMessage());
                }
            }
            return partName;
        }

        public PrincipalPrivilegeSet get_column_privilege_set(String dbName, String tableName, String partName, String columnName, String userName, List<String> groupNames) throws MetaException, TException {
            this.incrementCounter("get_column_privilege_set");
            PrincipalPrivilegeSet ret = null;
            try {
                ret = this.getMS().getColumnPrivilegeSet(dbName, tableName, partName, columnName, userName, groupNames);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public PrincipalPrivilegeSet get_db_privilege_set(String dbName, String userName, List<String> groupNames) throws MetaException, TException {
            this.incrementCounter("get_db_privilege_set");
            PrincipalPrivilegeSet ret = null;
            try {
                ret = this.getMS().getDBPrivilegeSet(dbName, userName, groupNames);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public PrincipalPrivilegeSet get_partition_privilege_set(String dbName, String tableName, String partName, String userName, List<String> groupNames) throws MetaException, TException {
            this.incrementCounter("get_partition_privilege_set");
            PrincipalPrivilegeSet ret = null;
            try {
                ret = this.getMS().getPartitionPrivilegeSet(dbName, tableName, partName, userName, groupNames);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public PrincipalPrivilegeSet get_table_privilege_set(String dbName, String tableName, String userName, List<String> groupNames) throws MetaException, TException {
            this.incrementCounter("get_table_privilege_set");
            PrincipalPrivilegeSet ret = null;
            try {
                ret = this.getMS().getTablePrivilegeSet(dbName, tableName, userName, groupNames);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public boolean grant_role(String roleName, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws MetaException, TException {
            this.incrementCounter("add_role_member");
            Boolean ret = null;
            try {
                RawStore ms = this.getMS();
                Role role = ms.getRole(roleName);
                ret = ms.grantRole(role, userName, principalType, grantor, grantorType, grantOption);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public List<Role> list_roles(String principalName, PrincipalType principalType) throws MetaException, TException {
            this.incrementCounter("list_roles");
            ArrayList<Role> ret = null;
            try {
                ArrayList<Role> result = new ArrayList<Role>();
                List<MRoleMap> roleMap = this.getMS().listRoles(principalName, principalType);
                if (roleMap != null) {
                    for (MRoleMap role : roleMap) {
                        MRole r = role.getRole();
                        result.add(new Role(r.getRoleName(), r.getCreateTime(), r.getOwnerName()));
                    }
                }
                ret = result;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public boolean create_role(Role role) throws MetaException, TException {
            this.incrementCounter("create_role");
            Boolean ret = null;
            try {
                ret = this.getMS().addRole(role.getRoleName(), role.getOwnerName());
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public boolean drop_role(String roleName) throws MetaException, TException {
            this.incrementCounter("drop_role");
            Boolean ret = null;
            try {
                ret = this.getMS().removeRole(roleName);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public List<String> get_role_names() throws MetaException, TException {
            this.incrementCounter("get_role_names");
            List<String> ret = null;
            try {
                ret = this.getMS().listRoleNames();
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public boolean grant_privileges(PrivilegeBag privileges) throws MetaException, TException {
            this.incrementCounter("grant_privileges");
            Boolean ret = null;
            try {
                ret = this.getMS().grantPrivileges(privileges);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public boolean revoke_role(String roleName, String userName, PrincipalType principalType) throws MetaException, TException {
            this.incrementCounter("remove_role_member");
            Boolean ret = null;
            try {
                RawStore ms = this.getMS();
                Role mRole = ms.getRole(roleName);
                ret = ms.revokeRole(mRole, userName, principalType);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public boolean revoke_privileges(PrivilegeBag privileges) throws MetaException, TException {
            this.incrementCounter("revoke_privileges");
            Boolean ret = null;
            try {
                ret = this.getMS().revokePrivileges(privileges);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public PrincipalPrivilegeSet get_user_privilege_set(String userName, List<String> groupNames) throws MetaException, TException {
            this.incrementCounter("get_user_privilege_set");
            PrincipalPrivilegeSet ret = null;
            try {
                ret = this.getMS().getUserPrivilegeSet(userName, groupNames);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public PrincipalType getPrincipalType(String principalType) {
            return PrincipalType.valueOf(principalType);
        }

        @Override
        public List<HiveObjectPrivilege> list_privileges(String principalName, PrincipalType principalType, HiveObjectRef hiveObject) throws MetaException, TException {
            if (hiveObject.getObjectType() == HiveObjectType.GLOBAL) {
                return this.list_global_privileges(principalName, principalType);
            }
            if (hiveObject.getObjectType() == HiveObjectType.DATABASE) {
                return this.list_db_privileges(principalName, principalType, hiveObject.getDbName());
            }
            if (hiveObject.getObjectType() == HiveObjectType.TABLE) {
                return this.list_table_privileges(principalName, principalType, hiveObject.getDbName(), hiveObject.getObjectName());
            }
            if (hiveObject.getObjectType() == HiveObjectType.PARTITION) {
                return this.list_partition_privileges(principalName, principalType, hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getPartValues());
            }
            if (hiveObject.getObjectType() == HiveObjectType.COLUMN) {
                return this.list_column_privileges(principalName, principalType, hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getPartValues(), hiveObject.getColumnName());
            }
            return null;
        }

        public List<HiveObjectPrivilege> list_column_privileges(String principalName, PrincipalType principalType, String dbName, String tableName, List<String> partValues, String columnName) throws MetaException, TException {
            this.incrementCounter("list_security_column_grant");
            List<HiveObjectPrivilege> ret = null;
            try {
                RawStore ms = this.getMS();
                String partName = null;
                if (partValues != null && partValues.size() > 0) {
                    Table tbl = this.get_table(dbName, tableName);
                    partName = Warehouse.makePartName(tbl.getPartitionKeys(), partValues);
                }
                List<HiveObjectPrivilege> result = Collections.emptyList();
                if (partName != null) {
                    Partition part = null;
                    part = this.get_partition_by_name(dbName, tableName, partName);
                    List<MPartitionColumnPrivilege> mPartitionCols = ms.listPrincipalPartitionColumnGrants(principalName, principalType, dbName, tableName, partName, columnName);
                    if (mPartitionCols.size() > 0) {
                        result = new ArrayList<HiveObjectPrivilege>();
                        for (int i = 0; i < mPartitionCols.size(); ++i) {
                            MPartitionColumnPrivilege sCol = mPartitionCols.get(i);
                            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.COLUMN, dbName, tableName, part == null ? null : part.getValues(), sCol.getColumnName());
                            HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sCol.getPrincipalName(), principalType, new PrivilegeGrantInfo(sCol.getPrivilege(), sCol.getCreateTime(), sCol.getGrantor(), PrincipalType.valueOf(sCol.getGrantorType()), sCol.getGrantOption()));
                            result.add(secObj);
                        }
                    }
                } else {
                    List<MTableColumnPrivilege> mTableCols = ms.listPrincipalTableColumnGrants(principalName, principalType, dbName, tableName, columnName);
                    if (mTableCols.size() > 0) {
                        result = new ArrayList();
                        for (int i = 0; i < mTableCols.size(); ++i) {
                            MTableColumnPrivilege sCol = mTableCols.get(i);
                            HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.COLUMN, dbName, tableName, null, sCol.getColumnName());
                            HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sCol.getPrincipalName(), principalType, new PrivilegeGrantInfo(sCol.getPrivilege(), sCol.getCreateTime(), sCol.getGrantor(), PrincipalType.valueOf(sCol.getGrantorType()), sCol.getGrantOption()));
                            result.add(secObj);
                        }
                    }
                }
                ret = result;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public List<HiveObjectPrivilege> list_db_privileges(String principalName, PrincipalType principalType, String dbName) throws MetaException, TException {
            this.incrementCounter("list_security_db_grant");
            try {
                RawStore ms = this.getMS();
                List<MDBPrivilege> mDbs = ms.listPrincipalDBGrants(principalName, principalType, dbName);
                if (mDbs.size() > 0) {
                    ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
                    for (int i = 0; i < mDbs.size(); ++i) {
                        MDBPrivilege sDB = mDbs.get(i);
                        HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.DATABASE, dbName, null, null, null);
                        HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sDB.getPrincipalName(), principalType, new PrivilegeGrantInfo(sDB.getPrivilege(), sDB.getCreateTime(), sDB.getGrantor(), PrincipalType.valueOf(sDB.getGrantorType()), sDB.getGrantOption()));
                        result.add(secObj);
                    }
                    return result;
                }
                return Collections.emptyList();
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public List<HiveObjectPrivilege> list_partition_privileges(String principalName, PrincipalType principalType, String dbName, String tableName, List<String> partValues) throws MetaException, TException {
            this.incrementCounter("list_security_partition_grant");
            try {
                RawStore ms = this.getMS();
                Table tbl = this.get_table(dbName, tableName);
                String partName = Warehouse.makePartName(tbl.getPartitionKeys(), partValues);
                List<MPartitionPrivilege> mParts = ms.listPrincipalPartitionGrants(principalName, principalType, dbName, tableName, partName);
                if (mParts.size() > 0) {
                    ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
                    for (int i = 0; i < mParts.size(); ++i) {
                        MPartitionPrivilege sPart = mParts.get(i);
                        HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.PARTITION, dbName, tableName, partValues, null);
                        HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sPart.getPrincipalName(), principalType, new PrivilegeGrantInfo(sPart.getPrivilege(), sPart.getCreateTime(), sPart.getGrantor(), PrincipalType.valueOf(sPart.getGrantorType()), sPart.getGrantOption()));
                        result.add(secObj);
                    }
                    return result;
                }
                return Collections.emptyList();
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public List<HiveObjectPrivilege> list_table_privileges(String principalName, PrincipalType principalType, String dbName, String tableName) throws MetaException, TException {
            this.incrementCounter("list_security_table_grant");
            try {
                List<MTablePrivilege> mTbls = this.getMS().listAllTableGrants(principalName, principalType, dbName, tableName);
                if (mTbls.size() > 0) {
                    ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
                    for (int i = 0; i < mTbls.size(); ++i) {
                        MTablePrivilege sTbl = mTbls.get(i);
                        HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.TABLE, dbName, tableName, null, null);
                        HiveObjectPrivilege secObj = new HiveObjectPrivilege(objectRef, sTbl.getPrincipalName(), principalType, new PrivilegeGrantInfo(sTbl.getPrivilege(), sTbl.getCreateTime(), sTbl.getGrantor(), PrincipalType.valueOf(sTbl.getGrantorType()), sTbl.getGrantOption()));
                        result.add(secObj);
                    }
                    return result;
                }
                return Collections.emptyList();
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public List<HiveObjectPrivilege> list_global_privileges(String principalName, PrincipalType principalType) throws MetaException, TException {
            this.incrementCounter("list_security_user_grant");
            try {
                List<MGlobalPrivilege> mUsers = this.getMS().listPrincipalGlobalGrants(principalName, principalType);
                if (mUsers.size() > 0) {
                    ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
                    for (int i = 0; i < mUsers.size(); ++i) {
                        MGlobalPrivilege sUsr = mUsers.get(i);
                        HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.GLOBAL, null, null, null, null);
                        HiveObjectPrivilege secUser = new HiveObjectPrivilege(objectRef, sUsr.getPrincipalName(), principalType, new PrivilegeGrantInfo(sUsr.getPrivilege(), sUsr.getCreateTime(), sUsr.getGrantor(), PrincipalType.valueOf(sUsr.getGrantorType()), sUsr.getGrantOption()));
                        result.add(secUser);
                    }
                    return result;
                }
                return Collections.emptyList();
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void cancel_delegation_token(String token_str_form) throws MetaException, TException {
            this.startFunction("cancel_delegation_token");
            boolean success = false;
            Exception ex = null;
            try {
                HiveMetaStore.cancelDelegationToken(token_str_form);
                success = true;
            }
            catch (IOException e) {
                ex = e;
                throw new MetaException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)((Object)e);
                }
                if (e instanceof TException) {
                    throw (TException)((Object)e);
                }
                MetaException me = new MetaException(e.toString());
                me.initCause(e);
                throw me;
            }
            finally {
                this.endFunction("cancel_delegation_token", success, ex);
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long renew_delegation_token(String token_str_form) throws MetaException, TException {
            this.startFunction("renew_delegation_token");
            Long ret = null;
            Exception ex = null;
            try {
                ret = HiveMetaStore.renewDelegationToken(token_str_form);
                this.endFunction("renew_delegation_token", ret != null, ex);
                return ret;
            }
            catch (IOException e) {
                try {
                    ex = e;
                    throw new MetaException(e.getMessage());
                    catch (Exception e2) {
                        ex = e2;
                        if (e2 instanceof MetaException) {
                            throw (MetaException)((Object)e2);
                        }
                        if (e2 instanceof TException) {
                            throw (TException)((Object)e2);
                        }
                        MetaException me = new MetaException(e2.toString());
                        me.initCause(e2);
                        throw me;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("renew_delegation_token", ret != null, ex);
                    throw throwable;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public String get_delegation_token(String token_owner, String renewer_kerberos_principal_name) throws MetaException, TException {
            this.startFunction("get_delegation_token");
            String ret = null;
            Exception ex = null;
            try {
                ret = HiveMetaStore.getDelegationToken(token_owner, renewer_kerberos_principal_name);
                this.endFunction("get_delegation_token", ret != null, ex);
                return ret;
            }
            catch (IOException e) {
                try {
                    ex = e;
                    throw new MetaException(e.getMessage());
                    catch (InterruptedException e2) {
                        ex = e2;
                        throw new MetaException(e2.getMessage());
                    }
                    catch (Exception e3) {
                        ex = e3;
                        if (e3 instanceof MetaException) {
                            throw (MetaException)((Object)e3);
                        }
                        if (e3 instanceof TException) {
                            throw (TException)((Object)e3);
                        }
                        MetaException me = new MetaException(e3.toString());
                        me.initCause(e3);
                        throw me;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_delegation_token", ret != null, ex);
                    throw throwable;
                }
            }
        }

        @Override
        public void markPartitionForEvent(String db_name, String tbl_name, Map<String, String> partName, PartitionEventType evtType) throws MetaException, TException, NoSuchObjectException, UnknownDBException, UnknownTableException, InvalidPartitionException, UnknownPartitionException {
            Table tbl = null;
            Exception ex = null;
            try {
                this.startPartitionFunction("markPartitionForEvent", db_name, tbl_name, partName);
                this.firePreEvent(new PreLoadPartitionDoneEvent(db_name, tbl_name, partName, this));
                tbl = this.getMS().markPartitionForEvent(db_name, tbl_name, partName, evtType);
                if (null == tbl) {
                    throw new UnknownTableException("Table: " + tbl_name + " not found.");
                }
                for (MetaStoreEventListener listener : this.listeners) {
                    listener.onLoadPartitionDone(new LoadPartitionDoneEvent(true, tbl, partName, this));
                }
                this.endFunction("markPartitionForEvent", tbl != null, ex);
            }
            catch (Exception original) {
                try {
                    ex = original;
                    LOG.error((Object)original);
                    if (original instanceof NoSuchObjectException) {
                        throw (NoSuchObjectException)((Object)original);
                    }
                    if (original instanceof UnknownTableException) {
                        throw (UnknownTableException)((Object)original);
                    }
                    if (original instanceof UnknownDBException) {
                        throw (UnknownDBException)((Object)original);
                    }
                    if (original instanceof UnknownPartitionException) {
                        throw (UnknownPartitionException)((Object)original);
                    }
                    if (original instanceof InvalidPartitionException) {
                        throw (InvalidPartitionException)((Object)original);
                    }
                    if (original instanceof MetaException) {
                        throw (MetaException)((Object)original);
                    }
                    MetaException me = new MetaException(original.toString());
                    me.initCause(original);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("markPartitionForEvent", tbl != null, ex);
                    throw throwable;
                }
            }
        }

        @Override
        public boolean isPartitionMarkedForEvent(String db_name, String tbl_name, Map<String, String> partName, PartitionEventType evtType) throws MetaException, NoSuchObjectException, UnknownDBException, UnknownTableException, TException, UnknownPartitionException, InvalidPartitionException {
            this.startPartitionFunction("isPartitionMarkedForEvent", db_name, tbl_name, partName);
            Boolean ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().isPartitionMarkedForEvent(db_name, tbl_name, partName, evtType);
                this.endFunction("isPartitionMarkedForEvent", ret != null, ex);
            }
            catch (Exception original) {
                try {
                    LOG.error((Object)original);
                    ex = original;
                    if (original instanceof NoSuchObjectException) {
                        throw (NoSuchObjectException)((Object)original);
                    }
                    if (original instanceof UnknownTableException) {
                        throw (UnknownTableException)((Object)original);
                    }
                    if (original instanceof UnknownDBException) {
                        throw (UnknownDBException)((Object)original);
                    }
                    if (original instanceof UnknownPartitionException) {
                        throw (UnknownPartitionException)((Object)original);
                    }
                    if (original instanceof InvalidPartitionException) {
                        throw (InvalidPartitionException)((Object)original);
                    }
                    if (original instanceof MetaException) {
                        throw (MetaException)((Object)original);
                    }
                    MetaException me = new MetaException(original.toString());
                    me.initCause(original);
                    throw me;
                }
                catch (Throwable throwable) {
                    this.endFunction("isPartitionMarkedForEvent", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<String> set_ugi(String username, List<String> groupNames) throws MetaException, TException {
            Collections.addAll(groupNames, username);
            return groupNames;
        }
    }

    private static final class ChainedTTransportFactory
    extends TTransportFactory {
        private final TTransportFactory parentTransFactory;
        private final TTransportFactory childTransFactory;

        private ChainedTTransportFactory(TTransportFactory parentTransFactory, TTransportFactory childTransFactory) {
            this.parentTransFactory = parentTransFactory;
            this.childTransFactory = childTransFactory;
        }

        public TTransport getTransport(TTransport trans) {
            return this.childTransFactory.getTransport(this.parentTransFactory.getTransport(trans));
        }
    }
}

