/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.gui;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.gui.AreaOwner;
import org.pentaho.di.core.gui.GCInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.gui.PrimitiveGCInterface;
import org.pentaho.di.core.gui.Rectangle;
import org.pentaho.di.core.gui.ScrollBarInterface;
import org.pentaho.di.trans.step.errorhandling.StreamIcon;

public class BasePainter {
    public final double theta = Math.toRadians(11.0);
    protected static final int MINI_ICON_SIZE = 16;
    protected static final int MINI_ICON_MARGIN = 5;
    protected static final int MINI_ICON_TRIANGLE_BASE = 10;
    protected static final int MINI_ICON_DISTANCE = 7;
    protected static final int MINI_ICON_SKEW = 0;
    protected Point area;
    protected ScrollBarInterface hori;
    protected ScrollBarInterface vert;
    protected List<AreaOwner> areaOwners;
    protected Point offset;
    protected Point drop_candidate;
    protected int iconsize;
    protected int gridSize;
    protected Rectangle selrect;
    protected int linewidth;
    protected float magnification;
    protected float translationX;
    protected float translationY;
    protected boolean shadow;
    protected Object subject;
    protected GCInterface gc;
    protected int shadowSize;
    private String noteFontName;
    private int noteFontHeight;

    public BasePainter(GCInterface gc, Object subject, Point area, ScrollBarInterface hori, ScrollBarInterface vert, Point drop_candidate, Rectangle selrect, List<AreaOwner> areaOwners, int iconsize, int linewidth, int gridsize, int shadowSize, boolean antiAliasing, String noteFontName, int noteFontHeight) {
        this.gc = gc;
        this.subject = subject;
        this.area = area;
        this.hori = hori;
        this.vert = vert;
        this.selrect = selrect;
        this.drop_candidate = drop_candidate;
        this.areaOwners = areaOwners;
        areaOwners.clear();
        this.iconsize = iconsize;
        this.linewidth = linewidth;
        this.gridSize = gridsize;
        this.shadowSize = shadowSize;
        this.shadow = shadowSize > 0;
        this.magnification = 1.0f;
        gc.setAntialias(antiAliasing);
        this.noteFontName = noteFontName;
        this.noteFontHeight = noteFontHeight;
    }

    public static PrimitiveGCInterface.EImage getStreamIconImage(StreamIcon streamIcon) {
        switch (streamIcon) {
            case TRUE: {
                return PrimitiveGCInterface.EImage.TRUE;
            }
            case FALSE: {
                return PrimitiveGCInterface.EImage.FALSE;
            }
            case ERROR: {
                return PrimitiveGCInterface.EImage.ERROR;
            }
            case INFO: {
                return PrimitiveGCInterface.EImage.INFO;
            }
            case TARGET: {
                return PrimitiveGCInterface.EImage.TARGET;
            }
            case INPUT: {
                return PrimitiveGCInterface.EImage.INPUT;
            }
            case OUTPUT: {
                return PrimitiveGCInterface.EImage.OUTPUT;
            }
        }
        return PrimitiveGCInterface.EImage.ARROW;
    }

    protected void drawNote(NotePadMeta notePadMeta) {
        Point ext;
        if (notePadMeta.isSelected()) {
            this.gc.setLineWidth(2);
        } else {
            this.gc.setLineWidth(1);
        }
        if (Const.isEmpty((String)notePadMeta.getNote())) {
            ext = new Point(10, 10);
        } else {
            this.gc.setFont(Const.NVL((String)notePadMeta.getFontName(), (String)this.noteFontName), notePadMeta.getFontSize() == -1 ? this.noteFontHeight : notePadMeta.getFontSize(), notePadMeta.isFontBold(), notePadMeta.isFontItalic());
            ext = this.gc.textExtent(notePadMeta.getNote());
        }
        Point p = new Point(ext.x, ext.y);
        Point loc = notePadMeta.getLocation();
        Point note = this.real2screen(loc.x, loc.y);
        int margin = 5;
        p.x += 2 * margin;
        p.y += 2 * margin;
        int width = notePadMeta.width;
        int height = notePadMeta.height;
        if (p.x > width) {
            width = p.x;
        }
        if (p.y > height) {
            height = p.y;
        }
        int[] noteshape = new int[]{note.x, note.y, note.x + width + 2 * margin, note.y, note.x + width + 2 * margin, note.y + height, note.x + width, note.y + height + 2 * margin, note.x + width, note.y + height, note.x + width + 2 * margin, note.y + height, note.x + width, note.y + height + 2 * margin, note.x, note.y + height + 2 * margin};
        if (notePadMeta.isDrawShadow()) {
            int s = this.shadowSize;
            int[] shadowa = new int[]{note.x + s, note.y + s, note.x + width + 2 * margin + s, note.y + s, note.x + width + 2 * margin + s, note.y + height + s, note.x + width + s, note.y + height + 2 * margin + s, note.x + s, note.y + height + 2 * margin + s};
            this.gc.setBackground(PrimitiveGCInterface.EColor.LIGHTGRAY);
            this.gc.fillPolygon(shadowa);
        }
        this.gc.setBackground(notePadMeta.getBackGroundColorRed(), notePadMeta.getBackGroundColorGreen(), notePadMeta.getBackGroundColorBlue());
        this.gc.setForeground(notePadMeta.getBorderColorRed(), notePadMeta.getBorderColorGreen(), notePadMeta.getBorderColorBlue());
        this.gc.fillPolygon(noteshape);
        this.gc.drawPolygon(noteshape);
        if (!Const.isEmpty((String)notePadMeta.getNote())) {
            this.gc.setForeground(notePadMeta.getFontColorRed(), notePadMeta.getFontColorGreen(), notePadMeta.getFontColorBlue());
            this.gc.drawText(notePadMeta.getNote(), note.x + margin, note.y + margin, true);
        }
        notePadMeta.width = width;
        notePadMeta.height = height;
        if (notePadMeta.isSelected()) {
            this.gc.setLineWidth(1);
        } else {
            this.gc.setLineWidth(2);
        }
        if (!this.shadow) {
            this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.NOTE, note.x, note.y, width, height, this.offset, this.subject, notePadMeta));
        }
    }

    protected Point real2screen(int x, int y) {
        Point screen = new Point(x + this.offset.x, y + this.offset.y);
        return screen;
    }

    protected Point getThumb(Point area, Point transMax) {
        Point resizedMax = this.magnifyPoint(transMax);
        Point thumb = new Point(0, 0);
        thumb.x = resizedMax.x <= area.x ? 100 : (int)Math.floor(100.0 * (double)area.x / (double)resizedMax.x);
        thumb.y = resizedMax.y <= area.y ? 100 : (int)Math.floor(100.0 * (double)area.y / (double)resizedMax.y);
        return thumb;
    }

    protected Point magnifyPoint(Point p) {
        return new Point(Math.round((float)p.x * this.magnification), Math.round((float)p.y * this.magnification));
    }

    protected Point getOffset(Point thumb, Point area) {
        Point p = new Point(0, 0);
        if (this.hori == null || this.vert == null) {
            return p;
        }
        Point sel = new Point(this.hori.getSelection(), this.vert.getSelection());
        if (thumb.x == 0 || thumb.y == 0) {
            return p;
        }
        p.x = Math.round((float)(-sel.x * area.x / thumb.x) / this.magnification);
        p.y = Math.round((float)(-sel.y * area.y / thumb.y) / this.magnification);
        return p;
    }

    protected void drawRect(Rectangle rect) {
        if (rect == null) {
            return;
        }
        this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.DASHDOT);
        this.gc.setLineWidth(this.linewidth);
        this.gc.setForeground(PrimitiveGCInterface.EColor.GRAY);
        Point s = this.real2screen(rect.x, rect.y);
        if (rect.width < 0) {
            s.x += rect.width;
        }
        if (rect.height < 0) {
            s.y += rect.height;
        }
        this.gc.drawRectangle(s.x, s.y, Math.abs(rect.width), Math.abs(rect.height));
        this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.SOLID);
    }

    protected void drawGrid() {
        Point bounds = this.gc.getDeviceBounds();
        for (int x = 0; x < bounds.x; x += this.gridSize) {
            for (int y = 0; y < bounds.y; y += this.gridSize) {
                this.gc.drawPoint(x + this.offset.x % this.gridSize, y + this.offset.y % this.gridSize);
            }
        }
    }

    protected int calcArrowLength() {
        return 19 + (this.linewidth - 1) * 5;
    }

    public float getMagnification() {
        return this.magnification;
    }

    public void setMagnification(float magnification) {
        this.magnification = magnification;
    }
}

