/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.gui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.jfree.text.TextUtilities;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.GCInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.gui.PrimitiveGCInterface;
import org.pentaho.di.core.gui.SwingGUIResource;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.laf.BasePropertyHandler;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.reporting.libraries.base.util.WaitingImageObserver;

public class SwingGC
implements GCInterface {
    private static BufferedImage imageLocked;
    private static BufferedImage imageStepError;
    private static BufferedImage imageEdit;
    private static BufferedImage imageContextMenu;
    private static BufferedImage imageTrue;
    private static BufferedImage imageFalse;
    private static BufferedImage imageErrorHop;
    private static BufferedImage imageInfoHop;
    private static BufferedImage imageHopTarget;
    private static BufferedImage imageHopInput;
    private static BufferedImage imageHopOutput;
    private static BufferedImage imageArrow;
    private static BufferedImage imageCopyHop;
    private static BufferedImage imageLoadBalance;
    private static BufferedImage imageCheckpoint;
    private static BufferedImage imageDatabase;
    private static BufferedImage imageParallelHop;
    private static BufferedImage imageUnconditionalHop;
    private static BufferedImage imageStart;
    private static BufferedImage imageDummy;
    private static BufferedImage imageBusy;
    private static BufferedImage imageInject;
    protected Color background;
    protected Color black;
    protected Color red;
    protected Color yellow;
    protected Color orange;
    protected Color green;
    protected Color blue;
    protected Color magenta;
    protected Color gray;
    protected Color lightGray;
    protected Color darkGray;
    protected Color lightBlue;
    private Graphics2D gc;
    private int iconsize;
    private Map<String, BufferedImage> stepImages;
    private Map<String, BufferedImage> entryImages;
    private BufferedImage image;
    private ImageObserver observer;
    private Point area;
    private int alpha;
    private Font fontGraph;
    private Font fontNote;
    private Font fontSmall;
    private int lineWidth;
    private PrimitiveGCInterface.ELineStyle lineStyle;
    private int yOffset;
    private int xOffset;
    private boolean drawingPixelatedImages;

    public SwingGC(ImageObserver observer, Point area, int iconsize, int xOffset, int yOffset) throws KettleException {
        this.image = new BufferedImage(area.x, area.y, 1);
        this.gc = this.image.createGraphics();
        this.observer = observer;
        this.stepImages = SwingGUIResource.getInstance().getStepImages();
        this.entryImages = SwingGUIResource.getInstance().getEntryImages();
        this.iconsize = iconsize;
        this.area = area;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.init();
    }

    public SwingGC(Graphics2D gc, Rectangle2D rect, int iconsize, int xOffset, int yOffset) throws KettleException {
        this.image = null;
        this.gc = gc;
        this.observer = null;
        this.stepImages = SwingGUIResource.getInstance().getStepImages();
        this.entryImages = SwingGUIResource.getInstance().getEntryImages();
        this.iconsize = iconsize;
        this.area = new Point((int)rect.getWidth(), (int)rect.getHeight());
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.init();
    }

    private void init() throws KettleException {
        this.lineStyle = PrimitiveGCInterface.ELineStyle.SOLID;
        this.lineWidth = 1;
        this.alpha = 255;
        this.background = new Color(255, 255, 255);
        this.black = new Color(0, 0, 0);
        this.red = new Color(255, 0, 0);
        this.yellow = new Color(255, 255, 0);
        this.orange = new Color(255, 165, 0);
        this.green = new Color(0, 255, 0);
        this.blue = new Color(0, 0, 255);
        this.magenta = new Color(255, 0, 255);
        this.gray = new Color(128, 128, 128);
        this.lightGray = new Color(200, 200, 200);
        this.darkGray = new Color(80, 80, 80);
        this.lightBlue = new Color(135, 206, 250);
        imageLocked = this.getImageIcon(BasePropertyHandler.getProperty((String)"Locked_image"));
        imageStepError = this.getImageIcon(BasePropertyHandler.getProperty((String)"StepErrorLines_image"));
        imageEdit = this.getImageIcon(BasePropertyHandler.getProperty((String)"Edit_image"));
        imageContextMenu = this.getImageIcon(BasePropertyHandler.getProperty((String)"ContextMenu_image"));
        imageTrue = this.getImageIcon(BasePropertyHandler.getProperty((String)"True_image"));
        imageFalse = this.getImageIcon(BasePropertyHandler.getProperty((String)"False_image"));
        imageErrorHop = this.getImageIcon(BasePropertyHandler.getProperty((String)"ErrorHop_image"));
        imageInfoHop = this.getImageIcon(BasePropertyHandler.getProperty((String)"InfoHop_image"));
        imageHopTarget = this.getImageIcon(BasePropertyHandler.getProperty((String)"HopTarget_image"));
        imageHopInput = this.getImageIcon(BasePropertyHandler.getProperty((String)"HopInput_image"));
        imageHopOutput = this.getImageIcon(BasePropertyHandler.getProperty((String)"HopOutput_image"));
        imageArrow = this.getImageIcon(BasePropertyHandler.getProperty((String)"ArrowIcon_image"));
        imageCopyHop = this.getImageIcon(BasePropertyHandler.getProperty((String)"CopyHop_image"));
        imageLoadBalance = this.getImageIcon(BasePropertyHandler.getProperty((String)"LoadBalance_image"));
        imageCheckpoint = this.getImageIcon(BasePropertyHandler.getProperty((String)"CheckeredFlag_image"));
        imageDatabase = this.getImageIcon(BasePropertyHandler.getProperty((String)"Database_image"));
        imageParallelHop = this.getImageIcon(BasePropertyHandler.getProperty((String)"ParallelHop_image"));
        imageUnconditionalHop = this.getImageIcon(BasePropertyHandler.getProperty((String)"UnconditionalHop_image"));
        imageStart = this.getImageIcon(BasePropertyHandler.getProperty((String)"STR_image"));
        imageDummy = this.getImageIcon(BasePropertyHandler.getProperty((String)"DUM_image"));
        imageBusy = this.getImageIcon(BasePropertyHandler.getProperty((String)"Busy_image"));
        imageInject = this.getImageIcon(BasePropertyHandler.getProperty((String)"Inject_image"));
        this.fontGraph = new Font("FreeSans", 0, 10);
        this.fontNote = new Font("FreeSans", 0, 10);
        this.fontSmall = new Font("FreeSans", 0, 8);
        this.gc.setFont(this.fontGraph);
        this.gc.setColor(this.background);
        this.gc.fillRect(0, 0, this.area.x, this.area.y);
    }

    private BufferedImage getImageIcon(String fileName) throws KettleException {
        InputStream inputStream = null;
        BufferedImage image = null;
        if (fileName == null) {
            throw new KettleException("Image icon file name can not be null");
        }
        try {
            image = ImageIO.read(new File(fileName));
            if (image == null) {
                image = ImageIO.read(new File("/" + fileName));
            }
        }
        catch (IIOException iioe) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (image == null) {
            try {
                inputStream = this.getClass().getResourceAsStream(fileName);
                if (inputStream == null) {
                    inputStream = this.getClass().getResourceAsStream("/" + fileName);
                }
                if (inputStream == null) {
                    throw new KettleException("Unable to load image from classpath : '" + fileName + "'");
                }
                image = ImageIO.read(inputStream);
            }
            catch (IOException ioe) {
                throw new KettleException("Unable to close image reading stream", (Throwable)ioe);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        throw new KettleException("Unable to close image reading stream", (Throwable)e);
                    }
                }
            }
        }
        WaitingImageObserver observer = new WaitingImageObserver((Image)image);
        observer.waitImageLoaded();
        return image;
    }

    public void dispose() {
    }

    public void drawLine(int x, int y, int x2, int y2) {
        this.gc.drawLine(x + this.xOffset, y + this.yOffset, x2 + this.xOffset, y2 + this.yOffset);
    }

    public void drawImage(PrimitiveGCInterface.EImage image, int locationX, int locationY) {
        BufferedImage img = SwingGC.getNativeImage(image);
        this.drawPixelatedImage(img, locationX, locationY);
    }

    public void drawPixelatedImage(BufferedImage img, int locationX, int locationY) {
        if (this.isDrawingPixelatedImages()) {
            BufferedImage bi = new BufferedImage(img.getWidth(), img.getHeight(), 1);
            Graphics2D g2 = (Graphics2D)bi.getGraphics();
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, img.getWidth(), img.getHeight());
            g2.drawImage((Image)img, 0, 0, this.observer);
            g2.dispose();
            for (int x = 0; x < bi.getWidth(this.observer); ++x) {
                for (int y = 0; y < bi.getHeight(this.observer); ++y) {
                    int rgb = bi.getRGB(x, y);
                    this.gc.setColor(new Color(rgb));
                    this.gc.setStroke(new BasicStroke(1.0f));
                    this.gc.drawLine(locationX + this.xOffset + x, locationY + this.yOffset + y, locationX + this.xOffset + x, locationY + this.yOffset + y);
                }
            }
        } else {
            while (!this.gc.drawImage((Image)img, locationX, locationY, this.observer)) {
            }
        }
    }

    public Point getImageBounds(PrimitiveGCInterface.EImage image) {
        BufferedImage img = SwingGC.getNativeImage(image);
        int width = img.getWidth(this.observer);
        int height = img.getHeight(this.observer);
        return new Point(width, height);
    }

    public static final BufferedImage getNativeImage(PrimitiveGCInterface.EImage image) {
        switch (image) {
            case LOCK: {
                return imageLocked;
            }
            case STEP_ERROR: {
                return imageStepError;
            }
            case EDIT: {
                return imageEdit;
            }
            case CONTEXT_MENU: {
                return imageContextMenu;
            }
            case TRUE: {
                return imageTrue;
            }
            case FALSE: {
                return imageFalse;
            }
            case ERROR: {
                return imageErrorHop;
            }
            case INFO: {
                return imageInfoHop;
            }
            case TARGET: {
                return imageHopTarget;
            }
            case INPUT: {
                return imageHopInput;
            }
            case OUTPUT: {
                return imageHopOutput;
            }
            case ARROW: {
                return imageArrow;
            }
            case COPY_ROWS: {
                return imageCopyHop;
            }
            case LOAD_BALANCE: {
                return imageLoadBalance;
            }
            case CHECKPOINT: {
                return imageCheckpoint;
            }
            case DB: {
                return imageDatabase;
            }
            case PARALLEL: {
                return imageParallelHop;
            }
            case UNCONDITIONAL: {
                return imageUnconditionalHop;
            }
            case BUSY: {
                return imageBusy;
            }
            case INJECT: {
                return imageInject;
            }
        }
        return null;
    }

    public void drawPoint(int x, int y) {
        this.gc.drawLine(x + this.xOffset, y + this.yOffset, x + this.xOffset, y + this.yOffset);
    }

    public void drawPolygon(int[] polygon) {
        this.gc.drawPolygon(this.getSwingPolygon(polygon));
    }

    private Polygon getSwingPolygon(int[] polygon) {
        int nPoints = polygon.length / 2;
        int[] xPoints = new int[polygon.length / 2];
        int[] yPoints = new int[polygon.length / 2];
        for (int i = 0; i < nPoints; ++i) {
            xPoints[i] = polygon[2 * i + 0] + this.xOffset;
            yPoints[i] = polygon[2 * i + 1] + this.yOffset;
        }
        return new Polygon(xPoints, yPoints, nPoints);
    }

    public void drawPolyline(int[] polyline) {
        int nPoints = polyline.length / 2;
        int[] xPoints = new int[polyline.length / 2];
        int[] yPoints = new int[polyline.length / 2];
        for (int i = 0; i < nPoints; ++i) {
            xPoints[i] = polyline[2 * i + 0] + this.xOffset;
            yPoints[i] = polyline[2 * i + 1] + this.yOffset;
        }
        this.gc.drawPolyline(xPoints, yPoints, nPoints);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.gc.drawRect(x + this.xOffset, y + this.yOffset, width, height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int circleWidth, int circleHeight) {
        this.gc.drawRoundRect(x + this.xOffset, y + this.yOffset, width, height, circleWidth, circleHeight);
    }

    public void drawText(String text, int x, int y) {
        String[] lines;
        int height = this.gc.getFontMetrics().getHeight();
        for (String line : lines = text.split("\n")) {
            this.gc.drawString(line, x + this.xOffset, y + height + this.yOffset);
            y += height;
        }
    }

    public void drawText(String text, int x, int y, boolean transparent) {
        this.drawText(text, x, y);
    }

    public void fillPolygon(int[] polygon) {
        this.switchForegroundBackgroundColors();
        this.gc.fillPolygon(this.getSwingPolygon(polygon));
        this.switchForegroundBackgroundColors();
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.switchForegroundBackgroundColors();
        this.gc.fillRect(x + this.xOffset, y + this.yOffset, width, height);
        this.switchForegroundBackgroundColors();
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        this.fillRectangle(x, y, width, height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int circleWidth, int circleHeight) {
        this.switchForegroundBackgroundColors();
        this.gc.fillRoundRect(x + this.xOffset, y + this.yOffset, width, height, circleWidth, circleHeight);
        this.switchForegroundBackgroundColors();
    }

    public Point getDeviceBounds() {
        return this.area;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, alpha / 255);
        this.gc.setComposite(alphaComposite);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setBackground(PrimitiveGCInterface.EColor color) {
        this.gc.setBackground(this.getColor(color));
    }

    private Color getColor(PrimitiveGCInterface.EColor color) {
        switch (color) {
            case BACKGROUND: {
                return this.background;
            }
            case BLACK: {
                return this.black;
            }
            case RED: {
                return this.red;
            }
            case YELLOW: {
                return this.yellow;
            }
            case ORANGE: {
                return this.orange;
            }
            case GREEN: {
                return this.green;
            }
            case BLUE: {
                return this.blue;
            }
            case MAGENTA: {
                return this.magenta;
            }
            case GRAY: {
                return this.gray;
            }
            case LIGHTGRAY: {
                return this.lightGray;
            }
            case DARKGRAY: {
                return this.darkGray;
            }
            case LIGHTBLUE: {
                return this.lightBlue;
            }
        }
        return null;
    }

    public void setFont(PrimitiveGCInterface.EFont font) {
        switch (font) {
            case GRAPH: {
                this.gc.setFont(this.fontGraph);
                break;
            }
            case NOTE: {
                this.gc.setFont(this.fontNote);
                break;
            }
            case SMALL: {
                this.gc.setFont(this.fontSmall);
                break;
            }
        }
    }

    public void setForeground(PrimitiveGCInterface.EColor color) {
        this.gc.setColor(this.getColor(color));
    }

    public void setLineStyle(PrimitiveGCInterface.ELineStyle lineStyle) {
        this.lineStyle = lineStyle;
        this.gc.setStroke(this.createStroke());
    }

    private Stroke createStroke() {
        float[] dash;
        switch (this.lineStyle) {
            case SOLID: {
                dash = null;
                break;
            }
            case DOT: {
                dash = new float[]{5.0f};
                break;
            }
            case DASHDOT: {
                dash = new float[]{10.0f, 5.0f, 5.0f, 5.0f};
                break;
            }
            case PARALLEL: {
                dash = new float[]{10.0f, 5.0f, 10.0f, 5.0f};
                break;
            }
            default: {
                throw new RuntimeException("Unhandled line style!");
            }
        }
        return new BasicStroke(this.lineWidth, 0, 0, 2.0f, dash, 0.0f);
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
        this.gc.setStroke(this.createStroke());
    }

    public void setTransform(float translationX, float translationY, int shadowsize, float magnification) {
        AffineTransform transform = new AffineTransform();
        transform.translate(translationX + (float)shadowsize * magnification, translationY + (float)shadowsize * magnification);
        transform.scale(magnification, magnification);
        this.gc.setTransform(transform);
    }

    public Point textExtent(String text) {
        String[] lines = text.split(Const.CR);
        int maxWidth = 0;
        for (String line : lines) {
            Rectangle2D bounds = TextUtilities.getTextBounds((String)line, (Graphics2D)this.gc, (FontMetrics)this.gc.getFontMetrics());
            if (!(bounds.getWidth() > (double)maxWidth)) continue;
            maxWidth = (int)bounds.getWidth();
        }
        int height = this.gc.getFontMetrics().getHeight() * lines.length;
        return new Point(maxWidth, height);
    }

    @Override
    public void drawStepIcon(int x, int y, StepMeta stepMeta) {
        this.gc.fillRect(x + this.xOffset, y + this.yOffset, this.iconsize, this.iconsize);
        String steptype = stepMeta.getStepID();
        BufferedImage im = this.stepImages.get(steptype);
        if (im != null) {
            this.drawPixelatedImage(im, x + this.xOffset, y + this.xOffset);
        }
    }

    @Override
    public void drawJobEntryIcon(int x, int y, JobEntryCopy jobEntryCopy) {
        if (jobEntryCopy == null) {
            return;
        }
        BufferedImage image = null;
        if (jobEntryCopy.isSpecial()) {
            if (jobEntryCopy.isStart()) {
                image = imageStart;
            }
            if (jobEntryCopy.isDummy()) {
                image = imageDummy;
            }
        } else {
            String configId = jobEntryCopy.getEntry().getPluginId();
            if (configId != null) {
                image = this.entryImages.get(configId);
            }
        }
        if (image == null) {
            return;
        }
        this.drawPixelatedImage(image, x + this.xOffset, y + this.xOffset);
    }

    public void setAntialias(boolean antiAlias) {
        if (antiAlias) {
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
            hints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            this.gc.setRenderingHints(hints);
        }
    }

    public void setBackground(int r, int g, int b) {
        Color color = this.getColor(r, g, b);
        this.gc.setBackground(color);
    }

    public void setForeground(int r, int g, int b) {
        Color color = this.getColor(r, g, b);
        this.gc.setColor(color);
    }

    private Color getColor(int r, int g, int b) {
        return new Color(r, g, b);
    }

    public void setFont(String fontName, int fontSize, boolean fontBold, boolean fontItalic) {
        int style = 0;
        if (fontBold) {
            style = 1;
        }
        if (fontItalic) {
            style |= 2;
        }
        Font font = new Font(fontName, style, fontSize);
        this.gc.setFont(font);
    }

    public Object getImage() {
        return this.image;
    }

    public void switchForegroundBackgroundColors() {
        Color fg = this.gc.getColor();
        Color bg = this.gc.getBackground();
        this.gc.setColor(bg);
        this.gc.setBackground(fg);
    }

    public Point getArea() {
        return this.area;
    }

    public boolean isDrawingPixelatedImages() {
        return this.drawingPixelatedImages;
    }

    public void setDrawingPixelatedImages(boolean drawingPixelatedImages) {
        this.drawingPixelatedImages = drawingPixelatedImages;
    }

    public void drawImage(BufferedImage image, int x, int y) {
        this.gc.drawImage((Image)image, x, y, this.observer);
    }
}

