/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.logging.BaseLogTable;
import org.pentaho.di.core.logging.LogStatus;
import org.pentaho.di.core.logging.LogTableCoreInterface;
import org.pentaho.di.core.logging.LogTableField;
import org.pentaho.di.core.logging.LogTableInterface;
import org.pentaho.di.core.logging.LoggingHierarchy;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.HasDatabasesInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.w3c.dom.Node;

public class ChannelLogTable
extends BaseLogTable
implements Cloneable,
LogTableInterface {
    private static Class<?> PKG = ChannelLogTable.class;
    public static final String XML_TAG = "channel-log-table";

    private ChannelLogTable(VariableSpace space, HasDatabasesInterface databasesInterface) {
        super(space, databasesInterface, null, null, null);
    }

    @Override
    public Object clone() {
        try {
            ChannelLogTable table = (ChannelLogTable)super.clone();
            table.fields = new ArrayList();
            for (LogTableField field : this.fields) {
                table.fields.add((LogTableField)field.clone());
            }
            return table;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append(XMLHandler.openTag((String)XML_TAG));
        retval.append(XMLHandler.addTagValue((String)"connection", (String)this.connectionName));
        retval.append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append(XMLHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append(XMLHandler.addTagValue((String)"timeout_days", (String)this.timeoutInDays));
        retval.append(super.getFieldsXML());
        retval.append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node jobnode, List<DatabaseMeta> databases, List<StepMeta> steps) {
        Node node = XMLHandler.getSubNode((Node)jobnode, (String)XML_TAG);
        if (node == null) {
            return;
        }
        this.connectionName = XMLHandler.getTagValue((Node)node, (String)"connection");
        this.schemaName = XMLHandler.getTagValue((Node)node, (String)"schema");
        this.tableName = XMLHandler.getTagValue((Node)node, (String)"table");
        this.timeoutInDays = XMLHandler.getTagValue((Node)node, (String)"timeout_days");
        super.loadFieldsXML(node);
    }

    public void replaceMeta(LogTableCoreInterface logTableInterface) {
        if (!(logTableInterface instanceof ChannelLogTable)) {
            return;
        }
        ChannelLogTable logTable = (ChannelLogTable)logTableInterface;
        super.replaceMeta(logTable);
    }

    public static ChannelLogTable getDefault(VariableSpace space, HasDatabasesInterface databasesInterface) {
        ChannelLogTable table = new ChannelLogTable(space, databasesInterface);
        table.fields.add(new LogTableField(ID.ID_BATCH.id, true, false, "ID_BATCH", BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldName.IdBatch", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldDescription.IdBatch", (String[])new String[0]), 5, 8));
        table.fields.add(new LogTableField(ID.CHANNEL_ID.id, true, false, "CHANNEL_ID", BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldName.ChannelId", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldDescription.ChannelId", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.LOG_DATE.id, true, false, "LOG_DATE", BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldName.LogDate", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldDescription.LogDate", (String[])new String[0]), 3, -1));
        table.fields.add(new LogTableField(ID.LOGGING_OBJECT_TYPE.id, true, false, "LOGGING_OBJECT_TYPE", BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldName.ObjectType", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldDescription.ObjectType", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.OBJECT_NAME.id, true, false, "OBJECT_NAME", BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldName.ObjectName", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldDescription.ObjectName", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.OBJECT_COPY.id, true, false, "OBJECT_COPY", BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldName.ObjectCopy", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldDescription.ObjectCopy", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.REPOSITORY_DIRECTORY.id, true, false, "REPOSITORY_DIRECTORY", BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldName.RepositoryDirectory", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldDescription.RepositoryDirectory", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.FILENAME.id, true, false, "FILENAME", BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldName.Filename", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldDescription.Filename", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.OBJECT_ID.id, true, false, "OBJECT_ID", BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldName.ObjectId", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldDescription.ObjectId", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.OBJECT_REVISION.id, true, false, "OBJECT_REVISION", BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldName.ObjectRevision", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldDescription.ObjectRevision", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.PARENT_CHANNEL_ID.id, true, false, "PARENT_CHANNEL_ID", BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldName.ParentChannelId", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldDescription.ParentChannelId", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.ROOT_CHANNEL_ID.id, true, false, "ROOT_CHANNEL_ID", BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldName.RootChannelId", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ChannelLogTable.FieldDescription.RootChannelId", (String[])new String[0]), 2, 255));
        table.findField(ID.LOG_DATE.id).setLogDateField(true);
        table.findField(ID.ID_BATCH.id).setKey(true);
        return table;
    }

    public RowMetaAndData getLogRecord(LogStatus status, Object subject, Object parent) {
        if (subject == null || subject instanceof LoggingHierarchy) {
            LoggingHierarchy loggingHierarchy = (LoggingHierarchy)subject;
            LoggingObjectInterface loggingObject = null;
            if (subject != null) {
                loggingObject = loggingHierarchy.getLoggingObject();
            }
            RowMetaAndData row = new RowMetaAndData();
            for (LogTableField field : this.fields) {
                if (!field.isEnabled()) continue;
                Object value = null;
                if (subject != null) {
                    switch (ID.valueOf(field.getId())) {
                        case ID_BATCH: {
                            value = new Long(loggingHierarchy.getBatchId());
                            break;
                        }
                        case CHANNEL_ID: {
                            value = loggingObject.getLogChannelId();
                            break;
                        }
                        case LOG_DATE: {
                            value = new Date();
                            break;
                        }
                        case LOGGING_OBJECT_TYPE: {
                            value = loggingObject.getObjectType().toString();
                            break;
                        }
                        case OBJECT_NAME: {
                            value = loggingObject.getObjectName();
                            break;
                        }
                        case OBJECT_COPY: {
                            value = loggingObject.getObjectCopy();
                            break;
                        }
                        case REPOSITORY_DIRECTORY: {
                            value = loggingObject.getRepositoryDirectory() == null ? null : loggingObject.getRepositoryDirectory().getPath();
                            break;
                        }
                        case FILENAME: {
                            value = loggingObject.getFilename();
                            break;
                        }
                        case OBJECT_ID: {
                            value = loggingObject.getObjectId() == null ? null : loggingObject.getObjectId().toString();
                            break;
                        }
                        case OBJECT_REVISION: {
                            value = loggingObject.getObjectRevision() == null ? null : loggingObject.getObjectRevision().toString();
                            break;
                        }
                        case PARENT_CHANNEL_ID: {
                            value = loggingObject.getParent() == null ? null : loggingObject.getParent().getLogChannelId();
                            break;
                        }
                        case ROOT_CHANNEL_ID: {
                            value = loggingHierarchy.getRootChannelId();
                            break;
                        }
                    }
                }
                row.addValue(field.getFieldName(), field.getDataType(), value);
                row.getRowMeta().getValueMeta(row.size() - 1).setLength(field.getLength());
            }
            return row;
        }
        return null;
    }

    @Override
    public String getLogTableCode() {
        return "CHANNEL";
    }

    public String getLogTableType() {
        return BaseMessages.getString(PKG, (String)"ChannelLogTable.Type.Description", (String[])new String[0]);
    }

    @Override
    public String getConnectionNameVariable() {
        return "KETTLE_CHANNEL_LOG_DB";
    }

    @Override
    public String getSchemaNameVariable() {
        return "KETTLE_CHANNEL_LOG_SCHEMA";
    }

    @Override
    public String getTableNameVariable() {
        return "KETTLE_CHANNEL_LOG_TABLE";
    }

    public List<RowMetaInterface> getRecommendedIndexes() {
        ArrayList<RowMetaInterface> indexes = new ArrayList<RowMetaInterface>();
        return indexes;
    }

    public static enum ID {
        ID_BATCH("ID_BATCH"),
        CHANNEL_ID("CHANNEL_ID"),
        LOG_DATE("LOG_DATE"),
        LOGGING_OBJECT_TYPE("LOGGING_OBJECT_TYPE"),
        OBJECT_NAME("OBJECT_NAME"),
        OBJECT_COPY("OBJECT_COPY"),
        REPOSITORY_DIRECTORY("REPOSITORY_DIRECTORY"),
        FILENAME("FILENAME"),
        OBJECT_ID("OBJECT_ID"),
        OBJECT_REVISION("OBJECT_REVISION"),
        PARENT_CHANNEL_ID("PARENT_CHANNEL_ID"),
        ROOT_CHANNEL_ID("ROOT_CHANNEL_ID");

        private String id;

        private ID(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }
}

