/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.logging.BaseLogTable;
import org.pentaho.di.core.logging.LogStatus;
import org.pentaho.di.core.logging.LogTableCoreInterface;
import org.pentaho.di.core.logging.LogTableField;
import org.pentaho.di.core.logging.LogTableInterface;
import org.pentaho.di.core.logging.LoggingMetric;
import org.pentaho.di.core.metrics.MetricsSnapshotInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.HasDatabasesInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.w3c.dom.Node;

public class MetricsLogTable
extends BaseLogTable
implements Cloneable,
LogTableInterface {
    private static Class<?> PKG = MetricsLogTable.class;
    public static final String XML_TAG = "metrics-log-table";

    private MetricsLogTable(VariableSpace space, HasDatabasesInterface databasesInterface) {
        super(space, databasesInterface, null, null, null);
    }

    @Override
    public Object clone() {
        try {
            MetricsLogTable table = (MetricsLogTable)super.clone();
            table.fields = new ArrayList();
            for (LogTableField field : this.fields) {
                table.fields.add((LogTableField)field.clone());
            }
            return table;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append(XMLHandler.openTag((String)XML_TAG));
        retval.append(XMLHandler.addTagValue((String)"connection", (String)this.connectionName));
        retval.append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append(XMLHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append(XMLHandler.addTagValue((String)"timeout_days", (String)this.timeoutInDays));
        retval.append(super.getFieldsXML());
        retval.append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node node, List<DatabaseMeta> databases, List<StepMeta> steps) {
        this.connectionName = XMLHandler.getTagValue((Node)node, (String)"connection");
        this.schemaName = XMLHandler.getTagValue((Node)node, (String)"schema");
        this.tableName = XMLHandler.getTagValue((Node)node, (String)"table");
        this.timeoutInDays = XMLHandler.getTagValue((Node)node, (String)"timeout_days");
        super.loadFieldsXML(node);
    }

    public void replaceMeta(LogTableCoreInterface logTableInterface) {
        if (!(logTableInterface instanceof MetricsLogTable)) {
            return;
        }
        MetricsLogTable logTable = (MetricsLogTable)logTableInterface;
        super.replaceMeta(logTable);
    }

    public static MetricsLogTable getDefault(VariableSpace space, HasDatabasesInterface databasesInterface) {
        MetricsLogTable table = new MetricsLogTable(space, databasesInterface);
        table.fields.add(new LogTableField(ID.ID_BATCH.id, true, false, "ID_BATCH", BaseMessages.getString(PKG, (String)"MetricsLogTable.FieldName.IdBatch", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetricsLogTable.FieldDescription.IdBatch", (String[])new String[0]), 5, 8));
        table.fields.add(new LogTableField(ID.CHANNEL_ID.id, true, false, "CHANNEL_ID", BaseMessages.getString(PKG, (String)"MetricsLogTable.FieldName.ChannelId", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetricsLogTable.FieldDescription.ChannelId", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.LOG_DATE.id, true, false, "LOG_DATE", BaseMessages.getString(PKG, (String)"MetricsLogTable.FieldName.LogDate", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetricsLogTable.FieldDescription.LogDate", (String[])new String[0]), 3, -1));
        table.fields.add(new LogTableField(ID.METRICS_DATE.id, true, false, "METRICS_DATE", BaseMessages.getString(PKG, (String)"MetricsLogTable.FieldName.MetricsDate", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetricsLogTable.FieldDescription.MetricsDate", (String[])new String[0]), 3, -1));
        table.fields.add(new LogTableField(ID.METRICS_CODE.id, true, false, "METRICS_CODE", BaseMessages.getString(PKG, (String)"MetricsLogTable.FieldName.MetricsDescription", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetricsLogTable.FieldDescription.MetricsCode", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.METRICS_DESCRIPTION.id, true, false, "METRICS_DESCRIPTION", BaseMessages.getString(PKG, (String)"MetricsLogTable.FieldName.MetricsDescription", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetricsLogTable.FieldDescription.MetricsDescription", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.METRICS_SUBJECT.id, true, false, "METRICS_SUBJECT", BaseMessages.getString(PKG, (String)"MetricsLogTable.FieldName.MetricsSubject", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetricsLogTable.FieldDescription.MetricsSubject", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.METRICS_TYPE.id, true, false, "METRICS_TYPE", BaseMessages.getString(PKG, (String)"MetricsLogTable.FieldName.MetricsType", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetricsLogTable.FieldDescription.MetricsType", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.METRICS_VALUE.id, true, false, "METRICS_VALUE", BaseMessages.getString(PKG, (String)"MetricsLogTable.FieldName.MetricsValue", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetricsLogTable.FieldDescription.MetricsValue", (String[])new String[0]), 5, 12));
        table.findField(ID.LOG_DATE.id).setLogDateField(true);
        table.findField(ID.ID_BATCH.id).setKey(true);
        return table;
    }

    public RowMetaAndData getLogRecord(LogStatus status, Object subject, Object parent) {
        if (subject == null || subject instanceof LoggingMetric) {
            LoggingMetric loggingMetric = (LoggingMetric)subject;
            MetricsSnapshotInterface snapshot = null;
            if (subject != null) {
                snapshot = loggingMetric.getSnapshot();
            }
            RowMetaAndData row = new RowMetaAndData();
            for (LogTableField field : this.fields) {
                if (!field.isEnabled()) continue;
                Object value = null;
                if (subject != null) {
                    switch (ID.valueOf(field.getId())) {
                        case ID_BATCH: {
                            value = new Long(loggingMetric.getBatchId());
                            break;
                        }
                        case CHANNEL_ID: {
                            value = snapshot.getLogChannelId();
                            break;
                        }
                        case LOG_DATE: {
                            value = new Date();
                            break;
                        }
                        case METRICS_DATE: {
                            value = snapshot.getDate();
                            break;
                        }
                        case METRICS_CODE: {
                            value = snapshot.getMetric().getCode();
                            break;
                        }
                        case METRICS_DESCRIPTION: {
                            value = snapshot.getMetric().getDescription();
                            break;
                        }
                        case METRICS_SUBJECT: {
                            value = snapshot.getSubject();
                            break;
                        }
                        case METRICS_TYPE: {
                            value = snapshot.getMetric().getType().name();
                            break;
                        }
                        case METRICS_VALUE: {
                            value = snapshot.getValue();
                            break;
                        }
                    }
                }
                row.addValue(field.getFieldName(), field.getDataType(), value);
                row.getRowMeta().getValueMeta(row.size() - 1).setLength(field.getLength());
            }
            return row;
        }
        return null;
    }

    @Override
    public String getLogTableCode() {
        return "CHANNEL";
    }

    public String getLogTableType() {
        return BaseMessages.getString(PKG, (String)"MetricsLogTable.Type.Description", (String[])new String[0]);
    }

    @Override
    public String getConnectionNameVariable() {
        return "KETTLE_METRICS_LOG_DB";
    }

    @Override
    public String getSchemaNameVariable() {
        return "KETTLE_METRICS_LOG_SCHEMA";
    }

    @Override
    public String getTableNameVariable() {
        return "KETTLE_METRICS_LOG_TABLE";
    }

    public List<RowMetaInterface> getRecommendedIndexes() {
        ArrayList<RowMetaInterface> indexes = new ArrayList<RowMetaInterface>();
        return indexes;
    }

    public static enum ID {
        ID_BATCH("ID_BATCH"),
        CHANNEL_ID("CHANNEL_ID"),
        LOG_DATE("LOG_DATE"),
        METRICS_DATE("METRICS_DATE"),
        METRICS_CODE("METRICS_CODE"),
        METRICS_DESCRIPTION("METRICS_DESCRIPTION"),
        METRICS_SUBJECT("METRICS_SUBJECT"),
        METRICS_TYPE("METRICS_TYPE"),
        METRICS_VALUE("METRICS_VALUE");

        private String id;

        private ID(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }
}

