/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.gui.GCInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.gui.PrimitiveGCInterface;
import org.pentaho.di.core.gui.Rectangle;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.metrics.MetricsDuration;

public class MetricsPainter {
    private GCInterface gc;
    private Long periodStart = null;
    private Long periodEnd = null;
    private int barHeight;

    public MetricsPainter(GCInterface gc, int barHeight) {
        this.gc = gc;
        this.barHeight = barHeight;
    }

    public List<MetricsDrawArea> paint(List<MetricsDuration> durations) {
        int timeLineDistance;
        int width = this.gc.getArea().x - 4;
        int height = this.gc.getArea().y - 4;
        ArrayList<MetricsDrawArea> areas = new ArrayList<MetricsDrawArea>();
        this.determinePeriod(durations);
        if (this.periodStart == null || this.periodEnd == null || this.periodEnd <= this.periodStart) {
            return areas;
        }
        double pixelsPerMs = (double)width / (double)(this.periodEnd - this.periodStart);
        long periodInMs = this.periodEnd - this.periodStart;
        int log10 = (int)Math.log10(periodInMs) + 1;
        int time = timeLineDistance = (int)Math.pow(10.0, log10 - 1) / 2;
        while ((long)time < periodInMs) {
            int x = (int)((double)time * pixelsPerMs);
            this.gc.setForeground(PrimitiveGCInterface.EColor.LIGHTGRAY);
            this.gc.drawLine(x, 0, x, height);
            String marker = Integer.toString(time);
            Point point = this.gc.textExtent(marker);
            this.gc.setForeground(PrimitiveGCInterface.EColor.DARKGRAY);
            this.gc.drawText(marker, x - point.x / 2, 0, true);
            time += timeLineDistance;
        }
        int y = 20;
        for (int i = 0; i < durations.size(); ++i) {
            MetricsDuration duration = durations.get(i);
            Long realDuration = duration.getEndDate().getTime() - duration.getDate().getTime();
            int durationWidth = (int)((double)realDuration.longValue() * pixelsPerMs);
            int x = 2 + (int)((double)(duration.getDate().getTime() - this.periodStart) * pixelsPerMs);
            this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
            this.gc.setForeground(PrimitiveGCInterface.EColor.LIGHTBLUE);
            this.gc.fillGradientRectangle(x, y, durationWidth, this.barHeight, false);
            this.gc.setForeground(PrimitiveGCInterface.EColor.BLACK);
            this.gc.drawRectangle(x, y, durationWidth, this.barHeight);
            areas.add(new MetricsDrawArea(new Rectangle(x, y, durationWidth, this.barHeight), duration));
            LoggingObjectInterface loggingObject = LoggingRegistry.getInstance().getLoggingObject(duration.getLogChannelId());
            String message = duration.getDescription() + " - " + loggingObject.getObjectName() + " : " + duration.getDuration() + "ms";
            if (duration.getCount() > 1L) {
                message = message + " " + duration.getCount() + " calls, avg=" + duration.getDuration() / duration.getCount();
            }
            this.gc.setFont(PrimitiveGCInterface.EFont.GRAPH);
            this.gc.textExtent(message);
            this.gc.drawText(message, x + 3, y + 4, true);
            y += this.barHeight + 5;
        }
        return areas;
    }

    private void determinePeriod(List<MetricsDuration> durations) {
        this.periodStart = null;
        this.periodEnd = null;
        for (int i = 0; i < durations.size(); ++i) {
            MetricsDuration duration = durations.get(i);
            long periodStartTime = duration.getDate().getTime();
            if (this.periodStart == null || periodStartTime < this.periodStart) {
                this.periodStart = periodStartTime;
            }
            long periodEndTime = duration.getEndDate().getTime();
            if (this.periodEnd != null && this.periodEnd >= periodEndTime) continue;
            this.periodEnd = periodEndTime;
        }
    }

    public class MetricsDrawArea {
        private Rectangle area;
        private MetricsDuration duration;

        public MetricsDrawArea(Rectangle area, MetricsDuration duration) {
            this.area = area;
            this.duration = duration;
        }

        public MetricsDuration getDuration() {
            return this.duration;
        }

        public Rectangle getArea() {
            return this.area;
        }
    }
}

