/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.imp;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.imp.ImportRules;
import org.pentaho.di.imp.rule.ImportRuleInterface;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.pan.CommandLineOption;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryImportFeedbackInterface;
import org.pentaho.di.repository.RepositoryImporter;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.version.BuildVersion;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Import {
    private static Class<?> PKG = Import.class;
    public static final String STRING_IMPORT = "Import";

    public static void main(String[] a) throws KettleException {
        KettleEnvironment.init();
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 0; i < a.length; ++i) {
            if (a[i].length() <= 0) continue;
            args.add(a[i]);
        }
        CommandLineOption[] commandLineOptionArray = new CommandLineOption[14];
        StringBuffer optionRepname = new StringBuffer();
        commandLineOptionArray[0] = new CommandLineOption("rep", BaseMessages.getString(PKG, (String)"Import.CmdLine.RepName", (String[])new String[0]), optionRepname);
        StringBuffer optionUsername = new StringBuffer();
        commandLineOptionArray[1] = new CommandLineOption("user", BaseMessages.getString(PKG, (String)"Import.CmdLine.RepUsername", (String[])new String[0]), optionUsername);
        StringBuffer optionPassword = new StringBuffer();
        commandLineOptionArray[2] = new CommandLineOption("pass", BaseMessages.getString(PKG, (String)"Import.CmdLine.RepPassword", (String[])new String[0]), optionPassword);
        StringBuffer optionDirname = new StringBuffer();
        commandLineOptionArray[3] = new CommandLineOption("dir", BaseMessages.getString(PKG, (String)"Import.CmdLine.RepDir", (String[])new String[0]), optionDirname);
        StringBuffer optionLimitDir = new StringBuffer();
        commandLineOptionArray[4] = new CommandLineOption("limitdir", BaseMessages.getString(PKG, (String)"Import.CmdLine.LimitDir", (String[])new String[0]), optionLimitDir);
        StringBuffer optionFilename = new StringBuffer();
        commandLineOptionArray[5] = new CommandLineOption("file", BaseMessages.getString(PKG, (String)"Import.CmdLine.File", (String[])new String[0]), optionFilename);
        StringBuffer optionFileDir = new StringBuffer();
        commandLineOptionArray[6] = new CommandLineOption("filedir", BaseMessages.getString(PKG, (String)"Import.CmdLine.FileDir", (String[])new String[0]), optionFileDir);
        StringBuffer optionRules = new StringBuffer();
        commandLineOptionArray[7] = new CommandLineOption("rules", BaseMessages.getString(PKG, (String)"Import.CmdLine.RulesFile", (String[])new String[0]), optionRules);
        StringBuffer optionNoRules = new StringBuffer();
        commandLineOptionArray[8] = new CommandLineOption("norules", BaseMessages.getString(PKG, (String)"Import.CmdLine.NoRules", (String[])new String[0]), optionNoRules, true, false);
        StringBuffer optionComment = new StringBuffer();
        commandLineOptionArray[9] = new CommandLineOption("comment", BaseMessages.getString(PKG, (String)"Import.CmdLine.Comment", (String[])new String[0]), optionComment, true, false);
        StringBuffer optionReplace = new StringBuffer();
        commandLineOptionArray[10] = new CommandLineOption("replace", BaseMessages.getString(PKG, (String)"Import.CmdLine.Replace", (String[])new String[0]), optionReplace, true, false);
        StringBuffer optionContinueOnError = new StringBuffer();
        commandLineOptionArray[11] = new CommandLineOption("coe", BaseMessages.getString(PKG, (String)"Import.CmdLine.ContinueOnError", (String[])new String[0]), optionContinueOnError, true, false);
        StringBuffer optionVersion = new StringBuffer();
        commandLineOptionArray[12] = new CommandLineOption("version", BaseMessages.getString(PKG, (String)"Import.CmdLine.Version", (String[])new String[0]), optionVersion, true, false);
        commandLineOptionArray[13] = new CommandLineOption("", BaseMessages.getString(PKG, (String)"Import.CmdLine.ExtraFiles", (String[])new String[0]), new StringBuffer(), false, true, true);
        CommandLineOption[] options = commandLineOptionArray;
        if (args.size() == 0) {
            CommandLineOption.printUsage(options);
            Import.exitJVM(9);
        }
        LogChannel log = new LogChannel((Object)STRING_IMPORT);
        CommandLineOption.parseArguments(args, options, (LogChannelInterface)log);
        ArrayList<String> filenames = new ArrayList<String>(args);
        if (!Const.isEmpty((StringBuffer)optionFilename)) {
            filenames.add(optionFilename.toString());
        }
        String kettleRepname = Const.getEnvironmentVariable((String)"KETTLE_REPOSITORY", null);
        String kettleUsername = Const.getEnvironmentVariable((String)"KETTLE_USER", null);
        String kettlePassword = Const.getEnvironmentVariable((String)"KETTLE_PASSWORD", null);
        if (!Const.isEmpty((String)kettleRepname)) {
            optionRepname = new StringBuffer(kettleRepname);
        }
        if (!Const.isEmpty((String)kettleUsername)) {
            optionUsername = new StringBuffer(kettleUsername);
        }
        if (!Const.isEmpty((String)kettlePassword)) {
            optionPassword = new StringBuffer(kettlePassword);
        }
        if (!Const.isEmpty((StringBuffer)optionVersion)) {
            BuildVersion buildVersion = BuildVersion.getInstance();
            log.logBasic(BaseMessages.getString(PKG, (String)"Import.Log.KettleVersion", (String[])new String[]{buildVersion.getVersion(), buildVersion.getRevision(), buildVersion.getBuildDate()}));
            if (a.length == 1) {
                Import.exitJVM(6);
            }
        }
        if (Const.isEmpty((StringBuffer)optionRepname)) {
            log.logError(BaseMessages.getString(PKG, (String)"Import.Error.NoRepProvided", (String[])new String[0]));
            Import.exitJVM(1);
        }
        if (Const.isEmpty(filenames)) {
            log.logError(BaseMessages.getString(PKG, (String)"Import.Error.NoExportFileProvided", (String[])new String[0]));
            Import.exitJVM(1);
        }
        if (Const.isEmpty((StringBuffer)optionDirname)) {
            log.logError(BaseMessages.getString(PKG, (String)"Import.Error.NoRepositoryDirectoryProvided", (String[])new String[0]));
            Import.exitJVM(1);
        }
        if (Const.isEmpty((StringBuffer)optionRules) && Const.isEmpty((StringBuffer)optionNoRules) && !"Y".equalsIgnoreCase(optionNoRules.toString())) {
            log.logError(BaseMessages.getString(PKG, (String)"Import.Error.NoRulesFileProvided", (String[])new String[0]));
            Import.exitJVM(1);
        }
        ImportRules importRules = new ImportRules();
        String rulesFile = optionRules.toString();
        if (!Const.isEmpty((String)rulesFile)) {
            try {
                Document document = XMLHandler.loadXMLFile((String)rulesFile);
                Node rulesNode = XMLHandler.getSubNode((Node)document, (String)"rules");
                importRules.loadXML(rulesNode);
                log.logMinimal(BaseMessages.getString(PKG, (String)"Import.Log.RulesLoaded", (String[])new String[]{rulesFile, "" + importRules.getRules().size()}));
                for (ImportRuleInterface rule : importRules.getRules()) {
                    log.logBasic(" - " + rule.toString());
                }
            }
            catch (KettleException e) {
                log.logError(BaseMessages.getString(PKG, (String)"Import.Log.ExceptionLoadingRules", (String[])new String[]{rulesFile}), (Throwable)e);
                Import.exitJVM(7);
            }
        }
        ArrayList<String> limitDirs = new ArrayList<String>();
        if (!Const.isEmpty((StringBuffer)optionLimitDir)) {
            String[] directories;
            for (String directory : directories = optionLimitDir.toString().split(",")) {
                limitDirs.add(directory);
            }
        }
        RepositoriesMeta repsinfo = new RepositoriesMeta();
        try {
            repsinfo.readData();
        }
        catch (Exception e) {
            log.logError(BaseMessages.getString(PKG, (String)"Import.Error.UnableToLoadRepositoryInformation", (String[])new String[0]), (Throwable)e);
            Import.exitJVM(1);
        }
        RepositoryMeta repositoryMeta = repsinfo.findRepository(optionRepname.toString());
        if (repositoryMeta == null) {
            log.logError(BaseMessages.getString(PKG, (String)"Import.Error.RepositoryCouldNotBeFound", (String[])new String[]{optionRepname.toString()}));
            Import.exitJVM(1);
        }
        if (Const.isEmpty((StringBuffer)optionRepname)) {
            log.logError(BaseMessages.getString(PKG, (String)"Import.Error.NoRepProvided", (String[])new String[0]));
            Import.exitJVM(1);
        }
        Repository repository = null;
        try {
            repository = (Repository)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, (Object)repositoryMeta, Repository.class);
            repository.init(repositoryMeta);
        }
        catch (Exception e) {
            log.logError(BaseMessages.getString(PKG, (String)"Import.Error.UnableToLoadOrInitializeRepository", (String[])new String[0]));
            Import.exitJVM(1);
        }
        try {
            repository.connect(optionUsername != null ? optionUsername.toString() : null, optionPassword != null ? optionPassword.toString() : null);
        }
        catch (KettleException ke) {
            log.logError(ke.getMessage());
            Import.exitJVM(1);
        }
        catch (Exception e) {
            log.logError(BaseMessages.getString(PKG, (String)"Import.Error.UnableToConnectToRepository", (String[])new String[0]));
            Import.exitJVM(1);
        }
        final boolean replace = Const.isEmpty((StringBuffer)optionReplace) ? false : ValueMeta.convertStringToBoolean((String)optionReplace.toString());
        boolean continueOnError = Const.isEmpty((StringBuffer)optionContinueOnError) ? false : ValueMeta.convertStringToBoolean((String)optionContinueOnError.toString());
        log.logMinimal(BaseMessages.getString(PKG, (String)"Import.Log.Starting", (String[])new String[0]));
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        Calendar cal = Calendar.getInstance();
        Date start = cal.getTime();
        int returnCode = 0;
        try {
            RepositoryDirectoryInterface tree = repository.loadRepositoryDirectoryTree();
            RepositoryDirectoryInterface targetDirectory = tree.findDirectory(optionDirname.toString());
            if (targetDirectory == null) {
                log.logError(BaseMessages.getString(PKG, (String)"Import.Error.UnableToFindTargetDirectoryInRepository", (String[])new String[]{optionDirname.toString()}));
                Import.exitJVM(1);
            }
            RepositoryImporter importer = new RepositoryImporter(repository, importRules, limitDirs);
            RepositoryImportFeedbackInterface feedbackInterface = new RepositoryImportFeedbackInterface((LogChannelInterface)log, continueOnError){
                final /* synthetic */ LogChannelInterface val$log;
                final /* synthetic */ boolean val$continueOnError;
                {
                    this.val$log = logChannelInterface;
                    this.val$continueOnError = bl2;
                }

                @Override
                public void updateDisplay() {
                }

                @Override
                public boolean transOverwritePrompt(TransMeta transMeta) {
                    return replace;
                }

                @Override
                public void showError(String title, String message, Exception e) {
                    this.val$log.logError(title + " : " + message, (Throwable)e);
                }

                @Override
                public void setLabel(String labelText) {
                    this.val$log.logBasic(labelText);
                }

                @Override
                public boolean jobOverwritePrompt(JobMeta jobMeta) {
                    return replace;
                }

                @Override
                public boolean askContinueOnErrorQuestion(String title, String message) {
                    return this.val$continueOnError;
                }

                @Override
                public void addLog(String line) {
                    this.val$log.logBasic(line);
                }

                @Override
                public boolean isAskingOverwriteConfirmation() {
                    return false;
                }
            };
            importer.importAll(feedbackInterface, optionFileDir.toString(), filenames.toArray(new String[filenames.size()]), targetDirectory, replace, continueOnError, optionComment.toString());
            List<Exception> exceptions = importer.getExceptions();
            if (exceptions != null && !exceptions.isEmpty()) {
                log.logError(BaseMessages.getString(PKG, (String)"Import.Error.UnexpectedErrorDuringImport", (String[])new String[0]), (Throwable)exceptions.get(0));
                returnCode = 2;
            }
        }
        catch (Exception e) {
            log.logError(BaseMessages.getString(PKG, (String)"Import.Error.UnexpectedErrorDuringImport", (String[])new String[0]), (Throwable)e);
            Import.exitJVM(2);
        }
        log.logMinimal(BaseMessages.getString(PKG, (String)"Import.Log.Finished", (String[])new String[0]));
        cal = Calendar.getInstance();
        Date stop = cal.getTime();
        String begin = df.format(start).toString();
        String end = df.format(stop).toString();
        log.logMinimal(BaseMessages.getString(PKG, (String)"Import.Log.StartStop", (String[])new String[]{begin, end}));
        long seconds = (stop.getTime() - start.getTime()) / 1000L;
        if (seconds <= 60L) {
            log.logMinimal(BaseMessages.getString(PKG, (String)"Import.Log.ProcessEndAfter", (String[])new String[]{String.valueOf(seconds)}));
        } else if (seconds <= 3600L) {
            int min = (int)(seconds / 60L);
            int rem = (int)(seconds % 60L);
            log.logMinimal(BaseMessages.getString(PKG, (String)"Import.Log.ProcessEndAfterLong", (String[])new String[]{String.valueOf(min), String.valueOf(rem), String.valueOf(seconds)}));
        } else if (seconds <= 86400L) {
            int hour = (int)(seconds / 3600L);
            int rem = (int)(seconds % 3600L);
            int min = rem / 60;
            log.logMinimal(BaseMessages.getString(PKG, (String)"Import.Log.ProcessEndAfterLonger", (String[])new String[]{String.valueOf(hour), String.valueOf(min), String.valueOf(rem %= 60), String.valueOf(seconds)}));
        } else {
            int days = (int)(seconds / 86400L);
            int rem = (int)(seconds % 86400L);
            int hour = rem / 3600;
            int min = (rem %= 3600) / 60;
            log.logMinimal(BaseMessages.getString(PKG, (String)"Import.Log.ProcessEndAfterLongest", (String[])new String[]{String.valueOf(days), String.valueOf(hour), String.valueOf(min), String.valueOf(rem %= 60), String.valueOf(seconds)}));
        }
        Import.exitJVM(returnCode);
    }

    protected static int parseIntArgument(CommandLineOption option, int def) throws KettleException {
        if (!Const.isEmpty((StringBuffer)option.getArgument())) {
            try {
                return Integer.parseInt(option.getArgument().toString());
            }
            catch (NumberFormatException ex) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Import.Error.InvalidNumberArgument", (Object[])new Object[]{option.getOption(), option.getArgument()}));
            }
        }
        return def;
    }

    private static final void exitJVM(int status) {
        System.exit(status);
    }
}

