/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.checkfilelocked;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.checkfilelocked.LockFile;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryCheckFilesLocked
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryCheckFilesLocked.class;
    public boolean argFromPrevious = false;
    public boolean includeSubfolders = false;
    public String[] arguments = null;
    public String[] filemasks;
    private boolean oneFileLocked;

    public JobEntryCheckFilesLocked(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryCheckFilesLocked() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryCheckFilesLocked je = (JobEntryCheckFilesLocked)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (boolean)this.includeSubfolders));
        retval.append("      <fields>").append(Const.CR);
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.arguments[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"filemask", (String)this.filemasks[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.argFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.includeSubfolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.arguments = new String[nrFields];
            this.filemasks = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.arguments[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.filemasks[i] = XMLHandler.getTagValue((Node)fnode, (String)"filemask");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.UnableToLoadFromXml", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.argFromPrevious = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.includeSubfolders = rep.getJobEntryAttributeBoolean(id_jobentry, "include_subfolders");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "name");
            this.arguments = new String[argnr];
            this.filemasks = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = rep.getJobEntryAttributeString(id_jobentry, a, "name");
                this.filemasks[a] = rep.getJobEntryAttributeString(id_jobentry, a, "filemask");
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.UnableToLoadFromRepo", (String[])new String[]{String.valueOf(id_jobentry)}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "arg_from_previous", this.argFromPrevious);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "include_subfolders", this.includeSubfolders);
            if (this.arguments != null) {
                for (int i = 0; i < this.arguments.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "name", this.arguments[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "filemask", this.filemasks[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.UnableToSaveToRepo", (String[])new String[]{String.valueOf(id_job)}), (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        List rows = result.getRows();
        RowMetaAndData resultRow = null;
        this.oneFileLocked = false;
        result.setResult(true);
        try {
            if (this.argFromPrevious && this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.FoundPreviousRows", (String[])new String[]{String.valueOf(rows != null ? rows.size() : 0)}));
            }
            if (this.argFromPrevious && rows != null) {
                for (int iteration = 0; iteration < rows.size() && !this.parentJob.isStopped(); ++iteration) {
                    resultRow = (RowMetaAndData)rows.get(iteration);
                    String filefolder_previous = resultRow.getString(0, "");
                    String fmasks_previous = resultRow.getString(1, "");
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.ProcessingRow", (String[])new String[]{filefolder_previous, fmasks_previous}));
                    }
                    this.ProcessFile(filefolder_previous, fmasks_previous);
                }
            } else if (this.arguments != null) {
                for (int i = 0; i < this.arguments.length && !this.parentJob.isStopped(); ++i) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.ProcessingArg", (String[])new String[]{this.arguments[i], this.filemasks[i]}));
                    }
                    this.ProcessFile(this.arguments[i], this.filemasks[i]);
                }
            }
            if (this.oneFileLocked) {
                result.setResult(false);
                result.setNrErrors(1L);
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.ErrorRunningJobEntry", (Object[])new Object[]{e}));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ProcessFile(String filename, String wildcard) {
        FileObject filefolder = null;
        String realFilefoldername = this.environmentSubstitute(filename);
        String realwilcard = this.environmentSubstitute(wildcard);
        try {
            filefolder = KettleVFS.getFileObject((String)realFilefoldername);
            FileObject[] files = new FileObject[]{filefolder};
            if (filefolder.exists()) {
                if (filefolder.getType() == FileType.FOLDER) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.ProcessingFolder", (String[])new String[]{realFilefoldername}));
                    }
                    files = filefolder.findFiles((FileSelector)new TextFileSelector(filefolder.toString(), realwilcard));
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.TotalFilesToCheck", (String[])new String[]{String.valueOf(files.length)}));
                    }
                } else if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.ProcessingFile", (String[])new String[]{realFilefoldername}));
                }
                this.checkFilesLocked(files);
            } else {
                this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.FileNotExist", (String[])new String[]{realFilefoldername}));
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.CouldNotProcess", (String[])new String[]{realFilefoldername, e.getMessage()}));
        }
        finally {
            if (filefolder != null) {
                try {
                    filefolder.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private void checkFilesLocked(FileObject[] files) throws KettleException {
        for (int i = 0; i < files.length && !this.oneFileLocked; ++i) {
            FileObject file = files[i];
            String filename = KettleVFS.getFilename((FileObject)file);
            LockFile locked = new LockFile(filename);
            if (locked.isLocked()) {
                this.oneFileLocked = true;
                this.logError(BaseMessages.getString(PKG, (String)"JobCheckFilesLocked.Log.FileLocked", (String[])new String[]{filename}));
                continue;
            }
            if (!this.isDetailed()) continue;
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobCheckFilesLocked.Log.FileNotLocked", (String[])new String[]{filename}));
        }
    }

    private boolean GetFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Const.isEmpty((String)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public void setIncludeSubfolders(boolean includeSubfolders) {
        this.includeSubfolders = includeSubfolders;
    }

    public void setargFromPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public boolean isArgFromPrevious() {
        return this.argFromPrevious;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String[] getFilemasks() {
        return this.filemasks;
    }

    public boolean isIncludeSubfolders() {
        return this.includeSubfolders;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "arguments", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.arguments.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    private class TextFileSelector
    implements FileSelector {
        String file_wildcard = null;
        String source_folder = null;

        public TextFileSelector(String sourcefolderin, String filewildcard) {
            if (!Const.isEmpty((String)sourcefolderin)) {
                this.source_folder = sourcefolderin;
            }
            if (!Const.isEmpty((String)filewildcard)) {
                this.file_wildcard = filewildcard;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean includeFile(FileSelectInfo info) {
            boolean returncode = false;
            Object file_name = null;
            try {
                if (!info.getFile().toString().equals(this.source_folder)) {
                    String short_filename = info.getFile().getName().getBaseName();
                    if (!info.getFile().getParent().equals(info.getBaseFolder())) {
                        if (JobEntryCheckFilesLocked.this.includeSubfolders && info.getFile().getType() == FileType.FILE && JobEntryCheckFilesLocked.this.GetFileWildcard(short_filename, this.file_wildcard)) {
                            if (JobEntryCheckFilesLocked.this.isDetailed()) {
                                JobEntryCheckFilesLocked.this.logDetailed(BaseMessages.getString((Class)PKG, (String)"JobEntryCheckFilesLocked.CheckingFile", (String[])new String[]{info.getFile().toString()}));
                            }
                            returncode = true;
                        }
                    } else if (info.getFile().getType() == FileType.FILE && JobEntryCheckFilesLocked.this.GetFileWildcard(short_filename, this.file_wildcard)) {
                        if (JobEntryCheckFilesLocked.this.isDetailed()) {
                            JobEntryCheckFilesLocked.this.logDetailed(BaseMessages.getString((Class)PKG, (String)"JobEntryCheckFilesLocked.CheckingFile", (String[])new String[]{info.getFile().toString()}));
                        }
                        returncode = true;
                    }
                }
            }
            catch (Exception e) {
                JobEntryCheckFilesLocked.this.logError(BaseMessages.getString((Class)PKG, (String)"JobCheckFilesLocked.Error.Exception.ProcessError", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"JobCheckFilesLocked.Error.Exception.Process", (String[])new String[]{info.getFile().toString(), e.getMessage()}));
                returncode = false;
            }
            finally {
                if (file_name != null) {
                    try {
                        file_name.close();
                    }
                    catch (IOException ex) {}
                }
            }
            return returncode;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return info.getDepth() == 0 || JobEntryCheckFilesLocked.this.includeSubfolders;
        }
    }
}

