/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.columnsexist;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryColumnsExist
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryColumnsExist.class;
    private String schemaname = null;
    private String tablename = null;
    private DatabaseMeta connection = null;
    public String[] arguments;

    public JobEntryColumnsExist(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryColumnsExist() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryColumnsExist je = (JobEntryColumnsExist)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"tablename", (String)this.tablename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"schemaname", (String)this.schemaname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        retval.append("      <fields>").append(Const.CR);
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.arguments[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.tablename = XMLHandler.getTagValue((Node)entrynode, (String)"tablename");
            this.schemaname = XMLHandler.getTagValue((Node)entrynode, (String)"schemaname");
            String dbname = XMLHandler.getTagValue((Node)entrynode, (String)"connection");
            this.connection = DatabaseMeta.findDatabase(databases, (String)dbname);
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.arguments = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.arguments[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
            }
        }
        catch (KettleException e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryColumnsExist.Meta.UnableLoadXml", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.tablename = rep.getJobEntryAttributeString(id_jobentry, "tablename");
            this.schemaname = rep.getJobEntryAttributeString(id_jobentry, "schemaname");
            this.connection = rep.loadDatabaseMetaFromJobEntryAttribute(id_jobentry, "connection", "id_database", databases);
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "name");
            this.arguments = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = rep.getJobEntryAttributeString(id_jobentry, a, "name");
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryColumnsExist.Meta.UnableLoadRep", (String[])new String[]{"" + id_jobentry}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "tablename", this.tablename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "schemaname", this.schemaname);
            rep.saveDatabaseMetaJobEntryAttribute(id_job, this.getObjectId(), "connection", "id_database", this.connection);
            if (this.arguments != null) {
                for (int i = 0; i < this.arguments.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "name", this.arguments[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryColumnsExist.Meta.UnableSaveRep", (String[])new String[]{"" + id_job}), (Throwable)dbe);
        }
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setSchemaname(String schemaname) {
        this.schemaname = schemaname;
    }

    public String getSchemaname() {
        return this.schemaname;
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        result.setNrErrors(1L);
        int nrexistcolums = 0;
        int nrnotexistcolums = 0;
        if (Const.isEmpty((String)this.tablename)) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntryColumnsExist.Error.TablenameEmpty", (String[])new String[0]));
            return result;
        }
        if (this.arguments == null) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntryColumnsExist.Error.ColumnameEmpty", (String[])new String[0]));
            return result;
        }
        if (this.connection != null) {
            Database db = new Database((LoggingObjectInterface)this, this.connection);
            db.shareVariablesWith((VariableSpace)this);
            try {
                String realSchemaname = this.environmentSubstitute(this.schemaname);
                String realTablename = this.environmentSubstitute(this.tablename);
                realTablename = !Const.isEmpty((String)realSchemaname) ? db.getDatabaseMeta().getQuotedSchemaTableCombination(realSchemaname, realTablename) : db.getDatabaseMeta().quoteField(realTablename);
                db.connect(this.parentJob.getTransactionId(), null);
                if (db.checkTableExists(realTablename)) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryColumnsExist.Log.TableExists", (String[])new String[]{realTablename}));
                    }
                    for (int i = 0; i < this.arguments.length && !this.parentJob.isStopped(); ++i) {
                        String realColumnname = this.environmentSubstitute(this.arguments[i]);
                        realColumnname = db.getDatabaseMeta().quoteField(realColumnname);
                        if (db.checkColumnExists(realColumnname, realTablename)) {
                            if (this.log.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryColumnsExist.Log.ColumnExists", (String[])new String[]{realColumnname, realTablename}));
                            }
                            ++nrexistcolums;
                            continue;
                        }
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntryColumnsExist.Log.ColumnNotExists", (String[])new String[]{realColumnname, realTablename}));
                        ++nrnotexistcolums;
                    }
                }
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryColumnsExist.Log.TableNotExists", (String[])new String[]{realTablename}));
            }
            catch (KettleDatabaseException dbe) {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryColumnsExist.Error.UnexpectedError", (String[])new String[]{dbe.getMessage()}));
            }
            finally {
                if (db != null) {
                    try {
                        db.disconnect();
                    }
                    catch (Exception e) {}
                }
            }
        } else {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntryColumnsExist.Error.NoDbConnection", (String[])new String[0]));
        }
        result.setEntryNr((long)nrnotexistcolums);
        result.setNrLinesWritten((long)nrexistcolums);
        if (nrnotexistcolums == 0) {
            result.setResult(true);
        }
        return result;
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (this.connection != null) {
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(this.connection.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate(this, "tablename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "columnname", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

