/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.copymoveresultfilenames;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileUtil;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryCopyMoveResultFilenames
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryCopyMoveResultFilenames.class;
    private String foldername = null;
    private boolean specifywildcard = false;
    private String wildcard = null;
    private String wildcardexclude = null;
    private String destination_folder = null;
    private String nr_errors_less_than = "10";
    public String SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED = "success_when_at_least";
    public String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    private String success_condition = this.SUCCESS_IF_NO_ERRORS;
    private Pattern wildcardPattern;
    private Pattern wildcardExcludePattern;
    private boolean add_date = false;
    private boolean add_time = false;
    private boolean SpecifyFormat = false;
    private String date_time_format = null;
    private boolean AddDateBeforeExtension = false;
    private String action = "copy";
    private boolean OverwriteFile = false;
    private boolean CreateDestinationFolder = false;
    boolean RemovedSourceFilename = true;
    boolean AddDestinationFilename = true;
    int NrErrors = 0;
    private int NrSuccess = 0;
    boolean successConditionBroken = false;
    boolean successConditionBrokenExit = false;
    int limitFiles = 0;

    public JobEntryCopyMoveResultFilenames(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryCopyMoveResultFilenames() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryCopyMoveResultFilenames je = (JobEntryCopyMoveResultFilenames)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"foldername", (String)this.foldername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"specify_wildcard", (boolean)this.specifywildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcardexclude", (String)this.wildcardexclude));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destination_folder", (String)this.destination_folder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_errors_less_than", (String)this.nr_errors_less_than));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)this.success_condition));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_date", (boolean)this.add_date));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_time", (boolean)this.add_time));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyFormat", (boolean)this.SpecifyFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_format", (String)this.date_time_format));
        retval.append("      ").append(XMLHandler.addTagValue((String)"action", (String)this.action));
        retval.append("      ").append(XMLHandler.addTagValue((String)"AddDateBeforeExtension", (boolean)this.AddDateBeforeExtension));
        retval.append("      ").append(XMLHandler.addTagValue((String)"OverwriteFile", (boolean)this.OverwriteFile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"CreateDestinationFolder", (boolean)this.CreateDestinationFolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"RemovedSourceFilename", (boolean)this.RemovedSourceFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"AddDestinationFilename", (boolean)this.AddDestinationFilename));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.foldername = XMLHandler.getTagValue((Node)entrynode, (String)"foldername");
            this.specifywildcard = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"specify_wildcard"));
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.wildcardexclude = XMLHandler.getTagValue((Node)entrynode, (String)"wildcardexclude");
            this.destination_folder = XMLHandler.getTagValue((Node)entrynode, (String)"destination_folder");
            this.nr_errors_less_than = XMLHandler.getTagValue((Node)entrynode, (String)"nr_errors_less_than");
            this.success_condition = XMLHandler.getTagValue((Node)entrynode, (String)"success_condition");
            this.add_date = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_date"));
            this.add_time = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_time"));
            this.SpecifyFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"SpecifyFormat"));
            this.AddDateBeforeExtension = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"AddDateBeforeExtension"));
            this.date_time_format = XMLHandler.getTagValue((Node)entrynode, (String)"date_time_format");
            this.action = XMLHandler.getTagValue((Node)entrynode, (String)"action");
            this.OverwriteFile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"OverwriteFile"));
            this.CreateDestinationFolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"CreateDestinationFolder"));
            this.RemovedSourceFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"RemovedSourceFilename"));
            this.AddDestinationFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"AddDestinationFilename"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryCopyMoveResultFilenames.CanNotLoadFromXML", (String[])new String[]{xe.getMessage()}));
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.foldername = rep.getJobEntryAttributeString(id_jobentry, "foldername");
            this.specifywildcard = rep.getJobEntryAttributeBoolean(id_jobentry, "specify_wildcard");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.wildcardexclude = rep.getJobEntryAttributeString(id_jobentry, "wildcardexclude");
            this.destination_folder = rep.getJobEntryAttributeString(id_jobentry, "destination_folder");
            this.nr_errors_less_than = rep.getJobEntryAttributeString(id_jobentry, "nr_errors_less_than");
            this.success_condition = rep.getJobEntryAttributeString(id_jobentry, "success_condition");
            this.add_date = rep.getJobEntryAttributeBoolean(id_jobentry, "add_date");
            this.add_time = rep.getJobEntryAttributeBoolean(id_jobentry, "add_time");
            this.SpecifyFormat = rep.getJobEntryAttributeBoolean(id_jobentry, "SpecifyFormat");
            this.date_time_format = rep.getJobEntryAttributeString(id_jobentry, "date_time_format");
            this.AddDateBeforeExtension = rep.getJobEntryAttributeBoolean(id_jobentry, "AddDateBeforeExtension");
            this.action = rep.getJobEntryAttributeString(id_jobentry, "action");
            this.OverwriteFile = rep.getJobEntryAttributeBoolean(id_jobentry, "OverwriteFile");
            this.CreateDestinationFolder = rep.getJobEntryAttributeBoolean(id_jobentry, "CreateDestinationFolder");
            this.RemovedSourceFilename = rep.getJobEntryAttributeBoolean(id_jobentry, "RemovedSourceFilename");
            this.AddDestinationFilename = rep.getJobEntryAttributeBoolean(id_jobentry, "AddDestinationFilename");
        }
        catch (KettleException dbe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryCopyMoveResultFilenames.CanNotLoadFromRep", (String[])new String[]{"" + id_jobentry, dbe.getMessage()}));
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "foldername", this.foldername);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "specify_wildcard", this.specifywildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcardexclude", this.wildcardexclude);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "destination_folder", this.destination_folder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "nr_errors_less_than", this.nr_errors_less_than);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "success_condition", this.success_condition);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_date", this.add_date);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_time", this.add_time);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "SpecifyFormat", this.SpecifyFormat);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "date_time_format", this.date_time_format);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "AddDateBeforeExtension", this.AddDateBeforeExtension);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "action", this.action);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "OverwriteFile", this.OverwriteFile);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "CreateDestinationFolder", this.CreateDestinationFolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "RemovedSourceFilename", this.RemovedSourceFilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "AddDestinationFilename", this.AddDestinationFilename);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryCopyMoveResultFilenames.CanNotSaveToRep", (String[])new String[]{"" + id_job, dbe.getMessage()}));
        }
    }

    public void setSpecifyWildcard(boolean specifywildcard) {
        this.specifywildcard = specifywildcard;
    }

    public boolean isSpecifyWildcard() {
        return this.specifywildcard;
    }

    public void setFoldername(String foldername) {
        this.foldername = foldername;
    }

    public String getFoldername() {
        return this.foldername;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public String getWildcardExclude() {
        return this.wildcardexclude;
    }

    public String getRealWildcard() {
        return this.environmentSubstitute(this.getWildcard());
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public void setWildcardExclude(String wildcardexclude) {
        this.wildcardexclude = wildcardexclude;
    }

    public void setAddDate(boolean adddate) {
        this.add_date = adddate;
    }

    public boolean isAddDate() {
        return this.add_date;
    }

    public void setAddTime(boolean addtime) {
        this.add_time = addtime;
    }

    public boolean isAddTime() {
        return this.add_time;
    }

    public void setAddDateBeforeExtension(boolean AddDateBeforeExtension) {
        this.AddDateBeforeExtension = AddDateBeforeExtension;
    }

    public boolean isAddDateBeforeExtension() {
        return this.AddDateBeforeExtension;
    }

    public boolean isOverwriteFile() {
        return this.OverwriteFile;
    }

    public void setOverwriteFile(boolean OverwriteFile) {
        this.OverwriteFile = OverwriteFile;
    }

    public void setCreateDestinationFolder(boolean CreateDestinationFolder) {
        this.CreateDestinationFolder = CreateDestinationFolder;
    }

    public boolean isCreateDestinationFolder() {
        return this.CreateDestinationFolder;
    }

    public boolean isRemovedSourceFilename() {
        return this.RemovedSourceFilename;
    }

    public void setRemovedSourceFilename(boolean RemovedSourceFilename) {
        this.RemovedSourceFilename = RemovedSourceFilename;
    }

    public void setAddDestinationFilename(boolean AddDestinationFilename) {
        this.AddDestinationFilename = AddDestinationFilename;
    }

    public boolean isAddDestinationFilename() {
        return this.AddDestinationFilename;
    }

    public boolean isSpecifyFormat() {
        return this.SpecifyFormat;
    }

    public void setSpecifyFormat(boolean SpecifyFormat) {
        this.SpecifyFormat = SpecifyFormat;
    }

    public void setDestinationFolder(String destinationFolder) {
        this.destination_folder = destinationFolder;
    }

    public String getDestinationFolder() {
        return this.destination_folder;
    }

    public void setNrErrorsLessThan(String nr_errors_less_than) {
        this.nr_errors_less_than = nr_errors_less_than;
    }

    public String getNrErrorsLessThan() {
        return this.nr_errors_less_than;
    }

    public void setSuccessCondition(String success_condition) {
        this.success_condition = success_condition;
    }

    public String getSuccessCondition() {
        return this.success_condition;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public String getDateTimeFormat() {
        return this.date_time_format;
    }

    public void setDateTimeFormat(String date_time_format) {
        this.date_time_format = date_time_format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        boolean deleteFile = this.getAction().equals("delete");
        String realdestinationFolder = null;
        if (!deleteFile && !this.CreateDestinationFolder(realdestinationFolder = this.environmentSubstitute(this.getDestinationFolder()))) {
            return result;
        }
        if (!Const.isEmpty((String)this.wildcard)) {
            this.wildcardPattern = Pattern.compile(this.environmentSubstitute(this.wildcard));
        }
        if (!Const.isEmpty((String)this.wildcardexclude)) {
            this.wildcardExcludePattern = Pattern.compile(this.environmentSubstitute(this.wildcardexclude));
        }
        if (previousResult != null) {
            this.NrErrors = 0;
            this.limitFiles = Const.toInt((String)this.environmentSubstitute(this.getNrErrorsLessThan()), (int)10);
            this.NrErrors = 0;
            this.NrSuccess = 0;
            this.successConditionBroken = false;
            this.successConditionBrokenExit = false;
            FileObject file = null;
            try {
                List resultFiles;
                int size = result.getResultFiles().size();
                if (this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryCopyMoveResultFilenames.log.FilesFound", (String[])new String[]{"" + size}));
                }
                if ((resultFiles = result.getResultFilesList()) != null && resultFiles.size() > 0) {
                    Iterator it = resultFiles.iterator();
                    while (it.hasNext() && !this.parentJob.isStopped()) {
                        if (this.successConditionBroken) {
                            this.logError(BaseMessages.getString(PKG, (String)"JobEntryCopyMoveResultFilenames.Error.SuccessConditionbroken", (String[])new String[]{"" + this.NrErrors}));
                            throw new Exception(BaseMessages.getString(PKG, (String)"JobEntryCopyMoveResultFilenames.Error.SuccessConditionbroken", (String[])new String[]{"" + this.NrErrors}));
                        }
                        ResultFile resultFile = (ResultFile)it.next();
                        file = resultFile.getFile();
                        if (file != null && file.exists()) {
                            if (this.specifywildcard && (!this.CheckFileWildcard(file.getName().getBaseName(), this.wildcardPattern, true) || this.CheckFileWildcard(file.getName().getBaseName(), this.wildcardExcludePattern, false) || !this.specifywildcard) || this.processFile(file, realdestinationFolder, result, this.parentJob, deleteFile)) continue;
                            this.updateErrors();
                            continue;
                        }
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntryCopyMoveResultFilenames.log.ErrorCanNotFindFile", (String[])new String[]{file.toString()}));
                        this.updateErrors();
                    }
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryCopyMoveResultFilenames.Error", (String[])new String[]{e.toString()}));
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                        file = null;
                    }
                    catch (Exception ex) {}
                }
            }
        }
        result.setNrErrors((long)this.NrErrors);
        result.setNrLinesWritten((long)this.NrSuccess);
        if (this.getSuccessStatus()) {
            result.setResult(true);
        }
        return result;
    }

    private void updateErrors() {
        ++this.NrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.NrErrors > 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrErrors >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.NrErrors == 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrSuccess >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED) || this.NrErrors <= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean CreateDestinationFolder(String foldername) {
        block20: {
            boolean bl;
            FileObject folder = null;
            try {
                folder = KettleVFS.getFileObject((String)foldername, (VariableSpace)this);
                if (!folder.exists()) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryCopyMoveResultFilenames.Log.FolderNotExists", (String[])new String[]{foldername}));
                    if (!this.isCreateDestinationFolder()) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    folder.createFolder();
                    if (this.log.isBasic()) {
                        this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryCopyMoveResultFilenames.Log.FolderCreated", (String[])new String[]{foldername}));
                    }
                } else if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCopyMoveResultFilenames.Log.FolderExists", (String[])new String[]{foldername}));
                }
                bl = true;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryCopyMoveResultFilenames.Log.CanNotCreatedFolder", (String[])new String[]{foldername, e.toString()}));
                break block20;
            }
            finally {
                if (folder != null) {
                    try {
                        folder.close();
                        folder = null;
                    }
                    catch (Exception exception) {}
                }
            }
            return bl;
        }
        return false;
    }

    private boolean processFile(FileObject sourcefile, String destinationFolder, Result result, Job parentJob, boolean deleteFile) {
        boolean retval = false;
        try {
            if (deleteFile) {
                if (sourcefile.delete()) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCopyMoveResultFilenames.log.DeletedFile", (String[])new String[]{sourcefile.toString()}));
                    }
                    result.getResultFiles().remove(sourcefile.toString());
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCopyMoveResultFilenames.RemovedFileFromResult", (String[])new String[]{sourcefile.toString()}));
                    }
                } else {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryCopyMoveResultFilenames.CanNotDeletedFile", (String[])new String[]{sourcefile.toString()}));
                }
            } else {
                String shortfilename = this.getDestinationFilename(sourcefile.getName().getBaseName());
                String destinationFilename = destinationFolder + Const.FILE_SEPARATOR + shortfilename;
                FileObject destinationfile = KettleVFS.getFileObject((String)destinationFilename, (VariableSpace)this);
                boolean filexists = destinationfile.exists();
                if (filexists && this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCopyMoveResultFilenames.Log.FileExists", (String[])new String[]{destinationFilename}));
                }
                if (!filexists || filexists && this.isOverwriteFile()) {
                    if (this.getAction().equals("copy")) {
                        FileUtil.copyContent((FileObject)sourcefile, (FileObject)destinationfile);
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCopyMoveResultFilenames.log.CopiedFile", (String[])new String[]{sourcefile.toString(), destinationFolder}));
                        }
                    } else {
                        sourcefile.moveTo(destinationfile);
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCopyMoveResultFilenames.log.MovedFile", (String[])new String[]{sourcefile.toString(), destinationFolder}));
                        }
                    }
                    if (this.isRemovedSourceFilename()) {
                        result.getResultFiles().remove(sourcefile.toString());
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCopyMoveResultFilenames.RemovedFileFromResult", (String[])new String[]{sourcefile.toString()}));
                        }
                    }
                    if (this.isAddDestinationFilename()) {
                        ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)destinationfile.toString(), (VariableSpace)this), parentJob.getJobname(), this.toString());
                        result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCopyMoveResultFilenames.AddedFileToResult", (String[])new String[]{destinationfile.toString()}));
                        }
                    }
                }
            }
            retval = true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntryCopyMoveResultFilenames.Log.ErrorProcessing", (String[])new String[]{e.toString()}));
        }
        return retval;
    }

    private String getDestinationFilename(String shortsourcefilename) throws Exception {
        String shortfilename = shortsourcefilename;
        int lenstring = shortsourcefilename.length();
        int lastindexOfDot = shortfilename.lastIndexOf(46);
        if (this.isAddDateBeforeExtension()) {
            shortfilename = shortfilename.substring(0, lastindexOfDot);
        }
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (this.isSpecifyFormat() && !Const.isEmpty((String)this.getDateTimeFormat())) {
            daf.applyPattern(this.getDateTimeFormat());
            String dt = daf.format(now);
            shortfilename = shortfilename + dt;
        } else {
            if (this.isAddDate()) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                shortfilename = shortfilename + "_" + d;
            }
            if (this.isAddTime()) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                shortfilename = shortfilename + "_" + t;
            }
        }
        if (this.isAddDateBeforeExtension()) {
            shortfilename = shortfilename + shortsourcefilename.substring(lastindexOfDot, lenstring);
        }
        return shortfilename;
    }

    private boolean CheckFileWildcard(String selectedfile, Pattern pattern, boolean include) {
        boolean getIt = include;
        if (pattern != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileDoesNotExistValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, ctx);
    }
}

