/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.createfolder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.createfile.JobEntryCreateFile;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryCreateFolder
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String foldername = null;
    private boolean failOfFolderExists = true;

    public JobEntryCreateFolder(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryCreateFolder() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryCreateFolder je = (JobEntryCreateFolder)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"foldername", (String)this.foldername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"fail_of_folder_exists", (boolean)this.failOfFolderExists));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.foldername = XMLHandler.getTagValue((Node)entrynode, (String)"foldername");
            this.failOfFolderExists = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"fail_of_folder_exists"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'create folder' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.foldername = rep.getJobEntryAttributeString(id_jobentry, "foldername");
            this.failOfFolderExists = rep.getJobEntryAttributeBoolean(id_jobentry, "fail_of_folder_exists");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'create Folder' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "foldername", this.foldername);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "fail_of_folder_exists", this.failOfFolderExists);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'create Folder' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public void setFoldername(String foldername) {
        this.foldername = foldername;
    }

    public String getFoldername() {
        return this.foldername;
    }

    public String getRealFoldername() {
        return this.environmentSubstitute(this.getFoldername());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        if (this.foldername != null) {
            String realFoldername = this.getRealFoldername();
            FileObject folderObject = null;
            try {
                folderObject = KettleVFS.getFileObject((String)realFoldername, (VariableSpace)this);
                if (folderObject.exists()) {
                    boolean isFolder = false;
                    if (folderObject.getType() == FileType.FOLDER) {
                        isFolder = true;
                    }
                    if (this.isFailOfFolderExists()) {
                        result.setResult(false);
                        if (isFolder) {
                            this.logError("Folder [" + realFoldername + "] exists, failing.");
                            return result;
                        }
                        this.logError("File [" + realFoldername + "] exists, failing.");
                        return result;
                    }
                    result.setResult(true);
                    if (!this.log.isDetailed()) return result;
                    this.logDetailed("Folder [" + realFoldername + "] already exists, not recreating.");
                    return result;
                }
                folderObject.createFolder();
                if (this.log.isDetailed()) {
                    this.logDetailed("Folder [" + realFoldername + "] created!");
                }
                result.setResult(true);
                return result;
            }
            catch (Exception e) {
                this.logError("Could not create Folder [" + realFoldername + "]", e);
                result.setResult(false);
                result.setNrErrors(1L);
                return result;
            }
            finally {
                if (folderObject != null) {
                    try {
                        folderObject.close();
                        folderObject = null;
                    }
                    catch (IOException ex) {}
                }
            }
        }
        this.logError("No Foldername is defined.");
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public boolean isFailOfFolderExists() {
        return this.failOfFolderExists;
    }

    public void setFailOfFolderExists(boolean failIfFolderExists) {
        this.failOfFolderExists = failIfFolderExists;
    }

    public static void main(String[] args) {
        ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
        new JobEntryCreateFile().check(remarks, null, (VariableSpace)new Variables(), null, null);
        System.out.printf("Remarks: %s\n", remarks);
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileDoesNotExistValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, ctx);
    }
}

