/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.dostounix;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryDosToUnix
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static final int LF = 10;
    private static final int CR = 13;
    private static Class<?> PKG = JobEntryDosToUnix.class;
    public static final String[] ConversionTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"JobEntryDosToUnix.ConversionType.Guess.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryDosToUnix.ConversionType.DosToUnix.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryDosToUnix.ConversionType.UnixToDos.Label", (String[])new String[0])};
    public static final String[] ConversionTypeCode = new String[]{"guess", "dostounix", "unixtodos"};
    public static final int CONVERTION_TYPE_GUESS = 0;
    public static final int CONVERTION_TYPE_DOS_TO_UNIX = 1;
    public static final int CONVERTION_TYPE_UNIX_TO_DOS = 2;
    private static final int TYPE_DOS_FILE = 0;
    private static final int TYPE_UNIX_FILE = 1;
    private static final int TYPE_BINAY_FILE = 2;
    public static final String ADD_NOTHING = "nothing";
    public static final String SUCCESS_IF_AT_LEAST_X_FILES_PROCESSED = "success_when_at_least";
    public static final String SUCCESS_IF_ERROR_FILES_LESS = "success_if_error_files_less";
    public static final String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    public static final String ADD_ALL_FILENAMES = "all_filenames";
    public static final String ADD_PROCESSED_FILES_ONLY = "only_processed_filenames";
    public static final String ADD_ERROR_FILES_ONLY = "only_error_filenames";
    public boolean arg_from_previous = false;
    public boolean include_subfolders = false;
    public String[] source_filefolder = null;
    public String[] wildcard = null;
    public int[] ConversionTypes = null;
    private String nr_errors_less_than = "10";
    private String success_condition = "success_if_no_errors";
    private String resultfilenames = "all_filenames";
    int NrAllErrors = 0;
    int NrErrorFiles = 0;
    int NrProcessedFiles = 0;
    int limitFiles = 0;
    int NrErrors = 0;
    boolean successConditionBroken = false;
    boolean successConditionBrokenExit = false;
    private static String tempFolder;

    public JobEntryDosToUnix(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryDosToUnix() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryDosToUnix je = (JobEntryDosToUnix)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.arg_from_previous));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (boolean)this.include_subfolders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_errors_less_than", (String)this.nr_errors_less_than));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)this.success_condition));
        retval.append("      ").append(XMLHandler.addTagValue((String)"resultfilenames", (String)this.resultfilenames));
        retval.append("      <fields>").append(Const.CR);
        if (this.source_filefolder != null) {
            for (int i = 0; i < this.source_filefolder.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"source_filefolder", (String)this.source_filefolder[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"ConversionType", (String)JobEntryDosToUnix.getConversionTypeCode(this.ConversionTypes[i])));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    private static String getConversionTypeCode(int i) {
        if (i < 0 || i >= ConversionTypeCode.length) {
            return ConversionTypeCode[0];
        }
        return ConversionTypeCode[i];
    }

    public static String getConversionTypeDesc(int i) {
        if (i < 0 || i >= ConversionTypeDesc.length) {
            return ConversionTypeDesc[0];
        }
        return ConversionTypeDesc[i];
    }

    public static int getConversionTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < ConversionTypeDesc.length; ++i) {
            if (!ConversionTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntryDosToUnix.getConversionTypeByCode(tt);
    }

    private static int getConversionTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < ConversionTypeCode.length; ++i) {
            if (!ConversionTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.arg_from_previous = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.include_subfolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            this.nr_errors_less_than = XMLHandler.getTagValue((Node)entrynode, (String)"nr_errors_less_than");
            this.success_condition = XMLHandler.getTagValue((Node)entrynode, (String)"success_condition");
            this.resultfilenames = XMLHandler.getTagValue((Node)entrynode, (String)"resultfilenames");
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.source_filefolder = new String[nrFields];
            this.wildcard = new String[nrFields];
            this.ConversionTypes = new int[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.source_filefolder[i] = XMLHandler.getTagValue((Node)fnode, (String)"source_filefolder");
                this.wildcard[i] = XMLHandler.getTagValue((Node)fnode, (String)"wildcard");
                this.ConversionTypes[i] = JobEntryDosToUnix.getConversionTypeByCode(Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"ConversionType"), (String)""));
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobDosToUnix.Error.Exception.UnableLoadXML", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.arg_from_previous = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.include_subfolders = rep.getJobEntryAttributeBoolean(id_jobentry, "include_subfolders");
            this.nr_errors_less_than = rep.getJobEntryAttributeString(id_jobentry, "nr_errors_less_than");
            this.success_condition = rep.getJobEntryAttributeString(id_jobentry, "success_condition");
            this.resultfilenames = rep.getJobEntryAttributeString(id_jobentry, "resultfilenames");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "source_filefolder");
            this.source_filefolder = new String[argnr];
            this.wildcard = new String[argnr];
            this.ConversionTypes = new int[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.source_filefolder[a] = rep.getJobEntryAttributeString(id_jobentry, a, "source_filefolder");
                this.wildcard[a] = rep.getJobEntryAttributeString(id_jobentry, a, "wildcard");
                this.ConversionTypes[a] = JobEntryDosToUnix.getConversionTypeByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "ConversionType"), (String)""));
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobDosToUnix.Error.Exception.UnableLoadRep", (String[])new String[0]) + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "arg_from_previous", this.arg_from_previous);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "include_subfolders", this.include_subfolders);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "nr_errors_less_than", this.nr_errors_less_than);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "success_condition", this.success_condition);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "resultfilenames", this.resultfilenames);
            if (this.source_filefolder != null) {
                for (int i = 0; i < this.source_filefolder.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "source_filefolder", this.source_filefolder[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "wildcard", this.wildcard[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), "ConversionType", JobEntryDosToUnix.getConversionTypeCode(this.ConversionTypes[i]));
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobDosToUnix.Error.Exception.UnableSaveRep", (String[])new String[0]) + id_job, (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result previousResult, int nr) throws KettleException {
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        List rows = previousResult.getRows();
        RowMetaAndData resultRow = null;
        this.NrErrors = 0;
        this.NrProcessedFiles = 0;
        this.NrErrorFiles = 0;
        this.limitFiles = Const.toInt((String)this.environmentSubstitute(this.getNrErrorsLessThan()), (int)10);
        this.successConditionBroken = false;
        this.successConditionBrokenExit = false;
        tempFolder = this.environmentSubstitute("%%java.io.tmpdir%%");
        String[] vsourcefilefolder = this.source_filefolder;
        String[] vwildcard = this.wildcard;
        if (this.arg_from_previous && this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobDosToUnix.Log.ArgFromPrevious.Found", (String[])new String[]{(rows != null ? rows.size() : 0) + ""}));
        }
        if (this.arg_from_previous && rows != null) {
            for (int iteration = 0; iteration < rows.size() && !this.parentJob.isStopped(); ++iteration) {
                if (this.successConditionBroken) {
                    if (!this.successConditionBrokenExit) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobDosToUnix.Error.SuccessConditionbroken", (String[])new String[]{"" + this.NrAllErrors}));
                        this.successConditionBrokenExit = true;
                    }
                    result.setEntryNr((long)this.NrAllErrors);
                    result.setNrLinesRejected((long)this.NrErrorFiles);
                    result.setNrLinesWritten((long)this.NrProcessedFiles);
                    return result;
                }
                resultRow = (RowMetaAndData)rows.get(iteration);
                String vsourcefilefolder_previous = resultRow.getString(0, null);
                String vwildcard_previous = resultRow.getString(1, null);
                int convertion_type = JobEntryDosToUnix.getConversionTypeByCode(resultRow.getString(2, null));
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobDosToUnix.Log.ProcessingRow", (String[])new String[]{vsourcefilefolder_previous, vwildcard_previous}));
                }
                this.ProcessFileFolder(vsourcefilefolder_previous, vwildcard_previous, convertion_type, this.parentJob, result);
            }
        } else if (vsourcefilefolder != null) {
            for (int i = 0; i < vsourcefilefolder.length && !this.parentJob.isStopped(); ++i) {
                if (this.successConditionBroken) {
                    if (!this.successConditionBrokenExit) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobDosToUnix.Error.SuccessConditionbroken", (String[])new String[]{"" + this.NrAllErrors}));
                        this.successConditionBrokenExit = true;
                    }
                    result.setEntryNr((long)this.NrAllErrors);
                    result.setNrLinesRejected((long)this.NrErrorFiles);
                    result.setNrLinesWritten((long)this.NrProcessedFiles);
                    return result;
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobDosToUnix.Log.ProcessingRow", (String[])new String[]{vsourcefilefolder[i], vwildcard[i]}));
                }
                this.ProcessFileFolder(vsourcefilefolder[i], vwildcard[i], this.ConversionTypes[i], this.parentJob, result);
            }
        }
        result.setNrErrors((long)this.NrAllErrors);
        result.setNrLinesRejected((long)this.NrErrorFiles);
        result.setNrLinesWritten((long)this.NrProcessedFiles);
        if (this.getSuccessStatus()) {
            result.setNrErrors(0L);
            result.setResult(true);
        }
        this.displayResults();
        return result;
    }

    private void displayResults() {
        if (this.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobDosToUnix.Log.Info.Errors", (Object[])new Object[]{this.NrErrors}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobDosToUnix.Log.Info.ErrorFiles", (Object[])new Object[]{this.NrErrorFiles}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobDosToUnix.Log.Info.FilesProcessed", (Object[])new Object[]{this.NrProcessedFiles}));
            this.logDetailed("=======================================");
        }
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.NrAllErrors > 0 && this.getSuccessCondition().equals(SUCCESS_IF_NO_ERRORS) || this.NrErrorFiles >= this.limitFiles && this.getSuccessCondition().equals(SUCCESS_IF_ERROR_FILES_LESS)) {
            retval = true;
        }
        return retval;
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.NrAllErrors == 0 && this.getSuccessCondition().equals(SUCCESS_IF_NO_ERRORS) || this.NrProcessedFiles >= this.limitFiles && this.getSuccessCondition().equals(SUCCESS_IF_AT_LEAST_X_FILES_PROCESSED) || this.NrErrorFiles < this.limitFiles && this.getSuccessCondition().equals(SUCCESS_IF_ERROR_FILES_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void updateErrors() {
        ++this.NrErrors;
        this.updateAllErrors();
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private void updateAllErrors() {
        this.NrAllErrors = this.NrErrors + this.NrErrorFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getFileType(FileObject file) throws Exception {
        int aCount = 0;
        int dCount = 0;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file.getName().getPathDecoded());
            while (in.available() > 0) {
                int b = in.read();
                if (b == 13) {
                    ++dCount;
                    if (in.available() <= 0) continue;
                    b = in.read();
                    if (b == 10) {
                        ++aCount;
                        continue;
                    }
                    int n = 2;
                    return n;
                }
                if (b != 10) continue;
                ++aCount;
            }
        }
        finally {
            in.close();
        }
        if (aCount == dCount) {
            return 0;
        }
        return 1;
    }

    private boolean convert(FileObject file, boolean toUnix) {
        boolean retval = false;
        try {
            String localfilename = KettleVFS.getFilename((FileObject)file);
            File source = new File(localfilename);
            if (this.isDetailed()) {
                if (toUnix) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobDosToUnix.Log.ConvertingFileToUnix", (String[])new String[]{source.getAbsolutePath()}));
                } else {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobDosToUnix.Log.ConvertingFileToDos", (String[])new String[]{source.getAbsolutePath()}));
                }
            }
            File tempFile = new File(tempFolder, source.getName() + ".tmp");
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"JobDosToUnix.Log.CreatingTempFile", (String[])new String[]{tempFile.getAbsolutePath()}));
            }
            FileOutputStream out = new FileOutputStream(tempFile);
            FileInputStream in = new FileInputStream(localfilename);
            if (toUnix) {
                while (in.available() > 0) {
                    int b1 = in.read();
                    if (b1 == 13) {
                        int b2 = in.read();
                        if (b2 == 10) {
                            out.write(10);
                            continue;
                        }
                        out.write(b1);
                        out.write(b2);
                        continue;
                    }
                    out.write(b1);
                }
            } else {
                while (in.available() > 0) {
                    int b1 = in.read();
                    if (b1 == 10) {
                        out.write(13);
                        out.write(10);
                        continue;
                    }
                    out.write(b1);
                }
            }
            in.close();
            out.close();
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"JobDosToUnix.Log.DeletingSourceFile", (String[])new String[]{localfilename}));
            }
            file.delete();
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"JobDosToUnix.Log.RenamingTempFile", (String[])new String[]{tempFile.getAbsolutePath(), source.getAbsolutePath()}));
            }
            tempFile.renameTo(source);
            retval = true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobDosToUnix.Log.ErrorConvertingFile", (String[])new String[]{file.toString(), e.getMessage()}));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ProcessFileFolder(String sourcefilefoldername, String wildcard, int convertion, Job parentJob, Result result) {
        boolean entrystatus;
        block37: {
            entrystatus = false;
            FileObject sourcefilefolder = null;
            FileObject CurrentFile = null;
            String realSourceFilefoldername = this.environmentSubstitute(sourcefilefoldername);
            if (Const.isEmpty((String)realSourceFilefoldername)) {
                this.logError(BaseMessages.getString(PKG, (String)"JobDosToUnix.log.FileFolderEmpty", (String[])new String[]{sourcefilefoldername}));
                this.updateErrors();
                return entrystatus;
            }
            String realWildcard = this.environmentSubstitute(wildcard);
            try {
                sourcefilefolder = KettleVFS.getFileObject((String)realSourceFilefoldername);
                if (sourcefilefolder.exists()) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobDosToUnix.Log.FileExists", (String[])new String[]{sourcefilefolder.toString()}));
                    }
                    if (sourcefilefolder.getType() == FileType.FILE) {
                        entrystatus = this.convertOneFile(sourcefilefolder, convertion, result, parentJob);
                        break block37;
                    }
                    if (sourcefilefolder.getType() == FileType.FOLDER) {
                        FileObject[] fileObjects = sourcefilefolder.findFiles((FileSelector)new AllFileSelector(){

                            public boolean traverseDescendents(FileSelectInfo info) {
                                return info.getDepth() == 0 || JobEntryDosToUnix.this.include_subfolders;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public boolean includeFile(FileSelectInfo info) {
                                block18: {
                                    boolean bl;
                                    FileObject fileObject = info.getFile();
                                    try {
                                        if (fileObject == null) {
                                            boolean bl2 = false;
                                            return bl2;
                                        }
                                        if (fileObject.getType() == FileType.FILE) break block18;
                                        bl = false;
                                    }
                                    catch (Exception ex) {
                                        boolean bl3 = false;
                                        return bl3;
                                    }
                                    finally {
                                        if (fileObject != null) {
                                            try {
                                                fileObject.close();
                                            }
                                            catch (IOException ex) {}
                                        }
                                    }
                                    return bl;
                                }
                                return true;
                            }
                        });
                        if (fileObjects == null) break block37;
                        int j = 0;
                        while (true) {
                            if (j < fileObjects.length && !parentJob.isStopped()) {
                                if (this.successConditionBroken) {
                                    if (!this.successConditionBrokenExit) {
                                        this.logError(BaseMessages.getString(PKG, (String)"JobDosToUnix.Error.SuccessConditionbroken", (String[])new String[]{"" + this.NrAllErrors}));
                                        this.successConditionBrokenExit = true;
                                    }
                                    boolean bl = false;
                                    return bl;
                                }
                                CurrentFile = fileObjects[j];
                                if (!CurrentFile.getParent().toString().equals(sourcefilefolder.toString())) {
                                    if (this.include_subfolders && this.GetFileWildcard(CurrentFile.toString(), realWildcard)) {
                                        this.convertOneFile(CurrentFile, convertion, result, parentJob);
                                    }
                                } else if (this.GetFileWildcard(CurrentFile.toString(), realWildcard)) {
                                    this.convertOneFile(CurrentFile, convertion, result, parentJob);
                                }
                                ++j;
                                continue;
                            }
                            break block37;
                            break;
                        }
                    }
                    this.logError(BaseMessages.getString(PKG, (String)"JobDosToUnix.Error.UnknowFileFormat", (String[])new String[]{sourcefilefolder.toString()}));
                    this.updateErrors();
                    break block37;
                }
                this.logError(BaseMessages.getString(PKG, (String)"JobDosToUnix.Error.SourceFileNotExists", (String[])new String[]{realSourceFilefoldername}));
                this.updateErrors();
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobDosToUnix.Error.Exception.Processing", (String[])new String[]{realSourceFilefoldername.toString(), e.getMessage()}));
                this.updateErrors();
            }
            finally {
                if (sourcefilefolder != null) {
                    try {
                        sourcefilefolder.close();
                    }
                    catch (IOException ex) {}
                }
                if (CurrentFile != null) {
                    try {
                        CurrentFile.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        return entrystatus;
    }

    private boolean convertOneFile(FileObject file, int convertion, Result result, Job parentJob) {
        boolean retval = false;
        try {
            int fileType;
            boolean convertToUnix = true;
            convertToUnix = convertion == 0 ? (fileType = JobEntryDosToUnix.getFileType(file)) == 0 : convertion == 1;
            retval = this.convert(file, convertToUnix);
            if (!retval) {
                this.logError(BaseMessages.getString(PKG, (String)"JobDosToUnix.Error.FileNotConverted", (String[])new String[]{file.toString()}));
                this.updateBadFormed();
                if (this.resultfilenames.equals(ADD_ALL_FILENAMES) || this.resultfilenames.equals(ADD_ERROR_FILES_ONLY)) {
                    this.addFileToResultFilenames(file, result, parentJob);
                }
            } else {
                if (this.isDetailed()) {
                    this.logDetailed("---------------------------");
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobDosToUnix.Error.FileConverted", (Object[])new Object[]{file, convertToUnix ? "UNIX" : "DOS"}));
                }
                this.updateProcessedFormed();
                if (this.resultfilenames.equals(ADD_ALL_FILENAMES) || this.resultfilenames.equals(ADD_PROCESSED_FILES_ONLY)) {
                    this.addFileToResultFilenames(file, result, parentJob);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return retval;
    }

    private void updateProcessedFormed() {
        ++this.NrProcessedFiles;
    }

    private void updateBadFormed() {
        ++this.NrErrorFiles;
        this.updateAllErrors();
    }

    private void addFileToResultFilenames(FileObject fileaddentry, Result result, Job parentJob) {
        try {
            ResultFile resultFile = new ResultFile(0, fileaddentry, parentJob.getJobname(), this.toString());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobDosToUnix.Log.FileAddedToResultFilesName", (Object[])new Object[]{fileaddentry}));
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobDosToUnix.Error.AddingToFilenameResult", (String[])new String[]{fileaddentry.toString(), e.getMessage()}));
        }
    }

    private boolean GetFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Const.isEmpty((String)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public void setIncludeSubfolders(boolean include_subfoldersin) {
        this.include_subfolders = include_subfoldersin;
    }

    public void setArgFromPrevious(boolean argfrompreviousin) {
        this.arg_from_previous = argfrompreviousin;
    }

    public void setNrErrorsLessThan(String nr_errors_less_than) {
        this.nr_errors_less_than = nr_errors_less_than;
    }

    public String getNrErrorsLessThan() {
        return this.nr_errors_less_than;
    }

    public void setSuccessCondition(String success_condition) {
        this.success_condition = success_condition;
    }

    public String getSuccessCondition() {
        return this.success_condition;
    }

    public void setResultFilenames(String resultfilenames) {
        this.resultfilenames = resultfilenames;
    }

    public String getResultFilenames() {
        return this.resultfilenames;
    }

    @Override
    public boolean evaluates() {
        return true;
    }
}

