/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.exportrepository;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.sftp.JobEntrySFTP;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.IRepositoryExporter;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryExporter;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryExportRepository
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryExportRepository.class;
    private String repositoryname = null;
    private String username = null;
    private String password;
    private String targetfilename = null;
    private String iffileexists = this.If_FileExists_Skip;
    private String export_type = this.Export_All;
    private String directoryPath;
    public String If_FileExists_Skip = "if_file_exists_skip";
    public String If_FileExists_Fail = "if_file_exists_fail";
    public String If_FileExists_Overwrite = "if_file_exists_overwrite";
    public String If_FileExists_Uniquename = "if_file_exists_uniquename";
    public String Export_All = "export_all";
    public String Export_Jobs = "export_jobs";
    public String Export_Trans = "export_trans";
    public String Export_By_Folder = "export_by_folder";
    public String Export_One_Folder = "export_one_folder";
    private boolean add_date = false;
    private boolean add_time = false;
    private boolean SpecifyFormat = false;
    private String date_time_format = null;
    private boolean createfolder = false;
    private boolean newfolder = false;
    private boolean add_result_filesname = false;
    private String nr_errors_less_than = "10";
    private String success_condition = this.SUCCESS_IF_NO_ERRORS;
    public String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    FileObject file = null;
    RepositoriesMeta repsinfo = null;
    Repository repository = null;
    RepositoryMeta repositoryMeta = null;
    int NrErrors = 0;
    boolean successConditionBroken = false;
    int limitErr = 0;

    public JobEntryExportRepository(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryExportRepository() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryExportRepository je = (JobEntryExportRepository)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"repositoryname", (String)this.repositoryname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.username));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getPassword())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"targetfilename", (String)this.targetfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"iffileexists", (String)this.iffileexists));
        retval.append("      ").append(XMLHandler.addTagValue((String)"export_type", (String)this.export_type));
        retval.append("      ").append(XMLHandler.addTagValue((String)"directoryPath", (String)this.directoryPath));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_date", (boolean)this.add_date));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_time", (boolean)this.add_time));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyFormat", (boolean)this.SpecifyFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_format", (String)this.date_time_format));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createfolder", (boolean)this.createfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"newfolder", (boolean)this.newfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_result_filesname", (boolean)this.add_result_filesname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_errors_less_than", (String)this.nr_errors_less_than));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)this.success_condition));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.repositoryname = XMLHandler.getTagValue((Node)entrynode, (String)"repositoryname");
            this.username = XMLHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"password"));
            this.targetfilename = XMLHandler.getTagValue((Node)entrynode, (String)"targetfilename");
            this.iffileexists = XMLHandler.getTagValue((Node)entrynode, (String)"iffileexists");
            this.export_type = XMLHandler.getTagValue((Node)entrynode, (String)"export_type");
            this.directoryPath = XMLHandler.getTagValue((Node)entrynode, (String)"directoryPath");
            this.add_date = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_date"));
            this.add_time = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_time"));
            this.SpecifyFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"SpecifyFormat"));
            this.date_time_format = XMLHandler.getTagValue((Node)entrynode, (String)"date_time_format");
            this.createfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createfolder"));
            this.newfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"newfolder"));
            this.add_result_filesname = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_result_filesname"));
            this.nr_errors_less_than = XMLHandler.getTagValue((Node)entrynode, (String)"nr_errors_less_than");
            this.success_condition = XMLHandler.getTagValue((Node)entrynode, (String)"success_condition");
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobExportRepository.Meta.UnableLoadXML", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.repositoryname = rep.getJobEntryAttributeString(id_jobentry, "repositoryname");
            this.username = rep.getJobEntryAttributeString(id_jobentry, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "password"));
            this.targetfilename = rep.getJobEntryAttributeString(id_jobentry, "targetfilename");
            this.iffileexists = rep.getJobEntryAttributeString(id_jobentry, "iffileexists");
            this.export_type = rep.getJobEntryAttributeString(id_jobentry, "export_type");
            this.directoryPath = rep.getJobEntryAttributeString(id_jobentry, "directoryPath");
            this.add_date = rep.getJobEntryAttributeBoolean(id_jobentry, "add_date");
            this.add_time = rep.getJobEntryAttributeBoolean(id_jobentry, "add_time");
            this.SpecifyFormat = rep.getJobEntryAttributeBoolean(id_jobentry, "SpecifyFormat");
            this.date_time_format = rep.getJobEntryAttributeString(id_jobentry, "date_time_format");
            this.createfolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createfolder");
            this.newfolder = rep.getJobEntryAttributeBoolean(id_jobentry, "newfolder");
            this.add_result_filesname = rep.getJobEntryAttributeBoolean(id_jobentry, "add_result_filesname");
            this.nr_errors_less_than = rep.getJobEntryAttributeString(id_jobentry, "nr_errors_less_than");
            this.success_condition = rep.getJobEntryAttributeString(id_jobentry, "success_condition");
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobExportRepository.Meta.UnableLoadRep", (String[])new String[]{"" + id_jobentry}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "repositoryname", this.repositoryname);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "username", this.username);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "targetfilename", this.targetfilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "iffileexists", this.iffileexists);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "export_type", this.export_type);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "directoryPath", this.directoryPath);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_date", this.add_date);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_time", this.add_time);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "SpecifyFormat", this.SpecifyFormat);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "date_time_format", this.date_time_format);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "createfolder", this.createfolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "newfolder", this.newfolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_result_filesname", this.add_result_filesname);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "nr_errors_less_than", this.nr_errors_less_than);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "success_condition", this.success_condition);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobExportRepository.Meta.UnableSaveRep", (String[])new String[]{"" + id_job}), (Throwable)dbe);
        }
    }

    public void setSuccessCondition(String success_condition) {
        this.success_condition = success_condition;
    }

    public String getSuccessCondition() {
        return this.success_condition;
    }

    public void setRepositoryname(String repositoryname) {
        this.repositoryname = repositoryname;
    }

    public String getRepositoryname() {
        return this.repositoryname;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setExportType(String export_type) {
        this.export_type = export_type;
    }

    public String getExportType() {
        return this.export_type;
    }

    public void setIfFileExists(String iffileexists) {
        this.iffileexists = iffileexists;
    }

    public String getIfFileExists() {
        return this.iffileexists;
    }

    public void setTargetfilename(String targetfilename) {
        this.targetfilename = targetfilename;
    }

    public String getTargetfilename() {
        return this.targetfilename;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDirectory() {
        return this.directoryPath;
    }

    public String getDateTimeFormat() {
        return this.date_time_format;
    }

    public void setDateTimeFormat(String date_time_format) {
        this.date_time_format = date_time_format;
    }

    public boolean isSpecifyFormat() {
        return this.SpecifyFormat;
    }

    public void setSpecifyFormat(boolean SpecifyFormat) {
        this.SpecifyFormat = SpecifyFormat;
    }

    public void setAddTime(boolean addtime) {
        this.add_time = addtime;
    }

    public boolean isAddTime() {
        return this.add_time;
    }

    public boolean isCreateFolder() {
        return this.createfolder;
    }

    public void setCreateFolder(boolean createfolder) {
        this.createfolder = createfolder;
    }

    public void setNewFolder(boolean newfolder) {
        this.newfolder = newfolder;
    }

    public boolean isNewFolder() {
        return this.newfolder;
    }

    public void setDirectory(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    public void setAddDate(boolean adddate) {
        this.add_date = adddate;
    }

    public boolean isAddDate() {
        return this.add_date;
    }

    public void setAddresultfilesname(boolean add_result_filesnamein) {
        this.add_result_filesname = add_result_filesnamein;
    }

    public boolean isAddresultfilesname() {
        return this.add_result_filesname;
    }

    public void setNrLimit(String nr_errors_less_than) {
        this.nr_errors_less_than = nr_errors_less_than;
    }

    public String getNrLimit() {
        return this.nr_errors_less_than;
    }

    public String buildFilename(String filename) {
        String retval = "";
        if (Const.isEmpty((String)filename)) {
            return null;
        }
        int lenstring = filename.length();
        int lastindexOfDot = filename.lastIndexOf(46);
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        retval = filename.substring(0, lastindexOfDot);
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (this.isSpecifyFormat() && !Const.isEmpty((String)this.getDateTimeFormat())) {
            daf.applyPattern(this.getDateTimeFormat());
            String dt = daf.format(now);
            retval = retval + dt;
        } else {
            if (this.isAddDate()) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                retval = retval + "_" + d;
            }
            if (this.isAddTime()) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                retval = retval + "_" + t;
            }
        }
        retval = retval + filename.substring(lastindexOfDot, lenstring);
        return retval;
    }

    public String buildUniqueFilename(String filename) {
        String retval = "";
        if (Const.isEmpty((String)filename)) {
            return null;
        }
        int lenstring = filename.length();
        int lastindexOfDot = filename.lastIndexOf(46);
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        retval = filename.substring(0, lastindexOfDot);
        retval = retval + StringUtil.getFormattedDateTimeNow();
        retval = retval + filename.substring(lastindexOfDot, lenstring);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result;
        block70: {
            result = previousResult;
            result.setNrErrors(1L);
            result.setResult(false);
            String realrepName = this.environmentSubstitute(this.repositoryname);
            String realusername = this.environmentSubstitute(this.username);
            String realpassword = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.password));
            String realfoldername = this.environmentSubstitute(this.directoryPath);
            String realoutfilename = this.environmentSubstitute(this.targetfilename);
            if (this.export_type.equals(this.Export_All) || this.export_type.equals(this.Export_Jobs) || this.export_type.equals(this.Export_Trans) || this.export_type.equals(this.Export_One_Folder)) {
                realoutfilename = this.buildFilename(realoutfilename);
            }
            this.NrErrors = 0;
            this.successConditionBroken = false;
            this.limitErr = Const.toInt((String)this.environmentSubstitute(this.getNrLimit()), (int)10);
            try {
                RepositoryDirectory directory;
                block73: {
                    block71: {
                        block72: {
                            this.file = KettleVFS.getFileObject((String)realoutfilename, (VariableSpace)this);
                            if (!this.file.exists()) break block71;
                            if (!this.export_type.equals(this.Export_All) && !this.export_type.equals(this.Export_Jobs) && !this.export_type.equals(this.Export_Trans) && !this.export_type.equals(this.Export_One_Folder)) break block72;
                            if (this.iffileexists.equals(this.If_FileExists_Fail)) {
                                this.logError(BaseMessages.getString(PKG, (String)"JobExportRepository.Log.Failing", (String[])new String[]{realoutfilename}));
                                Result result2 = result;
                                return result2;
                            }
                            if (this.iffileexists.equals(this.If_FileExists_Skip)) {
                                if (this.log.isDetailed()) {
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobExportRepository.Log.Exit", (String[])new String[]{realoutfilename}));
                                }
                                result.setResult(true);
                                result.setNrErrors(0L);
                                Result result3 = result;
                                return result3;
                            }
                            if (this.iffileexists.equals(this.If_FileExists_Uniquename)) {
                                String parentFolder = KettleVFS.getFilename((FileObject)this.file.getParent());
                                String shortFilename = this.file.getName().getBaseName();
                                shortFilename = this.buildUniqueFilename(shortFilename);
                                this.file = KettleVFS.getFileObject((String)(parentFolder + Const.FILE_SEPARATOR + shortFilename), (VariableSpace)this);
                                if (this.log.isDetailed()) {
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobExportRepository.Log.NewFilename", (String[])new String[]{this.file.toString()}));
                                }
                            }
                            break block73;
                        }
                        if (this.export_type.equals(this.Export_By_Folder) && this.file.getType() != FileType.FOLDER) {
                            this.logError(BaseMessages.getString(PKG, (String)"JobExportRepository.Log.NotFolder", (String[])new String[]{"" + this.file.getName()}));
                            Result parentFolder = result;
                            return parentFolder;
                        }
                        break block73;
                    }
                    if (this.export_type.equals(this.Export_By_Folder)) {
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobExportRepository.Log.FolderNotExists", (String[])new String[]{"" + this.file.getName()}));
                        }
                        if (!this.createfolder) {
                            Result parentFolder = result;
                            return parentFolder;
                        }
                        this.file.createFolder();
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobExportRepository.Log.FolderCreated", (String[])new String[]{this.file.toString()}));
                        }
                    } else if ((this.export_type.equals(this.Export_All) || this.export_type.equals(this.Export_Jobs) || this.export_type.equals(this.Export_Trans) || this.export_type.equals(this.Export_One_Folder)) && !this.file.getParent().exists()) {
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobExportRepository.Log.FolderNotExists", (String[])new String[]{"" + this.file.getParent().toString()}));
                        }
                        if (!this.createfolder) {
                            Result parentFolder = result;
                            return parentFolder;
                        }
                        this.file.getParent().createFolder();
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobExportRepository.Log.FolderCreated", (String[])new String[]{this.file.getParent().toString()}));
                        }
                    }
                }
                realoutfilename = KettleVFS.getFilename((FileObject)this.file);
                this.connectRep(this.log, realrepName, realusername, realpassword);
                IRepositoryExporter exporter = this.repository.getExporter();
                if (this.export_type.equals(this.Export_All)) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobExportRepository.Log.StartingExportAllRep", (String[])new String[]{realoutfilename}));
                    }
                    exporter.exportAllObjects(null, realoutfilename, null, "all");
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobExportRepository.Log.EndExportAllRep", (String[])new String[]{realoutfilename}));
                    }
                    if (this.add_result_filesname) {
                        this.addFileToResultFilenames(realoutfilename, this.log, result, this.parentJob);
                    }
                    break block70;
                }
                if (this.export_type.equals(this.Export_Jobs)) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobExportRepository.Log.StartingExportJobsRep", (String[])new String[]{realoutfilename}));
                    }
                    exporter.exportAllObjects(null, realoutfilename, null, "jobs");
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobExportRepository.Log.EndExportJobsRep", (String[])new String[]{realoutfilename}));
                    }
                    if (this.add_result_filesname) {
                        this.addFileToResultFilenames(realoutfilename, this.log, result, this.parentJob);
                    }
                    break block70;
                }
                if (this.export_type.equals(this.Export_Trans)) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobExportRepository.Log.StartingExportTransRep", (String[])new String[]{realoutfilename}));
                    }
                    exporter.exportAllObjects(null, realoutfilename, null, "trans");
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobExportRepository.Log.EndExportTransRep", (String[])new String[]{realoutfilename}));
                    }
                    if (this.add_result_filesname) {
                        this.addFileToResultFilenames(realoutfilename, this.log, result, this.parentJob);
                    }
                    break block70;
                }
                if (this.export_type.equals(this.Export_One_Folder)) {
                    directory = new RepositoryDirectory();
                    directory = this.repository.findDirectory(realfoldername);
                    if (directory == null) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobExportRepository.Error.CanNotFindFolderInRep", (String[])new String[]{realfoldername, realrepName}));
                        Result result4 = result;
                        return result4;
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobExportRepository.Log.ExpAllFolderRep", (String[])new String[]{this.directoryPath, realoutfilename}));
                    }
                    exporter.exportAllObjects(null, realoutfilename, (RepositoryDirectoryInterface)directory, "all");
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobExportRepository.Log.EndExpAllFolderRep", (String[])new String[]{this.directoryPath, realoutfilename}));
                    }
                    if (this.add_result_filesname) {
                        this.addFileToResultFilenames(realoutfilename, this.log, result, this.parentJob);
                    }
                    break block70;
                }
                if (this.export_type.equals(this.Export_By_Folder)) {
                    directory = new RepositoryDirectory();
                    directory = this.repository.loadRepositoryDirectoryTree().findRoot();
                    ObjectId[] dirids = directory.getDirectoryIDs();
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobExportRepository.Log.TotalFolders", (String[])new String[]{"" + dirids.length}));
                    }
                    for (int d = 0; d < dirids.length && !this.parentJob.isStopped(); ++d) {
                        if (this.successConditionBroken) {
                            this.logError(BaseMessages.getString(PKG, (String)"JobExportRepository.Error.SuccessConditionbroken", (String[])new String[]{"" + this.NrErrors}));
                            throw new Exception(BaseMessages.getString(PKG, (String)"JobExportRepository.Error.SuccessConditionbroken", (String[])new String[]{"" + this.NrErrors}));
                        }
                        RepositoryDirectoryInterface repdir = directory.findDirectory(dirids[d]);
                        if (this.processOneFolder(this.parentJob, result, this.log, repdir, realoutfilename, d, dirids.length)) continue;
                        this.updateErrors();
                    }
                }
            }
            catch (Exception e) {
                this.updateErrors();
                this.logError(BaseMessages.getString(PKG, (String)"JobExportRepository.UnExpectedError", (String[])new String[]{e.toString()}));
                this.logError("Stack trace: " + Const.CR + Const.getStackTracker((Throwable)e));
            }
            finally {
                if (this.repository != null) {
                    this.repository.disconnect();
                    this.repository = null;
                }
                if (this.repositoryMeta != null) {
                    this.repositoryMeta = null;
                }
                if (this.repsinfo != null) {
                    this.repsinfo.clear();
                    this.repsinfo = null;
                }
                if (this.file != null) {
                    try {
                        this.file.close();
                        this.file = null;
                    }
                    catch (Exception e) {}
                }
            }
        }
        result.setNrErrors((long)this.NrErrors);
        if (!this.getSuccessStatus()) return result;
        result.setResult(true);
        return result;
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.NrErrors == 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrErrors <= this.limitErr && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void updateErrors() {
        ++this.NrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private boolean processOneFolder(Job parentJob, Result result, LogChannelInterface log, RepositoryDirectoryInterface repdir, String realoutfilename, int folderno, int totalfolders) {
        boolean retval = false;
        try {
            if (!repdir.isRoot() && repdir.toString().lastIndexOf("/") == 0) {
                String filename = repdir.toString().replace("/", "");
                String foldername = realoutfilename;
                if (this.newfolder) {
                    foldername = realoutfilename + Const.FILE_SEPARATOR + filename;
                    this.file = KettleVFS.getFileObject((String)foldername, (VariableSpace)this);
                    if (!this.file.exists()) {
                        this.file.createFolder();
                    }
                }
                filename = foldername + Const.FILE_SEPARATOR + this.buildFilename(filename) + ".xml";
                this.file = KettleVFS.getFileObject((String)filename, (VariableSpace)this);
                if (this.file.exists()) {
                    if (this.iffileexists.equals(this.If_FileExists_Skip)) {
                        return true;
                    }
                    if (this.iffileexists.equals(this.If_FileExists_Uniquename)) {
                        filename = realoutfilename + Const.FILE_SEPARATOR + this.buildUniqueFilename(filename) + ".xml";
                    } else if (this.iffileexists.equals(this.If_FileExists_Fail)) {
                        return false;
                    }
                }
                if (log.isDetailed()) {
                    this.logDetailed("---");
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobExportRepository.Log.FolderProcessing", (String[])new String[]{"" + folderno, "" + totalfolders}));
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobExportRepository.Log.OutFilename", (String[])new String[]{repdir.toString(), filename}));
                }
                new RepositoryExporter(this.repository).exportAllObjects(null, filename, repdir, "all");
                if (log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobExportRepository.Log.OutFilenameEnd", (String[])new String[]{repdir.toString(), filename}));
                }
                if (this.add_result_filesname) {
                    this.addFileToResultFilenames(filename, log, result, parentJob);
                }
            }
            retval = true;
        }
        catch (Exception e) {
            this.updateErrors();
            this.logError(BaseMessages.getString(PKG, (String)"JobExportRepository.ErrorExportingFolder", (String[])new String[]{repdir.toString(), e.toString()}));
        }
        return retval;
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.NrErrors > 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrErrors >= this.limitErr && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void connectRep(LogChannelInterface log, String realrepName, String realusername, String realpassword) throws Exception {
        this.repsinfo = new RepositoriesMeta();
        try {
            this.repsinfo.readData();
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobExportRepository.Error.NoRep", (String[])new String[0]));
            throw new Exception(BaseMessages.getString(PKG, (String)"JobExportRepository.Error.NoRep", (String[])new String[0]));
        }
        this.repositoryMeta = this.repsinfo.findRepository(realrepName);
        if (this.repositoryMeta == null) {
            this.logError(BaseMessages.getString(PKG, (String)"JobExportRepository.Error.NoRepSystem", (String[])new String[0]));
            throw new Exception(BaseMessages.getString(PKG, (String)"JobExportRepository.Error.NoRepSystem", (String[])new String[0]));
        }
        this.repository = (Repository)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, (Object)this.repositoryMeta, Repository.class);
        this.repository.init(this.repositoryMeta);
        try {
            this.repository.connect(realusername, realpassword);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobExportRepository.Error.CanNotConnectRep", (String[])new String[0]));
            throw new Exception(BaseMessages.getString(PKG, (String)"JobExportRepository.Error.CanNotConnectRep", (String[])new String[0]), e);
        }
    }

    private void addFileToResultFilenames(String fileaddentry, LogChannelInterface log, Result result, Job parentJob) {
        try {
            ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)fileaddentry, (VariableSpace)this), parentJob.getJobname(), this.toString());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            if (log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"JobExportRepository.Log.FileAddedToResultFilesName", (String[])new String[]{fileaddentry}));
            }
        }
        catch (Exception e) {
            log.logError(BaseMessages.getString(PKG, (String)"JobExportRepository.Error.AddingToFilenameResult", (String[])new String[0]), new Object[]{fileaddentry + "" + e.getMessage()});
        }
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate(this, "repositoryname", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "targetfilename", remarks, ctx);
        JobEntryValidatorUtils.andValidator().validate(this, "username", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "password", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
    }

    public static void main(String[] args) {
        ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
        new JobEntrySFTP().check(remarks, null, (VariableSpace)new Variables(), null, null);
        System.out.printf("Remarks: %s\n", remarks);
    }
}

