/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.pgpverify;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.pgpencryptfiles.GPG;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryPGPVerify
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryPGPVerify.class;
    private String gpglocation = null;
    private String filename = null;
    private String detachedfilename = null;
    private boolean useDetachedSignature = false;

    public JobEntryPGPVerify(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryPGPVerify() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryPGPVerify je = (JobEntryPGPVerify)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"gpglocation", (String)this.gpglocation));
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"detachedfilename", (String)this.detachedfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"useDetachedSignature", (boolean)this.useDetachedSignature));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.gpglocation = XMLHandler.getTagValue((Node)entrynode, (String)"gpglocation");
            this.filename = XMLHandler.getTagValue((Node)entrynode, (String)"filename");
            this.detachedfilename = XMLHandler.getTagValue((Node)entrynode, (String)"detachedfilename");
            this.useDetachedSignature = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"useDetachedSignature"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryPGPVerify.ERROR_0001_Cannot_Load_Job_Entry_From_Xml_Node", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.gpglocation = rep.getJobEntryAttributeString(id_jobentry, "gpglocation");
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "filename");
            this.detachedfilename = rep.getJobEntryAttributeString(id_jobentry, "detachedfilename");
            this.useDetachedSignature = rep.getJobEntryAttributeBoolean(id_jobentry, "useDetachedSignature");
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryPGPVerify.ERROR_0002_Cannot_Load_Job_From_Repository", (Object[])new Object[]{id_jobentry}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "gpglocation", this.gpglocation);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "filename", this.filename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "detachedfilename", this.detachedfilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "useDetachedSignature", this.useDetachedSignature);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryPGPVerify.ERROR_0003_Cannot_Save_Job_Entry", (Object[])new Object[]{id_job}), (Throwable)dbe);
        }
    }

    public void setGPGLocation(String gpglocation) {
        this.gpglocation = gpglocation;
    }

    public String getGPGLocation() {
        return this.gpglocation;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public void setDetachedfilename(String detachedfilename) {
        this.detachedfilename = detachedfilename;
    }

    public String getDetachedfilename() {
        return this.detachedfilename;
    }

    public void setUseDetachedfilename(boolean useDetachedSignature) {
        this.useDetachedSignature = useDetachedSignature;
    }

    public boolean useDetachedfilename() {
        return this.useDetachedSignature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        result.setNrErrors(1L);
        FileObject file = null;
        FileObject detachedSignature = null;
        try {
            String realFilename = this.environmentSubstitute(this.getFilename());
            if (Const.isEmpty((String)realFilename)) {
                this.logError(BaseMessages.getString(PKG, (String)"JobPGPVerify.FilenameMissing", (String[])new String[0]));
                Result result2 = result;
                return result2;
            }
            file = KettleVFS.getFileObject((String)realFilename);
            GPG gpg = new GPG(this.environmentSubstitute(this.getGPGLocation()), this.log);
            if (this.useDetachedfilename()) {
                String signature = this.environmentSubstitute(this.getDetachedfilename());
                if (Const.isEmpty((String)signature)) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobPGPVerify.DetachedSignatureMissing", (String[])new String[0]));
                    Result result3 = result;
                    return result3;
                }
                detachedSignature = KettleVFS.getFileObject((String)signature);
                gpg.verifyDetachedSignature(detachedSignature, file);
            } else {
                gpg.verifySignature(file);
            }
            result.setNrErrors(0L);
            result.setResult(true);
            return result;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobPGPVerify.Error", (String[])new String[0]), e);
            return result;
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
                if (detachedSignature != null) {
                    detachedSignature.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.gpglocation)) {
            String realFileName = jobMeta.environmentSubstitute(this.gpglocation);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate(this, "gpglocation", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface namingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            FileObject fileObject;
            if (!Const.isEmpty((String)this.gpglocation) && (fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.gpglocation), (VariableSpace)space)).exists()) {
                this.gpglocation = namingInterface.nameResource(fileObject, space, true);
                return this.gpglocation;
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

