/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.simpleeval;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntrySimpleEval
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntrySimpleEval.class;
    public static final String[] valueTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"JobSimpleEval.EvalPreviousField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.EvalVariable.Label", (String[])new String[0])};
    public static final String[] valueTypeCode = new String[]{"field", "variable"};
    public static final int VALUE_TYPE_FIELD = 0;
    public static final int VALUE_TYPE_VARIABLE = 1;
    public int valuetype = 0;
    public static final String[] successConditionDesc = new String[]{BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessWhenEqual.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessWhenDifferent.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessWhenContains.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessWhenNotContains.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessWhenStartWith.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessWhenNotStartWith.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessWhenEndWith.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessWhenNotEndWith.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessWhenRegExp.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessWhenInList.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessWhenNotInList.Label", (String[])new String[0])};
    public static final String[] successConditionCode = new String[]{"equal", "different", "contains", "notcontains", "startswith", "notstatwith", "endswith", "notendwith", "regexp", "inlist", "notinlist"};
    public static final int SUCCESS_CONDITION_EQUAL = 0;
    public static final int SUCCESS_CONDITION_DIFFERENT = 1;
    public static final int SUCCESS_CONDITION_CONTAINS = 2;
    public static final int SUCCESS_CONDITION_NOT_CONTAINS = 3;
    public static final int SUCCESS_CONDITION_START_WITH = 4;
    public static final int SUCCESS_CONDITION_NOT_START_WITH = 5;
    public static final int SUCCESS_CONDITION_END_WITH = 6;
    public static final int SUCCESS_CONDITION_NOT_END_WITH = 7;
    public static final int SUCCESS_CONDITION_REGEX = 8;
    public static final int SUCCESS_CONDITION_IN_LIST = 9;
    public static final int SUCCESS_CONDITION_NOT_IN_LIST = 10;
    public int successcondition = 0;
    public static final String[] fieldTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"JobSimpleEval.FieldTypeString.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.FieldTypeNumber.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.FieldTypeDateTime.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.FieldTypeBoolean.Label", (String[])new String[0])};
    public static final String[] fieldTypeCode = new String[]{"string", "number", "datetime", "boolean"};
    public static final int FIELD_TYPE_STRING = 0;
    public static final int FIELD_TYPE_NUMBER = 1;
    public static final int FIELD_TYPE_DATE_TIME = 2;
    public static final int FIELD_TYPE_BOOLEAN = 3;
    public int fieldtype = 0;
    public static final String[] successNumberConditionDesc = new String[]{BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessWhenEqual.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessWhenDifferent.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessWhenSmallThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessWhenSmallOrEqualThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessWhenGreaterThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessWhenGreaterOrEqualThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessBetween.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessWhenInList.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessWhenNotInList.Label", (String[])new String[0])};
    public static final String[] successNumberConditionCode = new String[]{"equal", "different", "smaller", "smallequal", "greater", "greaterequal", "between", "inlist", "notinlist"};
    public static final int SUCCESS_NUMBER_CONDITION_EQUAL = 0;
    public static final int SUCCESS_NUMBER_CONDITION_DIFFERENT = 1;
    public static final int SUCCESS_NUMBER_CONDITION_SMALLER = 2;
    public static final int SUCCESS_NUMBER_CONDITION_SMALLER_EQUAL = 3;
    public static final int SUCCESS_NUMBER_CONDITION_GREATER = 4;
    public static final int SUCCESS_NUMBER_CONDITION_GREATER_EQUAL = 5;
    public static final int SUCCESS_NUMBER_CONDITION_BETWEEN = 6;
    public static final int SUCCESS_NUMBER_CONDITION_IN_LIST = 7;
    public static final int SUCCESS_NUMBER_CONDITION_NOT_IN_LIST = 8;
    public int successnumbercondition = 0;
    public static final String[] successBooleanConditionDesc = new String[]{BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessWhenTrue.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSimpleEval.SuccessWhenFalse.Label", (String[])new String[0])};
    public static final String[] successBooleanConditionCode = new String[]{"true", "false"};
    public static final int SUCCESS_BOOLEAN_CONDITION_TRUE = 0;
    public static final int SUCCESS_BOOLEAN_CONDITION_FALSE = 1;
    public int successbooleancondition = 1;
    private String fieldname = null;
    private String variablename = null;
    private String mask = null;
    private String comparevalue = null;
    private String minvalue = null;
    private String maxvalue = null;
    private boolean successwhenvarset = false;

    public JobEntrySimpleEval(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntrySimpleEval() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntrySimpleEval je = (JobEntrySimpleEval)super.clone();
        return je;
    }

    private static String getValueTypeCode(int i) {
        if (i < 0 || i >= valueTypeCode.length) {
            return valueTypeCode[0];
        }
        return valueTypeCode[i];
    }

    private static String getFieldTypeCode(int i) {
        if (i < 0 || i >= fieldTypeCode.length) {
            return fieldTypeCode[0];
        }
        return fieldTypeCode[i];
    }

    private static String getSuccessConditionCode(int i) {
        if (i < 0 || i >= successConditionCode.length) {
            return successConditionCode[0];
        }
        return successConditionCode[i];
    }

    public static String getSuccessNumberConditionCode(int i) {
        if (i < 0 || i >= successNumberConditionCode.length) {
            return successNumberConditionCode[0];
        }
        return successNumberConditionCode[i];
    }

    private static String getSuccessBooleanConditionCode(int i) {
        if (i < 0 || i >= successBooleanConditionCode.length) {
            return successBooleanConditionCode[0];
        }
        return successBooleanConditionCode[i];
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"valuetype", (String)JobEntrySimpleEval.getValueTypeCode(this.valuetype)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"fieldname", (String)this.fieldname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"variablename", (String)this.variablename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"fieldtype", (String)JobEntrySimpleEval.getFieldTypeCode(this.fieldtype)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"mask", (String)this.mask));
        retval.append("      ").append(XMLHandler.addTagValue((String)"comparevalue", (String)this.comparevalue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"minvalue", (String)this.minvalue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"maxvalue", (String)this.maxvalue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"successcondition", (String)JobEntrySimpleEval.getSuccessConditionCode(this.successcondition)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"successnumbercondition", (String)JobEntrySimpleEval.getSuccessNumberConditionCode(this.successnumbercondition)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"successbooleancondition", (String)JobEntrySimpleEval.getSuccessBooleanConditionCode(this.successbooleancondition)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"successwhenvarset", (boolean)this.successwhenvarset));
        return retval.toString();
    }

    private static int getValueTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < valueTypeCode.length; ++i) {
            if (!valueTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getSuccessNumberByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successNumberConditionCode.length; ++i) {
            if (!successNumberConditionCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getSuccessBooleanByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successBooleanConditionCode.length; ++i) {
            if (!successBooleanConditionCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getFieldTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < fieldTypeCode.length; ++i) {
            if (!fieldTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getSuccessConditionByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionCode.length; ++i) {
            if (!successConditionCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public void setSuccessWhenVarSet(boolean successwhenvarset) {
        this.successwhenvarset = successwhenvarset;
    }

    public boolean isSuccessWhenVarSet() {
        return this.successwhenvarset;
    }

    public static int getSuccessNumberConditionByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successNumberConditionCode.length; ++i) {
            if (!successNumberConditionCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getSuccessBooleanConditionByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successBooleanConditionCode.length; ++i) {
            if (!successBooleanConditionCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.valuetype = JobEntrySimpleEval.getValueTypeByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"valuetype"), (String)""));
            this.fieldname = XMLHandler.getTagValue((Node)entrynode, (String)"fieldname");
            this.fieldtype = JobEntrySimpleEval.getFieldTypeByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"fieldtype"), (String)""));
            this.variablename = XMLHandler.getTagValue((Node)entrynode, (String)"variablename");
            this.mask = XMLHandler.getTagValue((Node)entrynode, (String)"mask");
            this.comparevalue = XMLHandler.getTagValue((Node)entrynode, (String)"comparevalue");
            this.minvalue = XMLHandler.getTagValue((Node)entrynode, (String)"minvalue");
            this.maxvalue = XMLHandler.getTagValue((Node)entrynode, (String)"maxvalue");
            this.successcondition = JobEntrySimpleEval.getSuccessConditionByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"successcondition"), (String)""));
            this.successnumbercondition = JobEntrySimpleEval.getSuccessNumberConditionByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"successnumbercondition"), (String)""));
            this.successbooleancondition = JobEntrySimpleEval.getSuccessBooleanConditionByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"successbooleancondition"), (String)""));
            this.successwhenvarset = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"successwhenvarset"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntrySimple.Error.Exception.UnableLoadXML", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.valuetype = JobEntrySimpleEval.getValueTypeByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "valuetype"), (String)""));
            this.fieldname = rep.getJobEntryAttributeString(id_jobentry, "fieldname");
            this.variablename = rep.getJobEntryAttributeString(id_jobentry, "variablename");
            this.fieldtype = JobEntrySimpleEval.getFieldTypeByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "fieldtype"), (String)""));
            this.mask = rep.getJobEntryAttributeString(id_jobentry, "mask");
            this.comparevalue = rep.getJobEntryAttributeString(id_jobentry, "comparevalue");
            this.minvalue = rep.getJobEntryAttributeString(id_jobentry, "minvalue");
            this.maxvalue = rep.getJobEntryAttributeString(id_jobentry, "maxvalue");
            this.successcondition = JobEntrySimpleEval.getSuccessConditionByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "successcondition"), (String)""));
            this.successnumbercondition = JobEntrySimpleEval.getSuccessNumberConditionByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "successnumbercondition"), (String)""));
            this.successbooleancondition = JobEntrySimpleEval.getSuccessBooleanConditionByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "successbooleancondition"), (String)""));
            this.successwhenvarset = rep.getJobEntryAttributeBoolean(id_jobentry, "successwhenvarset");
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntrySimple.Error.Exception.UnableLoadRep", (String[])new String[0]) + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "valuetype", JobEntrySimpleEval.getValueTypeCode(this.valuetype));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "fieldname", this.fieldname);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "variablename", this.variablename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "fieldtype", JobEntrySimpleEval.getFieldTypeCode(this.fieldtype));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "mask", this.mask);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "comparevalue", this.comparevalue);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "minvalue", this.minvalue);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "maxvalue", this.maxvalue);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "successcondition", JobEntrySimpleEval.getSuccessConditionCode(this.successcondition));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "successnumbercondition", JobEntrySimpleEval.getSuccessNumberConditionCode(this.successnumbercondition));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "successbooleancondition", JobEntrySimpleEval.getSuccessBooleanConditionCode(this.successbooleancondition));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "successwhenvarset", this.successwhenvarset);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntrySimple.Error.Exception.UnableSaveRep", (String[])new String[0]) + id_job, (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result previousResult, int nr) throws KettleException {
        boolean success;
        Result result;
        block142: {
            result = previousResult;
            result.setNrErrors(1L);
            result.setResult(false);
            String sourcevalue = null;
            switch (this.valuetype) {
                case 0: {
                    List rows = result.getRows();
                    RowMetaAndData resultRow = null;
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.Log.ArgFromPrevious.Found", (String[])new String[]{(rows != null ? rows.size() : 0) + ""}));
                    }
                    if (rows.size() == 0) {
                        rows = null;
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.Error.NoRows", (String[])new String[0]));
                        return result;
                    }
                    resultRow = (RowMetaAndData)rows.get(0);
                    String realfieldname = this.environmentSubstitute(this.fieldname);
                    int indexOfField = -1;
                    indexOfField = resultRow.getRowMeta().indexOfValue(realfieldname);
                    if (indexOfField == -1) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.Error.FieldNotExist", (String[])new String[]{realfieldname}));
                        resultRow = null;
                        rows = null;
                        return result;
                    }
                    sourcevalue = resultRow.getString(indexOfField, null);
                    resultRow = null;
                    rows = null;
                    break;
                }
                case 1: {
                    if (Const.isEmpty((String)this.variablename)) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.Error.VariableMissing", (String[])new String[0]));
                        return result;
                    }
                    if (this.isSuccessWhenVarSet()) {
                        String variableName = StringUtil.getVariableName((String)Const.NVL((String)this.getVariableName(), (String)""));
                        String value = this.getVariable(variableName);
                        if (value != null) {
                            if (this.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.VariableSet", (String[])new String[]{variableName}));
                            }
                            result.setResult(true);
                            result.setNrErrors(0L);
                            return result;
                        }
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.VariableNotSet", (String[])new String[]{variableName}));
                        }
                        result.setNrErrors(0L);
                        return result;
                    }
                    sourcevalue = this.environmentSubstitute(this.getVariableWithSpec());
                    break;
                }
            }
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.ValueToevaluate", (String[])new String[]{sourcevalue}));
            }
            success = false;
            String realCompareValue = this.environmentSubstitute(this.comparevalue);
            String realMinValue = this.environmentSubstitute(this.minvalue);
            String realMaxValue = this.environmentSubstitute(this.maxvalue);
            block27 : switch (this.fieldtype) {
                case 0: {
                    switch (this.successcondition) {
                        case 0: {
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            success = sourcevalue.equals(realCompareValue);
                            if (this.valuetype == 1 && !success && Const.isEmpty((String)realCompareValue)) {
                                String variableName = StringUtil.getVariableName((String)this.variablename);
                                if (System.getProperty(variableName) != null) break block27;
                                success = true;
                                break;
                            }
                            break block142;
                        }
                        case 1: {
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            success = !sourcevalue.equals(realCompareValue);
                            break;
                        }
                        case 2: {
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            success = sourcevalue.contains(realCompareValue);
                            break;
                        }
                        case 3: {
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            success = !sourcevalue.contains(realCompareValue);
                            break;
                        }
                        case 4: {
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            success = sourcevalue.startsWith(realCompareValue);
                            break;
                        }
                        case 5: {
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            success = !sourcevalue.startsWith(realCompareValue);
                            break;
                        }
                        case 6: {
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            success = sourcevalue.endsWith(realCompareValue);
                            break;
                        }
                        case 7: {
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            success = !sourcevalue.endsWith(realCompareValue);
                            break;
                        }
                        case 8: {
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            success = Pattern.compile(realCompareValue).matcher(sourcevalue).matches();
                            break;
                        }
                        case 9: {
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            realCompareValue = Const.NVL((String)realCompareValue, (String)"");
                            String[] parts = realCompareValue.split(",");
                            for (int i = 0; i < parts.length && !success; ++i) {
                                success = sourcevalue.equals(parts[i].trim());
                            }
                            break block27;
                        }
                        case 10: {
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            realCompareValue = Const.NVL((String)realCompareValue, (String)"");
                            String[] parts = realCompareValue.split(",");
                            success = true;
                            for (int i = 0; i < parts.length && success; ++i) {
                                success = !sourcevalue.equals(parts[i].trim());
                            }
                            break block27;
                        }
                    }
                    break;
                }
                case 1: {
                    double valuenumber;
                    try {
                        valuenumber = Double.parseDouble(sourcevalue);
                    }
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.Error.UnparsableNumber", (String[])new String[]{sourcevalue, e.getMessage()}));
                        return result;
                    }
                    switch (this.successnumbercondition) {
                        case 0: {
                            double valuecompare;
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            try {
                                valuecompare = Double.parseDouble(realCompareValue);
                            }
                            catch (Exception e) {
                                this.logError(BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.Error.UnparsableNumber", (String[])new String[]{realCompareValue, e.getMessage()}));
                                return result;
                            }
                            success = valuenumber == valuecompare;
                            break;
                        }
                        case 1: {
                            double valuecompare;
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            try {
                                valuecompare = Double.parseDouble(realCompareValue);
                            }
                            catch (Exception e) {
                                this.logError(BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.Error.UnparsableNumber", (String[])new String[]{realCompareValue, e.getMessage()}));
                                return result;
                            }
                            success = valuenumber != valuecompare;
                            break;
                        }
                        case 2: {
                            double valuecompare;
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            try {
                                valuecompare = Double.parseDouble(realCompareValue);
                            }
                            catch (Exception e) {
                                this.logError(BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.Error.UnparsableNumber", (String[])new String[]{realCompareValue, e.getMessage()}));
                                return result;
                            }
                            success = valuenumber < valuecompare;
                            break;
                        }
                        case 3: {
                            double valuecompare;
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            try {
                                valuecompare = Double.parseDouble(realCompareValue);
                            }
                            catch (Exception e) {
                                this.logError(BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.Error.UnparsableNumber", (String[])new String[]{realCompareValue, e.getMessage()}));
                                return result;
                            }
                            success = valuenumber <= valuecompare;
                            break;
                        }
                        case 4: {
                            double valuecompare;
                            try {
                                valuecompare = Double.parseDouble(realCompareValue);
                            }
                            catch (Exception e) {
                                this.logError(BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.Error.UnparsableNumber", (String[])new String[]{realCompareValue, e.getMessage()}));
                                return result;
                            }
                            success = valuenumber > valuecompare;
                            break;
                        }
                        case 5: {
                            double valuecompare;
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            try {
                                valuecompare = Double.parseDouble(realCompareValue);
                            }
                            catch (Exception e) {
                                this.logError(BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.Error.UnparsableNumber", (String[])new String[]{realCompareValue, e.getMessage()}));
                                return result;
                            }
                            success = valuenumber >= valuecompare;
                            break;
                        }
                        case 6: {
                            double valuemax;
                            double valuemin;
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValues", (String[])new String[]{realMinValue, realMaxValue}));
                            }
                            try {
                                valuemin = Double.parseDouble(realMinValue);
                            }
                            catch (Exception e) {
                                this.logError(BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.Error.UnparsableNumber", (String[])new String[]{realMinValue, e.getMessage()}));
                                return result;
                            }
                            try {
                                valuemax = Double.parseDouble(realMaxValue);
                            }
                            catch (Exception e) {
                                this.logError(BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.Error.UnparsableNumber", (String[])new String[]{realMaxValue, e.getMessage()}));
                                return result;
                            }
                            if (valuemin >= valuemax) {
                                this.logError(BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.Error.IncorrectNumbers", (String[])new String[]{realMinValue, realMaxValue}));
                                return result;
                            }
                            success = valuenumber >= valuemin && valuenumber <= valuemax;
                            break;
                        }
                        case 7: {
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            String[] parts = realCompareValue.split(",");
                            for (int i = 0; i < parts.length && !success; ++i) {
                                double valuecompare;
                                try {
                                    valuecompare = Double.parseDouble(parts[i]);
                                }
                                catch (Exception e) {
                                    this.logError(this.toString(), BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.Error.UnparsableNumber", (String[])new String[]{parts[i], e.getMessage()}));
                                    return result;
                                }
                                success = valuenumber == valuecompare;
                            }
                            break block27;
                        }
                        case 8: {
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            realCompareValue = Const.NVL((String)realCompareValue, (String)"");
                            String[] parts = realCompareValue.split(",");
                            success = true;
                            for (int i = 0; i < parts.length && success; ++i) {
                                double valuecompare;
                                try {
                                    valuecompare = Double.parseDouble(parts[i]);
                                }
                                catch (Exception e) {
                                    this.logError(this.toString(), BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.Error.UnparsableNumber", (String[])new String[]{parts[i], e.getMessage()}));
                                    return result;
                                }
                                success = valuenumber != valuecompare;
                            }
                            break block27;
                        }
                    }
                    break;
                }
                case 2: {
                    String realMask = this.environmentSubstitute(this.mask);
                    SimpleDateFormat df = new SimpleDateFormat();
                    if (!Const.isEmpty((String)realMask)) {
                        df.applyPattern(realMask);
                    }
                    Date datevalue = null;
                    try {
                        datevalue = this.convertToDate(sourcevalue, realMask, df);
                    }
                    catch (Exception e) {
                        this.logError(e.getMessage());
                        return result;
                    }
                    switch (this.successnumbercondition) {
                        case 0: {
                            Date datecompare;
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            try {
                                datecompare = this.convertToDate(realCompareValue, realMask, df);
                            }
                            catch (Exception e) {
                                this.logError(e.getMessage());
                                return result;
                            }
                            success = datevalue.equals(datecompare);
                            break;
                        }
                        case 1: {
                            Date datecompare;
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            try {
                                datecompare = this.convertToDate(realCompareValue, realMask, df);
                            }
                            catch (Exception e) {
                                this.logError(e.getMessage());
                                return result;
                            }
                            success = !datevalue.equals(datecompare);
                            break;
                        }
                        case 2: {
                            Date datecompare;
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            try {
                                datecompare = this.convertToDate(realCompareValue, realMask, df);
                            }
                            catch (Exception e) {
                                this.logError(e.getMessage());
                                return result;
                            }
                            success = datevalue.before(datecompare);
                            break;
                        }
                        case 3: {
                            Date datecompare;
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            try {
                                datecompare = this.convertToDate(realCompareValue, realMask, df);
                            }
                            catch (Exception e) {
                                this.logError(e.getMessage());
                                return result;
                            }
                            success = datevalue.before(datecompare) || datevalue.equals(datecompare);
                            break;
                        }
                        case 4: {
                            Date datecompare;
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            try {
                                datecompare = this.convertToDate(realCompareValue, realMask, df);
                            }
                            catch (Exception e) {
                                this.logError(e.getMessage());
                                return result;
                            }
                            success = datevalue.after(datecompare);
                            break;
                        }
                        case 5: {
                            Date datecompare;
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            try {
                                datecompare = this.convertToDate(realCompareValue, realMask, df);
                            }
                            catch (Exception e) {
                                this.logError(e.getMessage());
                                return result;
                            }
                            success = datevalue.after(datecompare) || datevalue.equals(datecompare);
                            break;
                        }
                        case 6: {
                            Date datemax;
                            Date datemin;
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValues", (String[])new String[]{realMinValue, realMaxValue}));
                            }
                            try {
                                datemin = this.convertToDate(realMinValue, realMask, df);
                            }
                            catch (Exception e) {
                                this.logError(e.getMessage());
                                return result;
                            }
                            try {
                                datemax = this.convertToDate(realMaxValue, realMask, df);
                            }
                            catch (Exception e) {
                                this.logError(e.getMessage());
                                return result;
                            }
                            if (datemin.after(datemax) || datemin.equals(datemax)) {
                                this.logError(BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.Error.IncorrectDates", (String[])new String[]{realMinValue, realMaxValue}));
                                return result;
                            }
                            success = !(!datevalue.after(datemin) && !datevalue.equals(datemin) || !datevalue.before(datemax) && !datevalue.equals(datemax));
                            break;
                        }
                        case 7: {
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            String[] parts = realCompareValue.split(",");
                            for (int i = 0; i < parts.length && !success; ++i) {
                                Date datecompare;
                                try {
                                    datecompare = this.convertToDate(realCompareValue, realMask, df);
                                }
                                catch (Exception e) {
                                    this.logError(this.toString(), e.getMessage());
                                    return result;
                                }
                                success = datevalue.equals(datecompare);
                            }
                            break;
                        }
                        case 8: {
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                            }
                            realCompareValue = Const.NVL((String)realCompareValue, (String)"");
                            String[] parts = realCompareValue.split(",");
                            success = true;
                            for (int i = 0; i < parts.length && success; ++i) {
                                Date datecompare;
                                try {
                                    datecompare = this.convertToDate(realCompareValue, realMask, df);
                                }
                                catch (Exception e) {
                                    this.logError(this.toString(), e.getMessage());
                                    return result;
                                }
                                success = !datevalue.equals(datecompare);
                            }
                            break;
                        }
                    }
                    df = null;
                    break;
                }
                case 3: {
                    boolean valuebool;
                    try {
                        valuebool = ValueMeta.convertStringToBoolean((String)sourcevalue);
                    }
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.Error.UnparsableBoolean", (String[])new String[]{sourcevalue, e.getMessage()}));
                        return result;
                    }
                    switch (this.successbooleancondition) {
                        case 1: {
                            success = !valuebool;
                            break block27;
                        }
                        case 0: {
                            success = valuebool;
                            break block27;
                        }
                    }
                    break;
                }
            }
        }
        result.setResult(success);
        result.setNrErrors(0L);
        return result;
    }

    private String getVariableWithSpec() {
        String variable = this.getVariableName();
        if (!(variable.contains("${") || variable.contains("%%") || variable.contains("$[") || variable.contains("}") || variable.contains("%%") || variable.contains("]"))) {
            variable = "${" + variable + "}";
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.CheckingVariable", (String[])new String[]{variable}));
            }
        }
        return variable;
    }

    private Date convertToDate(String valueString, String mask, SimpleDateFormat df) throws KettleException {
        Date datevalue = null;
        try {
            datevalue = df.parse(valueString);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntrySimpleEval.Error.UnparsableDate", (String[])new String[]{valueString}));
        }
        return datevalue;
    }

    public static String getValueTypeDesc(int i) {
        if (i < 0 || i >= valueTypeDesc.length) {
            return valueTypeDesc[0];
        }
        return valueTypeDesc[i];
    }

    public static String getFieldTypeDesc(int i) {
        if (i < 0 || i >= fieldTypeDesc.length) {
            return fieldTypeDesc[0];
        }
        return fieldTypeDesc[i];
    }

    public static String getSuccessConditionDesc(int i) {
        if (i < 0 || i >= successConditionDesc.length) {
            return successConditionDesc[0];
        }
        return successConditionDesc[i];
    }

    public static String getSuccessNumberConditionDesc(int i) {
        if (i < 0 || i >= successNumberConditionDesc.length) {
            return successNumberConditionDesc[0];
        }
        return successNumberConditionDesc[i];
    }

    public static String getSuccessBooleanConditionDesc(int i) {
        if (i < 0 || i >= successBooleanConditionDesc.length) {
            return successBooleanConditionDesc[0];
        }
        return successBooleanConditionDesc[i];
    }

    public static int getValueTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < valueTypeDesc.length; ++i) {
            if (!valueTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntrySimpleEval.getValueTypeByCode(tt);
    }

    public static int getFieldTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < fieldTypeDesc.length; ++i) {
            if (!fieldTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntrySimpleEval.getFieldTypeByCode(tt);
    }

    public static int getSuccessConditionByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionDesc.length; ++i) {
            if (!successConditionDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntrySimpleEval.getSuccessConditionByCode(tt);
    }

    public static int getSuccessNumberConditionByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successNumberConditionDesc.length; ++i) {
            if (!successNumberConditionDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntrySimpleEval.getSuccessNumberByCode(tt);
    }

    public static int getSuccessBooleanConditionByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successBooleanConditionDesc.length; ++i) {
            if (!successBooleanConditionDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntrySimpleEval.getSuccessBooleanByCode(tt);
    }

    public void setMinValue(String minvalue) {
        this.minvalue = minvalue;
    }

    public String getMinValue() {
        return this.minvalue;
    }

    public void setCompareValue(String comparevalue) {
        this.comparevalue = comparevalue;
    }

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public String getFieldName() {
        return this.fieldname;
    }

    public void setFieldName(String fieldname) {
        this.fieldname = fieldname;
    }

    public String getVariableName() {
        return this.variablename;
    }

    public void setVariableName(String variablename) {
        this.variablename = variablename;
    }

    public String getCompareValue() {
        return this.comparevalue;
    }

    public void setMaxValue(String maxvalue) {
        this.maxvalue = maxvalue;
    }

    public String getMaxValue() {
        return this.maxvalue;
    }

    @Override
    public boolean evaluates() {
        return true;
    }
}

